/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003-2006, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: SetProxy.scala 6679 2006-03-10 16:09:08Z odersky $


package scala.collection.mutable;


/** This is a simple wrapper class for <code>scala.collection.mutable.Set</code>.
 *  It is most useful for assembling customized set abstractions
 *  dynamically using object composition and forwarding.
 *
 *  @author  Matthias Zenger
 *  @version 1.1, 09/05/2004
 */
trait SetProxy[A] extends Set[A] with collection.SetProxy[A] {

    def self: Set[A];

    override def update(elem: A, included: Boolean): Unit = self(elem) = included;
    
    def +=(elem: A): Unit = self += elem;
    
    override def ++=(that: Iterable[A]): Unit = self ++= that;
    
    override def ++=(it: Iterator[A]): Unit = self ++= it;
    
    override def incl(elems: A*): Unit = self ++= elems;
    
    def -=(elem: A): Unit = self -= elem;

    override def --=(that: Iterable[A]): Unit = self --= that;

    override def --=(it: Iterator[A]): Unit = self --= it;
    
    override def excl(elems: A*): Unit = self --= elems;
    
    override def intersect(that: Set[A]): Unit = self.intersect(that);
    
    def clear: Unit = self.clear;
    
    override def filter(p: A => Boolean): Unit =  self.filter(p);

    override def <<(cmd: Message[A]): Unit = self << cmd;

    override def clone(): Set[A] = new SetProxy[A] { def self = SetProxy.this.self.clone() }
}
