/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import scala.tools.util.AbstractFile;
import scala.tools.util.EmptyIterator;
import scala.tools.util.PlainFile;

public class PlainFile
extends AbstractFile {
    private final File file;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public static AbstractFile fromPath(String string) {
        return PlainFile.fromFile(new File(string));
    }

    public static AbstractFile fromFile(File file) {
        return file.exists() ? new PlainFile(file) : null;
    }

    protected PlainFile(File file) {
        this.file = file;
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (!file.exists()) {
            throw new Error("non-existent file: ".concat(String.valueOf(String.valueOf(file))));
        }
    }

    public String getName() {
        return this.file.getName();
    }

    public String getPath() {
        return this.file.getPath();
    }

    public File getFile() {
        return this.file;
    }

    public int hashCode() {
        try {
            return this.file.getCanonicalPath().hashCode();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public boolean equals(Object object) {
        try {
            return object instanceof PlainFile && this.file.getCanonicalPath().equals(((PlainFile)object).file.getCanonicalPath());
        }
        catch (IOException iOException) {
            return object instanceof PlainFile && this.file.getAbsolutePath().equals(((PlainFile)object).file.getAbsolutePath());
        }
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public byte[] read() throws IOException {
        int n;
        if (!$assertionsDisabled && this.isDirectory()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf("cannot read directory '".concat(String.valueOf(String.valueOf(this))))).concat("'"))));
        }
        FileInputStream fileInputStream = new FileInputStream(this.file);
        int n2 = (int)this.file.length();
        byte[] byArray = new byte[n2];
        do {
            if ((n = fileInputStream.read(byArray, byArray.length - n2, n2)) != -1) continue;
            throw new IOException("read error");
        } while ((n2 -= n) > 0);
        fileInputStream.close();
        return byArray;
    }

    public Iterator list() {
        if (!$assertionsDisabled && !this.isDirectory()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf("not a directory '".concat(String.valueOf(String.valueOf(this))))).concat("'"))));
        }
        String[] stringArray = this.file.list();
        if (stringArray == null || stringArray.length == 0) {
            return EmptyIterator.object;
        }
        return new 0.ListIterator(stringArray, this);
    }

    public AbstractFile lookupName(String string, boolean bl) {
        if (!$assertionsDisabled && !this.isDirectory()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf("not a directory '".concat(String.valueOf(String.valueOf(this))))).concat("'"))));
        }
        File file = new File(this.file, string);
        if (!file.exists()) {
            return null;
        }
        if (bl != file.isDirectory()) {
            return null;
        }
        if (bl == file.isFile()) {
            return null;
        }
        return new PlainFile(file);
    }

    final /* synthetic */ File access$0() {
        return this.file;
    }

    static {
        $assertionsDisabled = !Class.forName("scala.tools.util.PlainFile").desiredAssertionStatus();
    }
}

