/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.reporters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import scala.MatchError;
import scala.ScalaObject;
import scala.runtime.BoxedInt;
import scala.tools.nsc.reporters.AbstractReporter;
import scala.tools.nsc.reporters.Reporter$Severity;
import scala.tools.nsc.util.Position;
import scala.tools.nsc.util.Position$;
import scala.tools.util.AbstractFile;

public class ConsoleReporter
extends AbstractReporter
implements ScalaObject {
    private boolean shortname;
    private PrintWriter writer;
    private BufferedReader reader;

    public ConsoleReporter(BufferedReader bufferedReader, PrintWriter printWriter) {
        this.reader = bufferedReader;
        this.writer = printWriter;
        this.shortname = false;
    }

    public void displayPrompt() {
        try {
            boolean bl = true;
            while (true) {
                String string;
                if (!bl) {
                    return;
                }
                this.writer.print("r)esume, a)bort: ");
                this.writer.flush();
                String string2 = string = this.reader.readLine();
                Object var4_3 = null;
                if (!(string2 != null ? !string2.equals(var4_3) : var4_3 != null)) continue;
                if ("abort".startsWith(string = string.toLowerCase())) break;
                if (!"resume".startsWith(string)) continue;
                bl = false;
            }
            throw new Error("user abort");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new Error("input read error");
        }
    }

    public void display(Position position, String string, Reporter$Severity reporter$Severity) {
        this.incr(reporter$Severity);
        this.print(position, string, reporter$Severity);
    }

    public void printSummary() {
        if (this.warnings() > 0) {
            this.printMessage(this.getCountString(this.WARNING()) + " found");
        }
        if (this.errors() > 0) {
            this.printMessage(this.getCountString(this.ERROR()) + " found");
        }
    }

    public void printColumnMarker(Position position) {
        Position position2 = position;
        Object var2_2 = null;
        if (position2 != null ? !position2.equals(var2_2) : var2_2 != null) {
            StringBuffer stringBuffer = new StringBuffer(position.column());
            int n = 1;
            while (true) {
                if (n >= position.column()) {
                    if (position.column() > 0) {
                        stringBuffer.append('^');
                    }
                    this.printMessage(stringBuffer.toString());
                    break;
                }
                stringBuffer.append(' ');
                ++n;
            }
        }
    }

    public void printSourceLine(Position position) {
        Position position2 = position;
        Object var2_2 = null;
        if ((position2 != null ? !position2.equals(var2_2) : var2_2 != null) && position.offset() != Position$.MODULE$.NOPOS()) {
            this.printMessage(position.lineContent());
            this.printColumnMarker(position);
        }
    }

    public void print(Position position, String string, Reporter$Severity reporter$Severity) {
        this.printMessage(position, this.clabel(reporter$Severity) + string);
    }

    public void printMessage(Position position, String string) {
        Position position2 = position;
        Object var3_3 = null;
        if (position2 != null ? !position2.equals(var3_3) : var3_3 != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.insert(0, " ");
            if (position.line() != Position$.MODULE$.NOLINE()) {
                stringBuffer.insert(0, ":" + BoxedInt.box((int)position.line()));
            }
            AbstractFile abstractFile = position.source().file();
            stringBuffer.insert(0, !this.shortname() ? abstractFile.getPath() : abstractFile.getName());
            this.printMessage(stringBuffer.toString());
            this.printSourceLine(position);
        } else {
            this.printMessage(string);
        }
    }

    public void printMessage(String string) {
        this.writer.println(string);
    }

    public String getCountString0(int n, String string) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        int n2 = n;
        String string8 = n2 != 0 ? (n2 != 1 ? (n2 != 2 ? (n2 != 3 ? (n2 != 4 ? (string7 = "" + BoxedInt.box((int)n) + " " + string + "s") : (string6 = "four " + string + "s")) : (string5 = "three " + string + "s")) : (string4 = "two " + string + "s")) : (string3 = "one " + string)) : (string2 = "no " + string + "s");
        return string8;
    }

    public String getCountString(Reporter$Severity reporter$Severity) {
        return this.getCountString0(this.count(reporter$Severity), this.label(reporter$Severity));
    }

    public ConsoleReporter() {
        this(new BufferedReader(new InputStreamReader(System.in)), new PrintWriter(System.err, true));
    }

    public String clabel(Reporter$Severity reporter$Severity) {
        String string;
        String string2 = string = this.label(reporter$Severity);
        Object var3_3 = null;
        return (string2 != null ? !string2.equals(var3_3) : var3_3 != null) ? string + ": " : "";
    }

    public String label(Reporter$Severity reporter$Severity) {
        String string;
        Reporter$Severity reporter$Severity2;
        Reporter$Severity reporter$Severity3 = reporter$Severity2 = reporter$Severity;
        Reporter$Severity reporter$Severity4 = this.ERROR();
        if (reporter$Severity3 != null ? !reporter$Severity3.equals(reporter$Severity4) : reporter$Severity4 != null) {
            Reporter$Severity reporter$Severity5 = reporter$Severity2;
            reporter$Severity4 = this.WARNING();
            if (reporter$Severity5 != null ? !reporter$Severity5.equals(reporter$Severity4) : reporter$Severity4 != null) {
                Reporter$Severity reporter$Severity6 = reporter$Severity2;
                reporter$Severity4 = this.INFO();
                if (reporter$Severity6 != null ? !reporter$Severity6.equals(reporter$Severity4) : reporter$Severity4 != null) {
                    throw new MatchError((Object)reporter$Severity2);
                }
                Object var7_4 = null;
                string = var7_4;
            } else {
                String string2;
                string = string2 = "warning";
            }
        } else {
            String string3;
            string = string3 = "error";
        }
        return string;
    }

    public void shortname_$eq(boolean bl) {
        this.shortname = bl;
    }

    public boolean shortname() {
        return this.shortname;
    }
}

