/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2002-2005, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: BoxedIntArray.scala 5359 2005-12-16 15:33:49Z dubochet $

package scala.runtime;

[serializable]
final class BoxedIntArray(val value: Array[Int]) extends BoxedArray {

  def length: Int = value.length;

  def apply(index: Int): Object = BoxedInt.box(value(index));

  def update(index: Int, elem: Object): Unit = { 
    value(index) = elem.asInstanceOf[BoxedNumber].intValue() 
  }

  def unbox(elemTag: String): Object = value;

  override def equals(other: Any) = (
    value == other ||
    other.isInstanceOf[BoxedIntArray] && value == other.asInstanceOf[BoxedIntArray].value
  );

  override def hashCode(): Int = value.hashCode();
}

