/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2002-2005, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: BoxedDoubleArray.scala 5359 2005-12-16 15:33:49Z dubochet $

package scala.runtime;

[serializable]
final class BoxedDoubleArray(val value: Array[Double]) extends BoxedArray {

  def length: Int = value.length;

  def apply(index: Int): Object = BoxedDouble.box(value(index));

  def update(index: Int, elem: Object): Unit = { 
    value(index) = elem.asInstanceOf[BoxedNumber].doubleValue() 
  }

  def unbox(elemTag: String): Object = value;

  override def equals(other: Any) = (
    value == other ||
    other.isInstanceOf[BoxedDoubleArray] && value == other.asInstanceOf[BoxedDoubleArray].value
  );

  override def hashCode(): Int = value.hashCode();
}

