/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003, LAMP/EPFL                  **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
** $Id: SetProxy.scala 5359 2005-12-16 15:33:49Z dubochet $
\*                                                                      */

package scala.collection;


/** This is a simple wrapper class for <code>scala.collection.Set</code>.
 *  It is most useful for assembling customized set abstractions
 *  dynamically using object composition and forwarding.
 *
 *  @author  Matthias Zenger
 *  @version 1.0, 21/07/2003
 */
trait SetProxy[A] extends Set[A] with IterableProxy[A] {

    def self: Set[A];

    def size: Int = self.size;
    
    override def isEmpty: Boolean = self.isEmpty;
    
    def contains(elem: A): Boolean = self.contains(elem);
    
    override def subsetOf(that: Set[A]): Boolean = self.subsetOf(that);

    override def foreach(f: A => Unit): Unit = self.foreach(f);
    
    override def exists(p: A => Boolean): Boolean = self.exists(p);
    
    override def toList: List[A] = self.toList;
}
