/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab.classfile;

import scala.tools.util.AbstractFileReader;
import scala.tools.util.debug.Debug;
import scalac.atree.AConstant;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.symtab.classfile.ClassfileConstants;
import scalac.symtab.classfile.Signatures;
import scalac.util.Name;

public class ConstantPool
implements ClassfileConstants {
    private final AbstractFileReader in;
    private final Signatures parser;
    private final int[] starts;
    private final Object[] values;

    public ConstantPool(AbstractFileReader abstractFileReader, Signatures signatures) {
        this.in = abstractFileReader;
        this.parser = signatures;
        this.starts = new int[abstractFileReader.nextChar()];
        this.values = new Object[this.starts.length];
        int n = 1;
        block6: while (n < this.starts.length) {
            this.starts[n++] = abstractFileReader.bp;
            switch (abstractFileReader.nextByte()) {
                case 1: 
                case 2: {
                    abstractFileReader.skip(abstractFileReader.nextChar());
                    continue block6;
                }
                case 7: 
                case 8: {
                    abstractFileReader.skip(2);
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    abstractFileReader.skip(4);
                    continue block6;
                }
                case 5: 
                case 6: {
                    abstractFileReader.skip(8);
                    ++n;
                    continue block6;
                }
            }
            throw this.errorBadTag(abstractFileReader.bp - 1);
        }
    }

    public String getString(int n) {
        if (n <= 0 || this.starts.length <= n) {
            throw this.errorBadIndex(n);
        }
        if (this.values[n] instanceof String) {
            return (String)this.values[n];
        }
        if (this.values[n] instanceof Name) {
            return this.values[n].toString();
        }
        String string = this.readString(this.starts[n]);
        this.values[n] = string;
        return string;
    }

    public Name getName(int n) {
        if (n <= 0 || this.starts.length <= n) {
            throw this.errorBadIndex(n);
        }
        if (this.values[n] instanceof Name) {
            return (Name)this.values[n];
        }
        Name name = this.readName(this.starts[n]);
        this.values[n] = name;
        return name;
    }

    public Symbol getClass(int n) {
        if (n <= 0 || this.starts.length <= n) {
            throw this.errorBadIndex(n);
        }
        if (this.values[n] instanceof Symbol) {
            return (Symbol)this.values[n];
        }
        Symbol symbol = this.readClass(this.starts[n]);
        this.values[n] = symbol;
        return symbol;
    }

    public Type getFieldType(int n) {
        if (n <= 0 || this.starts.length <= n) {
            throw this.errorBadIndex(n);
        }
        if (this.values[n] instanceof Type) {
            return (Type)this.values[n];
        }
        Type type = this.readFieldType(this.starts[n]);
        this.values[n] = type;
        return type;
    }

    public Type getMethodType(int n) {
        if (n <= 0 || this.starts.length <= n) {
            throw this.errorBadIndex(n);
        }
        if (this.values[n] instanceof Type) {
            return this.clone((Type)this.values[n]);
        }
        Type type = this.readMethodType(this.starts[n]);
        this.values[n] = type;
        return type;
    }

    public AConstant getConstantValue(int n) {
        if (n <= 0 || this.starts.length <= n) {
            throw this.errorBadIndex(n);
        }
        if (this.values[n] != null) {
            return (AConstant)this.values[n];
        }
        AConstant aConstant = this.readConstantValue(this.starts[n]);
        this.values[n] = aConstant;
        return aConstant;
    }

    private String readString(int n) {
        if (this.in.byteAt(n) != 1) {
            throw this.errorBadTag(n);
        }
        return this.parser.at(n).getSignature();
    }

    private Name readName(int n) {
        return Name.fromString(this.readString(n));
    }

    private Symbol readClass(int n) {
        if (this.in.byteAt(n) != 7) {
            throw this.errorBadTag(n);
        }
        char c = this.in.getChar(n + 1);
        if (c <= '\u0000' || this.starts.length <= c) {
            throw this.errorBadIndex(c);
        }
        n = this.starts[c];
        if (this.in.byteAt(n) != 1) {
            throw this.errorBadTag(n);
        }
        return this.parser.at(n).readClassName();
    }

    private Type readFieldType(int n) {
        if (this.in.byteAt(n) != 1) {
            throw this.errorBadTag(n);
        }
        return this.parser.at(n).readValueType();
    }

    private Type readMethodType(int n) {
        if (this.in.byteAt(n) != 1) {
            throw this.errorBadTag(n);
        }
        return this.parser.at(n).readMethodType();
    }

    private AConstant readConstantValue(int n) {
        switch (this.in.byteAt(n)) {
            case 8: {
                return AConstant.STRING(this.getString(this.in.getChar(n + 1)));
            }
            case 3: {
                return AConstant.INT(this.in.getInt(n + 1));
            }
            case 4: {
                return AConstant.FLOAT(this.in.getFloat(n + 1));
            }
            case 5: {
                return AConstant.LONG(this.in.getLong(n + 1));
            }
            case 6: {
                return AConstant.DOUBLE(this.in.getDouble(n + 1));
            }
        }
        throw this.errorBadTag(n);
    }

    private Type clone(Type type) {
        switch (type.$tag) {
            case 3: {
                Type.MethodType methodType = (Type.MethodType)type;
                Symbol[] symbolArray = methodType.vparams;
                Type type2 = methodType.result;
                Symbol[] symbolArray2 = new Symbol[symbolArray.length];
                for (int i = 0; i < symbolArray2.length; ++i) {
                    symbolArray2[i] = symbolArray[i].cloneSymbol(Symbol.NONE);
                }
                return Type.MethodType(symbolArray2, type2);
            }
            case 13: {
                return type;
            }
        }
        throw Debug.abort("illegal case", type);
    }

    private RuntimeException errorBadIndex(int n) {
        String string = "bad constant pool index: ".concat(String.valueOf(n));
        throw new RuntimeException(string);
    }

    private RuntimeException errorBadTag(int n) {
        byte by = this.in.byteAt(n);
        String string = String.valueOf(String.valueOf(String.valueOf(String.valueOf("bad constant pool tag ".concat(String.valueOf(by)))).concat(" at byte "))).concat(String.valueOf(n));
        throw new RuntimeException(string);
    }
}

