/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab;

import java.util.HashMap;
import java.util.Map;
import scala.tools.util.debug.Debug;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.Type;

public class SymbolCloner {
    public final Map owners;
    public final Map clones;
    private final Type.Map mapper = new TypeMapper();
    private final Type.Map cloner = new TypeCloner();
    private static final /* synthetic */ boolean $assertionsDisabled;

    public SymbolCloner() {
        this(new HashMap());
    }

    public SymbolCloner(Map map) {
        this(map, new HashMap());
    }

    public SymbolCloner(Map map, Map map2) {
        this.owners = map;
        this.clones = map2;
    }

    public Symbol getOwnerFor(Symbol symbol) {
        Symbol symbol2 = symbol.owner();
        Object v = this.clones.get(symbol2);
        if (v == null) {
            v = this.owners.get(symbol2);
        }
        if (!$assertionsDisabled && v == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        return (Symbol)v;
    }

    public Symbol cloneSymbolWithoutType(Symbol symbol) {
        if (!$assertionsDisabled && symbol.isPrimaryConstructor()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        if (!$assertionsDisabled && symbol.isClassType() && !symbol.isCompoundSym()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        if (!$assertionsDisabled && this.owners.containsKey(symbol)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        if (!$assertionsDisabled && this.clones.containsKey(symbol)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(symbol))).concat(" -> "))).concat(String.valueOf(String.valueOf(Debug.show(this.clones.get(symbol))))))));
        }
        Symbol symbol2 = symbol.cloneSymbol(this.getOwnerFor(symbol));
        this.clones.put(symbol, symbol2);
        return symbol2;
    }

    public Symbol[] cloneSymbolsWithoutTypes(Symbol[] symbolArray) {
        if (symbolArray.length == 0) {
            return Symbol.EMPTY_ARRAY;
        }
        Symbol[] symbolArray2 = new Symbol[symbolArray.length];
        for (int i = 0; i < symbolArray2.length; ++i) {
            symbolArray2[i] = this.cloneSymbolWithoutType(symbolArray[i]);
        }
        return symbolArray2;
    }

    public Scope cloneScopeWithoutTypes(Scope scope) {
        Scope scope2 = new Scope();
        Scope.SymbolIterator symbolIterator = scope.iterator();
        while (symbolIterator.hasNext()) {
            scope2.enterOrOverload(this.cloneSymbolWithoutType(symbolIterator.next()));
        }
        return scope2;
    }

    public Symbol cloneSymbol(Symbol symbol) {
        Symbol symbol2 = this.cloneSymbolWithoutType(symbol);
        symbol2.setType(this.cloneType(symbol.info()));
        return symbol2;
    }

    public Symbol[] cloneSymbols(Symbol[] symbolArray) {
        Symbol[] symbolArray2 = this.cloneSymbolsWithoutTypes(symbolArray);
        for (int i = 0; i < symbolArray2.length; ++i) {
            symbolArray2[i].setType(this.cloneType(symbolArray[i].info()));
        }
        return symbolArray2;
    }

    public Scope cloneScope(Scope scope) {
        Scope scope2 = this.cloneScopeWithoutTypes(scope);
        Scope.SymbolIterator symbolIterator = scope.iterator();
        while (symbolIterator.hasNext()) {
            Symbol symbol = symbolIterator.next();
            symbol.setType(this.cloneType(symbol.info()));
        }
        return scope2;
    }

    public Type cloneType(Type type) {
        return this.cloner.apply(type);
    }

    public Type[] cloneTypes(Type[] typeArray) {
        Type[] typeArray2 = new Type[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray2[i] = this.cloner.apply(typeArray[i]);
        }
        return typeArray2;
    }

    public Symbol mapSymbol(Symbol symbol) {
        Object v = this.clones.get(symbol);
        return v != null ? (Symbol)v : symbol;
    }

    public Type mapType(Type type) {
        return this.mapper.apply(type);
    }

    public Type.Map getTypeMap() {
        return this.cloner;
    }

    private Symbol getCompoundClone(Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isCompoundSym()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        if (!$assertionsDisabled && this.owners.containsKey(symbol)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        if (!$assertionsDisabled && this.clones.containsKey(symbol)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(symbol))).concat(" -> "))).concat(String.valueOf(String.valueOf(Debug.show(this.clones.get(symbol))))))));
        }
        Symbol symbol2 = (Symbol)this.clones.get(symbol.owner());
        if (symbol2 == null) {
            symbol2 = (Symbol)this.owners.get(symbol.owner());
        }
        if (symbol2 == null) {
            symbol2 = symbol.owner();
        }
        Symbol symbol3 = symbol.cloneSymbol(symbol2);
        this.clones.put(symbol, symbol3);
        return symbol3;
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.symtab.SymbolCloner").desiredAssertionStatus();
    }

    private class TypeCloner
    extends TypeMapper {
        public Type apply(Type type) {
            switch (type.$tag) {
                case 0: {
                    Type.CompoundType compoundType = (Type.CompoundType)type;
                    Type[] typeArray = compoundType.parts;
                    Scope scope = compoundType.members;
                    Symbol symbol = type.symbol();
                    return Type.compoundType(this.map(typeArray), scope, symbol);
                }
                case 3: {
                    Type.MethodType methodType = (Type.MethodType)type;
                    Symbol[] symbolArray = methodType.vparams;
                    Type type2 = methodType.result;
                    Symbol[] symbolArray2 = SymbolCloner.this.cloneSymbols(symbolArray);
                    return Type.MethodType(symbolArray2, this.apply(type2));
                }
                case 5: {
                    Type.PolyType polyType = (Type.PolyType)type;
                    Symbol[] symbolArray = polyType.tparams;
                    Type type3 = polyType.result;
                    Symbol[] symbolArray3 = SymbolCloner.this.cloneSymbols(symbolArray);
                    return Type.PolyType(symbolArray3, this.apply(type3));
                }
            }
            return super.apply(type);
        }
    }

    private class TypeMapper
    extends Type.Map {
        public Type apply(Type type) {
            switch (type.$tag) {
                case 13: {
                    return type;
                }
                case 15: {
                    return type;
                }
                case 14: {
                    return type;
                }
                case 7: {
                    Type.ThisType thisType = (Type.ThisType)type;
                    Symbol symbol = thisType.sym;
                    Symbol symbol2 = (Symbol)SymbolCloner.this.clones.get(symbol);
                    if (symbol2 == null) {
                        return type;
                    }
                    return Type.ThisType(symbol2);
                }
                case 6: {
                    Type.SingleType singleType = (Type.SingleType)type;
                    Type type2 = singleType.pre;
                    Symbol symbol = singleType.sym;
                    Symbol symbol3 = (Symbol)SymbolCloner.this.clones.get(symbol);
                    if (symbol3 == null) {
                        return this.map(type);
                    }
                    return Type.singleType(this.apply(type2), symbol3);
                }
                case 1: {
                    return this.map(type);
                }
                case 8: {
                    Type.TypeRef typeRef = (Type.TypeRef)type;
                    Type type3 = typeRef.pre;
                    Symbol symbol = typeRef.sym;
                    Type[] typeArray = typeRef.args;
                    Symbol symbol4 = (Symbol)SymbolCloner.this.clones.get(symbol);
                    if (symbol4 == null) {
                        return this.map(type);
                    }
                    return Type.typeRef(this.apply(type3), symbol4, this.map(typeArray));
                }
                case 0: {
                    Type.CompoundType compoundType = (Type.CompoundType)type;
                    Type[] typeArray = compoundType.parts;
                    Scope scope = compoundType.members;
                    Symbol symbol = (Symbol)SymbolCloner.this.clones.get(type.symbol());
                    if (symbol == null) {
                        symbol = type.symbol();
                    }
                    return Type.compoundType(this.map(typeArray), scope, symbol);
                }
                case 3: {
                    Type.MethodType methodType = (Type.MethodType)type;
                    Symbol[] symbolArray = methodType.vparams;
                    Type type4 = methodType.result;
                    return Type.MethodType(symbolArray, this.apply(type4));
                }
                case 5: {
                    Type.PolyType polyType = (Type.PolyType)type;
                    Symbol[] symbolArray = polyType.tparams;
                    Type type5 = polyType.result;
                    return Type.PolyType(symbolArray, this.apply(type5));
                }
                case 11: {
                    return type;
                }
                case 10: {
                    return this.map(type);
                }
            }
            throw Debug.abort("illegal case", type);
        }
    }
}

