/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.util;

import java.util.HashSet;
import scala.tools.util.Position;
import scala.tools.util.Reporter;

public abstract class AbstractReporter
implements Reporter {
    private final HashSet positions = new HashSet();
    private boolean verbose = false;
    private boolean nowarn = false;
    private boolean prompt = false;
    private int warnings = 0;
    private int errors = 0;

    public abstract void displayInfo(Position var1, String var2);

    public abstract void displayWarning(Position var1, String var2);

    public abstract void displayError(Position var1, String var2);

    public abstract void displayPrompt();

    public boolean verbose() {
        return this.verbose;
    }

    public boolean nowarn() {
        return this.nowarn;
    }

    public boolean prompt() {
        return this.prompt;
    }

    public void verbose(boolean bl) {
        this.verbose = bl;
    }

    public void nowarn(boolean bl) {
        this.nowarn = bl;
    }

    public void prompt(boolean bl) {
        this.prompt = bl;
    }

    public int warnings() {
        return this.warnings;
    }

    public int errors() {
        return this.errors;
    }

    public void resetCounters() {
        this.errors = 0;
        this.warnings = 0;
    }

    public void info(Position position, String string, boolean bl) {
        if (bl || this.verbose) {
            this.displayInfo(null, string);
        }
    }

    public void warning(Position position, String string) {
        boolean bl = this.testAndLog(position);
        if (this.nowarn) {
            return;
        }
        if (!bl || this.prompt) {
            this.displayWarning(position, string);
        }
        if (!bl) {
            ++this.warnings;
        }
        if (this.prompt) {
            this.displayPrompt();
        }
    }

    public void error(Position position, String string) {
        boolean bl = this.testAndLog(position);
        if (!bl || this.prompt) {
            this.displayError(position, string);
        }
        if (!bl) {
            ++this.errors;
        }
        if (this.prompt) {
            this.displayPrompt();
        }
    }

    private boolean testAndLog(Position position) {
        if (position == null) {
            return false;
        }
        if (position.getColumnNumber() == 0) {
            return false;
        }
        if (this.positions.contains(position)) {
            return true;
        }
        this.positions.add(position);
        return false;
    }
}

