/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.downloaders;

import com.zerog.ia.download.WebInstallerApplet;
import com.zerog.ia.download.downloaders.FileDownloader;
import com.zerog.ia.download.downloaders.macexecutils.MacFileRunner;
import com.zerog.ia.download.downloaders.macosx.ExecuteMacOSXInstaller;
import com.zerog.ia.download.outputListeners.ExecutorListener;
import com.zerog.ia.download.utility.Gestalt;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class FileExecutor {
    Vector executorListenerList = new Vector(2, 1);
    FileDownloader download;
    File fileToExecute;

    public FileExecutor(File _fileToExecute, FileDownloader _download) {
        this.fileToExecute = _fileToExecute;
        this.download = _download;
    }

    public void start() throws Exception {
        try {
            this.download.notifyOutputDiagnosticMessage("execute: Trying to run " + this.fileToExecute.toString());
            if (Gestalt.isNetscapeSecurityModelAvailable()) {
                PrivilegeManager.enablePrivilege((String)Gestalt.NETSCAPE_EXEC_ACCESS);
            }
            if (Gestalt.getPlatform() == Gestalt.WINDOWS_PLATFORM) {
                Runtime.getRuntime().exec(this.fileToExecute.getPath());
            } else if (Gestalt.getPlatform() == Gestalt.MAC_OS_PLATFORM) {
                MacFileRunner macexec = new MacFileRunner(this.fileToExecute, this.download);
                macexec.runMacFile();
            } else if (Gestalt.getPlatform() == Gestalt.MAC_OS_X_PLATFORM) {
                ExecuteMacOSXInstaller.execute(this.fileToExecute);
            } else if (((WebInstallerApplet)this.download.getContext()).getPlatforms().getRunningOnPlatform().isUnix) {
                Runtime.getRuntime().exec("chmod 777 " + this.fileToExecute.getPath());
                Runtime.getRuntime().exec("sh " + this.fileToExecute.getPath());
            }
        }
        catch (Exception e) {
            this.download.notifySetFriendlyErrorMessage("File '" + this.fileToExecute.toString() + "' could not be run.  You may still run the installer yourself outside of the browser by executing the file directly at the aforementioned location.");
            throw e;
        }
        Enumeration e = this.executorListenerList.elements();
        while (e.hasMoreElements()) {
            ((ExecutorListener)e.nextElement()).startingExecution();
        }
    }

    public void addExecutorListener(ExecutorListener _el) {
        this.executorListenerList.addElement(_el);
    }

    public boolean removeExecutorListener(ExecutorListener _el) {
        return this.executorListenerList.removeElement(_el);
    }
}

