/*
 * Decompiled with CFR 0.152.
 */
package scalac.transformer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import scala.tools.util.debug.Debug;
import scalac.CompilationUnit;
import scalac.Global;
import scalac.ast.GenTransformer;
import scalac.ast.Tree;
import scalac.ast.TreeList;
import scalac.backend.Primitive;
import scalac.backend.Primitives;
import scalac.symtab.Definitions;
import scalac.symtab.Modifiers;
import scalac.symtab.Scope;
import scalac.symtab.SymSet;
import scalac.symtab.Symbol;
import scalac.symtab.Type;

public class Erasure
extends GenTransformer
implements Modifiers {
    private static final Type UNBOXED_UNIT;
    private static final Type UNBOXED_BOOLEAN;
    private static final Type UNBOXED_BYTE;
    private static final Type UNBOXED_SHORT;
    private static final Type UNBOXED_CHAR;
    private static final Type UNBOXED_INT;
    private static final Type UNBOXED_LONG;
    private static final Type UNBOXED_FLOAT;
    private static final Type UNBOXED_DOUBLE;
    private final Definitions definitions;
    private final Primitives primitives;
    private CompilationUnit unit;
    private final boolean forMSIL;
    private TreeList bridges;
    private HashMap bridgeSyms;
    private final Map interfaces = new HashMap();
    private static final /* synthetic */ boolean $assertionsDisabled;

    public Erasure(Global global) {
        super(global);
        this.definitions = global.definitions;
        this.primitives = global.primitives;
        this.forMSIL = global.target == Global.TARGET_MSIL;
    }

    public void apply(CompilationUnit compilationUnit) {
        this.unit = compilationUnit;
        super.apply(compilationUnit);
    }

    public Tree transform(Tree tree) {
        switch (tree.$tag) {
            case 10: {
                Tree.ClassDef classDef = (Tree.ClassDef)tree;
                if (classDef.impl.$tag != 33) break;
                Tree.Template template = classDef.impl;
                Tree[] treeArray = template.body;
                Symbol symbol = tree.symbol();
                TreeList treeList = new TreeList(this.transform(treeArray));
                this.addBridges(symbol, treeList);
                return this.gen.ClassDef(symbol, treeList.toArray());
            }
            case 40: {
                Tree.ValDef valDef = (Tree.ValDef)tree;
                Tree tree2 = valDef.rhs;
                Symbol symbol = tree.symbol();
                if (tree2 != Tree.Empty) {
                    tree2 = this.transform(tree2, symbol.nextType());
                }
                return this.gen.ValDef(symbol, tree2);
            }
            case 13: {
                Tree.DefDef defDef = (Tree.DefDef)tree;
                Tree tree3 = defDef.rhs;
                Symbol symbol = tree.symbol();
                if (tree3 != Tree.Empty) {
                    tree3 = this.transform(tree3, symbol.nextType().resultType());
                }
                return this.gen.DefDef(symbol, tree3);
            }
            case 20: {
                Tree.LabelDef labelDef = (Tree.LabelDef)tree;
                Tree[] treeArray = labelDef.params;
                Tree tree4 = labelDef.rhs;
                Symbol symbol = tree.symbol();
                tree4 = this.transform(tree4, symbol.nextType().resultType());
                return this.gen.LabelDef(symbol, Tree.symbolOf(treeArray), tree4);
            }
            case 5: {
                Tree.Assign assign = (Tree.Assign)tree;
                Tree tree5 = assign.lhs;
                Tree tree6 = assign.rhs;
                tree5 = this.transform(tree5);
                tree6 = this.transform(tree6, tree5.type);
                return this.gen.Assign(tree.pos, tree5, tree6);
            }
            case 26: {
                Tree.Return return_ = (Tree.Return)tree;
                Tree tree7 = return_.expr;
                Symbol symbol = tree.symbol();
                Type type = symbol.nextType().resultType();
                return this.gen.Return(tree.pos, symbol, this.transform(tree7, type));
            }
            case 23: {
                Tree.New new_ = (Tree.New)tree;
                Tree tree8 = new_.init;
                if (tree.getType().symbol() == this.definitions.ARRAY_CLASS) {
                    if (tree8.$tag == 4) {
                        Tree.Apply apply = (Tree.Apply)tree8;
                        Tree[] treeArray = apply.args;
                        if (!$assertionsDisabled && treeArray.length != 1) {
                            throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
                        }
                        Type type = this.getArrayElementType(tree.getType()).erasure();
                        Tree tree9 = this.transform(treeArray[0]);
                        return this.genNewUnboxedArray(tree.pos, type, tree9);
                    }
                    throw Debug.abort("illegal case", tree);
                }
                return this.gen.New(tree.pos, this.transform(tree8));
            }
            case 12: {
                return this.gen.Create(tree.pos, Tree.Empty, tree.symbol());
            }
            case 4: {
                Tree.Apply apply = (Tree.Apply)tree;
                if (apply.fun.$tag == 37) {
                    Tree.TypeApply typeApply = (Tree.TypeApply)apply.fun;
                    Tree tree10 = typeApply.fun;
                    Tree[] treeArray = typeApply.args;
                    Tree[] treeArray2 = apply.args;
                    tree10 = this.transform(tree10);
                    treeArray2 = this.transform(treeArray2);
                    Symbol symbol = tree10.symbol();
                    if (symbol == this.definitions.ANY_AS_ERASED) {
                        if (!($assertionsDisabled || treeArray.length == 1 && treeArray2.length == 0)) {
                            throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
                        }
                        return this.coerce(this.getQualifier(tree10), treeArray[0].getType().erasure());
                    }
                    if (symbol == this.definitions.ANY_IS_ERASED) {
                        if (!($assertionsDisabled || treeArray.length == 1 && treeArray2.length == 0)) {
                            throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
                        }
                        Type type = treeArray[0].type.erasure();
                        if (this.isUnboxedSimpleType(type)) {
                            type = treeArray[0].type;
                        }
                        return this.gen.mkIsInstanceOf(tree.pos, this.getQualifier(tree10), type);
                    }
                    return this.genApply(tree.pos, tree10, treeArray2);
                }
                Tree tree11 = apply.fun;
                Tree[] treeArray = apply.args;
                tree11 = this.transform(tree11);
                treeArray = this.transform(treeArray);
                if (tree11.$tag == 27) {
                    Tree.Select select = (Tree.Select)tree11;
                    if (select.qualifier.$tag == 4) {
                        Tree.Apply apply2 = (Tree.Apply)select.qualifier;
                        Tree tree12 = apply2.fun;
                        Tree[] treeArray3 = apply2.args;
                        Symbol symbol = tree12.symbol();
                        if (this.primitives.getPrimitive(symbol) == Primitive.BOX) {
                            if (!$assertionsDisabled && treeArray3.length != 1) {
                                throw new AssertionError((Object)String.valueOf(String.valueOf(tree11)));
                            }
                            Primitive primitive = this.primitives.getPrimitive(tree11.symbol());
                            switch (primitive.$tag) {
                                case 26: {
                                    if (!$assertionsDisabled && treeArray.length != 0) {
                                        throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
                                    }
                                    Tree tree13 = treeArray3[0];
                                    return this.coerce(tree13, tree11.type().resultType());
                                }
                                case 77: {
                                    if (!$assertionsDisabled && treeArray.length != 0) {
                                        throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
                                    }
                                    Tree tree14 = treeArray3[0];
                                    return this.genUnboxedArrayLength(tree.pos, tree14);
                                }
                                case 2: {
                                    if (!$assertionsDisabled && treeArray.length != 1) {
                                        throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
                                    }
                                    Tree tree15 = treeArray3[0];
                                    Tree tree16 = treeArray[0];
                                    return this.genUnboxedArrayGet(tree.pos, tree15, tree16);
                                }
                                case 117: {
                                    if (!$assertionsDisabled && treeArray.length != 2) {
                                        throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
                                    }
                                    Tree tree17 = treeArray3[0];
                                    Tree tree18 = treeArray[0];
                                    Tree tree19 = treeArray[1];
                                    return this.genUnboxedArraySet(tree.pos, tree17, tree18, tree19);
                                }
                            }
                        }
                    }
                }
                return this.genApply(tree.pos, tree11, treeArray);
            }
            case 27: {
                Tree.Select select = (Tree.Select)tree;
                Tree tree20 = select.qualifier;
                Symbol symbol = tree.symbol();
                Type type = tree20.type().baseType(symbol.owner()).erasure();
                if (!$assertionsDisabled && type == Type.NoType) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(tree)).concat(" -- "))).concat(String.valueOf(String.valueOf(Debug.show(symbol)))))));
                }
                tree20 = this.transform(tree20);
                tree20 = this.coerce(tree20, type);
                if (this.isUnboxedType(type)) {
                    tree20 = this.box(tree20, true);
                }
                return this.gen.Select(tree.pos, tree20, symbol);
            }
            case 21: {
                Tree.Literal literal = (Tree.Literal)tree;
                if (literal.value.$tag != 12) break;
                return this.gen.mkNullLit(tree.pos);
            }
            case 8: {
                return this.transform(tree, tree.getType().fullErasure());
            }
            case 18: {
                return this.transform(tree, tree.getType().fullErasure());
            }
            case 32: {
                return this.transform(tree, tree.getType().fullErasure());
            }
        }
        return super.transform(tree);
    }

    private Tree[] transform(Tree[] treeArray, Type type) {
        for (int i = 0; i < treeArray.length; ++i) {
            Tree tree = this.transform(treeArray[i], type);
            if (tree == treeArray[i]) continue;
            Tree[] treeArray2 = new Tree[treeArray.length];
            for (int j = 0; j < i; ++j) {
                treeArray2[j] = treeArray[j];
            }
            treeArray2[i] = tree;
            while (++i < treeArray.length) {
                treeArray2[i] = this.transform(treeArray[i], type);
            }
            return treeArray2;
        }
        return treeArray;
    }

    private Tree transform(Tree tree, Type type) {
        switch (tree.$tag) {
            case 8: {
                Tree.Block block = (Tree.Block)tree;
                Tree[] treeArray = block.stats;
                Tree tree2 = block.expr;
                return this.gen.Block(tree.pos, this.transform(treeArray), this.transform(tree2, type));
            }
            case 18: {
                Tree.If if_ = (Tree.If)tree;
                Tree tree3 = if_.cond;
                Tree tree4 = if_.thenp;
                Tree tree5 = if_.elsep;
                tree3 = this.transform(tree3, UNBOXED_BOOLEAN);
                tree4 = this.transform(tree4, type);
                tree5 = this.transform(tree5, type);
                return this.gen.If(tree.pos, tree3, tree4, tree5, type);
            }
            case 32: {
                Tree.Switch switch_ = (Tree.Switch)tree;
                Tree tree6 = switch_.test;
                int[] nArray = switch_.tags;
                Tree[] treeArray = switch_.bodies;
                Tree tree7 = switch_.otherwise;
                tree6 = this.transform(tree6, UNBOXED_INT);
                treeArray = this.transform(treeArray, type);
                tree7 = this.transform(tree7, type);
                return this.gen.Switch(tree.pos, tree6, nArray, treeArray, tree7, type);
            }
            case 26: {
                Tree tree8 = this.transform(this.gen.mkDefaultValue(tree.pos, type), type);
                return this.gen.mkBlock(this.transform(tree), tree8);
            }
            case 20: {
                return this.coerce(this.transform(tree), type);
            }
            case 5: {
                return this.coerce(this.transform(tree), type);
            }
            case 23: {
                return this.coerce(this.transform(tree), type);
            }
            case 4: {
                return this.coerce(this.transform(tree), type);
            }
            case 31: {
                return this.coerce(this.transform(tree), type);
            }
            case 34: {
                return this.coerce(this.transform(tree), type);
            }
            case 27: {
                return this.coerce(this.transform(tree), type);
            }
            case 17: {
                return this.coerce(this.transform(tree), type);
            }
            case 21: {
                return this.coerce(this.transform(tree), type);
            }
        }
        throw Debug.abort("illegal case", tree);
    }

    private Tree transformUnit(int n, Type type) {
        Tree tree = type.isSameAs(UNBOXED_UNIT) ? this.gen.mkUnitLit(n) : this.gen.mkApply__(this.gen.mkGlobalRef(n, this.primitives.BOX_UVALUE));
        return this.coerce(tree, type);
    }

    private Tree coerce(Tree tree, Type type) {
        if (this.isSubType(tree.type(), type)) {
            if (tree.type().symbol() == this.definitions.ARRAY_CLASS && type.symbol() != this.definitions.ARRAY_CLASS) {
                Symbol symbol = this.primitives.UNBOX__ARRAY;
                Tree tree2 = this.gen.mkGlobalRef(tree.pos, symbol);
                tree = this.gen.mkApply_V(tree2, new Tree[]{tree});
                return this.coerce(tree, type);
            }
            return tree;
        }
        if (this.isUnboxedSimpleType(tree.type())) {
            if (this.isUnboxedSimpleType(type)) {
                return this.convert(tree, type);
            }
            Type type2 = type.erasure();
            if (!this.isUnboxedSimpleType(type2) || this.isSameAs(type2, tree.type())) {
                return this.box(tree);
            }
            return this.coerce(this.convert(tree, type2), type);
        }
        if (this.isUnboxedArrayType(tree.type())) {
            if (!this.isUnboxedArrayType(type)) {
                return this.check(this.box(tree), type);
            }
        } else {
            if (this.isUnboxedSimpleType(type)) {
                Type type3 = tree.type().erasure();
                if (this.isUnboxedSimpleType(type3)) {
                    return this.convert(this.unbox(tree, type3), type);
                }
                return this.unbox(this.coerce(tree, this.boxUnboxedType(type)), type);
            }
            if (this.isUnboxedArrayType(type)) {
                if (tree.type.symbol() == this.definitions.ARRAY_CLASS) {
                    return this.coerce(this.unbox(tree, type), type);
                }
            } else if (type.symbol() == this.definitions.ARRAY_CLASS) {
                Tree tree3 = this.gen.mkGlobalRef(tree.pos, this.primitives.BOX__ARRAY);
                return this.gen.mkApply_V(tree3, new Tree[]{tree});
            }
        }
        return this.gen.mkAsInstanceOf(tree, type);
    }

    private Tree check(Tree tree, Type type) {
        if (!$assertionsDisabled && !this.isSubType(tree.type(), type)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(tree)).concat(" - "))).concat(String.valueOf(String.valueOf(tree.type()))))).concat(" -  "))).concat(String.valueOf(String.valueOf(type))))));
        }
        return tree;
    }

    private Tree box(Tree tree) {
        return this.box(tree, false);
    }

    private Tree box(Tree tree, boolean bl) {
        Tree tree2;
        Object object;
        if (tree.$tag == 4) {
            object = (Tree.Apply)tree;
            tree2 = ((Tree.Apply)object).fun;
            Tree[] treeArray = ((Tree.Apply)object).args;
            if (this.primitives.getPrimitive(tree2.symbol()) == Primitive.UNBOX) {
                if (!$assertionsDisabled && treeArray.length != 1) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
                }
                if (!bl) {
                    return treeArray[0];
                }
            }
        }
        object = this.primitives.getBoxValueSymbol(tree.getType());
        tree2 = this.gen.mkGlobalRef(tree.pos, (Symbol)object);
        return tree.getType().equals(UNBOXED_UNIT) ? this.gen.mkBlock(tree, this.gen.mkApply__(tree2)) : this.gen.mkApply_V(tree2, new Tree[]{tree});
    }

    private Tree unbox(Tree tree, Type type) {
        Object object;
        if (tree.$tag == 4) {
            object = (Tree.Apply)tree;
            Tree tree2 = ((Tree.Apply)object).fun;
            Tree[] treeArray = ((Tree.Apply)object).args;
            if (this.primitives.getPrimitive(tree2.symbol()) == Primitive.BOX) {
                if (!$assertionsDisabled && treeArray.length != 1) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
                }
                return treeArray[0];
            }
        }
        object = this.primitives.getUnboxValueSymbol(type);
        return this.gen.mkApply_V(this.gen.mkGlobalRef(tree.pos, (Symbol)object), new Tree[]{tree});
    }

    private Tree convert(Tree tree, Type type) {
        Symbol symbol = this.primitives.getConvertSymbol(tree.type(), type);
        return this.gen.mkApply_V(this.gen.mkGlobalRef(tree.pos, symbol), new Tree[]{tree});
    }

    private Tree genBridgeMethod(Symbol symbol, Symbol symbol2) {
        Type type = symbol.nextType();
        Tree tree = this.genApply(symbol.pos, this.gen.Select(this.gen.This(symbol.pos, symbol.owner()), symbol2), this.gen.mkLocalRefs(symbol.pos, type.valueParams()));
        return this.gen.DefDef(symbol, this.coerce(tree, type.resultType()));
    }

    private Tree genApply(int n, Tree tree, Tree[] treeArray) {
        Type type = tree.getType();
        if (type.$tag == 3) {
            Type.MethodType methodType = (Type.MethodType)type;
            Symbol[] symbolArray = methodType.vparams;
            Tree[] treeArray2 = treeArray;
            for (int i = 0; i < treeArray.length; ++i) {
                Tree tree2 = treeArray[i];
                Tree tree3 = this.coerce(tree2, symbolArray[i].nextType());
                if (tree3 != tree2 && treeArray2 == treeArray) {
                    treeArray2 = new Tree[treeArray.length];
                    for (int j = 0; j < i; ++j) {
                        treeArray2[j] = treeArray[j];
                    }
                }
                treeArray2[i] = tree3;
            }
            return this.gen.mkApply_V(n, tree, treeArray2);
        }
        throw Debug.abort(String.valueOf(String.valueOf(String.valueOf(String.valueOf("illegal type ".concat(String.valueOf(String.valueOf(tree.getType()))))).concat(" for "))).concat(String.valueOf(String.valueOf(tree))));
    }

    private Tree genNewUnboxedArray(int n, Type type, Tree tree) {
        if (this.global.target == Global.TARGET_INT) {
            Tree[] treeArray = new Tree[]{this.gen.mkType(n, type)};
            Tree[] treeArray2 = new Tree[]{this.coerce(tree, UNBOXED_INT)};
            Tree tree2 = this.gen.mkGlobalRef(n, this.primitives.NEW_OARRAY);
            return this.gen.mkApplyTV(tree2, treeArray, treeArray2);
        }
        if (type.$tag == 11) {
            Type.UnboxedType unboxedType = (Type.UnboxedType)type;
            int n2 = unboxedType.tag;
            return this.genNewUnboxedArray(n, n2, tree);
        }
        String string = this.primitives.getNameForClassForName(type);
        Tree[] treeArray = new Tree[]{this.coerce(tree, UNBOXED_INT), this.gen.mkStringLit(n, string)};
        Tree tree3 = this.gen.mkApply_V(this.gen.mkGlobalRef(n, this.primitives.NEW_OARRAY), treeArray);
        return this.gen.mkAsInstanceOf(tree3, Type.UnboxedArrayType(type));
    }

    private Tree genNewUnboxedArray(int n, int n2, Tree tree) {
        Symbol symbol = this.primitives.getNewArraySymbol(n2);
        Tree[] treeArray = new Tree[]{this.coerce(tree, UNBOXED_INT)};
        return this.gen.mkApply_V(this.gen.mkGlobalRef(n, symbol), treeArray);
    }

    private Tree genUnboxedArrayLength(int n, Tree tree) {
        if (!$assertionsDisabled && !this.isUnboxedArrayType(tree.getType())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
        }
        Symbol symbol = this.primitives.getArrayLengthSymbol(tree.getType());
        Tree[] treeArray = new Tree[]{tree};
        return this.gen.mkApply_V(this.gen.mkGlobalRef(n, symbol), treeArray);
    }

    private Tree genUnboxedArrayGet(int n, Tree tree, Tree tree2) {
        if (!$assertionsDisabled && !this.isUnboxedArrayType(tree.getType())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
        }
        Symbol symbol = this.primitives.getArrayGetSymbol(tree.getType());
        tree2 = this.coerce(tree2, UNBOXED_INT);
        Tree[] treeArray = new Tree[]{tree, tree2};
        return this.gen.mkApply_V(this.gen.mkGlobalRef(n, symbol), treeArray);
    }

    private Tree genUnboxedArraySet(int n, Tree tree, Tree tree2, Tree tree3) {
        if (!$assertionsDisabled && !this.isUnboxedArrayType(tree.getType())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
        }
        Symbol symbol = this.primitives.getArraySetSymbol(tree.getType());
        tree2 = this.coerce(tree2, UNBOXED_INT);
        tree3 = this.coerce(tree3, this.getArrayElementType(tree.getType()));
        Tree[] treeArray = new Tree[]{tree, tree2, tree3};
        return this.gen.mkApply_V(this.gen.mkGlobalRef(n, symbol), treeArray);
    }

    private Tree getQualifier(Tree tree) {
        if (tree.$tag == 27) {
            Tree.Select select = (Tree.Select)tree;
            Tree tree2 = select.qualifier;
            return tree2;
        }
        throw Debug.abort("no qualifier for tree", tree);
    }

    private boolean isSubType(Type type, Type type2) {
        this.global.nextPhase();
        boolean bl = type.isSubType(type2);
        this.global.prevPhase();
        return bl;
    }

    private boolean isSameAs(Type type, Type type2) {
        this.global.nextPhase();
        boolean bl = type.isSameAs(type2);
        this.global.prevPhase();
        return bl;
    }

    private boolean isUnboxedType(Type type) {
        switch (type.$tag) {
            case 11: {
                return true;
            }
            case 10: {
                return true;
            }
        }
        return false;
    }

    private boolean isUnboxedSimpleType(Type type) {
        return type.$tag == 11;
    }

    private boolean isUnboxedArrayType(Type type) {
        return type.$tag == 10;
    }

    private Type boxUnboxedType(Type type) {
        switch (type.$tag) {
            case 11: {
                Type.UnboxedType unboxedType = (Type.UnboxedType)type;
                switch (unboxedType.tag) {
                    case 18: {
                        return this.definitions.UNIT_CLASS.type();
                    }
                    case 17: {
                        return this.definitions.BOOLEAN_CLASS.type();
                    }
                    case 10: {
                        return this.definitions.BYTE_CLASS.type();
                    }
                    case 12: {
                        return this.definitions.SHORT_CLASS.type();
                    }
                    case 11: {
                        return this.definitions.CHAR_CLASS.type();
                    }
                    case 13: {
                        return this.definitions.INT_CLASS.type();
                    }
                    case 14: {
                        return this.definitions.LONG_CLASS.type();
                    }
                    case 15: {
                        return this.definitions.FLOAT_CLASS.type();
                    }
                    case 16: {
                        return this.definitions.DOUBLE_CLASS.type();
                    }
                }
                break;
            }
            case 10: {
                Type.UnboxedArrayType unboxedArrayType = (Type.UnboxedArrayType)type;
                Type type2 = unboxedArrayType.elemtp;
                return Type.appliedType(this.definitions.ARRAY_CLASS.type(), new Type[]{type2});
            }
        }
        throw Debug.abort("illegal case", type);
    }

    private Type getArrayElementType(Type type) {
        switch (type.$tag) {
            case 8: {
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Symbol symbol = typeRef.sym;
                Type[] typeArray = typeRef.args;
                if (symbol != this.definitions.ARRAY_CLASS) break;
                if (!$assertionsDisabled && typeArray.length != 1) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(type)));
                }
                return typeArray[0];
            }
            case 10: {
                Type.UnboxedArrayType unboxedArrayType = (Type.UnboxedArrayType)type;
                Type type2 = unboxedArrayType.elemtp;
                return type2;
            }
        }
        throw Debug.abort("non-array type", type);
    }

    public void addBridge(Symbol symbol, Symbol symbol2, Symbol symbol3) {
        int n;
        Modifiers[] modifiersArray;
        Object object;
        Symbol[] symbolArray;
        Type type = symbol3.nextType();
        SymSet symSet = (SymSet)this.bridgeSyms.get(symbol2);
        if (symSet == null) {
            symSet = SymSet.EMPTY;
        }
        Symbol[] symbolArray2 = symSet.toArray();
        for (int i = 0; i < symbolArray2.length; ++i) {
            if (!this.isSameAs(symbolArray2[i].type(), type)) continue;
            return;
        }
        Symbol symbol4 = symbol2.cloneSymbol();
        symbol4.flags |= 0x8000400;
        symbol4.flags &= 0xFFFFEFFE;
        symSet = symSet.incl(symbol4);
        this.bridgeSyms.put(symbol2, symSet);
        symbol4.setOwner(symbol);
        Symbol symbol5 = symbol.members().lookup(symbol2.name);
        Type type2 = symbol5.nextType();
        if (type2.$tag == 4) {
            symbolArray = (Symbol[])type2;
            object = symbolArray.alts;
            modifiersArray = symbolArray.alttypes;
            for (n = 0; n < ((Symbol[])object).length; ++n) {
                if (symbol2 == object[n] || !this.isSameAs(type, (Type)modifiersArray[n])) continue;
                this.unit.error(symbol2.pos, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("overlapping overloaded alternatives; overridden ".concat(String.valueOf(String.valueOf(symbol3))))).concat(String.valueOf(String.valueOf(symbol3.locationString()))))).concat(" has same erasure as "))).concat(String.valueOf(String.valueOf(object[n]))))).concat(String.valueOf(String.valueOf(modifiersArray[n]))))).concat(String.valueOf(String.valueOf(object[n].locationString()))));
            }
        }
        if (type.$tag == 3) {
            type2 = (Type.MethodType)type;
            symbolArray = ((Type.MethodType)type2).vparams;
            object = ((Type.MethodType)type2).result;
            modifiersArray = new Symbol[symbolArray.length];
            for (n = 0; n < symbolArray.length; ++n) {
                modifiersArray[n] = symbolArray[n].cloneSymbol(symbol4);
            }
            symbol4.setType(Type.MethodType((Symbol[])modifiersArray, (Type)object));
            this.bridges.append(this.genBridgeMethod(symbol4, symbol2));
        }
    }

    private Set getInterfacesOf(Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        HashSet<Symbol> hashSet = (HashSet<Symbol>)this.interfaces.get(symbol);
        if (hashSet == null) {
            hashSet = new HashSet<Symbol>();
            this.interfaces.put(symbol, hashSet);
            Type[] typeArray = symbol.parents();
            for (int i = 0; i < typeArray.length; ++i) {
                hashSet.addAll(this.getInterfacesOf(typeArray[i].symbol()));
            }
            if (symbol.isInterface()) {
                hashSet.add(symbol);
            }
        }
        return hashSet;
    }

    private void addInterfaceBridges_(Symbol symbol) {
        if (!($assertionsDisabled || symbol.isClass() && !symbol.isInterface())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        if (!$assertionsDisabled && symbol.parents().length <= 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(symbol))).concat(": "))).concat(String.valueOf(String.valueOf(symbol.info()))))));
        }
        Symbol symbol2 = symbol.parents()[0].symbol();
        if (!($assertionsDisabled || symbol2.isClass() && !symbol2.isInterface())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        HashSet hashSet = new HashSet(this.getInterfacesOf(symbol));
        hashSet.removeAll(this.getInterfacesOf(symbol2));
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Symbol symbol3 = (Symbol)iterator.next();
            this.addInterfaceBridgesAux(symbol, symbol3.members());
        }
    }

    private void addInterfaceBridgesAux(Symbol symbol, Scope scope) {
        Scope.SymbolIterator symbolIterator = scope.iterator();
        while (symbolIterator.hasNext()) {
            Symbol symbol2 = symbolIterator.next();
            if (!symbol2.isTerm() || !symbol2.isDeferred()) continue;
            this.addInterfaceBridges(symbol, symbol2);
        }
    }

    private Symbol getOverriddenMethod(Symbol symbol) {
        Type[] typeArray = symbol.owner().parents();
        if (typeArray.length == 0) {
            return Symbol.NONE;
        }
        return symbol.overriddenSymbol(typeArray[0]);
    }

    public void addBridgeMethodsTo(Symbol symbol) {
        if (!($assertionsDisabled || symbol.owner().isClass() && !symbol.owner().isInterface())) {
            throw new AssertionError();
        }
        Symbol symbol2 = this.getOverriddenMethod(symbol);
        if (!symbol2.isNone() && !this.isSameAs(symbol2.nextType(), symbol.nextType())) {
            this.addBridge(symbol.owner(), symbol, symbol2);
        }
    }

    public void addInterfaceBridges(Symbol symbol, Symbol symbol2) {
        if (!($assertionsDisabled || symbol.isClass() && !symbol.isInterface())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        Symbol symbol3 = symbol2.overridingSymbol(symbol.thisType());
        if (symbol3 == symbol2) {
            Symbol symbol4 = symbol2.overriddenSymbol(symbol.thisType().parents()[0], symbol);
            if (!symbol4.isNone() && !this.isSameAs(symbol4.nextType(), symbol2.nextType())) {
                this.addBridge(symbol, symbol2, symbol4);
            }
        } else if (!symbol3.isNone() && !this.isSameAs(symbol3.nextType(), symbol2.nextType())) {
            this.addBridge(symbol, symbol3, symbol2);
        }
    }

    private void addBridges(Symbol symbol, TreeList treeList) {
        Object object;
        TreeList treeList2 = this.bridges;
        HashMap hashMap = this.bridgeSyms;
        this.bridges = new TreeList();
        this.bridgeSyms = new HashMap();
        int n = treeList.length();
        if (!symbol.isInterface()) {
            for (int i = 0; i < n; ++i) {
                object = treeList.get(i);
                if (((Tree)object).$tag != 13) continue;
                this.addBridgeMethodsTo(treeList.get(i).symbol());
            }
            this.addInterfaceBridges_(symbol);
        }
        treeList.append(this.bridges);
        if (this.bridges.length() > 0) {
            Type type = symbol.nextInfo();
            if (type.$tag == 0) {
                object = (Type.CompoundType)type;
                Type[] typeArray = ((Type.CompoundType)object).parts;
                Scope scope = ((Type.CompoundType)object).members;
                scope = scope.cloneScope();
                for (int i = 0; i < this.bridges.length(); ++i) {
                    Tree tree = this.bridges.get(i);
                    scope.enterOrOverload(tree.symbol());
                }
                symbol.updateInfo(Type.compoundType(typeArray, scope, type.symbol()));
            } else {
                throw Debug.abort(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("class = ".concat(String.valueOf(String.valueOf(Debug.show(symbol)))))).concat(", "))).concat("info = "))).concat(String.valueOf(String.valueOf(Debug.show(type)))));
            }
        }
        this.bridgeSyms = hashMap;
        this.bridges = treeList2;
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.transformer.Erasure").desiredAssertionStatus();
        UNBOXED_UNIT = Type.unboxedType(18);
        UNBOXED_BOOLEAN = Type.unboxedType(17);
        UNBOXED_BYTE = Type.unboxedType(10);
        UNBOXED_SHORT = Type.unboxedType(12);
        UNBOXED_CHAR = Type.unboxedType(11);
        UNBOXED_INT = Type.unboxedType(13);
        UNBOXED_LONG = Type.unboxedType(14);
        UNBOXED_FLOAT = Type.unboxedType(15);
        UNBOXED_DOUBLE = Type.unboxedType(16);
    }
}

