/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab;

import scala.tools.util.debug.Debug;
import scalac.ApplicationError;
import scalac.symtab.Symbol;
import scalac.symtab.SymbolTablePrinter;
import scalac.symtab.Type;
import scalac.util.Name;

public class Scope {
    private Entry elems;
    private Entry[] hashtable;
    private Symbol[] elemsCache = null;
    private final int HASHSIZE = 128;
    private final int HASHMASK = 127;
    private final int MIN_HASH = 6;
    public static Scope EMPTY;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public Symbol[] getElemsCache() {
        return this.elemsCache;
    }

    public Scope() {
        this.elems = Entry.NONE;
    }

    public Scope(Entry entry) {
        this.elems = entry;
        if (this.size() >= 6) {
            this.createHash();
        }
    }

    public Scope(Scope scope) {
        this.elems = scope.elems;
        if (scope.hashtable != null) {
            this.hashtable = new Entry[128];
            for (int i = 0; i < 128; ++i) {
                this.hashtable[i] = scope.hashtable[i];
            }
        }
    }

    public Scope(Symbol[] symbolArray) {
        this();
        for (int i = 0; i < symbolArray.length; ++i) {
            this.enter(symbolArray[i]);
        }
    }

    public Scope cloneScope() {
        int n = 0;
        Scope scope = new Scope();
        Entry entry = this.elems;
        while (entry != Entry.NONE) {
            new Entry(entry.sym, scope);
            entry = entry.access$10();
            ++n;
        }
        if (n >= 6) {
            scope.createHash();
        }
        return scope;
    }

    public boolean isEmpty() {
        return this.elems == Entry.NONE;
    }

    int size() {
        int n = 0;
        for (Entry entry = this.elems; entry != Entry.NONE; entry = entry.access$10()) {
            ++n;
        }
        return n;
    }

    public Scope enter(Entry entry) {
        if (!$assertionsDisabled && this == EMPTY) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(entry.sym))));
        }
        this.elems = entry;
        this.elemsCache = null;
        if (this.hashtable != null) {
            int n = entry.sym.name.index & 0x7F;
            this.elems.tail = this.hashtable[n];
            this.hashtable[n] = this.elems;
        } else if (this.size() >= 6) {
            this.createHash();
        }
        return this;
    }

    public Scope enter(Symbol symbol) {
        return this.enter(new Entry(symbol, this));
    }

    public final Scope enterNoHide(Symbol symbol) {
        if (!$assertionsDisabled && this.lookupEntry(symbol.name) != Entry.NONE) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(symbol)).concat(" hides "))).concat(String.valueOf(String.valueOf(this.lookup(symbol.name)))))));
        }
        return this.enter(symbol);
    }

    public Scope enterOrOverload(Symbol symbol) {
        Entry entry = this.lookupEntry(symbol.name);
        if (entry.owner == this) {
            entry.setSymbol(entry.sym.overloadWith(symbol));
            return this;
        }
        return this.enter(symbol);
    }

    private void createHash() {
        this.hashtable = new Entry[128];
        for (int i = 0; i < 128; ++i) {
            this.hashtable[i] = Entry.NONE;
        }
        this.enterInHash(this.elems);
    }

    private void enterInHash(Entry entry) {
        if (entry != Entry.NONE) {
            this.enterInHash(entry.access$10());
            int n = entry.sym.name.index & 0x7F;
            entry.tail = this.hashtable[n];
            this.hashtable[n] = entry;
        }
    }

    public void unlink(Entry entry) {
        Entry entry2;
        if (this.elems == entry) {
            this.elems = entry.access$10();
        } else {
            entry2 = this.elems;
            while (entry2.access$10() != entry) {
                entry2 = entry2.access$10();
            }
            entry2.access$11(entry.access$10());
        }
        if (this.hashtable != null) {
            entry2 = this.hashtable[entry.sym.name.index & 0x7F];
            if (entry2 == entry) {
                this.hashtable[entry.sym.name.index & 0x7F] = entry.tail;
            } else {
                while (entry2.tail != entry) {
                    entry2 = entry2.tail;
                }
                entry2.tail = entry.tail;
            }
        }
        this.elemsCache = null;
    }

    public boolean contains(Symbol symbol) {
        Entry entry = this.lookupEntry(symbol.name);
        if (entry.sym == symbol) {
            return true;
        }
        Type type = entry.sym.type();
        if (type.$tag == 4) {
            Type.OverloadedType overloadedType = (Type.OverloadedType)type;
            Symbol[] symbolArray = overloadedType.alts;
            for (int i = 0; i < symbolArray.length; ++i) {
                if (symbolArray[i] != symbol) continue;
                return true;
            }
        }
        return false;
    }

    public Symbol lookup(Name name) {
        return this.lookupEntry((Name)name).sym;
    }

    public Entry lookupEntry(Name name) {
        Entry entry;
        if (this.hashtable != null) {
            entry = this.hashtable[name.index & 0x7F];
            while (entry != Entry.NONE && entry.sym.name != name) {
                entry = entry.tail;
            }
        } else {
            for (entry = this.elems; entry != Entry.NONE && entry.sym.name != name; entry = entry.access$10()) {
            }
        }
        return entry;
    }

    public Symbol[] elements() {
        if (this.elemsCache == null) {
            int n = this.size();
            this.elemsCache = new Symbol[n];
            for (Entry entry = this.elems; entry != Entry.NONE; entry = entry.access$10()) {
                this.elemsCache[--n] = entry.sym;
            }
        }
        return this.elemsCache;
    }

    public SymbolIterator iterator() {
        return new MySymbolIterator();
    }

    public String toString() {
        return new SymbolTablePrinter().printScope(this).toString();
    }

    final /* synthetic */ Symbol[] access$12() {
        return this.elemsCache;
    }

    final /* synthetic */ Symbol[] access$9(Symbol[] symbolArray) {
        this.elemsCache = symbolArray;
        return symbolArray;
    }

    final /* synthetic */ Entry access$7() {
        return this.elems;
    }

    final /* synthetic */ Entry access$8(Entry entry) {
        this.elems = entry;
        return this.elems;
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.symtab.Scope").desiredAssertionStatus();
        EMPTY = new Scope();
    }

    class MySymbolIterator
    extends SymbolIterator {
        private Symbol[] alternatives = Symbol.EMPTY_ARRAY;
        private int altindex = 0;
        private int elemindex = 0;

        public MySymbolIterator() {
            Scope.this.elements();
        }

        public boolean hasNext() {
            return this.altindex < this.alternatives.length || this.elemindex < Scope.this.access$12().length;
        }

        public Symbol next() {
            if (this.altindex < this.alternatives.length) {
                return this.alternatives[this.altindex++];
            }
            Symbol symbol = Scope.this.access$12()[this.elemindex++];
            Type type = symbol.type();
            if (type.$tag == 4) {
                Type.OverloadedType overloadedType = (Type.OverloadedType)type;
                Symbol[] symbolArray = overloadedType.alts;
                this.alternatives = symbolArray;
                this.altindex = 0;
                return this.next();
            }
            return symbol;
        }
    }

    public static class Entry {
        public static final Entry NONE = new Entry();
        public Symbol sym;
        public Entry tail;
        private Entry next;
        public final Scope owner;

        public Entry(Symbol symbol, Scope scope) {
            this.sym = symbol;
            this.owner = scope;
            this.next = scope.access$7();
            if (symbol == null) {
                throw new ApplicationError();
            }
            scope.access$8(this);
        }

        private Entry() {
            this.sym = Symbol.NONE;
            this.owner = null;
        }

        public Entry setSymbol(Symbol symbol) {
            this.sym = symbol;
            this.owner.access$9(null);
            return this;
        }

        public int hashCode() {
            return this.sym.name.index;
        }

        public String toString() {
            return this.sym.toString();
        }

        final /* synthetic */ Entry access$10() {
            return this.next;
        }

        final /* synthetic */ Entry access$11(Entry entry) {
            this.next = entry;
            return this.next;
        }
    }

    public static abstract class SymbolIterator {
        public abstract boolean hasNext();

        public abstract Symbol next();
    }
}

