/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scalatest;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import scala.tools.scalatest.DiffPrint;

class FileUtils {
    public static final String FILE_SEP = System.getProperty("file.separator");
    public static final String PATH_SEP = System.getProperty("path.separator");

    public static boolean createDir(File file) {
        FileUtils.deleteDir(file);
        return file.mkdirs();
    }

    public static boolean deleteDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = FileUtils.deleteDir(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static File getTempDir() {
        File file = null;
        try {
            File file2 = File.createTempFile("dummy", null);
            file = file2.getParentFile();
            file2.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public static String compareFiles(File file, File file2) {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(new BufferedOutputStream(byteArrayOutputStream), true);
            System.setOut(printStream);
            System.setErr(printStream);
            DiffPrint.main(new String[]{file.getCanonicalPath(), file2.getCanonicalPath()});
            System.setOut(System.out);
            System.setErr(System.err);
            string = byteArrayOutputStream.toString();
            if (string.startsWith("No")) {
                string = "";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }
}

