/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scalai;

import java.util.HashMap;
import java.util.Map;
import scala.tools.scalai.Compiler;
import scala.tools.scalai.Function;
import scala.tools.scalai.JavaMirror;
import scala.tools.scalai.Override;
import scala.tools.scalai.ScalaTemplate;
import scala.tools.scalai.Template;
import scala.tools.scalai.Variable;
import scalac.ast.Tree;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Debug;
import scalac.util.Names;

public class Environment {
    private final Compiler compiler;
    private final JavaMirror mirror;
    private final Map classdefs;
    private final Map templates;
    private final Map functions;
    private final Map variables;
    private final Map overrides;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public Environment(Compiler compiler, JavaMirror javaMirror) {
        this.compiler = compiler;
        this.mirror = javaMirror;
        this.classdefs = new HashMap();
        this.templates = new HashMap();
        this.functions = new HashMap();
        this.variables = new HashMap();
        this.overrides = new HashMap();
    }

    public Class getClass(Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))));
        }
        Template template = this.lookupTemplate(symbol);
        switch (template.$tag) {
            case 0: {
                Template.Global global = (Template.Global)template;
                ScalaTemplate scalaTemplate = global.template;
                return scalaTemplate.getProxy();
            }
            case 1: {
                Template.JavaClass javaClass = (Template.JavaClass)template;
                Class clazz = javaClass.clasz;
                return clazz;
            }
        }
        throw scala.tools.util.debug.Debug.abort("illegal case", template);
    }

    public Class getClass(Type type) {
        switch (type.$tag) {
            case 8: {
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Symbol symbol = typeRef.sym;
                return this.getClass(symbol);
            }
            case 11: {
                Type.UnboxedType unboxedType = (Type.UnboxedType)type;
                int n = unboxedType.tag;
                return this.mirror.getClass(n);
            }
            case 10: {
                Type.UnboxedArrayType unboxedArrayType = (Type.UnboxedArrayType)type;
                Type type2 = unboxedArrayType.elemtp;
                return this.mirror.getArray(this.getClass(type2));
            }
        }
        throw scala.tools.util.debug.Debug.abort("illegal case", type);
    }

    public Tree.ClassDef insertClassDef(Symbol symbol, Tree.ClassDef classDef) {
        if (!$assertionsDisabled && !symbol.isType()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))));
        }
        if (!$assertionsDisabled && !Debug.log("insert classdef: ", symbol)) {
            throw new AssertionError();
        }
        Tree.ClassDef classDef2 = this.classdefs.put(symbol, classDef);
        if (!$assertionsDisabled && classDef2 != null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))).concat(" -> "))).concat(String.valueOf(String.valueOf(classDef2))))));
        }
        if (!$assertionsDisabled && this.templates.containsKey(symbol)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))));
        }
        return classDef;
    }

    private Template insertTemplate(Symbol symbol, Template template) {
        if (!$assertionsDisabled && !symbol.isType()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))));
        }
        if (!$assertionsDisabled && !Debug.log("insert template: ", symbol)) {
            throw new AssertionError();
        }
        Template template2 = this.templates.put(symbol, template);
        if (!$assertionsDisabled && this.classdefs.containsKey(symbol)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))));
        }
        if (!$assertionsDisabled && template2 != null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))).concat(" -> "))).concat(String.valueOf(String.valueOf(template2))))));
        }
        return template;
    }

    public Function insertFunction(Symbol symbol, Function function) {
        if (!$assertionsDisabled && !symbol.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))));
        }
        if (!$assertionsDisabled && !Debug.log("insert function: ", symbol)) {
            throw new AssertionError();
        }
        Function function2 = this.functions.put(symbol, function);
        if (!$assertionsDisabled && function2 != null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))).concat(" -> "))).concat(String.valueOf(String.valueOf(function2))))));
        }
        return function;
    }

    public Variable insertVariable(Symbol symbol, Variable variable) {
        if (!$assertionsDisabled && !symbol.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))));
        }
        if (!$assertionsDisabled && !Debug.log("insert variable: ", symbol)) {
            throw new AssertionError();
        }
        Variable variable2 = this.variables.put(symbol, variable);
        if (!$assertionsDisabled && variable2 != null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))).concat(" -> "))).concat(String.valueOf(String.valueOf(variable2))))));
        }
        return variable;
    }

    public Override insertOverride(Symbol symbol, Override override) {
        if (!$assertionsDisabled && !symbol.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))));
        }
        if (!$assertionsDisabled && !Debug.log("insert override: ", symbol)) {
            throw new AssertionError();
        }
        Override override2 = this.overrides.put(symbol, override);
        if (!$assertionsDisabled && override2 != null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))).concat(" -> "))).concat(String.valueOf(String.valueOf(override2))))));
        }
        return override;
    }

    public Template lookupTemplate(Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isType()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))));
        }
        Object v = this.templates.get(symbol);
        if (v != null) {
            return (Template)v;
        }
        if (symbol.isExternal()) {
            Template.JavaClass javaClass = Template.JavaClass(this.mirror.getClass(symbol));
            return this.insertTemplate(symbol, javaClass);
        }
        return this.loadTemplate(symbol);
    }

    public Function lookupFunction(Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))));
        }
        Object v = this.functions.get(symbol);
        if (v != null) {
            return (Function)v;
        }
        if (symbol.isExternal()) {
            Function function = symbol.name == Names.CONSTRUCTOR ? Function.JavaConstructor(this.mirror.getConstructor(symbol)) : Function.JavaMethod(this.mirror.getMethod(symbol));
            return this.insertFunction(symbol, function);
        }
        return (Function)this.loadOwnerThenGet("function", symbol, this.functions);
    }

    public Variable lookupVariable(Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))));
        }
        Object v = this.variables.get(symbol);
        if (v != null) {
            return (Variable)v;
        }
        if (symbol.isJava() && symbol.isModule()) {
            Class clazz = this.mirror.getClass(symbol.moduleClass());
            Variable.Global global = Variable.Global(clazz);
            return this.insertVariable(symbol, global);
        }
        if (symbol.isExternal()) {
            Variable.JavaField javaField = Variable.JavaField(this.mirror.getField(symbol));
            return this.insertVariable(symbol, javaField);
        }
        if (symbol.isModule() && symbol.isStatic()) {
            Template template = this.lookupTemplate(symbol.moduleClass());
            if (template.$tag == 0) {
                Template.Global global = (Template.Global)template;
                ScalaTemplate scalaTemplate = global.template;
                Variable.Module module = Variable.Module(scalaTemplate, null);
                return this.insertVariable(symbol, module);
            }
            throw scala.tools.util.debug.Debug.abort("illegal case", symbol);
        }
        return (Variable)this.loadOwnerThenGet("variable", symbol, this.variables);
    }

    public Override lookupOverride(Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))));
        }
        Object v = this.overrides.get(symbol);
        if (v != null) {
            return (Override)v;
        }
        return this.loadOwnerOverridesThenGet(symbol);
    }

    private Object loadOwnerThenGet(String string, Symbol symbol, Map map) {
        this.loadOwner(string, symbol);
        Object v = map.get(symbol);
        if (!$assertionsDisabled && v == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))).concat(" -> "))).concat(String.valueOf(String.valueOf(v))))));
        }
        return v;
    }

    private void loadOwner(String string, Symbol symbol) {
        if (!$assertionsDisabled && !Debug.log("search ", string, ": ", symbol)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !symbol.owner().isType()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))));
        }
        if (!$assertionsDisabled && symbol.owner().isExternal()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))));
        }
        this.loadTemplate(symbol.owner());
    }

    private Template loadTemplate(Symbol symbol) {
        Object v = this.classdefs.remove(symbol);
        if (v != null) {
            return this.loadTemplate(symbol, (Tree.ClassDef)v);
        }
        this.loadOwner("template", symbol);
        Object v2 = this.classdefs.remove(symbol);
        if (v2 != null) {
            return this.loadTemplate(symbol, (Tree.ClassDef)v2);
        }
        Object v3 = this.templates.get(symbol);
        if (!$assertionsDisabled && v3 == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))).concat(" -> "))).concat(String.valueOf(String.valueOf(v3))))));
        }
        return (Template)v3;
    }

    private Template loadTemplate(Symbol symbol, Tree.ClassDef classDef) {
        Template.Global global = Template.Global(this.compiler.load(symbol, classDef));
        return this.insertTemplate(symbol, global);
    }

    private Override loadOwnerOverridesThenGet(Symbol symbol) {
        if (!$assertionsDisabled && !Debug.log("search override: ", symbol)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !symbol.owner().isType()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))));
        }
        this.loadTemplateOverrides(symbol.owner());
        Object v = this.overrides.get(symbol);
        if (!$assertionsDisabled && v == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(scala.tools.util.debug.Debug.show(symbol))).concat(" -> "))).concat(String.valueOf(String.valueOf(v))))));
        }
        return (Override)v;
    }

    private void loadTemplateOverrides(Symbol symbol) {
        Type[] typeArray = symbol.parents();
        Scope.SymbolIterator symbolIterator = symbol.members().iterator();
        while (symbolIterator.hasNext()) {
            this.loadMethodOverride(typeArray, symbolIterator.next());
        }
    }

    private void loadMethodOverride(Type[] typeArray, Symbol symbol) {
        if (!symbol.isMethod()) {
            return;
        }
        Override override = Override.empty().insert(symbol);
        if (!symbol.isInitializer()) {
            if (symbol.isExternal()) {
                override.insert(this.mirror.getMethod(symbol));
            }
            for (int i = 0; i < typeArray.length; ++i) {
                Symbol symbol2 = symbol.overriddenSymbol(typeArray[i], true);
                if (symbol2 == Symbol.NONE) continue;
                if (!$assertionsDisabled && !Debug.log("update override: ", symbol, " <- ", symbol2)) {
                    throw new AssertionError();
                }
                override.insert(this.lookupOverride(symbol2));
            }
        }
        this.insertOverride(symbol, override);
    }

    static {
        $assertionsDisabled = !Class.forName("scala.tools.scalai.Environment").desiredAssertionStatus();
    }
}

