/*
 * Decompiled with CFR 0.152.
 */
package scalac.ast;

import scalac.ast.Tree;

public final class TreeList {
    Tree[] trees;
    int len;

    public TreeList(Tree[] treeArray) {
        this.trees = treeArray;
        this.len = treeArray.length;
    }

    public TreeList() {
        this.clear();
    }

    public void append(Tree tree) {
        if (this.len == this.trees.length) {
            Tree[] treeArray = new Tree[this.len == 0 ? 4 : this.len * 2];
            System.arraycopy(this.trees, 0, treeArray, 0, this.len);
            this.trees = treeArray;
        }
        this.trees[this.len++] = tree;
    }

    public void append(Tree[] treeArray) {
        for (int i = 0; i < treeArray.length; ++i) {
            this.append(treeArray[i]);
        }
    }

    public void append(TreeList treeList) {
        for (int i = 0; i < treeList.len; ++i) {
            this.append(treeList.trees[i]);
        }
    }

    public void clear() {
        this.trees = new Tree[4];
        this.len = 0;
    }

    public int length() {
        return this.len;
    }

    public Tree get(int n) {
        return this.trees[n];
    }

    public Tree first() {
        return this.trees[0];
    }

    public Tree removeLast() {
        return this.trees[--this.len];
    }

    public Tree[] toArray() {
        Tree[] treeArray = new Tree[this.len];
        System.arraycopy(this.trees, 0, treeArray, 0, this.len);
        return treeArray;
    }

    public Tree[] copyTo(Tree[] treeArray) {
        return this.copyTo(treeArray, 0);
    }

    public Tree[] copyTo(Tree[] treeArray, int n) {
        System.arraycopy(this.trees, 0, treeArray, n, this.len);
        return treeArray;
    }
}

