/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scaladoc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.tools.scaladoc.Servlet;

class RequestProcessor
implements Runnable {
    private static final String MIME_APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String MIME_APPLICATION_PDF = "application/pdf";
    private static final String MIME_APPLICATION_POSTSCRIPT = "application/postscript";
    private static final String MIME_IMAGE_GIF = "image/gif";
    private static final String MIME_IMAGE_JPEG = "image/jpeg";
    private static final String MIME_IMAGE_PNG = "image/png";
    private static final String MIME_TEXT_HTML = "text/html";
    private static final String MIME_TEXT_PLAIN = "text/plain";
    private static final String ENCODING_SCHEME = "iso-8859-1";
    private static List pool = new LinkedList();
    private File documentRootDirectory;
    private String indexFileName = "index.html";
    private Map servletNamed;
    private static final Hashtable mimes = new Hashtable();

    public RequestProcessor(File file, String string, Map map) {
        if (file.isFile()) {
            throw new IllegalArgumentException("documentRootDirectory must be a directory, not a file");
        }
        this.documentRootDirectory = file;
        try {
            this.documentRootDirectory = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string != null) {
            this.indexFileName = string;
        }
        this.servletNamed = map;
    }

    public static void processRequest(Socket socket) {
        List list = pool;
        synchronized (list) {
            try {
                pool.add(pool.size(), socket);
                pool.notifyAll();
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    public static Map parseQuery(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String[] stringArray = string.split("\\&");
            String string2 = "([^=]*)=([^=]*)";
            Pattern pattern = Pattern.compile(string2);
            for (int i = 0; i < stringArray.length; ++i) {
                Matcher matcher = pattern.matcher(stringArray[i]);
                if (!matcher.find()) continue;
                String string3 = URLDecoder.decode(matcher.group(1), ENCODING_SCHEME);
                String string4 = URLDecoder.decode(matcher.group(2), ENCODING_SCHEME);
                hashMap.put(string3, string4);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("Une exception: ".concat(String.valueOf(String.valueOf(unsupportedEncodingException))));
        }
        return hashMap;
    }

    private static String mkMIMEHeader(int n, String string, String string2, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("HTTP/1.0 ".concat(String.valueOf(n)))).concat(" "))).concat(String.valueOf(String.valueOf(string))))).concat("\r\n"));
        stringBuffer.append(String.valueOf(String.valueOf("Date: ".concat(String.valueOf(String.valueOf(new Date()))))).concat("\r\n"));
        stringBuffer.append("Server: HTTPServer 1.0\r\n");
        stringBuffer.append(String.valueOf(String.valueOf("Content-length: ".concat(String.valueOf(n2)))).concat("\r\n"));
        stringBuffer.append(String.valueOf(String.valueOf("Content-type: ".concat(String.valueOf(String.valueOf(string2))))).concat("\r\n\r\n"));
        return stringBuffer.toString();
    }

    private static void write(Writer writer, String string, int n, String string2, String string3, String string4) {
        try {
            if (string.startsWith("HTTP/")) {
                String string5 = RequestProcessor.mkMIMEHeader(n, string2, string3, string4.length());
                writer.write(string5);
            }
            writer.write(string4);
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeData(OutputStream outputStream, String string, int n, String string2, String string3, File file) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            byte[] byArray = new byte[(int)file.length()];
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            if (string.startsWith("HTTP/")) {
                String string4 = RequestProcessor.mkMIMEHeader(n, string2, string3, byArray.length);
                outputStream.write(string4.getBytes());
            }
            outputStream.write(byArray);
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeError(Writer writer, String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>\r\n");
        stringBuffer.append(String.valueOf(String.valueOf("<head><title>".concat(String.valueOf(String.valueOf(string2))))).concat("</title>\r\n"));
        stringBuffer.append("</head>\r\n");
        stringBuffer.append("<body>");
        stringBuffer.append(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("<h1>HTTP Error ".concat(String.valueOf(n)))).concat(": "))).concat(String.valueOf(String.valueOf(string2))))).concat("</h1>\r\n"));
        stringBuffer.append("</body></html>\r\n");
        RequestProcessor.write(writer, string, n, string2, MIME_TEXT_HTML, stringBuffer.toString());
    }

    private static void writeServlet(Writer writer, String string, Servlet servlet, URI uRI) {
        String string2 = uRI.getRawQuery();
        Map map = string2 != null ? RequestProcessor.parseQuery(string2) : new HashMap();
        RequestProcessor.write(writer, string, 200, "OK", MIME_TEXT_HTML, "<!-- generated with Scala Servlet -->\r\n");
        servlet.apply(map, writer);
        try {
            writer.write("\n");
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        var1_1 = this.documentRootDirectory.getPath();
        while (true) {
            var3_3 = RequestProcessor.pool;
            synchronized (var3_3) {
                try {
                    while (RequestProcessor.pool.isEmpty()) {
                        try {
                            RequestProcessor.pool.wait();
                        }
                        catch (InterruptedException var4_5) {
                        }
                    }
                    var2_2 = (Socket)RequestProcessor.pool.remove(0);
                    var6_10 = null;
                }
                catch (Throwable var5_8) {
                    var6_10 = null;
                    throw var5_8;
                }
            }
            try {
                block24: {
                    try {
                        var6_10 = new BufferedOutputStream(var2_2.getOutputStream());
                        var7_11 = new OutputStreamWriter(var6_10);
                        var8_12 = new InputStreamReader((InputStream)new BufferedInputStream(var2_2.getInputStream()), "ASCII");
                        var9_13 = new StringBuffer();
                        while ((var10_14 = var8_12.read()) != 13 && var10_14 != 10) {
                            var9_13.append((char)var10_14);
                        }
                        var11_15 = var9_13.toString();
                        System.out.println(var11_15);
                        var12_16 = new StringTokenizer(var11_15);
                        var13_17 = var12_16.nextToken();
                        var14_18 = "";
                        if (var13_17.equals("GET")) {
                            var4_4 = var12_16.nextToken();
                            var15_19 = new URI(var4_4);
                            var16_20 = var15_19.getPath();
                            var17_21 = (Servlet)this.servletNamed.get(var16_20);
                            if (var17_21 != null) {
                                RequestProcessor.writeServlet(var7_11, "HTTP/", var17_21, var15_19);
                                break block24;
                            }
                            if (var4_4.endsWith("/")) {
                                var4_4 = String.valueOf(String.valueOf(var4_4)).concat(String.valueOf(String.valueOf(this.indexFileName)));
                            }
                            var5_7 = RequestProcessor.guessContentTypeFromName(var4_4);
                            if (var12_16.hasMoreTokens()) {
                                var14_18 = var12_16.nextToken();
                            }
                            if ((var18_22 = new File(this.documentRootDirectory, var4_4.substring(1, var4_4.length()))).canRead() && var18_22.getCanonicalPath().startsWith(var1_1)) {
                                RequestProcessor.writeData(var6_10, var14_18, 200, "OK", var5_7, var18_22);
                                break block24;
                            } else {
                                RequestProcessor.writeError(var7_11, var14_18, 404, "File Not Found");
                            }
                            break block24;
                        }
                        RequestProcessor.writeError(var7_11, var14_18, 501, "Not Implemented");
                    }
                    catch (URISyntaxException var4_6) {
                        System.out.println("Une exception: ".concat(String.valueOf(String.valueOf(var4_6))));
                        var20_23 = null;
                        try {
                            var2_2.close();
                        }
                        catch (IOException var21_24) {}
                        continue;
                    }
                    catch (IOException var5_9) {
                        System.out.println("Une exception: ".concat(String.valueOf(String.valueOf(var5_9))));
                        var20_23 = null;
                        try {}
                        catch (IOException var21_24) {}
                        var2_2.close();
                        continue;
                    }
                }
                var20_23 = null;
                {
                }
            }
            catch (Throwable var19_25) {
                var20_23 = null;
                ** try [egrp 4[TRYBLOCK] [5 : 485->492)] { 
lbl80:
                // 1 sources

                var2_2.close();
                throw var19_25;
lbl82:
                // 1 sources

                catch (IOException var21_24) {
                    // empty catch block
                }
                throw var19_25;
            }
            try {}
            catch (IOException var21_24) {}
            var2_2.close();
        }
    }

    public static String guessContentTypeFromName(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            String string2 = string.substring(n + 1).toLowerCase();
            String string3 = (String)mimes.get(string2);
            return string3 == null ? MIME_TEXT_PLAIN : string3;
        }
        return MIME_TEXT_PLAIN;
    }

    static {
        mimes.put("c", MIME_TEXT_PLAIN);
        mimes.put("cc", MIME_TEXT_PLAIN);
        mimes.put("cpp", MIME_TEXT_PLAIN);
        mimes.put("class", MIME_APPLICATION_OCTET_STREAM);
        mimes.put("gif", MIME_IMAGE_GIF);
        mimes.put("h", MIME_TEXT_PLAIN);
        mimes.put("htm", MIME_TEXT_HTML);
        mimes.put("html", MIME_TEXT_HTML);
        mimes.put("lst", MIME_TEXT_PLAIN);
        mimes.put("java", MIME_TEXT_PLAIN);
        mimes.put("jpe", MIME_IMAGE_JPEG);
        mimes.put("jpg", MIME_IMAGE_JPEG);
        mimes.put("jpeg", MIME_IMAGE_JPEG);
        mimes.put("pdf", MIME_APPLICATION_PDF);
        mimes.put("pl", MIME_TEXT_PLAIN);
        mimes.put("ps", MIME_APPLICATION_POSTSCRIPT);
        mimes.put("png", MIME_IMAGE_PNG);
        mimes.put("scala", MIME_TEXT_PLAIN);
        mimes.put("text", MIME_TEXT_PLAIN);
        mimes.put("txt", MIME_TEXT_PLAIN);
    }
}

