/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.downloaders;

import com.apple.mrj.MRJFileUtils;
import com.apple.mrj.MRJOSType;
import com.zerog.ia.download.dialogs.ProgressDialog;
import com.zerog.ia.download.downloaders.FileDownloader;
import com.zerog.ia.download.downloaders.FileExecutor;
import com.zerog.ia.download.outputListeners.DownloadListener;
import com.zerog.ia.download.shared.DownloadContext;
import com.zerog.ia.download.utility.DiskSpaceCheckForDownload;
import com.zerog.ia.download.utility.Gestalt;
import com.zerog.ia.download.utility.Util;
import java.awt.Component;
import java.awt.FileDialog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Enumeration;
import netscape.security.PrivilegeManager;

public class ZGDownloader
extends FileDownloader {
    File fileDestination = null;
    private String macFileLocation = null;
    boolean executeFile = false;
    boolean fileToBeDeletedAfterExecute = true;
    long totalSoFar;
    long expectedFileSize = -1L;
    FileExecutor executorObject;
    DownloadContext downloadContext;
    private ProgressDialog progressDialog = null;
    private boolean fileExists = false;
    private DiskSpaceCheckForDownload diskSpaceCheck = null;
    private InputStream input = null;

    public ZGDownloader(DownloadContext downloadContext, ProgressDialog progressDialog) {
        super(downloadContext);
        this.downloadContext = downloadContext;
        this.progressDialog = progressDialog;
    }

    public void setFileDestination(File file) {
        this.fileDestination = file;
        System.err.println("ZGDownloader.setFileDestination(): '" + this.fileDestination.toString() + "'");
        if (Gestalt.getVMVendor().equals(Gestalt.APPLE_VM)) {
            String string;
            System.err.println("ZGDownloader.setFileDestination(): determining Mac OS download location");
            File file2 = this.fileDestination;
            int n = file2.getName().indexOf(".bin");
            if (n != -1) {
                string = file2.getName().substring(0, n);
                this.notifyOutputDiagnosticMessage("ZGDownloader.setFileDestination(): installer application name = '" + string + "'");
            } else {
                string = "";
            }
            if (string != null && !string.trim().equals("")) {
                File file3 = null;
                try {
                    File file4 = MRJFileUtils.findFolder((MRJOSType)new MRJOSType("desk"));
                    String string2 = Util.prepFileName(file4.getPath());
                    file3 = new File(string2, string);
                    try {
                        this.macFileLocation = file3.getCanonicalPath();
                        this.notifyOutputDiagnosticMessage("ZGDownloader.setFileDestination(): Mac OS file location_1: '" + this.macFileLocation + "'");
                    }
                    catch (Exception exception) {
                        this.macFileLocation = file3.getAbsolutePath();
                        this.notifyOutputDiagnosticMessage("ZGDownloader.setFileDestination(): Mac OS file location_2: '" + this.macFileLocation + "'");
                    }
                }
                catch (Exception exception) {
                    System.err.println("ZGDownloader.setFileDestination(): error determining Mac OS Desktop location.");
                    exception.printStackTrace();
                }
            } else {
                System.err.println("ZGDownloader.setFileDestination(): error determining Mac OS installer application name");
            }
        }
    }

    public File getFileDestination() {
        return this.fileDestination;
    }

    public void setExecuteFile(boolean bl) {
        this.executeFile = bl;
    }

    public boolean getExecuteFile() {
        return this.executeFile;
    }

    public void setFileToBeDeletedAfterExecute(boolean bl) {
        this.fileToBeDeletedAfterExecute = bl;
    }

    public boolean isFileToBeDeletedAfterExecute() {
        return this.fileToBeDeletedAfterExecute;
    }

    public void downloadFileNow(URL uRL) throws Exception {
        System.err.println("ZGDownloader.downloadFileNow(): attempting to download:");
        System.err.println("    from: " + uRL.toString());
        System.err.println("      to: " + this.fileDestination.toString());
        super.downloadFileNow(uRL);
        boolean bl = true;
        int n = 1;
        while (bl) {
            try {
                this.copyFileFromServer(uRL, this.fileDestination);
                bl = false;
            }
            catch (Exception exception) {
                if (n > 10) {
                    this.notifySetFriendlyErrorMessage("ZGDownloader.downloadFileNow(): Unable to open file '" + this.fileDestination.toString() + "'\n    " + "most likely because the file is marked as 'read-only'.");
                    throw new IOException(exception.getMessage());
                }
                int n2 = this.fileDestination.toString().lastIndexOf(46);
                if (n2 == -1) {
                    n2 = this.fileDestination.toString().length() - 1;
                }
                try {
                    this.setFileDestination(new File(this.fileDestination.toString().substring(0, n2) + ++n + this.fileDestination.toString().substring(n2)));
                }
                catch (Exception exception2) {
                    n = 100;
                }
            }
        }
        if (!this.isDownloadCancelled()) {
            this.notifyDownloadCompleted();
        } else {
            this.notifyDownloadCancelled();
        }
    }

    public void run() {
        System.err.println("ZGDownloader.run(): begin...");
        try {
            this.downloadFileNow(this.fileToDownload);
            this.setFileExecutor();
            if (this.executorObject != null && !this.isDownloadCancelled()) {
                this.notifyOutputDiagnosticMessage("ZGDownloader.run(): Preparing to start installer...");
                this.notifyOutputDiagnosticMessage("    - installer exists = " + this.fileExists);
                if (Gestalt.getVMVendor().equals(Gestalt.APPLE_VM)) {
                    this.progressDialog.setProgressDialogText(0, null, this.macFileLocation);
                } else {
                    this.progressDialog.setProgressDialogText(0, null, this.fileDestination.toString());
                }
                this.notifyOutputDiagnosticMessage("ZGDownloader.run(): attempting to initiate executor object...");
                this.executorObject.start();
                Thread.sleep(5000L);
                ((Component)this.progressDialog).setVisible(false);
                this.progressDialog.dispose();
            } else if (this.progressDialog != null) {
                ((Component)this.progressDialog).setVisible(false);
                this.progressDialog.dispose();
            }
        }
        catch (IOException iOException) {
            System.err.println("ZGDownloader.run(): an IOException occurred while attempting to launch the installer...");
            iOException.printStackTrace();
            FileDialog fileDialog = new FileDialog(this.context.getParentFrame(), "Save Installer", 1);
            if (Gestalt.getPlatform() == Gestalt.MAC_OS_X_PLATFORM) {
                fileDialog.setFile("install.zip");
            } else if (Gestalt.getPlatform() == Gestalt.WINDOWS_PLATFORM) {
                fileDialog.setFile("install.exe");
            } else {
                fileDialog.setFile("install.bin");
            }
            fileDialog.show();
            String string = fileDialog.getDirectory();
            String string2 = fileDialog.getFile();
            if (string != null && string2 != null) {
                System.err.println("ZGDownloader.run(): new Directory path = '" + string + "'");
                System.err.println("ZGDownloader.run(): new File name = '" + string2 + "'");
                this.setFileDestination(new File(string, string2));
                this.downloadCancelled = true;
                this.run();
            } else {
                this.notifyDownloadCancelled();
                if (this.progressDialog != null) {
                    ((Component)this.progressDialog).setVisible(false);
                    this.progressDialog.dispose();
                }
            }
        }
        catch (Exception exception) {
            System.err.println("ZGDownloader.run(): an Exception occurred while attempting to launch the installer...");
            exception.printStackTrace();
            this.notifyErrorOccured(exception);
        }
    }

    /*
     * Loose catch block
     */
    private void copyFileFromServer(URL uRL, File file) throws Exception {
        File file2;
        long l;
        block28: {
            RandomAccessFile randomAccessFile;
            block27: {
                this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): sourceURL = '" + uRL.toString() + "'");
                this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): destinationFile = '" + file.toString() + "'");
                if (Gestalt.isNetscapeSecurityModelAvailable()) {
                    this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): Netscape Security Model = true");
                    PrivilegeManager.enablePrivilege((String)Gestalt.NETSCAPE_FILE_ACCESS);
                }
                this.input = DiskSpaceCheckForDownload.input;
                l = DiskSpaceCheckForDownload.contentLength;
                this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): total bytes in url file: " + l);
                Enumeration enumeration = this.downloadListenerList.elements();
                while (enumeration.hasMoreElements()) {
                    ((DownloadListener)enumeration.nextElement()).setTotalNumberOfBytesInFile(l);
                }
                if (file.length() == l) {
                    this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): destination file matches source file -- aborting additional download");
                    this.fileExists = true;
                    return;
                }
                if (Gestalt.isNetscapeSecurityModelAvailable()) {
                    PrivilegeManager.enablePrivilege((String)Gestalt.NETSCAPE_FILE_ACCESS);
                }
                if (!Util.makeLeadingDirectories(file)) {
                    this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): failure to create download directories: '" + file.getPath() + "'");
                    this.notifySetFriendlyErrorMessage("This volume is not writeable, you will be asked to choose a new location.");
                    throw new IOException("Disk is not writeable.");
                }
                this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): download directories created:  '" + file.getPath() + "'");
                randomAccessFile = null;
                try {
                    randomAccessFile = new RandomAccessFile(file, "rw");
                }
                catch (Exception exception) {
                    System.err.println("ZGDownloader.copyFileFromServer(): exception creating random access");
                    exception.printStackTrace();
                    if (file.exists()) {
                        throw new InterruptedIOException(exception.getMessage());
                    }
                    this.notifySetFriendlyErrorMessage("ZGDownloader.copyFileFromServer(): unable to access destination file '" + file + "'.");
                    throw exception;
                }
                this.totalSoFar = 0L;
                this.notifyDownloadStarted(uRL.toString());
                this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): preparing download...");
                byte[] byArray = new byte[4096];
                int n = 0;
                try {
                    block9: while (true) {
                        if (this.isDownloadCancelled()) {
                            this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): download cancelled by user.");
                            break;
                        }
                        n = this.input.read(byArray);
                        this.totalSoFar += (long)n;
                        if (n <= 0) break;
                        randomAccessFile.write(byArray, 0, n);
                        Enumeration enumeration2 = this.downloadListenerList.elements();
                        while (true) {
                            if (!enumeration2.hasMoreElements()) continue block9;
                            ((DownloadListener)enumeration2.nextElement()).setBytesInFileDownloaded(this.totalSoFar);
                        }
                        break;
                    }
                    this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): download should be complete!");
                    file2 = null;
                    if (this.input == null) break block27;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    if (this.input != null) {
                        this.input.close();
                    }
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): streams closed");
                    throw throwable;
                }
                this.input.close();
            }
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            break block28;
            {
                catch (Exception exception) {
                    throw exception;
                }
            }
        }
        this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): streams closed");
        this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): downloadCancelled = " + this.downloadCancelled);
        this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): bytes downloaded = " + this.totalSoFar);
        this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): destinationFile size = " + file.length());
        this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): expected content length = " + l);
        if (this.isDownloadCancelled()) {
            this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): download cancelled; attempting to delete: '" + file.toString() + "'");
            boolean bl = file.delete();
            if (bl) {
                this.notifyOutputDiagnosticMessage("    - deletion successful");
            }
            String string = null;
            file2 = null;
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string = file.getAbsolutePath();
            }
            if (string != null) {
                string = new File(string).getParent();
            }
            if (string != null) {
                file2 = new File(string);
            }
            this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): attempting to parent directories: '" + file2.toString() + "'");
            boolean bl2 = file2.delete();
            if (bl2) {
                this.notifyOutputDiagnosticMessage("    - deletion successful");
            }
            this.executorObject = null;
            this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): download cancelled successfully");
        } else {
            if (file.length() != l) {
                this.notifySetFriendlyErrorMessage("ZGDownloader.copyFileFromServer(): installer was not completely downloaded -- disk may be full.");
                throw new Exception("Unable to successfully complete download");
            }
            this.notifySetFriendlyErrorMessage("ZGDownloader.copyFileFromServer(): downloaded completed successfully.");
            this.fileExists = true;
        }
    }

    public long getTotalSoFar() {
        return this.totalSoFar;
    }

    void setFileExecutor() {
        FileExecutor fileExecutor = new FileExecutor(this.fileDestination, this);
        this.setExecutorObject(fileExecutor);
    }

    public void setExecutorObject(FileExecutor fileExecutor) {
        this.executorObject = fileExecutor;
    }
}

