/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003-2004, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
** $Id: Molecule.scala,v 1.1 2005/05/04 17:37:30 buraq Exp $
\*                                                                      */

package scala.xml;

/** an XML node for text (PCDATA). Used in both non-bound and bound XML 
 *  representations
 * @author Burak Emir
 * @param text the text contained in this node, may not be null.
 */
class Molecule[+A]( val list: List[A] ) extends SpecialNode {  

  final override def typeTag$:Int = -1;

  /** the constant "#PCDATA"
  */
  def label = "#PCDATA";

  final override def equals(x:Any) = x match {
    case s:Molecule[A] => list == s.list ;
    case _ => false;
  }

  /** hashcode for this Text */
  override def hashCode() = 
    list.hashCode();
  
  /** returns text, with some characters escaped according to XML spec */
  def toString(sb:StringBuffer) = 
    sb.append(list.mkString(""," ",""))
    
}
