/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003-2004, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
** $Id: Comment.scala,v 1.6 2005/04/24 22:19:28 buraq Exp $
\*                                                                      */

package scala.xml;

import scala.collection.immutable ;

/** an XML node for comments.
 *
 * @author Burak Emir
 * @param text text contained in this node, may not contain "--"
 */

case class Comment(text: String) extends SpecialNode {  

  final override def typeTag$:Int = -3;

  if( text.indexOf("--" ) != -1 ) 
    throw new IllegalArgumentException("text containts \"--\"");

  /** structural equality */
  override def equals(x: Any): Boolean = x match {
    case Comment(x) => x.equals(text);
      case _ => false
  }

  /** the constant &quot;#REM&quot; */
  def label    = "#REM";

  /** hashcode for this Comment */
  override def hashCode() = text.hashCode();

  /** appends &quot;<!-- text -->&quot; to this stringbuffer */
  def toString(sb: StringBuffer) = {
    sb.append("<!--").append(text).append("-->")
  }
}
