/*
 * Decompiled with CFR 0.152.
 */
package scalac.transformer;

import java.util.HashMap;
import java.util.Map;
import scala.tools.util.debug.Debug;
import scalac.Global;
import scalac.ast.GenTransformer;
import scalac.ast.Tree;
import scalac.ast.TreeList;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.SymbolSubstTypeMap;
import scalac.symtab.Type;
import scalac.transformer.AddInterfacesPhase;

public class AddInterfaces
extends GenTransformer {
    private final AddInterfacesPhase phase;
    private Symbol clasz;
    private Symbol member;
    private Type.Map classSubst;
    private SymbolSubstTypeMap paramSubst;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public AddInterfaces(Global global, AddInterfacesPhase addInterfacesPhase) {
        super(global);
        this.phase = addInterfacesPhase;
    }

    public Symbol getSymbolFor(Tree tree) {
        switch (tree.$tag) {
            case 12: {
                return this.phase.getClassSymbol(tree.symbol());
            }
            case 26: {
                return this.member;
            }
            case 34: {
                return this.clasz;
            }
            case 31: {
                return this.clasz;
            }
            case 27: {
                Tree.Select select = (Tree.Select)tree;
                if (select.qualifier.$tag == 31) {
                    Symbol symbol = tree.symbol();
                    if (symbol.isInitializer()) {
                        return this.getClassMember(symbol);
                    }
                    return this.getClassMember(symbol, true);
                }
                Symbol symbol = tree.symbol();
                if (symbol.isInitializer()) {
                    return this.getClassMember(symbol);
                }
                return symbol;
            }
            case 17: {
                Symbol symbol = tree.symbol();
                if (symbol.isInitializer()) {
                    return this.getClassMember(symbol);
                }
                if (symbol.isParameter() && !symbol.owner().isStatic()) {
                    return this.getClassVParam(symbol);
                }
                return symbol;
            }
        }
        return tree.symbol();
    }

    public Type transform(Type type) {
        if (this.classSubst != null) {
            type = this.classSubst.apply(type);
        }
        if (this.paramSubst != null) {
            type = this.paramSubst.apply(type);
        }
        return type;
    }

    public Tree[] transform(Tree[] treeArray) {
        if (this.member != null) {
            return super.transform(treeArray);
        }
        TreeList treeList = new TreeList();
        for (int i = 0; i < treeArray.length; ++i) {
            this.template(treeList, treeArray[i]);
        }
        return treeList.toArray();
    }

    public Tree transform(Tree tree) {
        switch (tree.$tag) {
            case 40: {
                Symbol symbol = tree.symbol();
                if (symbol.owner() != this.member) {
                    symbol.updateInfo(this.transform(symbol.info()));
                    symbol.setOwner(this.member);
                }
                return super.transform(tree);
            }
            case 20: {
                Symbol symbol = tree.symbol();
                if (symbol.owner() != this.member) {
                    symbol.updateInfo(this.transform(symbol.info()));
                    symbol.setOwner(this.member);
                }
                return super.transform(tree);
            }
            case 27: {
                Tree.Select select = (Tree.Select)tree;
                Tree tree2 = select.qualifier;
                Type type = tree2.type();
                tree2 = this.transform(tree2);
                Symbol symbol = this.getSymbolFor(tree);
                if (symbol.isJava() && !symbol.owner().isInterface() && tree2.type().widen().symbol().isInterface()) {
                    Type type2 = type.baseType(symbol.owner());
                    if (!$assertionsDisabled && type2 == Type.NoType) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
                    }
                    tree2 = this.gen.mkAsInstanceOf(tree2, type2);
                }
                return this.gen.Select(tree.pos, tree2, symbol);
            }
        }
        return super.transform(tree);
    }

    private void template(TreeList treeList, Tree tree) {
        switch (tree.$tag) {
            case 42: {
                return;
            }
            case 24: {
                treeList.append(super.transform(tree));
                return;
            }
            case 10: {
                Tree.ClassDef classDef = (Tree.ClassDef)tree;
                if (classDef.impl.$tag != 33) break;
                Tree.Template template = classDef.impl;
                Tree[] treeArray = template.body;
                TreeList treeList2 = new TreeList(this.transform(treeArray));
                this.clasz = tree.symbol();
                HashMap hashMap = new HashMap();
                if (this.phase.needInterface(this.clasz)) {
                    Symbol symbol = this.phase.getClassSymbol(this.clasz);
                    treeList.append(this.getClassTree(this.clasz, treeList2, hashMap));
                    treeList2 = new TreeList();
                    this.classSubst = new Type.SubstThisMap(this.clasz, symbol);
                    this.paramSubst = this.phase.getClassSubst(symbol);
                    this.clasz = symbol;
                }
                for (int i = 0; i < treeArray.length; ++i) {
                    this.member(hashMap, treeArray[i]);
                }
                treeList.append(this.getClassTree(this.clasz, treeList2, hashMap));
                if (!$assertionsDisabled && !hashMap.isEmpty()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(hashMap.keySet().toArray()))));
                }
                this.paramSubst = null;
                this.classSubst = null;
                this.clasz = null;
                return;
            }
            case 13: {
                return;
            }
            case 40: {
                return;
            }
        }
        throw Debug.abort("illegal tree", tree);
    }

    private void member(Map map, Tree tree) {
        switch (tree.$tag) {
            case 10: {
                return;
            }
            case 13: {
                Tree.DefDef defDef = (Tree.DefDef)tree;
                Tree tree2 = defDef.rhs;
                if (tree2 == Tree.Empty) {
                    return;
                }
                Symbol symbol = tree.symbol();
                this.member = this.getClassMember(symbol);
                if (this.member != symbol) {
                    this.paramSubst.insertSymbol(symbol.typeParams(), this.member.nextTypeParams());
                    this.paramSubst.insertSymbol(symbol.valueParams(), this.member.nextValueParams());
                }
                map.put(this.member, this.gen.DefDef(this.member, this.transform(tree2)));
                if (this.member != symbol) {
                    this.paramSubst.removeSymbol(symbol.valueParams());
                    this.paramSubst.removeSymbol(symbol.typeParams());
                }
                this.member = null;
                return;
            }
            case 40: {
                Tree.ValDef valDef = (Tree.ValDef)tree;
                Tree tree3 = valDef.rhs;
                if (!$assertionsDisabled && tree3 != Tree.Empty) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
                }
                return;
            }
        }
        throw Debug.abort("illegal tree", tree);
    }

    private Tree getClassTree(Symbol symbol, TreeList treeList, Map map) {
        Tree[] treeArray;
        Scope scope = symbol.nextInfo().members();
        Scope.SymbolIterator symbolIterator = scope.iterator();
        while (symbolIterator.hasNext()) {
            treeArray = symbolIterator.next();
            if (!treeArray.isTerm()) continue;
            treeList.append(this.getMemberTree(symbol, (Symbol)treeArray, map));
        }
        treeArray = treeList.toArray();
        if (!symbol.isInterface()) {
            this.phase.classToBody.put(symbol, treeArray);
        }
        return this.gen.ClassDef(symbol, treeArray);
    }

    private Tree getMemberTree(Symbol symbol, Symbol symbol2, Map map) {
        if (!symbol2.isMethod()) {
            return this.gen.ValDef(symbol2, Tree.Empty);
        }
        if (symbol2.isDeferred()) {
            return this.gen.DefDef(symbol2, Tree.Empty);
        }
        Tree tree = (Tree)map.remove(symbol2);
        if (!$assertionsDisabled && tree == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(symbol)).concat("."))).concat(String.valueOf(String.valueOf(symbol2))))).concat(":"))).concat(String.valueOf(String.valueOf(symbol2.info()))))).concat(String.valueOf(String.valueOf(symbol2.locationString())))))));
        }
        return tree;
    }

    private Symbol getClassVParam(Symbol symbol) {
        if (this.paramSubst == null) {
            return symbol;
        }
        Symbol symbol2 = this.paramSubst.lookupSymbol(symbol);
        if (!$assertionsDisabled && symbol2 == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol, this.clasz, this.member))));
        }
        return symbol2;
    }

    private Symbol getClassMember(Symbol symbol) {
        return this.getClassMember(symbol, false);
    }

    private Symbol getClassMember(Symbol symbol, boolean bl) {
        Symbol symbol2 = symbol.owner();
        if (!$assertionsDisabled && !symbol2.isClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        if (!this.phase.needInterface(symbol2)) {
            return symbol;
        }
        Symbol symbol3 = this.phase.getClassSymbol(symbol2);
        Symbol symbol4 = (Symbol)this.phase.getClassMemberMap(symbol3).get(symbol);
        if (!$assertionsDisabled && symbol4 == null && !bl) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol, " not in ", symbol3))));
        }
        return symbol4 != null ? symbol4 : symbol;
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.transformer.AddInterfaces").desiredAssertionStatus();
    }
}

