/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scaladoc;

import ch.epfl.lamp.util.Pair;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import scala.tools.scaladoc.HTMLValidator;
import scala.tools.scaladoc.Tag;
import scalac.CompilationUnit;
import scalac.symtab.Symbol;

public class Comment
extends DefaultHandler {
    public final Symbol holder;
    CompilationUnit unit;
    public final String rawText;
    public String text;
    public Tag[] tags;

    public Comment(String string, Symbol symbol, CompilationUnit compilationUnit, HTMLValidator hTMLValidator) {
        this.holder = symbol;
        this.rawText = Comment.cleanComment(string);
        this.unit = compilationUnit;
        if (!this.isEmpty()) {
            hTMLValidator.validate(this.rawText, this);
        }
        this.parseComment();
    }

    public boolean isEmpty() {
        return "".equals(this.rawText);
    }

    public boolean containsTag(String string) {
        string = string.startsWith("@") ? string : "@".concat(String.valueOf(String.valueOf(string)));
        for (int i = 0; i < this.tags.length; ++i) {
            if (!this.tags[i].name.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String cleanComment(String string) {
        if (string == null) {
            return "";
        }
        string = string.substring(3, string.length() - 2);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "^([ \\t]*)([\\*]*)(.*)$";
        Pattern pattern = Pattern.compile(string2, 8);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            if (matcher.group(2).length() == 0) {
                stringBuffer.append(String.valueOf(String.valueOf(String.valueOf(String.valueOf(matcher.group(1))).concat(String.valueOf(String.valueOf(matcher.group(2)))))).concat(String.valueOf(String.valueOf(matcher.group(3)))));
            } else {
                stringBuffer.append(matcher.group(3));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    protected void parseComment() {
        String string = "\n[ ]*@|\\A[ ]*@";
        String[] stringArray = this.rawText.split(string);
        if (stringArray.length == 0) {
            this.text = "";
            this.tags = new Tag[0];
        } else {
            int n;
            if (stringArray[0].startsWith("@")) {
                this.text = "";
                n = 0;
            } else {
                this.text = stringArray[0];
                n = 1;
            }
            LinkedList<Tag> linkedList = new LinkedList<Tag>();
            for (int i = n; i < stringArray.length; ++i) {
                Pair pair = Tag.split(stringArray[i]);
                String string2 = (String)pair.fst;
                String string3 = (String)pair.snd;
                linkedList.add(new Tag(this.holder, "@".concat(String.valueOf(String.valueOf(string2))), string3));
            }
            this.tags = linkedList.toArray(new Tag[linkedList.size()]);
        }
    }

    public static Tag[] makeTags(Symbol symbol, String string) {
        String string2;
        LinkedList<Tag> linkedList = new LinkedList<Tag>();
        Pattern pattern = Pattern.compile("\\{@([^\\}]*)\\}");
        Matcher matcher = pattern.matcher(string);
        int n = 0;
        while (matcher.find()) {
            string2 = string.substring(n, matcher.start());
            if (!string2.equals("")) {
                linkedList.add(new Tag(symbol, "@text", string2));
            }
            Pair pair = Tag.split(matcher.group(1));
            String string3 = (String)pair.fst;
            String string4 = (String)pair.snd;
            linkedList.add(new Tag(symbol, "@".concat(String.valueOf(String.valueOf(string3))), string4));
            n = matcher.end();
        }
        string2 = string.substring(n, string.length());
        if (!string2.equals("")) {
            linkedList.add(new Tag(symbol, "@text", string2));
        }
        return linkedList.toArray(new Tag[linkedList.size()]);
    }

    public String firstSentence() {
        Pattern pattern = Pattern.compile("\\.(\\s)");
        Matcher matcher = pattern.matcher(this.text);
        if (matcher.find()) {
            return this.text.substring(0, matcher.start(1));
        }
        return this.text;
    }

    public void warning(SAXParseException sAXParseException) {
    }

    public void error(SAXParseException sAXParseException) {
        this.showHtmlError(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.showHtmlError(sAXParseException);
    }

    void showHtmlError(SAXParseException sAXParseException) {
        String string = "";
        string = String.valueOf(String.valueOf(string)).concat("documentation comments should be written in XHTML\n");
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(sAXParseException.getMessage())).concat("\n"))));
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.rawText)));
        if (this.unit != null) {
            this.unit.warning(this.holder.pos, string);
        }
    }
}

