/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.downloaders.macexecutils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MacMB2InputStream
extends FilterInputStream {
    static final int ByteBoundary = 128;
    static final int HeaderLength = 128;
    static final short Off_HeaderBeginning = 0;
    static final short Off_OldVersionNumber = 0;
    static final short Off_FileNameLength = 1;
    static final short Off_FileName = 2;
    static final short Off_Type = 65;
    static final short Off_Creator = 69;
    static final short Off_HighFinderFlags = 73;
    static final short Off_ZeroFill = 74;
    static final short Off_YWindowPosition = 75;
    static final short Off_HWindowPosition = 77;
    static final short Off_FolderID = 79;
    static final short Off_ProtectedFlag = 81;
    static final short Off_ZeroFill2 = 82;
    static final short Off_DataLength = 83;
    static final short Off_ResourceLength = 87;
    static final short Off_CreationDate = 91;
    static final short Off_ModifiedDate = 95;
    static final short Off_CommentLength = 99;
    static final short Off_LowFinderFlags = 101;
    static final short Off_Unused = 102;
    static final short Off_TotalFileLength = 116;
    static final short Off_Header2Length = 120;
    static final short Off_MEUMB2Version = 122;
    static final short Off_MinimumMEUMB2Version = 123;
    static final short Off_CRC = 124;
    static final short Off_LastByte = 127;
    private static final int kBufferSize = 2048;
    static final byte kDataForkType = 0;
    static final byte kRsrcForkType = 1;
    private static final boolean debug = false;
    private BufferedInputStream in;
    private byte[] mbHeader;
    private byte[] finderInfo;
    private long byteAlignedrsrcForkLength;
    private long rsrcForkLength;
    private long rsrcForkMark;
    private long byteAlignedDataForkLength;
    private long dataForkLength;
    private long dataForkMark;
    private long finderInfoMark;
    private byte lastForkRead;
    private File dataForkBuffer;
    private boolean dataForkCompletelyRead = false;

    public MacMB2InputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        boolean bl = false;
        this.in = new BufferedInputStream(inputStream);
        this.mbHeader = new byte[128];
        try {
            this.in.read(this.mbHeader, 0, 128);
        }
        catch (Exception exception) {
            throw new IOException("MacBinary header truncated");
        }
        this.verifyHeader();
        this.makeFinderInfo();
        this.rsrcForkLength = MacMB2InputStream.SignUnsignedBytes(this.mbHeader, 87, 4);
        this.byteAlignedrsrcForkLength = this.rsrcForkLength % 128L == 0L ? this.rsrcForkLength : (this.rsrcForkLength / 128L + 1L) * 128L;
        this.dataForkLength = MacMB2InputStream.SignUnsignedBytes(this.mbHeader, 83, 4);
        this.byteAlignedDataForkLength = this.dataForkLength % 128L == 0L ? this.dataForkLength : (this.dataForkLength / 128L + 1L) * 128L;
        this.rsrcForkMark = 0L;
        this.dataForkMark = 0L;
        this.lastForkRead = 0;
        if (false) {
            System.err.println("MacMB2InputStream");
            System.err.println("byteAlignedrsrcForkLength\t" + this.byteAlignedrsrcForkLength);
            System.err.println("rsrcForkLength\t" + this.rsrcForkLength);
            System.err.println("rsrcForkMark\t" + this.rsrcForkMark);
            System.err.println("byteAlignedDataForkLength\t" + this.byteAlignedDataForkLength);
            System.err.println("dataForkLength\t" + this.dataForkLength);
            System.err.println("dataForkMark\t" + this.dataForkMark);
        }
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported for MacBinary input stream.");
        }
    }

    public boolean markSupported() {
        return false;
    }

    private void makeFinderInfo() throws IOException {
        this.finderInfo = new byte[16];
        System.arraycopy(this.mbHeader, 65, this.finderInfo, 0, 4);
        System.arraycopy(this.mbHeader, 69, this.finderInfo, 4, 4);
        System.arraycopy(this.mbHeader, 73, this.finderInfo, 8, 1);
        System.arraycopy(this.mbHeader, 101, this.finderInfo, 9, 1);
        this.finderInfo[9] = (byte)(this.finderInfo[9] & 0xFC);
        this.finderInfo[8] = (byte)(this.finderInfo[8] & 0xFC);
    }

    private void verifyHeader() throws IOException {
        if (this.mbHeader[0] != 0 || this.mbHeader[74] != 0 || this.mbHeader[82] != 0) {
            throw new IOException("Invalid MacBinary header");
        }
        short s = MacMB2InputStream.SignUnsignedByte(this.mbHeader[123]);
        if (s > 129) {
            Short s2 = new Short(s);
            throw new IOException("Macbinary version in file is: " + s2.toString() + "This decoder only supports 129");
        }
    }

    private int readFork(byte[] byArray, int n, int n2, byte by) throws IOException {
        int n3 = n2;
        int n4 = 0;
        if (by == 1 & !this.dataForkCompletelyRead) {
            throw new IOException("For now, you must read all of the data fork before skipping to the resource fork");
        }
        if (by == 0) {
            n3 = (int)(this.dataForkLength - this.dataForkMark);
            if (this.lastForkRead != 0) {
                this.in.reset();
                n3 = (int)(this.dataForkLength - this.dataForkMark);
            }
            this.lastForkRead = 0;
        } else {
            n3 = (int)(this.rsrcForkLength - this.rsrcForkMark);
            if (this.lastForkRead != 1) {
                long l;
                long l2 = l = this.byteAlignedDataForkLength + this.rsrcForkMark - this.dataForkMark;
                long l3 = 0L;
                this.in.mark((int)l);
                while ((l3 = this.in.skip(l2)) != -1L & l2 > 0L) {
                    l2 -= l3;
                }
                n3 = (int)(this.rsrcForkLength - this.rsrcForkMark);
            }
            this.lastForkRead = 1;
        }
        if (n3 == 0 & n2 > 0) {
            if (this.lastForkRead == 0) {
                int n5 = (int)(this.byteAlignedDataForkLength - this.dataForkMark);
                long l = 0L;
                while ((l = this.in.skip(n5)) != -1L & n5 > 0) {
                    n5 = (int)((long)n5 - l);
                    this.dataForkMark += l;
                }
                this.dataForkCompletelyRead = true;
            }
            return -1;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        if ((n4 = this.in.read(byArray, n, n2)) != -1) {
            if (this.lastForkRead == 0) {
                this.dataForkMark += (long)n4;
            } else {
                this.rsrcForkMark += (long)n4;
            }
        } else {
            throw new IOException("Read past end of stream.");
        }
        return n4;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.readFork(byArray, n, n2, (byte)0);
    }

    public long skip(long l) throws IOException {
        return -1L;
    }

    public int readRF() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.readRF(byArray);
        if (n != -1) {
            n = byArray[1];
        }
        return n;
    }

    public int readRF(byte[] byArray) throws IOException {
        return this.readFork(byArray, 0, byArray.length, (byte)1);
    }

    public int readRF(byte[] byArray, int n, int n2) throws IOException {
        return this.readFork(byArray, n, n2, (byte)1);
    }

    public long skipRF(long l) throws IOException {
        return 0L;
    }

    public void getFinderInfo(byte[] byArray) {
        System.arraycopy(this.finderInfo, 0, byArray, 0, this.finderInfo.length);
    }

    public String getFilename() {
        return new String(this.mbHeader, 2, (int)this.mbHeader[1]);
    }

    public static short SignUnsignedByte(byte by) {
        if (by >= 0) {
            return by;
        }
        return (short)(256 + by);
    }

    public static long SignUnsignedBytes(byte[] byArray, int n, int n2) {
        if (n2 > 8) {
            return -1L;
        }
        long l = 0L;
        int n3 = 0;
        while (n3 < n2) {
            l <<= 8;
            l += (long)MacMB2InputStream.SignUnsignedByte(byArray[n3 + n]);
            ++n3;
        }
        return l;
    }
}

