/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.downloaders.macexecutils;

import com.apple.mrj.MRJFileUtils;
import com.apple.mrj.MRJOSType;
import com.zerog.ia.download.downloaders.FileDownloader;
import com.zerog.ia.download.downloaders.macexecutils.MacComLineExec;
import com.zerog.ia.download.downloaders.macexecutils.MacDecoder;
import com.zerog.ia.download.utility.Util;
import java.io.File;

public class MacFileRunner {
    FileDownloader download;
    File fileToRun;

    public MacFileRunner(File file, FileDownloader fileDownloader) {
        this.fileToRun = file;
        this.download = fileDownloader;
    }

    public void runMacFile() {
        int n = this.fileToRun.getName().indexOf(".bin");
        String string = n != -1 ? this.fileToRun.getName().substring(0, n) : "";
        try {
            String string2 = Util.prepFileName(this.fileToRun.getParent());
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            File file = new File(string2, string);
            try {
                this.download.notifyOutputDiagnosticMessage("MacTryInstaller: MacBinaried File to Exec: " + this.fileToRun.getCanonicalPath());
                this.download.notifyOutputDiagnosticMessage("MacTryInstaller: Copy of MacBinary File: " + file.getCanonicalPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.download.notifyOutputDiagnosticMessage("Decoding MacBinary file...");
            String string3 = MacDecoder.decode(this.fileToRun, string2);
            this.download.notifyOutputDiagnosticMessage("Decoded to " + string3);
            this.download.notifyOutputDiagnosticMessage("Debugging Info:");
            if (new File(file.getAbsolutePath()).exists()) {
                this.download.notifyOutputDiagnosticMessage("   File (binCopyFile): " + file.getAbsolutePath() + " exists.");
                this.setFileTypeAndCreator(file, "APPL", "IAse");
            } else {
                this.download.notifyOutputDiagnosticMessage("   File (binCopyFile): " + file.getAbsolutePath() + " does not exist.");
            }
            if (new File(this.fileToRun.getAbsolutePath()).exists()) {
                this.download.notifyOutputDiagnosticMessage("   File (exe): " + this.fileToRun.getAbsolutePath() + " exists.");
            } else {
                this.download.notifyOutputDiagnosticMessage("   File (exe):" + this.fileToRun.getAbsolutePath() + " does not exist.");
            }
            try {
                this.setFileTypeAndCreator(file, "APPL", "IAse");
                MacComLineExec.execCommandLine("\"" + file.getCanonicalPath() + "\"", false);
            }
            catch (Exception exception) {
                this.download.notifyOutputDiagnosticMessage("First attempt to exec failed.  Trying again...");
                exception.printStackTrace();
                MacComLineExec.execCommandLine("\"" + file.getAbsolutePath() + "\"", false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setFileTypeAndCreator(File file, String string, String string2) {
        if (file == null) {
            System.err.println("setFileTypeAndCreator: No File Specified...");
            return;
        }
        System.err.println("setFileTypeAndCreator: File = " + file.getAbsolutePath());
        if (!file.exists()) {
            System.err.println("setFileTypeAndCreator: Specified File does not exist...");
            return;
        }
        MRJOSType mRJOSType = null;
        MRJOSType mRJOSType2 = null;
        try {
            mRJOSType = MRJFileUtils.getFileType((File)file);
            mRJOSType2 = MRJFileUtils.getFileCreator((File)file);
            if (mRJOSType != null && mRJOSType.toString().equals(string) && mRJOSType2 != null && mRJOSType2.toString().equals(string2)) {
                System.err.println("setFileTypeAndCreator: File already has correct type and creator...");
            }
        }
        catch (Exception exception) {
            System.err.println("setFileTypeAndCreator: Error getting current file type...");
        }
        try {
            int n = 0;
            while (n < 5) {
                try {
                    System.err.println("Attempting to set Mac OS file type and creator: " + file.getAbsolutePath() + ".");
                    MRJFileUtils.setFileType((File)file, (MRJOSType)new MRJOSType(string));
                    MRJFileUtils.setFileCreator((File)file, (MRJOSType)new MRJOSType(string2));
                    mRJOSType = MRJFileUtils.getFileType((File)file);
                    mRJOSType2 = MRJFileUtils.getFileCreator((File)file);
                    if (mRJOSType != null && mRJOSType.toString().equals(string) && mRJOSType2 != null && mRJOSType2.toString().equals(string2)) {
                        System.err.println("setFileTypeAndCreator: File has been correctly typed...");
                        break;
                    }
                    System.err.println("Failure setting file type and creator:");
                    System.err.println("    Desired type:    " + string + ", Current type:    " + mRJOSType.toString());
                    System.err.println("    Desired creator: " + string2 + ", Current creator: " + mRJOSType2.toString());
                }
                catch (Exception exception) {
                    System.err.println("setFileTypeAndCreator: Error setting Mac OS file type and creator.");
                }
                Thread.sleep(250L);
                System.gc();
                ++n;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

