/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.downloaders.macexecutils;

import com.zerog.ia.download.downloaders.macexecutils.MacHFSOutStrm;
import com.zerog.ia.download.downloaders.macexecutils.MacMB2InputStream;
import com.zerog.ia.download.downloaders.macexecutils.MacUtilFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MacDecoder {
    private static final int kBufferSize = 2048;

    public static String decode(File file) throws IOException {
        String string = file.getParent() != null ? new String(file.getParent() + File.separator) : "";
        return MacDecoder.decode(file, string);
    }

    public static String decode(File file, String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        return MacDecoder.decode(fileInputStream, string);
    }

    public static String decode(InputStream inputStream, String string) throws IOException {
        byte[] byArray = new byte[2048];
        byte[] byArray2 = new byte[16];
        MacMB2InputStream macMB2InputStream = new MacMB2InputStream(inputStream);
        macMB2InputStream.getFinderInfo(byArray2);
        String string2 = macMB2InputStream.getFilename();
        MacUtilFile macUtilFile = new MacUtilFile(string + string2);
        MacHFSOutStrm macHFSOutStrm = new MacHFSOutStrm(macUtilFile);
        int n = 0;
        while ((n = macMB2InputStream.read(byArray, 0, byArray.length)) != -1) {
            macHFSOutStrm.write(0, byArray, 0, n);
        }
        while ((n = macMB2InputStream.readRF(byArray, 0, byArray.length)) != -1) {
            macHFSOutStrm.write(1, byArray, 0, n);
        }
        macHFSOutStrm.write(2, byArray2, 0, byArray2.length);
        macHFSOutStrm.close();
        return string2;
    }
}

