/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.downloaders.macexecutils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MacMB2InputStream
extends FilterInputStream {
    static final int ByteBoundary = 128;
    static final int HeaderLength = 128;
    static final short Off_HeaderBeginning = 0;
    static final short Off_OldVersionNumber = 0;
    static final short Off_FileNameLength = 1;
    static final short Off_FileName = 2;
    static final short Off_Type = 65;
    static final short Off_Creator = 69;
    static final short Off_HighFinderFlags = 73;
    static final short Off_ZeroFill = 74;
    static final short Off_YWindowPosition = 75;
    static final short Off_HWindowPosition = 77;
    static final short Off_FolderID = 79;
    static final short Off_ProtectedFlag = 81;
    static final short Off_ZeroFill2 = 82;
    static final short Off_DataLength = 83;
    static final short Off_ResourceLength = 87;
    static final short Off_CreationDate = 91;
    static final short Off_ModifiedDate = 95;
    static final short Off_CommentLength = 99;
    static final short Off_LowFinderFlags = 101;
    static final short Off_Unused = 102;
    static final short Off_TotalFileLength = 116;
    static final short Off_Header2Length = 120;
    static final short Off_MEUMB2Version = 122;
    static final short Off_MinimumMEUMB2Version = 123;
    static final short Off_CRC = 124;
    static final short Off_LastByte = 127;
    private static final int kBufferSize = 2048;
    static final byte kDataForkType = 0;
    static final byte kRsrcForkType = 1;
    private static final boolean debug = false;
    private BufferedInputStream in;
    private byte[] mbHeader;
    private byte[] finderInfo;
    private long byteAlignedrsrcForkLength;
    private long rsrcForkLength;
    private long rsrcForkMark;
    private long byteAlignedDataForkLength;
    private long dataForkLength;
    private long dataForkMark;
    private long finderInfoMark;
    private byte lastForkRead;
    private File dataForkBuffer;
    private boolean dataForkCompletelyRead = false;

    public MacMB2InputStream(InputStream is) throws IOException {
        super(is);
        boolean bytesread = false;
        this.in = new BufferedInputStream(is);
        this.mbHeader = new byte[128];
        try {
            this.in.read(this.mbHeader, 0, 128);
        }
        catch (Exception e) {
            throw new IOException("MacBinary header truncated");
        }
        this.verifyHeader();
        this.makeFinderInfo();
        this.rsrcForkLength = MacMB2InputStream.SignUnsignedBytes(this.mbHeader, 87, 4);
        this.byteAlignedrsrcForkLength = this.rsrcForkLength % 128L == 0L ? this.rsrcForkLength : (this.rsrcForkLength / 128L + 1L) * 128L;
        this.dataForkLength = MacMB2InputStream.SignUnsignedBytes(this.mbHeader, 83, 4);
        this.byteAlignedDataForkLength = this.dataForkLength % 128L == 0L ? this.dataForkLength : (this.dataForkLength / 128L + 1L) * 128L;
        this.rsrcForkMark = 0L;
        this.dataForkMark = 0L;
        this.lastForkRead = 0;
        if (false) {
            System.err.println("MacMB2InputStream");
            System.err.println("byteAlignedrsrcForkLength\t" + this.byteAlignedrsrcForkLength);
            System.err.println("rsrcForkLength\t" + this.rsrcForkLength);
            System.err.println("rsrcForkMark\t" + this.rsrcForkMark);
            System.err.println("byteAlignedDataForkLength\t" + this.byteAlignedDataForkLength);
            System.err.println("dataForkLength\t" + this.dataForkLength);
            System.err.println("dataForkMark\t" + this.dataForkMark);
        }
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported for MacBinary input stream.");
        }
    }

    public boolean markSupported() {
        return false;
    }

    private void makeFinderInfo() throws IOException {
        this.finderInfo = new byte[16];
        System.arraycopy(this.mbHeader, 65, this.finderInfo, 0, 4);
        System.arraycopy(this.mbHeader, 69, this.finderInfo, 4, 4);
        System.arraycopy(this.mbHeader, 73, this.finderInfo, 8, 1);
        System.arraycopy(this.mbHeader, 101, this.finderInfo, 9, 1);
        this.finderInfo[9] = (byte)(this.finderInfo[9] & 0xFC);
        this.finderInfo[8] = (byte)(this.finderInfo[8] & 0xFC);
    }

    private void verifyHeader() throws IOException {
        if (this.mbHeader[0] != 0 || this.mbHeader[74] != 0 || this.mbHeader[82] != 0) {
            throw new IOException("Invalid MacBinary header");
        }
        short minMBVersion = MacMB2InputStream.SignUnsignedByte(this.mbHeader[123]);
        if (minMBVersion > 129) {
            Short minMB = new Short(minMBVersion);
            throw new IOException("Macbinary version in file is: " + minMB.toString() + "This decoder only supports 129");
        }
    }

    private int readFork(byte[] outbytes, int offset, int length, byte forkToRead) throws IOException {
        int leftToRead = length;
        int bytesRead = 0;
        if (forkToRead == 1 & !this.dataForkCompletelyRead) {
            throw new IOException("For now, you must read all of the data fork before skipping to the resource fork");
        }
        if (forkToRead == 0) {
            leftToRead = (int)(this.dataForkLength - this.dataForkMark);
            if (this.lastForkRead != 0) {
                this.in.reset();
                leftToRead = (int)(this.dataForkLength - this.dataForkMark);
            }
            this.lastForkRead = 0;
        } else {
            leftToRead = (int)(this.rsrcForkLength - this.rsrcForkMark);
            if (this.lastForkRead != 1) {
                long markDiff;
                long remainingBytes = markDiff = this.byteAlignedDataForkLength + this.rsrcForkMark - this.dataForkMark;
                long bytesSkipped = 0L;
                this.in.mark((int)markDiff);
                while ((bytesSkipped = this.in.skip(remainingBytes)) != -1L & remainingBytes > 0L) {
                    remainingBytes -= bytesSkipped;
                }
                leftToRead = (int)(this.rsrcForkLength - this.rsrcForkMark);
            }
            this.lastForkRead = 1;
        }
        if (leftToRead == 0 & length > 0) {
            if (this.lastForkRead == 0) {
                int restOfDFork = (int)(this.byteAlignedDataForkLength - this.dataForkMark);
                long bytesSkipped = 0L;
                while ((bytesSkipped = this.in.skip(restOfDFork)) != -1L & restOfDFork > 0) {
                    restOfDFork = (int)((long)restOfDFork - bytesSkipped);
                    this.dataForkMark += bytesSkipped;
                }
                this.dataForkCompletelyRead = true;
            }
            return -1;
        }
        if (length > leftToRead) {
            length = leftToRead;
        }
        if ((bytesRead = this.in.read(outbytes, offset, length)) != -1) {
            if (this.lastForkRead == 0) {
                this.dataForkMark += (long)bytesRead;
            } else {
                this.rsrcForkMark += (long)bytesRead;
            }
        } else {
            throw new IOException("Read past end of stream.");
        }
        return bytesRead;
    }

    public int read(byte[] outbytes, int offset, int length) throws IOException {
        return this.readFork(outbytes, offset, length, (byte)0);
    }

    public long skip(long skipbytes) throws IOException {
        return -1L;
    }

    public int readRF() throws IOException {
        byte[] aByte = new byte[1];
        int returnValue = this.readRF(aByte);
        if (returnValue != -1) {
            returnValue = aByte[1];
        }
        return returnValue;
    }

    public int readRF(byte[] outbytes) throws IOException {
        return this.readFork(outbytes, 0, outbytes.length, (byte)1);
    }

    public int readRF(byte[] outbytes, int offset, int length) throws IOException {
        return this.readFork(outbytes, offset, length, (byte)1);
    }

    public long skipRF(long skipbytes) throws IOException {
        return 0L;
    }

    public void getFinderInfo(byte[] outInfo) {
        System.arraycopy(this.finderInfo, 0, outInfo, 0, this.finderInfo.length);
    }

    public String getFilename() {
        return new String(this.mbHeader, 2, (int)this.mbHeader[1]);
    }

    public static short SignUnsignedByte(byte signed) {
        if (signed >= 0) {
            return signed;
        }
        return (short)(256 + signed);
    }

    public static long SignUnsignedBytes(byte[] data, int offset, int len) {
        if (len > 8) {
            return -1L;
        }
        long result = 0L;
        int pos = 0;
        while (pos < len) {
            result <<= 8;
            result += (long)MacMB2InputStream.SignUnsignedByte(data[pos + offset]);
            ++pos;
        }
        return result;
    }
}

