/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.downloaders;

import com.apple.mrj.MRJFileUtils;
import com.apple.mrj.MRJOSType;
import com.zerog.ia.download.dialogs.ProgressDialog;
import com.zerog.ia.download.downloaders.FileDownloader;
import com.zerog.ia.download.downloaders.FileExecutor;
import com.zerog.ia.download.outputListeners.DownloadListener;
import com.zerog.ia.download.shared.DownloadContext;
import com.zerog.ia.download.utility.DiskSpaceCheckForDownload;
import com.zerog.ia.download.utility.Gestalt;
import com.zerog.ia.download.utility.Util;
import java.awt.Component;
import java.awt.FileDialog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Enumeration;
import netscape.security.PrivilegeManager;

public class ZGDownloader
extends FileDownloader {
    File fileDestination = null;
    private String macFileLocation = null;
    boolean executeFile = false;
    boolean fileToBeDeletedAfterExecute = true;
    long totalSoFar;
    long expectedFileSize = -1L;
    FileExecutor executorObject;
    DownloadContext downloadContext;
    private ProgressDialog progressDialog = null;
    private boolean fileExists = false;
    private DiskSpaceCheckForDownload diskSpaceCheck = null;
    private InputStream input = null;

    public ZGDownloader(DownloadContext _contextThisDownloadIsBeingRunIn, ProgressDialog progressDialog) {
        super(_contextThisDownloadIsBeingRunIn);
        this.downloadContext = _contextThisDownloadIsBeingRunIn;
        this.progressDialog = progressDialog;
    }

    public void setFileDestination(File _fileDestination) {
        this.fileDestination = _fileDestination;
        System.err.println("ZGDownloader.setFileDestination(): '" + this.fileDestination.toString() + "'");
        if (Gestalt.getVMVendor().equals(Gestalt.APPLE_VM)) {
            String exeName;
            System.err.println("ZGDownloader.setFileDestination(): determining Mac OS download location");
            File fileLocation = this.fileDestination;
            int extensionIndex = fileLocation.getName().indexOf(".bin");
            if (extensionIndex != -1) {
                exeName = fileLocation.getName().substring(0, extensionIndex);
                this.notifyOutputDiagnosticMessage("ZGDownloader.setFileDestination(): installer application name = '" + exeName + "'");
            } else {
                exeName = "";
            }
            if (exeName != null && !exeName.trim().equals("")) {
                File binCopyFile = null;
                try {
                    File path = MRJFileUtils.findFolder((MRJOSType)new MRJOSType("desk"));
                    String tempHome = Util.prepFileName(path.getPath());
                    binCopyFile = new File(tempHome, exeName);
                    try {
                        this.macFileLocation = binCopyFile.getCanonicalPath();
                        this.notifyOutputDiagnosticMessage("ZGDownloader.setFileDestination(): Mac OS file location_1: '" + this.macFileLocation + "'");
                    }
                    catch (Exception e) {
                        this.macFileLocation = binCopyFile.getAbsolutePath();
                        this.notifyOutputDiagnosticMessage("ZGDownloader.setFileDestination(): Mac OS file location_2: '" + this.macFileLocation + "'");
                    }
                }
                catch (Exception e) {
                    System.err.println("ZGDownloader.setFileDestination(): error determining Mac OS Desktop location.");
                    e.printStackTrace();
                }
            } else {
                System.err.println("ZGDownloader.setFileDestination(): error determining Mac OS installer application name");
            }
        }
    }

    public File getFileDestination() {
        return this.fileDestination;
    }

    public void setExecuteFile(boolean _wantsToExecuteFile) {
        this.executeFile = _wantsToExecuteFile;
    }

    public boolean getExecuteFile() {
        return this.executeFile;
    }

    public void setFileToBeDeletedAfterExecute(boolean _fileToBeDeletedAfterExecute) {
        this.fileToBeDeletedAfterExecute = _fileToBeDeletedAfterExecute;
    }

    public boolean isFileToBeDeletedAfterExecute() {
        return this.fileToBeDeletedAfterExecute;
    }

    public void downloadFileNow(URL _fileToDownload) throws Exception {
        System.err.println("ZGDownloader.downloadFileNow(): attempting to download:");
        System.err.println("    from: " + _fileToDownload.toString());
        System.err.println("      to: " + this.fileDestination.toString());
        super.downloadFileNow(_fileToDownload);
        boolean fileCopyFailed = true;
        int tryNumber = 1;
        while (fileCopyFailed) {
            try {
                this.copyFileFromServer(_fileToDownload, this.fileDestination);
                fileCopyFailed = false;
            }
            catch (Exception e) {
                if (tryNumber > 10) {
                    this.notifySetFriendlyErrorMessage("ZGDownloader.downloadFileNow(): Unable to open file '" + this.fileDestination.toString() + "'\n    " + "most likely because the file is marked as 'read-only'.");
                    throw new IOException(e.getMessage());
                }
                int fileExtensionLocation = this.fileDestination.toString().lastIndexOf(46);
                if (fileExtensionLocation == -1) {
                    fileExtensionLocation = this.fileDestination.toString().length() - 1;
                }
                try {
                    this.setFileDestination(new File(this.fileDestination.toString().substring(0, fileExtensionLocation) + ++tryNumber + this.fileDestination.toString().substring(fileExtensionLocation)));
                }
                catch (Exception ex) {
                    tryNumber = 100;
                }
            }
        }
        if (!this.isDownloadCancelled()) {
            this.notifyDownloadCompleted();
        } else {
            this.notifyDownloadCancelled();
        }
    }

    public void run() {
        System.err.println("ZGDownloader.run(): begin...");
        try {
            this.downloadFileNow(this.fileToDownload);
            this.setFileExecutor();
            if (this.executorObject != null && !this.isDownloadCancelled()) {
                this.notifyOutputDiagnosticMessage("ZGDownloader.run(): Preparing to start installer...");
                this.notifyOutputDiagnosticMessage("    - installer exists = " + this.fileExists);
                if (Gestalt.getVMVendor().equals(Gestalt.APPLE_VM)) {
                    this.progressDialog.setProgressDialogText(0, null, this.macFileLocation);
                } else {
                    this.progressDialog.setProgressDialogText(0, null, this.fileDestination.toString());
                }
                this.notifyOutputDiagnosticMessage("ZGDownloader.run(): attempting to initiate executor object...");
                this.executorObject.start();
                Thread.sleep(5000L);
                ((Component)this.progressDialog).setVisible(false);
                this.progressDialog.dispose();
            } else if (this.progressDialog != null) {
                ((Component)this.progressDialog).setVisible(false);
                this.progressDialog.dispose();
            }
        }
        catch (IOException ioe) {
            System.err.println("ZGDownloader.run(): an IOException occurred while attempting to launch the installer...");
            ioe.printStackTrace();
            FileDialog saveDialog = new FileDialog(this.context.getParentFrame(), "Save Installer", 1);
            if (Gestalt.getPlatform() == Gestalt.MAC_OS_X_PLATFORM) {
                saveDialog.setFile("install.zip");
            } else if (Gestalt.getPlatform() == Gestalt.WINDOWS_PLATFORM) {
                saveDialog.setFile("install.exe");
            } else {
                saveDialog.setFile("install.bin");
            }
            saveDialog.show();
            String dirString = saveDialog.getDirectory();
            String fileString = saveDialog.getFile();
            if (dirString != null && fileString != null) {
                System.err.println("ZGDownloader.run(): new Directory path = '" + dirString + "'");
                System.err.println("ZGDownloader.run(): new File name = '" + fileString + "'");
                this.setFileDestination(new File(dirString, fileString));
                this.downloadCancelled = true;
                this.run();
            } else {
                this.notifyDownloadCancelled();
                if (this.progressDialog != null) {
                    ((Component)this.progressDialog).setVisible(false);
                    this.progressDialog.dispose();
                }
            }
        }
        catch (Exception e) {
            System.err.println("ZGDownloader.run(): an Exception occurred while attempting to launch the installer...");
            e.printStackTrace();
            this.notifyErrorOccured(e);
        }
    }

    /*
     * Loose catch block
     */
    private void copyFileFromServer(URL sourceUrl, File destinationFile) throws Exception {
        long contentLength;
        block28: {
            RandomAccessFile output;
            block27: {
                this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): sourceURL = '" + sourceUrl.toString() + "'");
                this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): destinationFile = '" + destinationFile.toString() + "'");
                if (Gestalt.isNetscapeSecurityModelAvailable()) {
                    this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): Netscape Security Model = true");
                    PrivilegeManager.enablePrivilege((String)Gestalt.NETSCAPE_FILE_ACCESS);
                }
                this.input = DiskSpaceCheckForDownload.input;
                contentLength = DiskSpaceCheckForDownload.contentLength;
                this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): total bytes in url file: " + contentLength);
                Enumeration e = this.downloadListenerList.elements();
                while (e.hasMoreElements()) {
                    ((DownloadListener)e.nextElement()).setTotalNumberOfBytesInFile(contentLength);
                }
                if (destinationFile.length() == contentLength) {
                    this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): destination file matches source file -- aborting additional download");
                    this.fileExists = true;
                    return;
                }
                if (Gestalt.isNetscapeSecurityModelAvailable()) {
                    PrivilegeManager.enablePrivilege((String)Gestalt.NETSCAPE_FILE_ACCESS);
                }
                if (!Util.makeLeadingDirectories(destinationFile)) {
                    this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): failure to create download directories: '" + destinationFile.getPath() + "'");
                    this.notifySetFriendlyErrorMessage("This volume is not writeable, you will be asked to choose a new location.");
                    throw new IOException("Disk is not writeable.");
                }
                this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): download directories created:  '" + destinationFile.getPath() + "'");
                output = null;
                try {
                    output = new RandomAccessFile(destinationFile, "rw");
                }
                catch (Exception e2) {
                    System.err.println("ZGDownloader.copyFileFromServer(): exception creating random access");
                    e2.printStackTrace();
                    if (destinationFile.exists()) {
                        throw new InterruptedIOException(e2.getMessage());
                    }
                    this.notifySetFriendlyErrorMessage("ZGDownloader.copyFileFromServer(): unable to access destination file '" + destinationFile + "'.");
                    throw e2;
                }
                this.totalSoFar = 0L;
                this.notifyDownloadStarted(sourceUrl.toString());
                this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): preparing download...");
                byte[] dataBuffer = new byte[4096];
                int bytesRead = 0;
                try {
                    block9: while (true) {
                        if (this.isDownloadCancelled()) {
                            this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): download cancelled by user.");
                            break;
                        }
                        bytesRead = this.input.read(dataBuffer);
                        this.totalSoFar += (long)bytesRead;
                        if (bytesRead <= 0) break;
                        output.write(dataBuffer, 0, bytesRead);
                        Enumeration e3 = this.downloadListenerList.elements();
                        while (true) {
                            if (!e3.hasMoreElements()) continue block9;
                            ((DownloadListener)e3.nextElement()).setBytesInFileDownloaded(this.totalSoFar);
                        }
                        break;
                    }
                    this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): download should be complete!");
                    Object var11_12 = null;
                    if (this.input == null) break block27;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    if (this.input != null) {
                        this.input.close();
                    }
                    if (output != null) {
                        output.close();
                    }
                    this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): streams closed");
                    throw throwable;
                }
                this.input.close();
            }
            if (output != null) {
                output.close();
            }
            break block28;
            {
                catch (Exception e) {
                    throw e;
                }
            }
        }
        this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): streams closed");
        this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): downloadCancelled = " + this.downloadCancelled);
        this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): bytes downloaded = " + this.totalSoFar);
        this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): destinationFile size = " + destinationFile.length());
        this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): expected content length = " + contentLength);
        if (this.isDownloadCancelled()) {
            this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): download cancelled; attempting to delete: '" + destinationFile.toString() + "'");
            boolean success = destinationFile.delete();
            if (success) {
                this.notifyOutputDiagnosticMessage("    - deletion successful");
            }
            String parentPath = null;
            File parentFile = null;
            try {
                parentPath = destinationFile.getCanonicalPath();
            }
            catch (IOException ioe) {
                parentPath = destinationFile.getAbsolutePath();
            }
            if (parentPath != null) {
                parentPath = new File(parentPath).getParent();
            }
            if (parentPath != null) {
                parentFile = new File(parentPath);
            }
            this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): attempting to parent directories: '" + parentFile.toString() + "'");
            boolean success2 = parentFile.delete();
            if (success2) {
                this.notifyOutputDiagnosticMessage("    - deletion successful");
            }
            this.executorObject = null;
            this.notifyOutputDiagnosticMessage("ZGDownloader.copyFileFromServer(): download cancelled successfully");
        } else {
            if (destinationFile.length() != contentLength) {
                this.notifySetFriendlyErrorMessage("ZGDownloader.copyFileFromServer(): installer was not completely downloaded -- disk may be full.");
                throw new Exception("Unable to successfully complete download");
            }
            this.notifySetFriendlyErrorMessage("ZGDownloader.copyFileFromServer(): downloaded completed successfully.");
            this.fileExists = true;
        }
    }

    public long getTotalSoFar() {
        return this.totalSoFar;
    }

    void setFileExecutor() {
        FileExecutor executor = new FileExecutor(this.fileDestination, this);
        this.setExecutorObject(executor);
    }

    public void setExecutorObject(FileExecutor _executorObject) {
        this.executorObject = _executorObject;
    }
}

