/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003, LAMP/EPFL                  **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: TypeChar.java,v 1.2 2004/10/26 13:13:24 schinz Exp $

package scala.runtime.types;

import scala.runtime.RunTime;
import scala.Type;
import scala.Array;
import scala.Char;

public class TypeChar extends BasicType {
    private final Char ZERO = RunTime.box_cvalue((char)0);
    public Array newArray(int size) {
        return RunTime.box_carray(new char[size]);
    }
    public Object defaultValue() { return ZERO; }
};
