/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003, LAMP/EPFL                  **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
** $Id: ObservableSet.scala,v 1.7 2004/05/10 13:06:59 zenger Exp $
\*                                                                      */

package scala.collection.mutable;


/** This class is typically used as a mixin. It adds a subscription
 *  mechanism to the <code>Set</code> class into which this abstract
 *  class is mixed in. Class <code>ObservableSet</code> publishes
 *  events of the type <code>Message</code>.
 *
 *  @author  Matthias Zenger
 *  @version 1.0, 08/07/2003
 */
abstract class ObservableSet[A, This <: ObservableSet[A, This]]: This
                    extends scala.collection.mutable.Set[A]
                    with Publisher[Message[A] with Undoable, This] {
    
    abstract override def +=(elem: A): Unit = if (!contains(elem)) {
        super.+=(elem);
        publish(new Include(elem) with Undoable { def undo = -=(elem); });
    }
    
    abstract override def -=(elem: A): Unit = if (contains(elem)) {
        super.-=(elem);
        publish(new Remove(elem) with Undoable { def undo = +=(elem); });
    }
    
    abstract override def clear: Unit = {
        super.clear;
        publish(new Reset with Undoable { def undo: Unit = error("cannot undo"); });
    }
}
