/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab.classfile;

import java.io.IOException;
import java.io.PrintStream;
import scala.tools.util.AbstractFile;
import scalac.Global;
import scalac.atree.AConstant;
import scalac.symtab.EntryTags;
import scalac.symtab.Kinds;
import scalac.symtab.Modifiers;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.symtab.TypeTags;
import scalac.util.Debug;
import scalac.util.Name;
import scalac.util.NameTransformer;
import scalac.util.Names;
import scalac.util.SourceRepresentation;
import scalac.util.TermName;

public class UnPickle
implements Kinds,
Modifiers,
EntryTags,
TypeTags {
    static final boolean debug = true;
    Symbol classroot;
    Symbol moduleroot;
    byte[] bytes;
    int bp;
    int[] index;
    Object[] entries;
    int paramFlags;
    final Global global;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public static void parse(Global global, AbstractFile abstractFile, Symbol symbol) throws IOException {
        try {
            UnPickle.parse(global, abstractFile.read(), symbol);
        }
        catch (BadSignature badSignature) {
            throw new IOException(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("symbol file '".concat(String.valueOf(String.valueOf(abstractFile.getPath()))))).concat("' "))).concat("could not be loaded; "))).concat(String.valueOf(String.valueOf(badSignature.getMessage()))));
        }
    }

    public static void parse(Global global, byte[] byArray, Symbol symbol) throws BadSignature {
        new UnPickle(global, byArray, symbol);
    }

    private UnPickle(Global global, byte[] byArray, Symbol symbol) {
        this.global = global;
        this.classroot = symbol.isModule() ? symbol.linkedClass() : symbol;
        Symbol symbol2 = this.moduleroot = symbol.isClassType() ? symbol.linkedModule() : symbol;
        if (!$assertionsDisabled && this.classroot != null && !this.classroot.isClassType()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        if (!$assertionsDisabled && this.moduleroot != null && !this.moduleroot.isModule()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        if (symbol != this.moduleroot && this.moduleroot != null) {
            this.moduleroot.moduleClass().setInfo(Type.NoType);
        }
        if (global.debug) {
            global.log(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("unpickle ".concat(String.valueOf(String.valueOf(symbol))))).concat(" "))).concat(String.valueOf(String.valueOf(this.classroot))))).concat(" "))).concat(String.valueOf(String.valueOf(this.moduleroot))))).concat(String.valueOf(String.valueOf(this.moduleroot != null ? " ".concat(String.valueOf(String.valueOf(this.moduleroot.moduleClass()))) : ""))));
        }
        this.bytes = byArray;
        this.bp = 0;
        this.index = new int[this.readNat()];
        for (int i = 0; i < this.index.length; ++i) {
            this.index[i] = this.bp++;
            this.bp = this.readNat() + this.bp;
        }
        this.entries = new Object[this.index.length];
        if (global.debug) {
            this.print(System.out);
        }
        for (int i = 0; i < this.index.length; ++i) {
            if (!this.isSymbolEntry(i)) continue;
            this.getSymbol(i);
        }
        if (global.debug) {
            global.log(String.valueOf(String.valueOf(String.valueOf(String.valueOf("unpickled ".concat(String.valueOf(String.valueOf(symbol))))).concat(":"))).concat(String.valueOf(String.valueOf(symbol.rawInfo()))));
        }
        if (!this.classroot.isInitialized() && !this.moduleroot.isInitialized()) {
            throw new BadSignature(this, "it does not define ".concat(String.valueOf(String.valueOf(symbol))));
        }
        if (this.moduleroot != null && this.moduleroot.isModule() && this.moduleroot.moduleClass().type() == Type.NoType) {
            this.moduleroot.setInfo(Type.NoType);
        }
    }

    int readByte() {
        return this.bytes[this.bp++];
    }

    int readNat() {
        int n;
        int n2 = 0;
        do {
            n = this.readByte();
            n2 = (n2 << 7) + (n & 0x7F);
        } while ((n & 0x80) != 0);
        return n2;
    }

    long readLong(int n) {
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l = (l << 8) + (long)(this.readByte() & 0xFF);
        }
        int n2 = 64 - n * 8;
        return l << n2 >> n2;
    }

    boolean isTypeEntry(int n) {
        byte by = this.bytes[this.index[n]];
        return 11 <= by && by <= 22 || by == 36;
    }

    boolean isSymbolEntry(int n) {
        byte by = this.bytes[this.index[n]];
        return 4 <= by && by <= 8;
    }

    Name getName(int n) {
        if (this.entries[n] == null) {
            int n2 = this.bp;
            this.bp = this.index[n];
            byte by = this.bytes[this.bp++];
            int n3 = this.readNat();
            TermName termName = Name.fromAscii(this.bytes, this.bp, n3);
            switch (by) {
                case 1: {
                    this.entries[n] = termName;
                    break;
                }
                case 2: {
                    this.entries[n] = termName.toTypeName();
                    break;
                }
                default: {
                    throw new BadSignature(this);
                }
            }
            this.bp = n2;
        }
        return (Name)this.entries[n];
    }

    Name readNameRef() {
        return this.getName(this.readNat());
    }

    String decode(Name name) {
        if (name.isTypeName()) {
            return "type ".concat(String.valueOf(String.valueOf(NameTransformer.decode(name))));
        }
        return "value ".concat(String.valueOf(String.valueOf(NameTransformer.decode(name))));
    }

    void enterSymbol(Symbol symbol) {
        if ((symbol.flags & 0x8000000) != 0) {
            symbol.flags &= 0xF7FFFFFF;
        } else {
            Symbol symbol2 = symbol.owner();
            if (symbol2.kind == 3 && !symbol.isConstructor() && !symbol.isModuleClass()) {
                Scope scope = symbol2.info().members();
                Symbol symbol3 = scope.lookup(symbol.name);
                if (symbol3 == Symbol.NONE) {
                    scope.enter(symbol);
                } else if (!$assertionsDisabled && symbol != symbol3) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("double enter: ".concat(String.valueOf(String.valueOf(symbol3))))).concat(":"))).concat(String.valueOf(String.valueOf(symbol3.rawFirstInfo()))))).concat(","))).concat(String.valueOf(String.valueOf(symbol))))).concat(":"))).concat(String.valueOf(String.valueOf(symbol.rawFirstInfo()))))));
                }
            }
        }
    }

    Symbol getSymbol(int n) {
        if (this.entries[n] == null) {
            int n2 = this.bp;
            this.bp = this.index[n];
            byte by = this.bytes[this.bp++];
            int n3 = this.readNat() + this.bp;
            switch (by) {
                case 4: {
                    Symbol symbol = Symbol.NONE;
                    this.entries[n] = symbol;
                    break;
                }
                case 9: 
                case 10: {
                    Symbol symbol;
                    Symbol symbol2;
                    Name name = this.readNameRef();
                    if (this.bp == n3) {
                        symbol2 = this.global.definitions.ROOT_CLASS;
                    } else {
                        if (!$assertionsDisabled && this.bp >= n3) {
                            throw new AssertionError();
                        }
                        symbol2 = this.readSymbolRef();
                    }
                    if (name == Names.ROOT && symbol2 == Symbol.NONE) {
                        symbol = this.global.definitions.ROOT_CLASS;
                        if (by == 9) {
                            // empty if block
                        }
                    } else {
                        symbol = symbol2.info().lookup(name);
                        if (by == 10) {
                            if (!$assertionsDisabled && !symbol.isModule()) {
                                throw new AssertionError();
                            }
                            symbol = symbol.moduleClass();
                        }
                    }
                    this.entries[n] = symbol;
                    if (symbol.kind != 1) break;
                    if (this.global.debug) {
                        this.global.log(symbol2.info().members().toString());
                    }
                    throw new BadSignature(this, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("reference ".concat(String.valueOf(String.valueOf(this.decode(name)))))).concat(" of "))).concat(String.valueOf(String.valueOf(symbol2))))).concat(" refers to nonexisting symbol."));
                }
                default: {
                    Symbol symbol;
                    if (!$assertionsDisabled && !this.isSymbolEntry(n)) {
                        throw new AssertionError((Object)String.valueOf(n));
                    }
                    Name name = this.readNameRef();
                    if (this.global.debug) {
                        this.global.log(String.valueOf(String.valueOf(String.valueOf(String.valueOf("reading ".concat(String.valueOf(String.valueOf(name))))).concat(" at "))).concat(String.valueOf(n)));
                    }
                    Symbol symbol3 = this.readSymbolRef();
                    if (this.entries[n] != null) break;
                    int n4 = this.readNat();
                    int n5 = this.readNat();
                    switch (by) {
                        case 5: {
                            symbol = symbol3.newAbstractType(0, n4, name);
                            this.entries[n] = symbol;
                            if ((n4 & 0x4000) != 0) {
                                symbol.setInfo(this.global.definitions.ANY_TYPE());
                                symbol.setVuBound(this.getType(n5, symbol));
                            } else {
                                symbol.setInfo(this.getType(n5, symbol));
                            }
                            symbol.setLoBound(this.readTypeRef(symbol));
                            break;
                        }
                        case 6: {
                            symbol = symbol3.newTypeAlias(0, n4, name);
                            this.entries[n] = symbol;
                            symbol.setInfo(this.getType(n5, symbol));
                            this.readSymbolRef();
                            break;
                        }
                        case 7: {
                            Symbol symbol4;
                            if ((n4 & 0x2000) != 0) {
                                symbol4 = this.readSymbolRef();
                                symbol = symbol4.moduleClass();
                                this.entries[n] = symbol;
                                symbol.flags = n4;
                            } else if (this.classroot != null && name == this.classroot.name && symbol3 == this.classroot.owner()) {
                                if (this.global.debug) {
                                    this.global.log("overwriting ".concat(String.valueOf(String.valueOf(this.classroot))));
                                }
                                symbol = this.classroot;
                                this.entries[n] = symbol;
                                symbol.flags = n4;
                            } else {
                                symbol = symbol3.newClass(0, n4, name);
                                this.entries[n] = symbol;
                            }
                            symbol.setInfo(this.getType(n5, symbol));
                            symbol.setTypeOfThis(this.readTypeRef(symbol));
                            symbol4 = this.readSymbolRef();
                            if (!$assertionsDisabled && symbol4 != symbol.allConstructors()) {
                                throw new AssertionError();
                            }
                            break;
                        }
                        case 8: {
                            Modifiers modifiers;
                            if (this.moduleroot != null && name == this.moduleroot.name && symbol3 == this.moduleroot.owner()) {
                                if (this.global.debug) {
                                    this.global.log("overwriting ".concat(String.valueOf(String.valueOf(this.moduleroot))));
                                }
                                symbol = this.moduleroot;
                                this.entries[n] = symbol;
                                symbol.flags = n4;
                            } else if ((n4 & 0x2000) != 0) {
                                symbol = symbol3.newModule(0, n4, name);
                                this.entries[n] = symbol;
                            } else if (name == Names.CONSTRUCTOR) {
                                Symbol symbol5 = modifiers = this.bp < n3 ? this.readSymbolRef() : null;
                                if (modifiers == null) {
                                    symbol = symbol3.newConstructor(0, n4);
                                    this.entries[n] = symbol;
                                } else {
                                    symbol = modifiers.allConstructors();
                                    this.entries[n] = symbol;
                                    symbol.flags = n4;
                                }
                            } else {
                                symbol = symbol3.newTerm(0, n4, name);
                                this.entries[n] = symbol;
                            }
                            if (symbol.isModule()) {
                                modifiers = this.readSymbolRef();
                                if (!$assertionsDisabled && modifiers != symbol.moduleClass()) {
                                    throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
                                }
                            }
                            modifiers = this.getType(n5, symbol);
                            symbol.setInfo((Type)modifiers);
                            break;
                        }
                        default: {
                            throw new BadSignature(this);
                        }
                    }
                    this.enterSymbol(symbol);
                }
            }
            this.bp = n2;
        }
        return (Symbol)this.entries[n];
    }

    Symbol readSymbolRef() {
        return this.getSymbol(this.readNat());
    }

    Symbol[] readSymbolRefs(int n) {
        return this.readSymbolRefs(0, n);
    }

    Symbol[] readSymbolRefs(int n, int n2) {
        if (this.bp == n2) {
            return new Symbol[n];
        }
        if (!$assertionsDisabled && this.bp >= n2) {
            throw new AssertionError();
        }
        int n3 = this.bp;
        int n4 = this.readNat();
        if (this.isSymbolEntry(n4)) {
            Symbol symbol = this.getSymbol(n4);
            Symbol[] symbolArray = this.readSymbolRefs(n + 1, n2);
            symbolArray[n] = symbol;
            return symbolArray;
        }
        this.bp = n3;
        return new Symbol[n];
    }

    Type getType(int n, Symbol symbol) {
        Type type = (Type)this.entries[n];
        if (type == null) {
            int n2 = this.bp;
            this.bp = this.index[n];
            byte by = this.bytes[this.bp++];
            int n3 = this.readNat() + this.bp;
            switch (by) {
                case 11: {
                    type = Type.NoType;
                    break;
                }
                case 36: {
                    type = Type.NoPrefix;
                    break;
                }
                case 12: {
                    Symbol symbol2 = this.readSymbolRef();
                    type = symbol2.kind == 1 ? Type.NoPrefix : Type.ThisType(symbol2);
                    break;
                }
                case 13: {
                    Type type2 = this.readTypeRef(symbol);
                    Symbol symbol3 = this.readSymbolRef();
                    type = symbol3.isRoot() ? symbol3.thisType() : Type.singleType(type2, symbol3);
                    break;
                }
                case 14: {
                    Type type3 = this.readTypeRef(symbol);
                    AConstant aConstant = this.readConstantRef();
                    type = new Type.ConstantType(type3, aConstant);
                    break;
                }
                case 15: {
                    type = Type.newTypeRefUnsafe(this.readTypeRef(symbol), this.readSymbolRef(), this.readTypeRefs(n3, symbol));
                    break;
                }
                case 16: {
                    boolean bl = this.readByte() != 0;
                    Symbol symbol4 = bl ? this.readSymbolRef() : null;
                    int n4 = this.readNat();
                    Symbol symbol5 = bl ? (Symbol)this.entries[n4] : this.getSymbol(n4);
                    Type[] typeArray = this.readTypeRefs(n3, symbol);
                    if (symbol5 == null) {
                        type = Type.compoundTypeWithOwner(symbol4, typeArray, new Scope());
                        this.entries[n4] = type.symbol();
                        break;
                    }
                    type = Type.compoundType(typeArray, new Scope(), symbol5);
                    break;
                }
                case 17: {
                    Type type4 = this.readTypeRef(symbol);
                    int n5 = this.bp;
                    Type[] typeArray = this.readTypeRefs(n3, symbol);
                    int[] nArray = new int[typeArray.length];
                    this.bp = n5;
                    this.readFlags(nArray);
                    Symbol[] symbolArray = new Symbol[typeArray.length];
                    for (int i = 0; i < typeArray.length; ++i) {
                        TermName termName = Name.fromString("$".concat(String.valueOf(i)));
                        symbolArray[i] = symbol.newVParam(0, nArray[i], termName, typeArray[i]);
                    }
                    type = Type.MethodType(symbolArray, type4);
                    break;
                }
                case 18: {
                    Type type5 = this.readTypeRef(symbol);
                    type = Type.PolyType(this.readSymbolRefs(n3), type5);
                    break;
                }
                case 19: {
                    int n6 = this.bp;
                    Symbol[] symbolArray = this.readSymbolRefs(n3);
                    int n7 = this.bp;
                    Type[] typeArray = this.readTypeRefs(n3, symbolArray);
                    if (!$assertionsDisabled && symbolArray.length != typeArray.length) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(symbolArray.length).concat("!="))).concat(String.valueOf(typeArray.length)))).concat(" at "))).concat(String.valueOf(n6)))).concat("/"))).concat(String.valueOf(n7)))).concat("/"))).concat(String.valueOf(this.bp)))));
                    }
                    type = Type.OverloadedType(symbolArray, typeArray);
                    break;
                }
                case 22: {
                    this.readNat();
                    type = this.readTypeRef(symbol);
                    break;
                }
                default: {
                    throw new BadSignature(this);
                }
            }
            if (by != 17) {
                this.entries[n] = type;
            }
            this.bp = n2;
        }
        return type;
    }

    Type readTypeRef(Symbol symbol) {
        return this.getType(this.readNat(), symbol);
    }

    Type[] readTypeRefs(int n, Symbol symbol) {
        return this.readTypeRefs(0, n, symbol, null);
    }

    Type[] readTypeRefs(int n, Symbol[] symbolArray) {
        return this.readTypeRefs(0, n, null, symbolArray);
    }

    Type[] readTypeRefs(int n, int n2, Symbol symbol, Symbol[] symbolArray) {
        if (!$assertionsDisabled && !(symbol != null ^ symbolArray != null)) {
            throw new AssertionError();
        }
        if (this.bp == n2) {
            return new Type[n];
        }
        if (!$assertionsDisabled && this.bp >= n2) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.bp).concat(">"))).concat(String.valueOf(n2)))));
        }
        int n3 = this.bp;
        int n4 = this.readNat();
        if (this.isTypeEntry(n4)) {
            Type type = this.getType(n4, symbol != null ? symbol : symbolArray[n]);
            Type[] typeArray = this.readTypeRefs(n + 1, n2, symbol, symbolArray);
            typeArray[n] = type;
            return typeArray;
        }
        this.bp = n3;
        return new Type[n];
    }

    void readFlags(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.getFlags(this.readNat());
        }
    }

    int getFlags(int n) {
        int n2 = this.bp;
        this.bp = this.index[n];
        byte by = this.bytes[this.bp++];
        int cfr_ignored_0 = this.readNat() + this.bp;
        int n3 = by == 22 ? UnPickle.decodeFlags(this.readNat()) : 0;
        this.bp = n2;
        return n3;
    }

    private static int decodeFlags(int n) {
        int n2 = 0;
        if ((n & 4) != 0) {
            n2 |= 0x200;
        }
        if ((n & 8) != 0) {
            n2 |= 0x100;
        }
        return n2;
    }

    AConstant readConstant() {
        byte by = this.bytes[this.bp++];
        int n = this.readNat();
        switch (by) {
            case 24: {
                return AConstant.UNIT;
            }
            case 25: {
                return AConstant.BOOLEAN(this.readByte() != 0);
            }
            case 26: {
                return AConstant.BYTE((byte)this.readLong(n));
            }
            case 27: {
                return AConstant.SHORT((short)this.readLong(n));
            }
            case 28: {
                return AConstant.CHAR((char)this.readLong(n));
            }
            case 29: {
                return AConstant.INT((int)this.readLong(n));
            }
            case 30: {
                return AConstant.LONG(this.readLong(n));
            }
            case 31: {
                return AConstant.FLOAT(Float.intBitsToFloat((int)this.readLong(n)));
            }
            case 32: {
                return AConstant.DOUBLE(Double.longBitsToDouble(this.readLong(n)));
            }
            case 33: {
                return AConstant.STRING(this.readNameRef().toString());
            }
            case 34: {
                return AConstant.NULL;
            }
            case 35: {
                return AConstant.ZERO;
            }
        }
        throw Debug.abort("illegal tag: ".concat(String.valueOf(by)));
    }

    AConstant readConstantRef() {
        int n = this.readNat();
        int n2 = this.bp;
        this.bp = this.index[n];
        AConstant aConstant = this.readConstant();
        this.bp = n2;
        return aConstant;
    }

    private static String tag2string(int n) {
        switch (n) {
            case 1: {
                return "TERMname";
            }
            case 2: {
                return "TYPEname";
            }
            case 4: {
                return "NONEsym";
            }
            case 5: {
                return "TYPEsym";
            }
            case 6: {
                return "ALIASsym";
            }
            case 7: {
                return "CLASSsym";
            }
            case 8: {
                return "VALsym";
            }
            case 9: {
                return "EXTref";
            }
            case 10: {
                return "EXTMODCLASSref";
            }
            case 11: {
                return "NOtpe";
            }
            case 12: {
                return "THIStpe";
            }
            case 13: {
                return "SINGLEtpe";
            }
            case 15: {
                return "TYPEREFtpe";
            }
            case 14: {
                return "CONSTANTtpe";
            }
            case 16: {
                return "COMPOUNDtpe";
            }
            case 17: {
                return "METHODtpe";
            }
            case 18: {
                return "POLYtpe";
            }
            case 19: {
                return "OVERLOADEDtpe";
            }
            case 20: {
                return "UNBOXEDtpe";
            }
            case 21: {
                return "UNBOXEDARRAYtpe";
            }
            case 22: {
                return "FLAGGEDtpe";
            }
            case 23: {
                return "ERRORtpe";
            }
            case 24: {
                return "LITERALunit";
            }
            case 25: {
                return "LITERALboolean";
            }
            case 26: {
                return "LITERALbyte";
            }
            case 27: {
                return "LITERALshort";
            }
            case 28: {
                return "LITERALchar";
            }
            case 29: {
                return "LITERALint";
            }
            case 30: {
                return "LITERALlong";
            }
            case 31: {
                return "LITERALfloat";
            }
            case 32: {
                return "LITERALdouble";
            }
            case 33: {
                return "LITERALstring";
            }
            case 34: {
                return "LITERALnull";
            }
            case 35: {
                return "LITERALzero";
            }
        }
        return String.valueOf(String.valueOf("***BAD TAG***(".concat(String.valueOf(n)))).concat(")");
    }

    private void print(PrintStream printStream) {
        printStream.println(String.valueOf(String.valueOf("symbl attribute for ".concat(String.valueOf(String.valueOf(this.classroot))))).concat(":"));
        for (int i = 0; i < this.index.length; ++i) {
            printStream.print(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(i).concat(","))).concat(String.valueOf(this.index[i])))).concat(": "));
            this.bp = this.index[i];
            int n = this.readByte();
            printStream.print(UnPickle.tag2string(n));
            int n2 = this.readNat();
            int n3 = n2 + this.bp;
            printStream.print(" ".concat(String.valueOf(n2)));
            switch (n) {
                case 1: 
                case 2: {
                    String string = SourceRepresentation.ascii2string(this.bytes, this.bp, n2);
                    printStream.print(" ".concat(String.valueOf(String.valueOf(SourceRepresentation.escape(string)))));
                    this.bp = n3;
                    break;
                }
                case 4: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    printStream.print(" ".concat(String.valueOf(this.readNat())));
                    printStream.print(" ".concat(String.valueOf(this.readNat())));
                    printStream.print(" ".concat(String.valueOf(String.valueOf(Integer.toHexString(this.readNat())))));
                    printStream.print(" ".concat(String.valueOf(this.readNat())));
                    break;
                }
                case 22: {
                    printStream.print(" ".concat(String.valueOf(String.valueOf(Integer.toHexString(this.readNat())))));
                }
            }
            while (this.bp < n3) {
                printStream.print(" ".concat(String.valueOf(this.readNat())));
            }
            printStream.println();
        }
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.symtab.classfile.UnPickle").desiredAssertionStatus();
    }

    public static class BadSignature
    extends Error {
        public BadSignature(UnPickle unPickle, String string) {
            super(string);
        }

        public BadSignature(UnPickle unPickle) {
            this(unPickle, "malformed signature at ".concat(String.valueOf(unPickle.bp)));
        }
    }
}

