/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab;

import scalac.Global;
import scalac.framework.History;
import scalac.symtab.ClosureHistory;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Debug;
import scalac.util.Name;

public abstract class TypeSymbol
extends Symbol {
    private final History closures = new ClosureHistory();
    private Type tycon = null;
    private Symbol constructor;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public TypeSymbol(int n, Symbol symbol, int n2, int n3, Name name, int n4) {
        super(n, symbol, n2, n3, name, n4);
        if (!$assertionsDisabled && !name.isTypeName()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this)));
        }
        this.constructor = this.newConstructor(n2, n3 & 0x1040);
    }

    protected final void copyConstructorInfo(TypeSymbol typeSymbol) {
        Symbol[] symbolArray = this.primaryConstructor().info().cloneType(this.primaryConstructor(), typeSymbol.primaryConstructor());
        if (!this.isTypeAlias()) {
            symbolArray = this.fixConstrType((Type)symbolArray, typeSymbol);
        }
        typeSymbol.primaryConstructor().setInfo((Type)symbolArray);
        symbolArray = this.allConstructors().alternativeSymbols();
        for (int i = 1; i < symbolArray.length; ++i) {
            Symbol symbol = typeSymbol.newConstructor(symbolArray[i].pos, symbolArray[i].flags);
            typeSymbol.addConstructor(symbol);
            Type type = symbolArray[i].info().cloneType(symbolArray[i], symbol);
            if (!this.isTypeAlias()) {
                type = this.fixConstrType(type, typeSymbol);
            }
            symbol.setInfo(type);
        }
    }

    private final Type fixConstrType(Type type, Symbol symbol) {
        switch (type.$tag) {
            case 3: {
                Type.MethodType methodType = (Type.MethodType)type;
                Symbol[] symbolArray = methodType.vparams;
                Type type2 = methodType.result;
                type2 = this.fixConstrType(type2, symbol);
                return new Type.MethodType(symbolArray, type2);
            }
            case 5: {
                Type.PolyType polyType = (Type.PolyType)type;
                Symbol[] symbolArray = polyType.tparams;
                Type type3 = polyType.result;
                type3 = this.fixConstrType(type3, symbol);
                return new Type.PolyType(symbolArray, type3);
            }
            case 8: {
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Type type4 = typeRef.pre;
                Symbol symbol2 = typeRef.sym;
                Type[] typeArray = typeRef.args;
                if (symbol2 != this && this.isTypeAlias() && this.owner().isCompoundSym()) {
                    return type;
                }
                if (!$assertionsDisabled && symbol2 != this) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(symbol2))).concat(" != "))).concat(String.valueOf(String.valueOf(Debug.show(this)))))));
                }
                return Type.typeRef(type4, symbol, typeArray);
            }
            case 2: {
                return type;
            }
        }
        throw Debug.abort(String.valueOf(String.valueOf(String.valueOf(String.valueOf("unexpected constructor type:".concat(String.valueOf(String.valueOf(symbol))))).concat(":"))).concat(String.valueOf(String.valueOf(type))));
    }

    public final void addConstructor(Symbol symbol) {
        if (!$assertionsDisabled && !symbol.isConstructor()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        this.constructor = this.constructor.overloadWith(symbol);
    }

    public final Symbol primaryConstructor() {
        return this.constructor.firstAlternative();
    }

    public final Symbol allConstructors() {
        return this.constructor;
    }

    public final Symbol[] typeParams() {
        return this.primaryConstructor().info().typeParams();
    }

    public final Symbol[] valueParams() {
        return this.kind == 3 ? this.primaryConstructor().info().valueParams() : Symbol.EMPTY_ARRAY;
    }

    public final Type typeConstructor() {
        if (this.tycon == null) {
            this.tycon = Type.typeRef(this.owner().thisType(), this, Type.EMPTY_ARRAY);
        }
        return this.tycon;
    }

    public Symbol setOwner(Symbol symbol) {
        this.tycon = null;
        this.constructor.setOwner0(symbol);
        Type type = this.constructor.type();
        if (type.$tag == 4) {
            Type.OverloadedType overloadedType = (Type.OverloadedType)type;
            Symbol[] symbolArray = overloadedType.alts;
            for (int i = 0; i < symbolArray.length; ++i) {
                symbolArray[i].setOwner0(symbol);
            }
        }
        return super.setOwner(symbol);
    }

    public final Type type() {
        return this.primaryConstructor().type().resultType();
    }

    public final Type getType() {
        return this.primaryConstructor().type().resultType();
    }

    public final Type[] closure() {
        if (this.kind == 2) {
            return this.info().symbol().closure();
        }
        if ((this.flags & 0x2000000) != 0 && Global.instance.currentPhase.id <= Global.instance.PHASE.REFCHECK.id()) {
            throw new Type.Error("illegal cyclic reference involving ".concat(String.valueOf(String.valueOf(this))));
        }
        this.flags |= 0x2000000;
        Type[] typeArray = (Type[])this.closures.getValue(this);
        this.flags &= 0xFDFFFFFF;
        return typeArray;
    }

    public void reset(Type type) {
        super.reset(type);
        this.closures.reset();
        this.tycon = null;
    }

    protected final Symbol cloneSymbolImpl(Symbol symbol, int n) {
        TypeSymbol typeSymbol = this.cloneTypeSymbolImpl(symbol, n);
        this.copyConstructorInfo(typeSymbol);
        return typeSymbol;
    }

    protected abstract TypeSymbol cloneTypeSymbolImpl(Symbol var1, int var2);

    static {
        $assertionsDisabled = !Class.forName("scalac.symtab.TypeSymbol").desiredAssertionStatus();
    }
}

