/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab;

import ch.epfl.lamp.util.CodePrinter;
import scalac.Global;
import scalac.atree.AConstant;
import scalac.symtab.ModuleSymbol;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Debug;
import scalac.util.NameTransformer;

public class SymbolTablePrinter {
    private final Global global;
    private final CodePrinter printer;

    public SymbolTablePrinter() {
        this((String)null);
    }

    public SymbolTablePrinter(String string) {
        this(Global.instance, new CodePrinter(string));
    }

    public SymbolTablePrinter(CodePrinter codePrinter) {
        this(Global.instance, codePrinter);
    }

    public SymbolTablePrinter(Global global, CodePrinter codePrinter) {
        this.global = global;
        this.printer = codePrinter;
    }

    public CodePrinter getCodePrinter() {
        return this.printer;
    }

    public SymbolTablePrinter indent() {
        this.printer.indent();
        return this;
    }

    public SymbolTablePrinter undent() {
        this.printer.undent();
        return this;
    }

    public SymbolTablePrinter line() {
        this.printer.line();
        return this;
    }

    public SymbolTablePrinter space() {
        this.printer.space();
        return this;
    }

    public SymbolTablePrinter println() {
        this.printer.println();
        return this;
    }

    public SymbolTablePrinter println(boolean bl) {
        this.printer.println(bl);
        return this;
    }

    public SymbolTablePrinter println(byte by) {
        this.printer.println(by);
        return this;
    }

    public SymbolTablePrinter println(short s) {
        this.printer.println(s);
        return this;
    }

    public SymbolTablePrinter println(char c) {
        this.printer.println(c);
        return this;
    }

    public SymbolTablePrinter println(int n) {
        this.printer.println(n);
        return this;
    }

    public SymbolTablePrinter println(long l) {
        this.printer.println(l);
        return this;
    }

    public SymbolTablePrinter println(float f) {
        this.printer.println(f);
        return this;
    }

    public SymbolTablePrinter println(double d) {
        this.printer.println(d);
        return this;
    }

    public SymbolTablePrinter println(String string) {
        this.printer.println(string);
        return this;
    }

    public SymbolTablePrinter print(boolean bl) {
        this.printer.print(bl);
        return this;
    }

    public SymbolTablePrinter print(byte by) {
        this.printer.print(by);
        return this;
    }

    public SymbolTablePrinter print(short s) {
        this.printer.print(s);
        return this;
    }

    public SymbolTablePrinter print(char c) {
        this.printer.print(c);
        return this;
    }

    public SymbolTablePrinter print(int n) {
        this.printer.print(n);
        return this;
    }

    public SymbolTablePrinter print(long l) {
        this.printer.print(l);
        return this;
    }

    public SymbolTablePrinter print(float f) {
        this.printer.print(f);
        return this;
    }

    public SymbolTablePrinter print(double d) {
        this.printer.print(d);
        return this;
    }

    public SymbolTablePrinter print(String string) {
        this.printer.print(string);
        return this;
    }

    public SymbolTablePrinter printScope(Scope scope) {
        return this.printScope(scope, false);
    }

    public SymbolTablePrinter printScope(Scope scope, boolean bl) {
        boolean bl2 = true;
        Scope.SymbolIterator symbolIterator = scope.iterator();
        while (symbolIterator.hasNext()) {
            Symbol symbol = symbolIterator.next();
            if (!this.mustShowMember(symbol)) continue;
            if (bl2) {
                this.print("{").indent();
            } else {
                this.print(", ");
            }
            bl2 = false;
            this.line().printSignature(symbol);
        }
        if (!bl2) {
            this.line().undent().print("}");
        } else if (!bl) {
            this.print("{}");
        }
        return this;
    }

    public boolean mustShowMember(Symbol symbol) {
        return true;
    }

    public String getSymbolKind(Symbol symbol) {
        switch (symbol.kind) {
            case 1: {
                return null;
            }
            case 3: {
                if (symbol.isPackageClass()) {
                    return "package class";
                }
                if (symbol.isModuleClass()) {
                    return "object class";
                }
                if (symbol.isTrait()) {
                    return "trait";
                }
                return "class";
            }
            case 2: 
            case 4: {
                return "type";
            }
            case 5: {
                if (symbol.isVariable()) {
                    return "variable";
                }
                if (symbol.isPackage()) {
                    return "package";
                }
                if (symbol.isModule()) {
                    return "object";
                }
                if (symbol.isConstructor()) {
                    return "constructor";
                }
                if (symbol.isInitializedMethod() && (this.global.debug || (symbol.flags & 0x800000) == 0)) {
                    return "method";
                }
                return "value";
            }
        }
        throw Debug.abort("unknown kind ".concat(String.valueOf(symbol.kind)));
    }

    public String getSymbolKeyword(Symbol symbol) {
        if (symbol.isParameter()) {
            return null;
        }
        switch (symbol.kind) {
            case 1: {
                return null;
            }
            case 3: {
                if (symbol.isTrait()) {
                    return "trait";
                }
                return "class";
            }
            case 2: 
            case 4: {
                return "type";
            }
            case 5: {
                if (symbol.isVariable()) {
                    return "var";
                }
                if (symbol.isPackage()) {
                    return "package";
                }
                if (symbol.isModule()) {
                    return "object";
                }
                if (symbol.isInitializedMethod()) {
                    return "def";
                }
                return "val";
            }
        }
        throw Debug.abort("unknown kind ".concat(String.valueOf(symbol.kind)));
    }

    public String getSymbolName(Symbol symbol) {
        String string = symbol.simpleName().toString();
        if (!this.global.debug) {
            string = NameTransformer.decode(string);
        }
        return string;
    }

    public String getSymbolInnerString(Symbol symbol) {
        switch (symbol.kind) {
            case 1: {
                return ":";
            }
            case 2: {
                return "=";
            }
            case 3: {
                return "extends";
            }
            case 4: {
                return "<:";
            }
            case 5: {
                return symbol.isModule() ? "extends" : ":";
            }
        }
        throw Debug.abort("unknown kind ".concat(String.valueOf(symbol.kind)));
    }

    public SymbolTablePrinter printSymbolUniqueId(Symbol symbol) {
        if (this.global.uniqid) {
            this.print('#').print(symbol.id);
        }
        return this;
    }

    public SymbolTablePrinter printSymbolName(Symbol symbol) {
        this.print(this.getSymbolName(symbol));
        return this.printSymbolUniqueId(symbol);
    }

    public SymbolTablePrinter printSymbolKindAndName(Symbol symbol) {
        if (symbol.isAnonymousClass()) {
            this.print("<template>");
            return this.printSymbolUniqueId(symbol);
        }
        String string = this.getSymbolKind(symbol);
        if (string != null) {
            this.print(string).space();
        }
        return this.printSymbolName(symbol);
    }

    public SymbolTablePrinter printSymbolType(Symbol symbol, String string) {
        Type type = symbol.rawFirstInfo();
        if (!(type instanceof Type.LazyType)) {
            type = symbol.info();
        }
        boolean bl = false;
        if ((symbol.flags & 0x200) != 0 && type.symbol() == this.global.definitions.SEQ_CLASS && type.typeArgs().length == 1) {
            type = type.typeArgs()[0];
            bl = true;
        }
        this.printType(type, string);
        if (bl) {
            this.print("*");
        }
        return this;
    }

    public SymbolTablePrinter printSignature(Symbol symbol) {
        String string = this.getSymbolKeyword(symbol);
        if (string != null) {
            this.print(string).space();
        }
        String string2 = this.getSymbolInnerString(symbol);
        return this.printSymbolName(symbol).printType(symbol.loBound(), ">:").printSymbolType(symbol, string2);
    }

    public SymbolTablePrinter printTypeParams(Symbol[] symbolArray) {
        this.print('[');
        for (int i = 0; i < symbolArray.length; ++i) {
            if (i > 0) {
                this.print(",");
            }
            this.printSignature(symbolArray[i]);
        }
        return this.print(']');
    }

    public SymbolTablePrinter printValueParams(Symbol[] symbolArray) {
        this.print('(');
        for (int i = 0; i < symbolArray.length; ++i) {
            if (i > 0) {
                this.print(",");
            }
            if (symbolArray[i].isDefParameter()) {
                this.print("def ");
            }
            this.printSymbolType(symbolArray[i], null);
        }
        return this.print(')');
    }

    public Type getTypeToPrintForType(Type type) {
        Type type2;
        while ((type2 = this.getTypeToPrintForType0(type)) != type) {
            type = type2;
        }
        return type2;
    }

    public Type getTypeToPrintForType0(Type type) {
        switch (type.$tag) {
            case 7: {
                Type.ThisType thisType = (Type.ThisType)type;
                Symbol symbol = thisType.sym;
                if (this.global.debug || !symbol.isModuleClass()) {
                    return type;
                }
                Type type2 = this.getTypeToPrintForType(symbol.owner().thisType());
                ModuleSymbol moduleSymbol = symbol.sourceModule();
                if (moduleSymbol.owner() != symbol.owner()) {
                    return type;
                }
                if (!moduleSymbol.type().isObjectType()) {
                    return type;
                }
                return Type.singleType(type2, moduleSymbol);
            }
            case 6: {
                Type.SingleType singleType = (Type.SingleType)type;
                Symbol symbol = singleType.sym;
                if (this.global.debug) {
                    return type;
                }
                if (symbol.isSynthetic()) {
                    return type.widen();
                }
                return type;
            }
            case 0: {
                Type.CompoundType compoundType = (Type.CompoundType)type;
                Type[] typeArray = compoundType.parts;
                if (this.global.debug) {
                    return type;
                }
                if (type.isFunctionType()) {
                    return typeArray[1];
                }
                return type;
            }
            case 9: {
                Type.TypeVar typeVar = (Type.TypeVar)type;
                Type.Constraint constraint = typeVar.constr;
                if (constraint.inst != Type.NoType) {
                    return constraint.inst;
                }
                return type;
            }
        }
        return type;
    }

    public SymbolTablePrinter printTypes(Type[] typeArray, String string) {
        for (int i = 0; i < typeArray.length; ++i) {
            if (i > 0) {
                this.print(string);
            }
            this.printType(typeArray[i]);
        }
        return this;
    }

    public SymbolTablePrinter printType(Type type) {
        return this.printType0(this.getTypeToPrintForType(type));
    }

    public SymbolTablePrinter printType0(Type type) {
        this.printCommonPart(type);
        switch (type.$tag) {
            case 7: {
                return this.print(".type");
            }
            case 6: {
                return this.print(".type");
            }
        }
        return this;
    }

    public SymbolTablePrinter printType(Type type, String string) {
        if ("<:".equals(string) && type.symbol() == this.global.definitions.ANY_CLASS || ">:".equals(string) && type.symbol() == this.global.definitions.ALL_CLASS) {
            return this;
        }
        return this.printType0(this.getTypeToPrintForType(type), string);
    }

    public SymbolTablePrinter printType0(Type type, String string) {
        switch (type.$tag) {
            case 5: {
                Type.PolyType polyType = (Type.PolyType)type;
                Symbol[] symbolArray = polyType.tparams;
                Type type2 = polyType.result;
                if (symbolArray.length != 0 || this.global.debug) {
                    this.printTypeParams(symbolArray);
                }
                return this.printType(type2, string);
            }
            case 3: {
                Type.MethodType methodType = (Type.MethodType)type;
                Symbol[] symbolArray = methodType.vparams;
                Type type3 = methodType.result;
                return this.printValueParams(symbolArray).printType(type3, string);
            }
        }
        if (string != null) {
            if (!string.startsWith(":")) {
                this.space();
            }
            this.print(string).space();
        }
        return this.printType0(type);
    }

    public SymbolTablePrinter printFunctionType(Type[] typeArray) {
        Type[] typeArray2 = new Type[typeArray.length - 1];
        for (int i = 0; i < typeArray2.length; ++i) {
            typeArray2[i] = typeArray[i];
        }
        this.print('(').printTypes(typeArray2, ",").print(") => ");
        this.printType(typeArray[typeArray.length - 1]);
        return this;
    }

    public SymbolTablePrinter printTemplateType(Type[] typeArray) {
        this.print("<template: ").printTypes(typeArray, " with ").print(" {...}>");
        return this;
    }

    public SymbolTablePrinter printCommonPart(Type type) {
        switch (type.$tag) {
            case 13: {
                return this.print("<error>");
            }
            case 12: {
                return this.print("<any type>");
            }
            case 15: {
                return this.print("<notype>");
            }
            case 14: {
                return this.print("<noprefix>");
            }
            case 7: {
                Type.ThisType thisType = (Type.ThisType)type;
                Symbol symbol = thisType.sym;
                if ((symbol.isAnonymousClass() || symbol.isCompoundSym()) && !this.global.debug) {
                    return this.print("this");
                }
                return this.printSymbolName(symbol).print(".this");
            }
            case 8: {
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Type type2 = typeRef.pre;
                Symbol symbol = typeRef.sym;
                Type[] typeArray = typeRef.args;
                if (!this.global.debug) {
                    if (type.isFunctionType()) {
                        return this.printFunctionType(typeArray);
                    }
                    if (symbol.isAnonymousClass() || symbol.isCompoundSym()) {
                        return this.printTemplateType(type2.memberInfo(symbol).parents());
                    }
                }
                this.printPrefix(type2).printSymbolName(symbol);
                if (typeArray.length != 0) {
                    this.print('[').printTypes(typeArray, ",").print(']');
                }
                return this;
            }
            case 6: {
                Type.SingleType singleType = (Type.SingleType)type;
                Type type3 = singleType.pre;
                Symbol symbol = singleType.sym;
                return this.printPrefix(type3).printSymbolName(symbol);
            }
            case 1: {
                Type.ConstantType constantType = (Type.ConstantType)type;
                Type type4 = constantType.base;
                AConstant aConstant = constantType.value;
                return this.printType(type4).printConstantValue(aConstant);
            }
            case 0: {
                Type.CompoundType compoundType = (Type.CompoundType)type;
                Type[] typeArray = compoundType.parts;
                Scope scope = compoundType.members;
                return this.printTypes(typeArray, " with ").space().printScope(scope, true).printSymbolUniqueId(type.symbol());
            }
            case 3: {
                return this.printType0(type, null);
            }
            case 5: {
                return this.printType0(type, null);
            }
            case 4: {
                Type.OverloadedType overloadedType = (Type.OverloadedType)type;
                Type[] typeArray = overloadedType.alttypes;
                return this.printTypes(typeArray, " <and> ");
            }
            case 9: {
                Type.TypeVar typeVar = (Type.TypeVar)type;
                Type type5 = typeVar.origin;
                return this.printType(type5).print("?");
            }
            case 11: {
                Type.UnboxedType unboxedType = (Type.UnboxedType)type;
                int n = unboxedType.tag;
                return this.print(Type.unboxedName(n).toString());
            }
            case 10: {
                Type.UnboxedArrayType unboxedArrayType = (Type.UnboxedArrayType)type;
                Type type6 = unboxedArrayType.elemtp;
                return this.printType(type6).print("[]");
            }
            case 2: {
                if (!this.global.debug) {
                    return this.print("?");
                }
                String string = type.getClass().getName();
                return this.print("<lazy type ").print(string).print(">");
            }
        }
        String string = type.getClass().getName();
        return this.print("<unknown type ").print(string).print(">");
    }

    public Type getTypeToPrintForPrefix(Type type) {
        Type type2;
        while ((type2 = this.getTypeToPrintForPrefix0(type)) != type && type2 != null) {
            type = type2;
        }
        return type2;
    }

    public Type getTypeToPrintForPrefix0(Type type) {
        if (!this.global.debug) {
            if (type.symbol().isNone()) {
                return null;
            }
            if (type.symbol().isRoot()) {
                return null;
            }
        }
        return this.getTypeToPrintForType0(type);
    }

    public SymbolTablePrinter printPrefix(Type type) {
        return (type = this.getTypeToPrintForPrefix(type)) == null ? this : this.printPrefix0(type);
    }

    public SymbolTablePrinter printPrefix0(Type type) {
        this.printCommonPart(type);
        switch (type.$tag) {
            case 14: {
                return this.print(".");
            }
            case 7: {
                return this.print(".");
            }
            case 6: {
                return this.print(".");
            }
        }
        return this.print("#");
    }

    public SymbolTablePrinter printConstantValue(AConstant aConstant) {
        return this.print("(").print(aConstant.toString()).print(")");
    }

    public String toString() {
        return this.printer.toString();
    }
}

