/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab;

import scala.tools.util.Position;
import scalac.ApplicationError;
import scalac.Global;
import scalac.Phase;
import scalac.symtab.AbsTypeSymbol;
import scalac.symtab.AliasTypeSymbol;
import scalac.symtab.ClassSymbol;
import scalac.symtab.ConstructorSymbol;
import scalac.symtab.CyclicReference;
import scalac.symtab.ErrorScope;
import scalac.symtab.Kinds;
import scalac.symtab.LinkedClassSymbol;
import scalac.symtab.Modifiers;
import scalac.symtab.ModuleClassSymbol;
import scalac.symtab.ModuleSymbol;
import scalac.symtab.NoSymbol;
import scalac.symtab.Scope;
import scalac.symtab.SourceCompleter;
import scalac.symtab.SymbolLoader;
import scalac.symtab.SymbolTablePrinter;
import scalac.symtab.TermSymbol;
import scalac.symtab.Type;
import scalac.symtab.Type$Relation$;
import scalac.symtab.TypeIntervalList;
import scalac.util.Debug;
import scalac.util.Name;
import scalac.util.NameTransformer;
import scalac.util.Names;
import scalac.util.TypeName;

public abstract class Symbol
implements Modifiers,
Kinds {
    public static final Symbol[] EMPTY_ARRAY;
    public static final Symbol[][] EMPTY_ARRAY_ARRAY;
    public static final Symbol NONE;
    public static final int IS_ROOT = 1;
    public static final int IS_ANONYMOUS = 2;
    public static final int IS_LABEL = 16;
    public static final int IS_CONSTRUCTOR = 32;
    public static final int IS_ACCESSMETHOD = 256;
    public static final int IS_STATIC = 512;
    public static final int IS_ERROR = 0x10000000;
    public static final int IS_THISTYPE = 0x20000000;
    public static final int IS_LOCALDUMMY = 0x40000000;
    public static final int IS_COMPOUND = Integer.MIN_VALUE;
    private static int ids;
    public int kind;
    public int pos;
    public Name name;
    public int flags;
    private Symbol owner;
    private TypeIntervalList infos;
    private final int attrs;
    public final int id;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public Symbol(int n, Symbol symbol, int n2, int n3, Name name, int n4) {
        this.kind = n;
        this.pos = n2;
        this.name = name;
        this.owner = symbol == null ? this : symbol;
        this.flags = n3 & 0xFFFCFFFF;
        this.attrs = n4;
        this.id = ids++;
    }

    public final Symbol newTerm(int n, int n2, Name name) {
        return this.newTerm(n, n2, name, 0);
    }

    public final Symbol newConstructor(int n, int n2) {
        if (!$assertionsDisabled && !this.isType()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        return new ConstructorSymbol(this, n, n2);
    }

    public final Symbol newMethod(int n, int n2, Name name) {
        if (!$assertionsDisabled && !this.isClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        return this.newTerm(n, n2, name, 0);
    }

    public final Symbol newStaticMethod(int n, int n2, Name name) {
        if (!$assertionsDisabled && !this.isClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        return this.newTerm(n, n2, name, 512);
    }

    public final Symbol newAccessMethod(int n, Name name) {
        if (!$assertionsDisabled && !this.isClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        int n2 = 1030;
        return this.newTerm(n, n2, name, 256);
    }

    public final Symbol newFunction(int n, int n2, Name name) {
        if (!$assertionsDisabled && !this.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        return this.newTerm(n, n2, name, 0);
    }

    public final Symbol newMethodOrFunction(int n, int n2, Name name) {
        if (!($assertionsDisabled || this.isClass() || this.isTerm())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        return this.newTerm(n, n2, name, 0);
    }

    public final Symbol newLabel(int n, Name name) {
        if (!$assertionsDisabled && !this.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        return this.newTerm(n, 0, name, 16);
    }

    public final Symbol newField(int n, int n2, Name name) {
        if (!$assertionsDisabled && !this.isClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        return this.newTerm(n, n2, name, 0);
    }

    public final Symbol newStaticField(int n, int n2, Name name) {
        if (!$assertionsDisabled && !this.isClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        return this.newTerm(n, n2, name, 512);
    }

    public final Symbol newVariable(int n, int n2, Name name) {
        if (!$assertionsDisabled && !this.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        return this.newTerm(n, n2, name, 0);
    }

    public final Symbol newFieldOrVariable(int n, int n2, Name name) {
        if (!($assertionsDisabled || this.isClass() || this.isTerm())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        return this.newTerm(n, n2, name, 0);
    }

    public final Symbol newPatternVariable(int n, Name name) {
        return this.newVariable(n, 0, name);
    }

    public final Symbol newVParam(int n, int n2, Name name) {
        if (!$assertionsDisabled && !this.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        return this.newTerm(n, n2 | 0x8000, name);
    }

    public final Symbol newVParam(int n, int n2, Name name, Type type) {
        Symbol symbol = this.newVParam(n, n2, name);
        symbol.setInfo(type);
        return symbol;
    }

    public final Symbol newLocalDummy() {
        if (!$assertionsDisabled && !this.isClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        Symbol symbol = this.newTerm(this.pos, 0, Names.LOCAL(this), 0x40000000);
        symbol.setInfo(Type.NoType);
        return symbol;
    }

    public final Symbol newModule(int n, int n2, Name name) {
        return new ModuleSymbol(this, n, n2, name);
    }

    public final Symbol newPackage(int n, Name name) {
        return this.newPackage(n, name, null);
    }

    public final Symbol newLoadedPackage(Name name, SymbolLoader symbolLoader, Scope scope) {
        if (!$assertionsDisabled && symbolLoader == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(this))).concat(" - "))).concat(String.valueOf(String.valueOf(name))))));
        }
        Symbol symbol = this.newPackage(0, name, symbolLoader);
        if (scope != null) {
            scope.enterNoHide(symbol);
        }
        return symbol;
    }

    public Symbol newErrorValue(Name name) {
        Symbol symbol = this.newTerm(this.pos, 1024, name, 0x10000000);
        symbol.setInfo(Type.ErrorType);
        return symbol;
    }

    public final Symbol newTypeAlias(int n, int n2, Name name) {
        return new AliasTypeSymbol(this, n, n2, name, 0);
    }

    public final Symbol newAbstractType(int n, int n2, Name name) {
        return new AbsTypeSymbol(this, n, n2, name, 0);
    }

    public final Symbol newTParam(int n, int n2, Name name) {
        if (!$assertionsDisabled && !this.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        return this.newAbstractType(n, n2 | 0x8000, name);
    }

    public final Symbol newTParam(int n, int n2, Name name, Type type) {
        Symbol symbol = this.newTParam(n, n2, name);
        symbol.setInfo(type);
        return symbol;
    }

    public final Symbol newTypeAlias(int n, int n2, Name name, Type type) {
        Symbol symbol = this.newTypeAlias(n, n2, name);
        symbol.setInfo(type);
        symbol.allConstructors().setInfo(Type.MethodType(EMPTY_ARRAY, type));
        return symbol;
    }

    public final ClassSymbol newClass(int n, int n2, Name name) {
        return this.newClass(n, n2, name, 0);
    }

    public final ClassSymbol newAnonymousClass(int n, Name name) {
        if (!$assertionsDisabled && !this.isTerm()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        return this.newClass(n, 0, name, 2);
    }

    public final ClassSymbol newLoadedClass(int n, Name name, SymbolLoader symbolLoader, Scope scope) {
        if (!$assertionsDisabled && !this.isPackageClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        if (!$assertionsDisabled && symbolLoader == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(this))).concat(" - "))).concat(String.valueOf(String.valueOf(name))))));
        }
        LinkedClassSymbol linkedClassSymbol = new LinkedClassSymbol(this, n, name);
        linkedClassSymbol.setInfo(symbolLoader);
        linkedClassSymbol.allConstructors().setInfo(symbolLoader);
        ((Symbol)linkedClassSymbol).linkedModule().setInfo(symbolLoader);
        ((Symbol)linkedClassSymbol).linkedModule().moduleClass().setInfo(symbolLoader);
        if (scope != null) {
            scope.enterNoHide(linkedClassSymbol);
        }
        if (scope != null) {
            scope.enterNoHide(((Symbol)linkedClassSymbol).linkedModule());
        }
        return linkedClassSymbol;
    }

    public ClassSymbol newErrorClass(Name name) {
        ClassSymbol classSymbol = this.newClass(this.pos, 1024, name, 0x10000000);
        ErrorScope errorScope = new ErrorScope(this);
        classSymbol.setInfo(Type.compoundType(Type.EMPTY_ARRAY, errorScope, this));
        classSymbol.allConstructors().setInfo(Type.ErrorType);
        return classSymbol;
    }

    final Symbol newTerm(int n, int n2, Name name, int n3) {
        return new TermSymbol(this, n, n2, name, n3);
    }

    final Symbol newPackage(int n, Name name, Type type) {
        if (!$assertionsDisabled && !this.isPackageClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        Symbol symbol = this.newModule(n, 0x101000, name);
        if (type == null) {
            type = Type.compoundType(Type.EMPTY_ARRAY, new Scope(), symbol.moduleClass());
        }
        symbol.moduleClass().setInfo(type);
        return symbol;
    }

    final ClassSymbol newClass(int n, int n2, Name name, int n3) {
        return new ClassSymbol(this, n, n2, name, n3);
    }

    final ClassSymbol newCompoundClass(Type type) {
        int n = Position.FIRSTPOS;
        TypeName typeName = Names.COMPOUND_NAME.toTypeName();
        int n2 = 1152;
        int n3 = Integer.MIN_VALUE;
        ClassSymbol classSymbol = this.newClass(n, n2, typeName, n3);
        classSymbol.setInfo(type);
        classSymbol.primaryConstructor().setInfo(Type.MethodType(EMPTY_ARRAY, classSymbol.typeConstructor()));
        return classSymbol;
    }

    public final Symbol cloneSymbol() {
        return this.cloneSymbol(this.owner);
    }

    public final Symbol cloneSymbol(Symbol symbol) {
        Symbol symbol2 = this.cloneSymbolImpl(symbol, this.attrs);
        symbol2.setInfo(this.info());
        return symbol2;
    }

    protected abstract Symbol cloneSymbolImpl(Symbol var1, int var2);

    public static Symbol[] cloneArray(Symbol[] symbolArray) {
        return Symbol.cloneArray(0, symbolArray, 0);
    }

    public static Symbol[] cloneArray(int n, Symbol[] symbolArray) {
        return Symbol.cloneArray(n, symbolArray, 0);
    }

    public static Symbol[] cloneArray(Symbol[] symbolArray, int n) {
        return Symbol.cloneArray(0, symbolArray, n);
    }

    public static Symbol[] cloneArray(int n, Symbol[] symbolArray, int n2) {
        if (!($assertionsDisabled || n >= 0 && n2 >= 0)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(n).concat(" - "))).concat(String.valueOf(n2)))));
        }
        int n3 = n + symbolArray.length + n2;
        if (n3 == 0) {
            return EMPTY_ARRAY;
        }
        Symbol[] symbolArray2 = new Symbol[n3];
        for (int i = 0; i < symbolArray.length; ++i) {
            symbolArray2[n + i] = symbolArray[i];
        }
        return symbolArray2;
    }

    public static Symbol[] concat(Symbol[] symbolArray, Symbol[] symbolArray2) {
        if (symbolArray.length == 0) {
            return symbolArray2;
        }
        if (symbolArray2.length == 0) {
            return symbolArray;
        }
        Symbol[] symbolArray3 = Symbol.cloneArray(symbolArray.length, symbolArray2);
        for (int i = 0; i < symbolArray.length; ++i) {
            symbolArray3[i] = symbolArray[i];
        }
        return symbolArray3;
    }

    public Symbol setOwner(Symbol symbol) {
        if (!$assertionsDisabled && (this.isConstructor() || this.isNone() || this.isError())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        this.setOwner0(symbol);
        return this;
    }

    protected void setOwner0(Symbol symbol) {
        this.owner = symbol;
    }

    public final Symbol setType(Type type) {
        return this.setInfo(type);
    }

    public Symbol setInfo(Type type) {
        return this.setInfoAt(type, Global.instance.currentPhase);
    }

    private final Symbol setInfoAt(Type type, Phase phase) {
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        if (!$assertionsDisabled && phase == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        if (!($assertionsDisabled || !this.isConstructor() || type instanceof Type.LazyType || type == Type.NoType || type == Type.ErrorType || type instanceof Type.MethodType || type instanceof Type.OverloadedType || type instanceof Type.PolyType)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("illegal type for ".concat(String.valueOf(String.valueOf(this))))).concat(": "))).concat(String.valueOf(String.valueOf(type))))));
        }
        this.infos = new TypeIntervalList(null, type, phase);
        this.flags = type instanceof Type.LazyType ? (this.flags &= 0xFFFEFFFF) : (this.flags |= 0x10000);
        return this;
    }

    public final Symbol updateInfo(Type type) {
        return this.updateInfoAt(type, Global.instance.currentPhase.next);
    }

    private final Symbol updateInfoAt(Type type, Phase phase) {
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        if (!$assertionsDisabled && phase == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        if (!$assertionsDisabled && this.infos == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        if (!$assertionsDisabled && phase.precedes(this.infos.limit())) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(this))).concat(" -- "))).concat(String.valueOf(String.valueOf(phase))))).concat(" -- "))).concat(String.valueOf(String.valueOf(this.infos.limit()))))));
        }
        if (this.infos.limit() == phase) {
            if (this.infos.start == phase) {
                this.infos = this.infos.prev;
            } else {
                this.infos.setLimit(this.infos.limit().prev);
            }
        }
        this.infos = new TypeIntervalList(this.infos, type, phase);
        return this;
    }

    public Symbol setTypeOfThis(Type type) {
        throw new ApplicationError(String.valueOf(String.valueOf(this)).concat(".setTypeOfThis"));
    }

    public Symbol setLoBound(Type type) {
        throw new ApplicationError("setLoBound inapplicable for ".concat(String.valueOf(String.valueOf(this))));
    }

    public Symbol setVuBound(Type type) {
        throw new ApplicationError("setVuBound inapplicable for ".concat(String.valueOf(String.valueOf(this))));
    }

    public void addConstructor(Symbol symbol) {
        throw new ApplicationError("addConstructor inapplicable for ".concat(String.valueOf(String.valueOf(this))));
    }

    public final boolean isError() {
        return (this.attrs & 0x10000000) != 0;
    }

    public final boolean isNone() {
        return this.kind == 1;
    }

    public final boolean isType() {
        return this.kind == 4 || this.kind == 3 || this.kind == 2;
    }

    public final boolean isTerm() {
        return this.kind == 5;
    }

    public final boolean isValue() {
        this.preInitialize();
        return this.kind == 5 && (!this.isModule() || !this.isJava()) && !this.isPackage();
    }

    public final boolean isStable() {
        return this.kind == 5 && (this.flags & 0x100) == 0 && ((this.flags & 0x800000) != 0 || (this.flags & 0x4000) == 0 && this.type().isObjectType());
    }

    public final boolean hasStableFlag() {
        return (this.flags & 0x800000) != 0;
    }

    public final boolean isStatic() {
        return this.isRoot() || (this.attrs & 0x200) != 0 || this.owner.isStaticOwner();
    }

    public final boolean isStaticOwner() {
        return this.isPackageClass() || this.isJava() && this.isModuleClass() && this.isStatic();
    }

    public final boolean isFinal() {
        return (this.flags & 6) != 0 || this.isLocal() || this.owner.isModuleClass();
    }

    public final boolean isVariable() {
        return this.kind == 5 && (this.flags & 0x4000) != 0;
    }

    public final boolean isViewBounded() {
        Global global = Global.instance;
        return this.kind == 4 && (this.flags & 0x4000) != 0 && global.currentPhase.id <= global.PHASE.REFCHECK.id();
    }

    public final boolean isMethodFinal() {
        return (this.flags & 2) != 0 || this.isPrivate() || this.isLifted();
    }

    public final boolean isSealed() {
        return (this.flags & 0x10) != 0;
    }

    public final boolean isInitializedMethod() {
        if (this.infos == null) {
            return false;
        }
        Type type = this.rawInfo();
        switch (type.$tag) {
            case 3: {
                return true;
            }
            case 5: {
                return true;
            }
            case 4: {
                Type.OverloadedType overloadedType = (Type.OverloadedType)type;
                Symbol[] symbolArray = overloadedType.alts;
                for (int i = 0; i < symbolArray.length; ++i) {
                    if (!symbolArray[i].isMethod()) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public final boolean isMethod() {
        this.initialize();
        return this.isInitializedMethod();
    }

    public final boolean isCaseFactory() {
        return this.isMethod() && !this.isConstructor() && (this.flags & 0x40) != 0;
    }

    public final boolean isAbstractClass() {
        this.preInitialize();
        return this.kind == 3 && (this.flags & 0x80) != 0 && this != Global.instance.definitions.ARRAY_CLASS;
    }

    public final boolean isOverride() {
        this.preInitialize();
        return (this.flags & 0x20) != 0;
    }

    public final boolean isAbstractOverride() {
        this.preInitialize();
        return (this.flags & 0xA0) == 160;
    }

    public final boolean isAnonymousClass() {
        return this.isClass() && (this.attrs & 2) != 0;
    }

    public final boolean isRoot() {
        return (this.attrs & 1) != 0;
    }

    public final boolean isJava() {
        this.preInitialize();
        return (this.flags & 0x1000) != 0;
    }

    public final boolean isPackage() {
        return this.kind == 5 && (this.flags & 0x100000) != 0;
    }

    public final boolean isPackageClass() {
        return this.kind == 3 && (this.flags & 0x100000) != 0;
    }

    public final boolean isModule() {
        return this.kind == 5 && (this.flags & 0x2000) != 0;
    }

    public final boolean isModuleClass() {
        return this.kind == 3 && (this.flags & 0x2000) != 0;
    }

    public final boolean isClass() {
        return this.kind == 3 && (this.flags & 0x100000) == 0;
    }

    public final boolean isCaseClass() {
        this.preInitialize();
        return this.kind == 3 && (this.flags & 0x40) != 0;
    }

    public final boolean isCaseModuleClass() {
        return this.isModuleClass() && this.isCaseClass();
    }

    public final boolean isTrait() {
        return this.kind == 3 && (this.flags & 0x20000000) != 0;
    }

    public final boolean isCompoundSym() {
        return (this.attrs & Integer.MIN_VALUE) != 0;
    }

    public final boolean isThisSym() {
        return (this.attrs & 0x20000000) != 0;
    }

    public final boolean isInterface() {
        this.info();
        return (this.flags & 0x10000000) != 0;
    }

    public final boolean isTypeAlias() {
        return this.kind == 2;
    }

    public final boolean isAbstractType() {
        return this.kind == 4;
    }

    public final boolean isClassType() {
        return this.kind == 3;
    }

    public final boolean isPublic() {
        return !this.isProtected() && !this.isPrivate();
    }

    public final boolean isProtected() {
        this.preInitialize();
        return (this.flags & 8) != 0;
    }

    public final boolean isPrivate() {
        this.preInitialize();
        return (this.flags & 4) != 0;
    }

    public final boolean isLifted() {
        this.preInitialize();
        return (this.flags & 0x8000000) != 0;
    }

    public final boolean isDeferred() {
        return (this.flags & 1) != 0;
    }

    public final boolean isSynthetic() {
        return (this.flags & 0x400) != 0;
    }

    public final boolean isAccessor() {
        return (this.flags & 0x4000000) != 0;
    }

    public final boolean isAccessMethod() {
        return (this.attrs & 0x100) != 0;
    }

    public final boolean isLocal() {
        return this.owner.kind == 5 && ((this.flags & 0x8000) == 0 || !this.owner.isPrimaryConstructor());
    }

    public final boolean isParameter() {
        return (this.flags & 0x8000) != 0;
    }

    public final boolean isDefParameter() {
        return (this.flags & 0x8100) == 33024;
    }

    public final boolean isLocalClass() {
        return this.isClass() && (this.isAnonymousClass() || this.owner.isValue() || this.owner.isLocalClass());
    }

    public boolean isInitializer() {
        return false;
    }

    public final boolean isConstructor() {
        return (this.attrs & 0x20) != 0;
    }

    public final boolean isPrimaryConstructor() {
        return this.isConstructor() && this == this.constructorClass().primaryConstructor();
    }

    public final boolean isExternal() {
        return this.pos == 0;
    }

    public final boolean isOverloaded() {
        Type type = this.rawInfo();
        return type instanceof Type.OverloadedType || type instanceof LazyOverloadedType;
    }

    public final boolean isLabel() {
        return (this.attrs & 0x10) != 0;
    }

    public final boolean isAccessed() {
        return (this.flags & 0x40000) != 0;
    }

    public int variance() {
        if ((this.flags & 0x40000000) != 0) {
            return 1;
        }
        if ((this.flags & Integer.MIN_VALUE) != 0) {
            return -1;
        }
        return 0;
    }

    public Name simpleName() {
        if (this.isConstructor()) {
            return this.constructorClass().name.toTermName();
        }
        return this.name;
    }

    public Symbol[] typeParams() {
        return EMPTY_ARRAY;
    }

    public Symbol[] valueParams() {
        return EMPTY_ARRAY;
    }

    public final Type resultType() {
        return this.type().resultType();
    }

    public final Symbol[] nextTypeParams() {
        Global.instance.nextPhase();
        Symbol[] symbolArray = this.typeParams();
        Global.instance.prevPhase();
        return symbolArray;
    }

    public final Symbol[] nextValueParams() {
        Global.instance.nextPhase();
        Symbol[] symbolArray = this.valueParams();
        Global.instance.prevPhase();
        return symbolArray;
    }

    public final Type nextResultType() {
        return this.nextType().resultType();
    }

    public Symbol allConstructors() {
        return NONE;
    }

    public Symbol primaryConstructor() {
        return NONE;
    }

    public ClassSymbol linkedClass() {
        if (!$assertionsDisabled && !this.isModule()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf("not a module: ".concat(String.valueOf(String.valueOf(Debug.show(this)))))));
        }
        return null;
    }

    public ModuleSymbol linkedModule() {
        if (!$assertionsDisabled && !this.isClassType()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf("not a class: ".concat(String.valueOf(String.valueOf(Debug.show(this)))))));
        }
        return null;
    }

    public Symbol owner() {
        return this.owner;
    }

    public Symbol classOwner() {
        Symbol symbol = this.owner();
        Symbol symbol2 = symbol.constructorClass();
        if (symbol2.primaryConstructor() == symbol) {
            return symbol2;
        }
        return symbol;
    }

    public Symbol enclClass() {
        return this.owner().enclClass();
    }

    public Symbol enclMethod() {
        return this.isMethod() ? this : this.owner().enclMethod();
    }

    public Symbol constructorClass() {
        return this;
    }

    public ModuleClassSymbol moduleClass() {
        throw Debug.abort("not a module", this);
    }

    public ModuleSymbol sourceModule() {
        throw Debug.abort("not a module class", this);
    }

    public Symbol[] alternativeSymbols() {
        Symbol[] symbolArray = this.type().alternativeSymbols();
        if (symbolArray.length == 0) {
            return new Symbol[]{this};
        }
        return symbolArray;
    }

    public Type[] alternativeTypes() {
        return this.type().alternativeTypes();
    }

    public Symbol stableAlternative() {
        Type type = this.type();
        if (type.$tag == 4) {
            Type.OverloadedType overloadedType = (Type.OverloadedType)type;
            Symbol[] symbolArray = overloadedType.alts;
            for (int i = 0; i < symbolArray.length; ++i) {
                if (!symbolArray[i].isStable()) continue;
                return symbolArray[i];
            }
        }
        return this;
    }

    public Symbol accessed() {
        if (!$assertionsDisabled && (this.flags & 0x4000000) == 0) {
            throw new AssertionError();
        }
        String string = this.name.toString();
        if (string.endsWith(Names._EQ.toString())) {
            string = string.substring(0, string.length() - Names._EQ.length());
        }
        return this.owner.lookup(Name.fromString(String.valueOf(String.valueOf(string)).concat("$")));
    }

    public Scope members() {
        return this.info().members();
    }

    public Symbol lookup(Name name) {
        return this.info().lookup(name);
    }

    public final boolean isUpdatedAt(Phase phase) {
        Phase phase2 = phase.next;
        TypeIntervalList typeIntervalList = this.infos;
        while (typeIntervalList != null) {
            if (typeIntervalList.start == phase2) {
                return true;
            }
            if (typeIntervalList.limit().precedes(phase2)) {
                return false;
            }
            typeIntervalList = typeIntervalList.prev;
        }
        return false;
    }

    public final boolean isLocked() {
        return (this.flags & 0x20000) != 0;
    }

    public final boolean isInitialized() {
        return (this.flags & 0x10000) != 0;
    }

    public final Symbol initialize() {
        this.info();
        return this;
    }

    public final void preInitialize() {
        if (this.infos.info instanceof SymbolLoader) {
            this.infos.info.complete(this);
        }
    }

    public final Type info() {
        if ((this.flags & 0x10000) == 0) {
            Global global = Global.instance;
            Phase phase = global.currentPhase;
            global.currentPhase = this.rawFirstInfoStartPhase();
            Type type = this.rawFirstInfo();
            if (!$assertionsDisabled && type == null) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(this)));
            }
            if ((this.flags & 0x20000) != 0) {
                this.setInfo(Type.ErrorType);
                this.flags |= 0x10000;
                throw new CyclicReference(this, type);
            }
            this.flags |= 0x20000;
            type.complete(this);
            this.flags &= 0xFFFDFFFF;
            if (type instanceof SourceCompleter && (this.flags & 0x8000000) == 0) {
                this.flags |= 0x8000000;
                this.info();
                this.flags &= 0xF7FFFFFF;
            } else if (!$assertionsDisabled && this.rawInfo() instanceof Type.LazyType) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(this)));
            }
            global.currentPhase = phase;
        }
        return this.rawInfo();
    }

    public final Type nextInfo() {
        Global.instance.nextPhase();
        Type type = this.info();
        Global.instance.prevPhase();
        return type;
    }

    protected final Type infoAt(Phase phase) {
        Global global = phase.global;
        Phase phase2 = global.currentPhase;
        global.currentPhase = phase;
        Type type = this.info();
        global.currentPhase = phase2;
        return type;
    }

    public final Type rawInfo() {
        return this.rawInfoAt(Global.instance.currentPhase);
    }

    public final Type rawNextInfo() {
        Global.instance.nextPhase();
        Type type = this.rawInfo();
        Global.instance.prevPhase();
        return type;
    }

    private final Type rawInfoAt(Phase phase) {
        if (!$assertionsDisabled && this.infos == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this)));
        }
        if (!$assertionsDisabled && phase == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this)));
        }
        if (this.infos.limit().id <= phase.id) {
            if (this.infos.info.$tag == 2) {
                return this.infos.info;
            }
            while (this.infos.limit() != phase) {
                Phase phase2 = this.infos.limit();
                Type type = this.transformInfo(phase2, this.infos.info);
                if (!$assertionsDisabled && type == null) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(this))).concat(" -- "))).concat(String.valueOf(String.valueOf(phase2))))));
                }
                if (type != this.infos.info) {
                    this.infos = new TypeIntervalList(this.infos, type, phase2.next);
                    continue;
                }
                this.infos.setLimit(phase2.next);
            }
            return this.infos.info;
        }
        TypeIntervalList typeIntervalList = this.infos;
        while (phase.id < typeIntervalList.start.id && typeIntervalList.prev != null) {
            typeIntervalList = typeIntervalList.prev;
        }
        return typeIntervalList.info;
    }

    private Type transformInfo(Phase phase, Type type) {
        Global global = phase.global;
        Phase phase2 = global.currentPhase;
        boolean bl = phase2.id <= global.PHASE.UNCURRY.id();
        switch (type.$tag) {
            case 13: {
                return type;
            }
            case 15: {
                return type;
            }
            case 4: {
                Type type2;
                Type.OverloadedType overloadedType = (Type.OverloadedType)type;
                Symbol[] symbolArray = overloadedType.alts;
                Type[] typeArray = overloadedType.alttypes;
                global.currentPhase = phase.next;
                int n = 0;
                boolean bl2 = false;
                for (int i = 0; i < symbolArray.length; ++i) {
                    symbolArray[i].info();
                    if (bl || symbolArray[i].owner() == this.owner()) {
                        ++n;
                    }
                    if (symbolArray[i].info() == typeArray[i]) continue;
                    bl2 = true;
                }
                if (n < symbolArray.length) {
                    Symbol[] symbolArray2 = new Symbol[n];
                    Type[] typeArray2 = new Type[n];
                    int n2 = 0;
                    for (int i = 0; i < symbolArray.length; ++i) {
                        if (bl || symbolArray[i].owner() == this.owner()) {
                            symbolArray2[n2] = symbolArray[i];
                            typeArray2[n2] = symbolArray[i].info();
                            ++n2;
                            continue;
                        }
                        if (!Global.instance.debug) continue;
                        Global.instance.log(String.valueOf(String.valueOf(String.valueOf(String.valueOf("removing inherited alternatve ".concat(String.valueOf(String.valueOf(symbolArray[i]))))).concat(":"))).concat(String.valueOf(String.valueOf(typeArray[i]))));
                    }
                    type2 = Type.OverloadedType(symbolArray2, typeArray2);
                } else if (bl2) {
                    Type[] typeArray3 = new Type[typeArray.length];
                    for (int i = 0; i < symbolArray.length; ++i) {
                        typeArray3[i] = symbolArray[i].info();
                    }
                    type2 = Type.OverloadedType(symbolArray, typeArray3);
                } else {
                    type2 = type;
                }
                global.currentPhase = phase2;
                return type2;
            }
        }
        global.currentPhase = phase;
        type = phase.transformInfo(this, type);
        global.currentPhase = phase2;
        return type;
    }

    public final Type rawFirstInfo() {
        TypeIntervalList typeIntervalList = this.infos;
        if (!$assertionsDisabled && typeIntervalList == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this)));
        }
        while (typeIntervalList.prev != null) {
            typeIntervalList = typeIntervalList.prev;
        }
        return typeIntervalList.info;
    }

    public final Phase rawFirstInfoStartPhase() {
        TypeIntervalList typeIntervalList = this.infos;
        if (!$assertionsDisabled && typeIntervalList == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(this)));
        }
        while (typeIntervalList.prev != null) {
            typeIntervalList = typeIntervalList.prev;
        }
        return typeIntervalList.start;
    }

    public Type type() {
        return this.info();
    }

    public Type getType() {
        return this.info();
    }

    public final Type nextType() {
        Global.instance.nextPhase();
        Type type = this.type();
        Global.instance.prevPhase();
        return type;
    }

    public static Type[] info(Symbol[] symbolArray) {
        Type[] typeArray = new Type[symbolArray.length];
        for (int i = 0; i < symbolArray.length; ++i) {
            typeArray[i] = symbolArray[i].info();
        }
        return typeArray;
    }

    public static Type[] type(Symbol[] symbolArray) {
        Type[] typeArray = new Type[symbolArray.length];
        for (int i = 0; i < symbolArray.length; ++i) {
            typeArray[i] = symbolArray[i].type();
        }
        return typeArray;
    }

    public static Type[] getType(Symbol[] symbolArray) {
        return Symbol.type(symbolArray);
    }

    public final Type staticType() {
        return this.staticType(Type.EMPTY_ARRAY);
    }

    public final Type staticType(Type type) {
        return this.staticType(new Type[]{type});
    }

    public final Type staticType(Type type, Type type2) {
        return this.staticType(new Type[]{type, type2});
    }

    public final Type staticType(Type[] typeArray) {
        Type type = this.owner.staticPrefix();
        if (this.isType()) {
            return Type.typeRef(type, this, typeArray);
        }
        if (!$assertionsDisabled && typeArray.length != 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this, typeArray))));
        }
        return type.memberType(this);
    }

    public final Type staticPrefix() {
        if (!$assertionsDisabled && !this.isStaticOwner()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(this))).concat(" - "))).concat(String.valueOf(this.isTerm())))).concat(" - "))).concat(String.valueOf(this.isModuleClass())))).concat(" - "))).concat(String.valueOf(this.owner().isStaticOwner())))).concat(" - "))).concat(String.valueOf(this.isJava())))));
        }
        Global global = Global.instance;
        if (global.PHASE.EXPLICITOUTER.id() < global.currentPhase.id) {
            return Type.NoPrefix;
        }
        if (this.isRoot()) {
            return this.thisType();
        }
        if (!$assertionsDisabled && this.sourceModule().owner() != this.owner()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        if (!$assertionsDisabled && !this.sourceModule().type().isObjectType()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this))));
        }
        return Type.singleType(this.owner.staticPrefix(), this.sourceModule());
    }

    public Type typeConstructor() {
        throw new ApplicationError("typeConstructor inapplicable for ".concat(String.valueOf(String.valueOf(this))));
    }

    public Type loBound() {
        return Global.instance.definitions.ALL_TYPE();
    }

    public Type vuBound() {
        return Global.instance.definitions.ANY_TYPE();
    }

    public Type thisType() {
        return Type.NoPrefix;
    }

    public Type typeOfThis() {
        return this.type();
    }

    public Symbol thisSym() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLess(Symbol symbol) {
        if (this == symbol) {
            return false;
        }
        if (this.isType()) {
            if (!symbol.isType()) return true;
            int n = this.closure().length - symbol.closure().length;
            if (n > 0) {
                return true;
            }
            if (n < 0) {
                return false;
            }
        } else if (symbol.isType()) {
            return false;
        }
        if (this.id >= symbol.id) return false;
        return true;
    }

    public Type[] closure() {
        return this.info().closure();
    }

    public int closurePos(Symbol symbol) {
        if (this == symbol) {
            return 0;
        }
        if (symbol.isCompoundSym()) {
            return -1;
        }
        Type[] typeArray = this.closure();
        int n = 0;
        int n2 = typeArray.length - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            Symbol symbol2 = typeArray[n3].symbol();
            if (symbol == symbol2) {
                return n3;
            }
            if (symbol.isLess(symbol2)) {
                n2 = n3 - 1;
                continue;
            }
            if (symbol2.isLess(symbol)) {
                n = n3 + 1;
                continue;
            }
            throw new ApplicationError();
        }
        return -1;
    }

    public Type baseType(Symbol symbol) {
        int n = this.closurePos(symbol);
        if (n >= 0) {
            return this.closure()[n];
        }
        return Type.NoType;
    }

    public boolean isSubClass(Symbol symbol) {
        return this == symbol || symbol.isError() || this.closurePos(symbol) >= 0 || this == Global.instance.definitions.ALL_CLASS || this == Global.instance.definitions.ALLREF_CLASS && symbol != Global.instance.definitions.ALL_CLASS && symbol.isSubClass(Global.instance.definitions.ANYREF_CLASS);
    }

    public Type[] parents() {
        return this.info().parents();
    }

    public String nameString() {
        return NameTransformer.decode(this.simpleName());
    }

    public String toString() {
        return new SymbolTablePrinter().printSymbolKindAndName(this).toString();
    }

    public String locationString() {
        if (this.owner.kind == 3 && !this.owner.isAnonymousClass() && !this.owner.isCompoundSym() || Global.instance.debug) {
            return " in ".concat(String.valueOf(String.valueOf(this.owner.isModuleClass() ? this.owner.sourceModule() : this.owner)));
        }
        return "";
    }

    public String defString() {
        return new SymbolTablePrinter().printSignature(this).toString();
    }

    public static String[] defString(Symbol[] symbolArray) {
        String[] stringArray = new String[symbolArray.length];
        for (int i = 0; i < symbolArray.length; ++i) {
            stringArray[i] = symbolArray[i].defString();
        }
        return stringArray;
    }

    public Symbol firstAlternative() {
        if (this.infos == null) {
            return this;
        }
        if (this.infos.info instanceof Type.OverloadedType) {
            Symbol symbol = this.infos.info.alternativeSymbols()[0];
            if (!$assertionsDisabled && symbol.isOverloaded()) {
                throw new AssertionError();
            }
            return symbol;
        }
        if (this.infos.info instanceof LazyOverloadedType) {
            return ((LazyOverloadedType)this.infos.info).sym1.firstAlternative();
        }
        return this;
    }

    public Symbol overloadWith(Symbol symbol) {
        throw new ApplicationError("overloadWith inapplicable for ".concat(String.valueOf(String.valueOf(this))));
    }

    public final Symbol overriddenSymbol(Type type, boolean bl) {
        return this.overriddenSymbol(type, this.owner(), bl);
    }

    public final Symbol overriddenSymbol(Type type) {
        return this.overriddenSymbol(type, false);
    }

    public final Symbol overriddenSymbol(Type type, Symbol symbol, boolean bl) {
        Type$Relation$.Var var = bl ? Type.Relation.SameType : Type.Relation.SuperType;
        return type.lookup(this, symbol.thisType(), var);
    }

    public final Symbol overriddenSymbol(Type type, Symbol symbol) {
        return this.overriddenSymbol(type, symbol, false);
    }

    public final Symbol overridingSymbol(Type type, boolean bl) {
        Type$Relation$.Var var = bl ? Type.Relation.SameType : Type.Relation.SubType;
        return type.lookup(this, type, var);
    }

    public final Symbol overridingSymbol(Type type) {
        return this.overridingSymbol(type, false);
    }

    public boolean overrides(Symbol symbol) {
        return ((this.flags | symbol.flags) & 4) == 0 && this.name == symbol.name && this.owner.thisType().memberType(this).derefDef().isSubType(this.owner.thisType().memberType(symbol).derefDef());
    }

    public void reset(Type type) {
        this.flags &= 0xE010E377;
        this.pos = 0;
        this.infos = null;
        this.setInfo(type);
    }

    public Symbol rebindSym() {
        return this;
    }

    public int tag() {
        return this.name.toString().hashCode();
    }

    public void addInheritedOverloaded(Type type) {
        Symbol symbol = Type.lookupNonPrivate(this.owner.parents(), this.name);
        if (symbol.kind == 5) {
            Type type2 = this.owner.thisType().memberType(symbol);
            if (type2.$tag == 4) {
                Type.OverloadedType overloadedType = (Type.OverloadedType)type2;
                Symbol[] symbolArray = overloadedType.alts;
                Type[] typeArray = overloadedType.alttypes;
                for (int i = 0; i < symbolArray.length; ++i) {
                    this.addInheritedOverloaded(type, symbolArray[i], typeArray[i]);
                }
            } else {
                this.addInheritedOverloaded(type, symbol, type2);
            }
        }
    }

    public void addInheritedOverloaded(Type type, Symbol symbol, Type type2) {
        if (!type.overrides(type2)) {
            if (Global.instance.debug) {
                Global.instance.log(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.owner())).concat(" inherits overloaded: "))).concat(String.valueOf(String.valueOf(symbol))))).concat(":"))).concat(String.valueOf(String.valueOf(type2))))).concat(String.valueOf(String.valueOf(symbol.locationString()))));
            }
            this.owner().members().lookupEntry(this.name).setSymbol(this.overloadWith(symbol));
        }
    }

    public Type removeInheritedOverloaded(Type type) {
        if (type.$tag == 4) {
            Type.OverloadedType overloadedType = (Type.OverloadedType)type;
            Symbol[] symbolArray = overloadedType.alts;
            Type[] typeArray = overloadedType.alttypes;
            int n = 0;
            for (int i = 0; i < symbolArray.length; ++i) {
                if (symbolArray[i].owner() != this.owner()) continue;
                ++n;
            }
            if (n < symbolArray.length) {
                Symbol[] symbolArray2 = new Symbol[n];
                Type[] typeArray2 = new Type[n];
                int n2 = 0;
                for (int i = 0; i < symbolArray.length; ++i) {
                    if (symbolArray[i].owner() == this.owner()) {
                        symbolArray2[n2] = symbolArray[i];
                        typeArray2[n2] = typeArray[i];
                        ++n2;
                        continue;
                    }
                    if (!Global.instance.debug) continue;
                    Global.instance.log(String.valueOf(String.valueOf(String.valueOf(String.valueOf("removing inherited alternatve ".concat(String.valueOf(String.valueOf(symbolArray[i]))))).concat(":"))).concat(String.valueOf(String.valueOf(typeArray[i]))));
                }
                return Type.OverloadedType(symbolArray2, typeArray2);
            }
            return type;
        }
        return type;
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.symtab.Symbol").desiredAssertionStatus();
        EMPTY_ARRAY = new Symbol[0];
        EMPTY_ARRAY_ARRAY = new Symbol[0][];
        NONE = new NoSymbol();
    }

    public static class LazyOverloadedType
    extends Type.LazyType {
        Symbol sym1;
        Symbol sym2;

        LazyOverloadedType(Symbol symbol, Symbol symbol2) {
            this.sym1 = symbol;
            this.sym2 = symbol2;
        }

        public Symbol[] alternativeSymbols() {
            Symbol[] symbolArray = this.sym1.alternativeSymbols();
            Symbol[] symbolArray2 = this.sym2.alternativeSymbols();
            Symbol[] symbolArray3 = new Symbol[symbolArray.length + symbolArray2.length];
            System.arraycopy(symbolArray, 0, symbolArray3, 0, symbolArray.length);
            System.arraycopy(symbolArray2, 0, symbolArray3, symbolArray.length, symbolArray2.length);
            return symbolArray3;
        }

        public Type[] alternativeTypes() {
            Type[] typeArray = this.sym1.alternativeTypes();
            Type[] typeArray2 = this.sym2.alternativeTypes();
            Type[] typeArray3 = new Type[typeArray.length + typeArray2.length];
            System.arraycopy(typeArray, 0, typeArray3, 0, typeArray.length);
            System.arraycopy(typeArray2, 0, typeArray3, typeArray.length, typeArray2.length);
            return typeArray3;
        }

        public void complete(Symbol symbol) {
            symbol.setInfo(Type.OverloadedType(this.alternativeSymbols(), this.alternativeTypes()));
        }

        public String toString() {
            return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("LazyOverloadedType(".concat(String.valueOf(String.valueOf(this.sym1))))).concat(","))).concat(String.valueOf(String.valueOf(this.sym2))))).concat(")");
        }
    }
}

