/*
 * Decompiled with CFR 0.152.
 */
package scalac.backend.msil;

import ch.epfl.lamp.compiler.msil.ConstructorInfo;
import ch.epfl.lamp.compiler.msil.FieldInfo;
import ch.epfl.lamp.compiler.msil.MethodBase;
import ch.epfl.lamp.compiler.msil.MethodInfo;
import ch.epfl.lamp.compiler.msil.ParameterInfo;
import ch.epfl.lamp.compiler.msil.emit.ConstructorBuilder;
import ch.epfl.lamp.compiler.msil.emit.ILGenerator;
import ch.epfl.lamp.compiler.msil.emit.Label;
import ch.epfl.lamp.compiler.msil.emit.LocalBuilder;
import ch.epfl.lamp.compiler.msil.emit.MethodBuilder;
import ch.epfl.lamp.compiler.msil.emit.OpCode;
import ch.epfl.lamp.compiler.msil.emit.OpCodes;
import ch.epfl.lamp.compiler.msil.emit.TypeBuilder;
import java.util.HashMap;
import java.util.Map;
import scala.tools.util.Position;
import scalac.CompilationUnit;
import scalac.Global;
import scalac.ast.Tree;
import scalac.ast.TreeList;
import scalac.atree.AConstant;
import scalac.backend.Primitive;
import scalac.backend.Primitive$;
import scalac.backend.Primitives;
import scalac.backend.msil.Chain;
import scalac.backend.msil.GenMSILPhase;
import scalac.backend.msil.Item;
import scalac.backend.msil.ItemFactory;
import scalac.backend.msil.MSILType;
import scalac.backend.msil.Test;
import scalac.backend.msil.TypeCreator;
import scalac.symtab.Definitions;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.symtab.classfile.Pickle;
import scalac.util.Debug;
import scalac.util.Names;
import scalac.util.SourceRepresentation;

public final class GenMSIL {
    private final Map params = new HashMap();
    private final Map locals = new HashMap();
    private final Map sym2label = new HashMap();
    private ILGenerator code;
    private final Global global;
    private final TypeCreator tc;
    private final Definitions defs;
    private final Primitives primitives;
    private final ItemFactory items;
    private static final Item TRUE_ITEM;
    private static final Item FALSE_ITEM;
    private CompilationUnit currUnit;
    private Symbol currentClass;
    private MethodBase currentMethod;
    private boolean lastExpr;
    private boolean enableTailCalls = false;
    private Label methodEnd = null;
    private boolean unreachable = false;
    private Label exitLabel;
    private int pos;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public GenMSIL(Global global, GenMSILPhase genMSILPhase) {
        this.global = global;
        this.defs = global.definitions;
        this.primitives = global.primitives;
        this.tc = genMSILPhase.tc;
        this.items = new ItemFactory(this);
    }

    private String getSourceFilename() {
        if (!$assertionsDisabled && this.currUnit == null) {
            throw new AssertionError();
        }
        return SourceRepresentation.escape(this.currUnit.source.getFile().getPath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void apply(CompilationUnit compilationUnit) {
        this.currUnit = compilationUnit;
        int n = 0;
        while (true) {
            block9: {
                if (n >= compilationUnit.body.length) {
                    return;
                }
                Tree tree = compilationUnit.body[n];
                Symbol symbol = tree.symbol();
                try {
                    switch (tree.$tag) {
                        case 42: {
                            break block9;
                        }
                        case 10: {
                            Tree.ClassDef classDef = (Tree.ClassDef)tree;
                            if (classDef.impl.$tag != 33) break;
                            Tree.Template template = classDef.impl;
                            Tree[] treeArray = template.body;
                            this.genClass(symbol, treeArray);
                            break block9;
                        }
                        case 24: {
                            Tree.PackageDef packageDef = (Tree.PackageDef)tree;
                            if (packageDef.impl.$tag != 33) break;
                            Tree.Template template = packageDef.impl;
                            Tree[] treeArray = template.body;
                            this.genPackage(treeArray);
                            break block9;
                        }
                    }
                    throw Debug.abort("Illegal top-level definition: ".concat(String.valueOf(String.valueOf(Debug.show(tree)))));
                }
                catch (Throwable throwable) {
                    this.currUnit.error(tree.pos, "Exception caught: ".concat(String.valueOf(String.valueOf(throwable.getMessage()))));
                    throwable.printStackTrace();
                    this.tc.saveAssembly();
                    System.exit(1);
                }
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void genPackage(Tree[] treeArray) {
        int n = 0;
        while (true) {
            block9: {
                if (n >= treeArray.length) {
                    return;
                }
                Symbol symbol = treeArray[n].symbol();
                Tree tree = treeArray[n];
                switch (tree.$tag) {
                    case 42: {
                        break block9;
                    }
                    case 10: {
                        Tree.ClassDef classDef = (Tree.ClassDef)tree;
                        if (classDef.impl.$tag != 33) break;
                        Tree.Template template = classDef.impl;
                        Tree[] treeArray2 = template.body;
                        ch.epfl.lamp.compiler.msil.Type type = this.tc.getType(symbol);
                        if (!$assertionsDisabled && !(type instanceof TypeBuilder)) {
                            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Debug.show(symbol))).concat(" => ["))).concat(String.valueOf(String.valueOf(type.Assembly()))))).concat("]"))).concat(String.valueOf(String.valueOf(type))))));
                        }
                        if (type instanceof TypeBuilder) {
                            this.genClass(symbol, treeArray2);
                        }
                        break block9;
                    }
                    case 24: {
                        Tree.PackageDef packageDef = (Tree.PackageDef)tree;
                        if (packageDef.impl.$tag != 33) break;
                        Tree.Template template = packageDef.impl;
                        Tree[] treeArray2 = template.body;
                        this.genPackage(treeArray2);
                        break block9;
                    }
                }
                throw Debug.abort("Class definition expected", Debug.show(symbol));
            }
            ++n;
        }
    }

    private void emitSymtab(Symbol symbol) {
        Pickle pickle = (Pickle)this.global.symdata.get(symbol);
        if (pickle != null) {
            TypeBuilder typeBuilder;
            byte[] byArray = new byte[pickle.size() + 8];
            byArray[0] = 1;
            int n = pickle.size();
            for (int i = 2; i < 6; ++i) {
                byArray[i] = (byte)(n & 0xFF);
                n >>= 8;
            }
            System.arraycopy(pickle.bytes, 0, byArray, 6, pickle.size());
            TypeBuilder typeBuilder2 = (TypeBuilder)this.tc.getType(symbol);
            if (symbol.isModuleClass() && (typeBuilder = this.tc.getStaticType(symbol)) != null) {
                typeBuilder2 = typeBuilder;
                if (this.global.args.debuginfo.value) {
                    typeBuilder2.setPosition(Position.line(symbol.pos), this.getSourceFilename());
                }
            }
            typeBuilder2.SetCustomAttribute(this.tc.SCALA_SYMTAB_ATTR_CONSTR, byArray);
        }
    }

    private void genClass(Symbol symbol, Tree[] treeArray) {
        Symbol symbol2 = this.currentClass;
        this.currentClass = symbol;
        if (symbol.isModuleClass()) {
            this.tc.getModuleField(symbol);
        }
        TypeBuilder typeBuilder = (TypeBuilder)this.tc.getType(symbol);
        if (this.global.args.debuginfo.value) {
            typeBuilder.setPosition(Position.line(symbol.pos), this.getSourceFilename());
        }
        this.emitSymtab(symbol);
        block6: for (int i = 0; i < treeArray.length; ++i) {
            Symbol symbol3 = treeArray[i].symbol();
            Tree tree = treeArray[i];
            switch (tree.$tag) {
                case 42: {
                    continue block6;
                }
                case 40: {
                    this.tc.createField(symbol3);
                    continue block6;
                }
                case 10: {
                    Tree tree2 = (Tree.ClassDef)tree;
                    Tree.ValDef[][] valDefArray = tree2.impl;
                    this.genClass(symbol3, valDefArray.body);
                    continue block6;
                }
                case 13: {
                    Tree tree2 = (Tree.DefDef)tree;
                    Tree.ValDef[][] valDefArray = ((Tree.DefDef)tree2).vparams;
                    Tree tree3 = ((Tree.DefDef)tree2).tpe;
                    Tree tree4 = ((Tree.DefDef)tree2).rhs;
                    if (symbol3.isDeferred()) continue block6;
                    this.currentMethod = this.tc.getMethod(symbol3);
                    if (this.tc.isEntryPoint(symbol3) && this.tc.moreThanOneEntryPoint()) {
                        this.currUnit.warning(treeArray[i].pos, "Program has more than one entry point defined");
                    }
                    this.genDef(symbol3, valDefArray[0], tree4, this.msilType(tree3.type));
                    continue block6;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf("Illegal class body definition: ".concat(String.valueOf(String.valueOf(Debug.show(treeArray[i])))))));
                    }
                    continue block6;
                }
            }
        }
        this.currentClass = symbol2;
    }

    private void genDef(Symbol symbol, Tree.ValDef[] valDefArray, Tree tree, MSILType mSILType) {
        MethodBase methodBase = this.tc.getMethod(symbol);
        this.params.clear();
        this.locals.clear();
        int n = methodBase.IsStatic() ? 0 : 1;
        for (int i = 0; i < valDefArray.length; ++i) {
            this.params.put(valDefArray[i].symbol(), new Integer(i + n));
        }
        if (methodBase.IsConstructor()) {
            ConstructorInfo constructorInfo = (ConstructorInfo)methodBase;
            this.code = ((ConstructorBuilder)constructorInfo).GetILGenerator();
            this.methodEnd = this.code.DefineLabel();
            if (this.global.args.debuginfo.value) {
                this.code.setPosition(Position.line(tree.pos));
            }
            if (symbol.owner().isModuleClass() && symbol.owner().owner().isPackageClass()) {
                Tree.Block block;
                Tree[] treeArray = null;
                if (tree.$tag == 8) {
                    Tree[] treeArray2;
                    Tree[] treeArray3;
                    Tree tree2;
                    block = (Tree.Block)tree;
                    Tree[] treeArray4 = block.stats;
                    Tree tree3 = block.expr;
                    TreeList treeList = new TreeList();
                    for (int i = 0; i < treeArray4.length; ++i) {
                        tree2 = treeArray4[i];
                        if (tree2.$tag == 8) {
                            treeArray3 = (Tree.Block)tree2;
                            treeArray2 = treeArray3.stats;
                            Tree tree4 = treeArray3.expr;
                            treeList.append(treeArray2);
                            treeList.append(tree4);
                            continue;
                        }
                        treeList.append(treeArray4[i]);
                    }
                    if (tree3.$tag == 8) {
                        tree2 = (Tree.Block)tree3;
                        treeArray3 = ((Tree.Block)tree2).stats;
                        treeArray2 = ((Tree.Block)tree2).expr;
                        treeList.append(treeArray3);
                        treeList.append((Tree)treeArray2);
                    }
                    treeArray = treeList.toArray();
                } else {
                    treeArray = new Tree[]{tree};
                }
                this.drop(this.gen(treeArray[0], MSILType.VOID));
                this.closeMethod(this.methodEnd);
                block = ((TypeBuilder)methodBase.DeclaringType).DefineConstructor((short)22, (short)1, ch.epfl.lamp.compiler.msil.Type.EmptyTypes);
                this.currentMethod = block;
                this.code = block.GetILGenerator();
                if (this.global.args.debuginfo.value) {
                    this.code.setPosition(Position.line(symbol.owner().pos));
                }
                this.code.Emit(OpCodes.Newobj, constructorInfo);
                this.code.Emit(OpCodes.Stsfld, this.tc.getModuleField(this.currentClass));
                for (int i = 1; i < treeArray.length; ++i) {
                    this.drop(this.gen(treeArray[i], MSILType.VOID));
                }
                this.code.Emit(OpCodes.Ret);
            } else {
                this.drop(this.gen(tree, MSILType.VOID));
                this.closeMethod(this.methodEnd);
            }
        } else if (!methodBase.IsAbstract()) {
            MethodBuilder methodBuilder;
            this.lastExpr = true;
            this.code = ((MethodBuilder)methodBase).GetILGenerator();
            this.methodEnd = this.code.DefineLabel();
            if (this.global.args.debuginfo.value) {
                this.code.setPosition(Position.line(tree.pos));
            }
            Item item = this.gen(tree, mSILType);
            if (this.returnsVoid(methodBase)) {
                this.drop(item);
            } else {
                this.coerce(this.load(item), mSILType);
            }
            this.closeMethod(this.methodEnd);
            if (this.currentClass.isModuleClass() && (methodBuilder = this.tc.getStaticObjectMethod(symbol)) != null) {
                this.code = methodBuilder.GetILGenerator();
                if (this.global.args.debuginfo.value) {
                    this.code.setPosition(Position.line(symbol.pos));
                }
                this.code.Emit(OpCodes.Ldsfld, this.tc.getModuleField(this.currentClass));
                for (int i = 0; i < valDefArray.length; ++i) {
                    this.emitLdarg(i);
                }
                this.code.Emit(OpCodes.Call, (MethodInfo)methodBase);
                this.code.Emit(OpCodes.Ret);
            }
        }
        this.lastExpr = false;
        this.code = null;
        this.methodEnd = null;
    }

    private void closeMethod(Label label) {
        this.code.MarkLabel(label);
        this.code.Emit(OpCodes.Ret);
    }

    private boolean returnsVoid(MethodBase methodBase) {
        return methodBase.IsConstructor() || ((MethodInfo)methodBase).ReturnType == this.tc.VOID;
    }

    private boolean returnsVoid(Symbol symbol) {
        Type type = symbol.type();
        if (type.$tag == 3) {
            Type.MethodType methodType = (Type.MethodType)type;
            Type type2 = methodType.result;
            return type2.isSameAs(this.defs.UNIT_TYPE().unbox());
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void emitThis() {
        if (this.currentMethod.IsStatic()) {
            if (!this.currentMethod.IsConstructor()) throw Debug.abort("Static methods don't have 'this' pointer");
            this.code.Emit(OpCodes.Ldsfld, this.tc.getModuleField(this.currentClass));
            return;
        } else {
            this.code.Emit(OpCodes.Ldarg_0);
        }
    }

    private Item check(Item item) {
        if (!($assertionsDisabled || item != null && item.type != null)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf("".concat(String.valueOf(String.valueOf(item))))));
        }
        return item;
    }

    private Item genLoad(Tree tree, MSILType mSILType) {
        return this.load(this.gen(tree, mSILType));
    }

    private Item gen(Tree tree, MSILType mSILType) {
        this.unreachable = false;
        if (this.global.args.debuginfo.value && this.code != null && tree.pos != 0 && Position.line(tree.pos) != Position.line(this.pos)) {
            this.code.setPosition(Position.line(tree.pos));
        }
        int n = this.pos;
        this.pos = tree.pos;
        Item item = null;
        try {
            item = this.gen0(tree, mSILType);
            if (!($assertionsDisabled || item.type.equals(mSILType) || item.type.equals(this.unboxValueType(mSILType)))) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("".concat(String.valueOf(String.valueOf(item))))).concat(" <> "))).concat(String.valueOf(String.valueOf(mSILType))))).concat("; tree = "))).concat(String.valueOf(String.valueOf(tree.getClass()))))));
            }
        }
        catch (Throwable throwable) {
            this.currUnit.error(tree.pos, "Exception caught: ".concat(String.valueOf(String.valueOf(throwable.getMessage()))));
            throwable.printStackTrace();
            this.tc.saveAssembly();
            System.exit(1);
            throw Debug.abort(throwable);
        }
        this.pos = n;
        return this.check(item);
    }

    private Item gen0(Tree tree, MSILType mSILType) {
        Symbol symbol = tree.hasSymbol() ? tree.symbol() : null;
        Item item = null;
        switch (tree.$tag) {
            case 42: {
                return this.items.VoidItem();
            }
            case 8: {
                Tree.Block block = (Tree.Block)tree;
                Tree[] treeArray = block.stats;
                Tree tree2 = block.expr;
                boolean bl = this.lastExpr;
                this.lastExpr = false;
                Label label = this.exitLabel;
                this.exitLabel = null;
                for (int i = 0; i < treeArray.length; ++i) {
                    this.drop(this.gen(treeArray[i], MSILType.VOID));
                }
                this.lastExpr = bl;
                this.exitLabel = label;
                return this.gen(tree2, mSILType);
            }
            case 40: {
                Tree.ValDef valDef = (Tree.ValDef)tree;
                Tree tree3 = valDef.tpe;
                Tree tree4 = valDef.rhs;
                LocalBuilder localBuilder = this.code.DeclareLocal(this.tc.getType(symbol));
                localBuilder.SetLocalSymInfo(tree.symbol().name.toString());
                this.locals.put(symbol, localBuilder);
                if (tree4 == Tree.Empty) {
                    return this.items.VoidItem();
                }
                MSILType mSILType2 = this.msilType(tree3.type);
                this.genLoad(tree4, mSILType2);
                return this.check(this.store(this.items.LocalItem(localBuilder)));
            }
            case 17: {
                if (symbol.isModule()) {
                    FieldInfo fieldInfo = this.tc.getModuleField(symbol);
                    item = this.coerce(this.load(this.items.StaticItem(fieldInfo)), mSILType);
                } else {
                    MSILType mSILType3 = this.msilType(symbol.info());
                    Integer n = (Integer)this.params.get(symbol);
                    if (n != null) {
                        item = this.items.ArgItem(mSILType3, n);
                    } else {
                        LocalBuilder localBuilder = (LocalBuilder)this.locals.get(symbol);
                        if (localBuilder != null) {
                            item = this.items.LocalItem(localBuilder);
                        } else {
                            if (!$assertionsDisabled && !symbol.isStatic()) {
                                throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
                            }
                            FieldInfo fieldInfo = this.tc.getField(symbol);
                            if (!$assertionsDisabled && fieldInfo == null) {
                                throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
                            }
                            if (fieldInfo.IsLiteral()) {
                                if (!($assertionsDisabled || fieldInfo.FieldType.IsEnum() && fieldInfo.getValue() != null)) {
                                    throw new AssertionError((Object)String.valueOf(String.valueOf(fieldInfo.toString())));
                                }
                                return this.coerce(this.mkLiteral(this.msilType(fieldInfo.FieldType), fieldInfo.getValue()), mSILType);
                            }
                            return this.coerce(this.items.StaticItem(fieldInfo), mSILType);
                        }
                    }
                }
                return this.coerce(item, mSILType);
            }
            case 27: {
                Tree.Select select = (Tree.Select)tree;
                Tree tree5 = select.qualifier;
                if (symbol.isModule()) {
                    if (!$assertionsDisabled && symbol.isJava()) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf("Cannot treat Java class '".concat(String.valueOf(String.valueOf(Debug.show(symbol)))))).concat("' as value."))));
                    }
                    return this.coerce(this.load(this.items.StaticItem(this.tc.getModuleField(symbol))), mSILType);
                }
                if (!$assertionsDisabled && symbol.isStatic()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
                }
                item = this.items.SelectItem(this.genLoad(tree5, this.msilType(tree5)), this.tc.getField(symbol));
                return this.coerce(item, mSILType);
            }
            case 4: {
                Tree.Apply apply = (Tree.Apply)tree;
                Tree tree6 = apply.fun;
                Tree[] treeArray = apply.args;
                Item item2 = this.check(this.genApply(tree6, treeArray, this.msilType(tree.type)));
                return this.coerce(item2, mSILType);
            }
            case 5: {
                Tree.Assign assign = (Tree.Assign)tree;
                Tree tree7 = assign.lhs;
                Tree tree8 = assign.rhs;
                boolean bl = this.lastExpr;
                this.lastExpr = false;
                Label label = this.exitLabel;
                this.exitLabel = null;
                MSILType mSILType4 = this.msilType(tree7.type);
                Item item3 = this.gen(tree7, mSILType4);
                this.genLoad(tree8, mSILType4);
                this.lastExpr = bl;
                this.exitLabel = label;
                return this.check(this.store(item3));
            }
            case 23: {
                Tree.New new_ = (Tree.New)tree;
                Tree tree9 = new_.init;
                if (tree9.$tag == 4) {
                    Tree.Apply apply = (Tree.Apply)tree9;
                    Tree tree10 = apply.fun;
                    Tree[] treeArray = apply.args;
                    boolean bl = this.lastExpr;
                    this.lastExpr = false;
                    Label label = this.exitLabel;
                    this.exitLabel = null;
                    ConstructorInfo constructorInfo = (ConstructorInfo)this.tc.getMethod(tree10.symbol());
                    this.loadArgs(treeArray, constructorInfo.GetParameters());
                    this.code.Emit(OpCodes.Newobj, constructorInfo);
                    this.lastExpr = bl;
                    this.exitLabel = label;
                    return this.coerce(this.items.StackItem(this.msilType(constructorInfo.DeclaringType)), mSILType);
                }
                throw Debug.abort("Incorrect tree", tree9);
            }
            case 34: {
                return this.coerce(this.items.SelfItem(this.tc.getType(symbol)), mSILType);
            }
            case 31: {
                return this.coerce(this.items.SelfItem(this.tc.getType(symbol)), mSILType);
            }
            case 21: {
                Tree.Literal literal = (Tree.Literal)tree;
                AConstant aConstant = literal.value;
                if (mSILType == MSILType.VOID) {
                    return this.items.VoidItem();
                }
                return this.coerce(this.items.LiteralItem(aConstant), mSILType);
            }
            case 26: {
                Tree.Return return_ = (Tree.Return)tree;
                Tree tree11 = return_.expr;
                this.genLoad(tree11, this.msilType(tree11));
                this.code.Emit(OpCodes.Ret);
                return this.items.VoidItem();
            }
            case 18: {
                Tree.If if_ = (Tree.If)tree;
                Tree tree12 = if_.cond;
                Tree tree13 = if_.thenp;
                Tree tree14 = if_.elsep;
                item = this.genIf(tree12, tree13, tree14, mSILType);
                return this.check(item);
            }
            case 20: {
                Tree.LabelDef labelDef = (Tree.LabelDef)tree;
                Tree.Ident[] identArray = labelDef.params;
                Tree tree15 = labelDef.rhs;
                Label label = this.code.DefineLabel();
                this.code.MarkLabel(label);
                this.sym2label.put(symbol, new LabelDescr(label, identArray));
                return this.gen(tree15, mSILType);
            }
            case 32: {
                Tree.Switch switch_ = (Tree.Switch)tree;
                Tree tree16 = switch_.test;
                int[] nArray = switch_.tags;
                Tree[] treeArray = switch_.bodies;
                Tree tree17 = switch_.otherwise;
                boolean bl = this.lastExpr;
                this.lastExpr = false;
                Item item4 = this.gen(tree16, MSILType.I4);
                switch (item4.$tag) {
                    case 0: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        item4 = this.items.LocalItem(this.code.DeclareLocal(this.tc.INT));
                        this.store(item4);
                    }
                }
                this.lastExpr = bl;
                Label label = this.exitLabel;
                if (this.exitLabel == null) {
                    this.exitLabel = this.code.DefineLabel();
                }
                Label label2 = this.code.DefineLabel();
                if (!$assertionsDisabled && nArray.length != treeArray.length) {
                    throw new AssertionError();
                }
                for (int i = 0; i < nArray.length; ++i) {
                    this.load(item4);
                    this.loadI4(nArray[i]);
                    this.code.Emit(OpCodes.Bne_Un, label2);
                    this.genLoad(treeArray[i], mSILType);
                    if (!this.unreachable) {
                        this.code.Emit(OpCodes.Br, this.exitLabel);
                    }
                    this.code.MarkLabel(label2);
                    label2 = this.code.DefineLabel();
                }
                Item item5 = this.genLoad(tree17, mSILType);
                if (label == null) {
                    this.resolve(this.exitLabel);
                }
                this.exitLabel = label;
                return item5;
            }
        }
        throw Debug.abort("Dunno what to do", tree);
    }

    private Item genIf(Tree tree, Tree tree2, Tree tree3, MSILType mSILType) {
        Item item = null;
        boolean bl = this.lastExpr;
        this.lastExpr = false;
        Label label = this.exitLabel;
        this.exitLabel = null;
        Item.CondItem condItem = this.mkCond(this.gen(tree, this.msilType(tree.type)));
        this.lastExpr = bl;
        this.exitLabel = label;
        if (tree3 == Tree.Empty && mSILType == MSILType.VOID) {
            if (condItem.success == null) {
                Chain chain = new Chain(this.code.DefineLabel(), null);
                this.branch(condItem.test, chain);
                item = this.genLoad(tree2, mSILType);
                this.resolve(chain);
                this.resolve(condItem.failure);
            } else {
                Chain chain = condItem.failure != null ? condItem.failure : new Chain(this.code.DefineLabel(), null);
                this.branch(condItem.test, chain);
                this.resolve(condItem.success);
                item = this.genLoad(tree2, mSILType);
                this.resolve(chain);
            }
        } else {
            Chain chain = condItem.failure != null ? condItem.failure : new Chain(this.code.DefineLabel(), null);
            this.branch(condItem.test, chain);
            this.resolve(condItem.success);
            if (this.exitLabel == null) {
                this.exitLabel = this.code.DefineLabel();
            }
            Item item2 = this.gen(tree2, mSILType);
            item = this.load(this.coerce(item2, mSILType));
            if (!this.unreachable) {
                this.code.Emit(OpCodes.Br, this.exitLabel);
            }
            this.resolve(chain);
            this.genLoad(tree3, mSILType);
            if (label == null) {
                this.resolve(this.exitLabel);
            }
            this.exitLabel = label;
        }
        return item;
    }

    private Item coerce(Item item, MSILType mSILType) {
        if (!($assertionsDisabled || item != null && mSILType != null)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("".concat(String.valueOf(String.valueOf(item))))).concat(" => "))).concat(String.valueOf(String.valueOf(mSILType))))));
        }
        if (item.type.equals(mSILType)) {
            return item;
        }
        if (mSILType == MSILType.VOID) {
            return this.drop(item);
        }
        switch (item.$tag) {
            case 8: {
                if (!$assertionsDisabled && mSILType != MSILType.VOID) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf("".concat(String.valueOf(String.valueOf(mSILType))))));
                }
                return item;
            }
            case 5: {
                if (!$assertionsDisabled && !item.type.isSubtypeOf(mSILType)) {
                    throw new AssertionError();
                }
                item.type = mSILType;
                return item;
            }
            case 6: {
                MSILType mSILType2 = this.unboxValueType(mSILType);
                if (item.type.isValueType() && mSILType2 != null) {
                    mSILType = mSILType2;
                }
                this.emitConvert(item.type, mSILType);
                item.type = mSILType;
                return item;
            }
            case 2: {
                if (item.type.$tag == 1) {
                    MSILType.REF rEF = (MSILType.REF)item.type;
                    ch.epfl.lamp.compiler.msil.Type type = rEF.t;
                    if (item.type.isValueType()) {
                        if (!($assertionsDisabled || type.IsEnum() || mSILType.equals(MSILType.OBJECT))) {
                            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(item)).concat(" => "))).concat(String.valueOf(String.valueOf(mSILType))))));
                        }
                        return this.coerce(this.load(item), mSILType);
                    }
                    if (!($assertionsDisabled || item.type.isValueType() || item.type.isReferenceType() && item.type.isSubtypeOf(mSILType))) {
                        throw new AssertionError();
                    }
                }
                item.type = mSILType;
                return item;
            }
            case 0: {
                if (!item.type.isSubtypeOf(mSILType)) break;
                item.type = mSILType;
                return item;
            }
            case 3: {
                if (!item.type.isSubtypeOf(mSILType)) break;
                item.type = mSILType;
                return item;
            }
            case 1: {
                if (item.type != MSILType.BOOL) break;
                return item;
            }
        }
        return this.coerce(this.load(item), mSILType);
    }

    private void emitConvert(MSILType mSILType, MSILType mSILType2) {
        ch.epfl.lamp.compiler.msil.Type type;
        MSILType.REF rEF;
        if (mSILType.$tag == 1) {
            rEF = (MSILType.REF)mSILType;
            type = rEF.t;
            if (type.IsValueType() && mSILType2.isType(this.tc.OBJECT)) {
                this.code.Emit(OpCodes.Box, type);
                return;
            }
            if (type.IsEnum()) {
                this.emitConvert(this.msilType(type.getUnderlyingType()), mSILType2);
                return;
            }
        }
        if (mSILType.isSubtypeOf(mSILType2)) {
            return;
        }
        switch (mSILType2.$tag) {
            case 2: {
                this.code.Emit(OpCodes.Conv_I4);
                return;
            }
            case 4: {
                this.code.Emit(OpCodes.Conv_I1);
                return;
            }
            case 5: {
                this.code.Emit(OpCodes.Conv_I2);
                return;
            }
            case 6: {
                this.code.Emit(OpCodes.Conv_I4);
                return;
            }
            case 7: {
                this.code.Emit(OpCodes.Conv_I8);
                return;
            }
            case 9: {
                this.code.Emit(OpCodes.Conv_R4);
                return;
            }
            case 10: {
                this.code.Emit(OpCodes.Conv_R8);
                return;
            }
            case 3: {
                this.code.Emit(OpCodes.Conv_U2);
                return;
            }
            case 1: {
                rEF = (MSILType.REF)mSILType2;
                type = rEF.t;
                if (!type.IsEnum()) break;
                if (!$assertionsDisabled && !mSILType.isType(type.getUnderlyingType())) {
                    throw new AssertionError();
                }
                return;
            }
        }
        throw Debug.abort(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("emitConvert: ".concat(String.valueOf(String.valueOf(mSILType))))).concat(" => "))).concat(String.valueOf(String.valueOf(mSILType2))))).concat("; fromType.isSubtypeOf(toType) = "))).concat(String.valueOf(mSILType.isSubtypeOf(mSILType2))));
    }

    private Item genApply(Tree tree, Tree[] treeArray, MSILType mSILType) {
        boolean bl = this.lastExpr;
        this.lastExpr = false;
        Label label = this.exitLabel;
        this.exitLabel = null;
        Item item = this.genApply0(tree, treeArray, mSILType);
        this.lastExpr = bl;
        this.exitLabel = label;
        return item;
    }

    private Item genApply0(Tree tree, Tree[] treeArray, MSILType mSILType) {
        Symbol symbol = tree.symbol();
        switch (tree.$tag) {
            case 17: {
                LabelDescr labelDescr = (LabelDescr)this.sym2label.get(symbol);
                if (labelDescr != null) {
                    Object object;
                    if (!$assertionsDisabled && labelDescr.params.length != treeArray.length) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(labelDescr.params.length).concat(" != "))).concat(String.valueOf(treeArray.length)))));
                    }
                    this.lastExpr = false;
                    for (int i = 0; i < treeArray.length; ++i) {
                        this.genLoad(treeArray[i], this.msilType(treeArray[i].type));
                    }
                    for (int i = treeArray.length - 1; i >= 0; --i) {
                        object = this.gen(labelDescr.params[i], this.msilType(labelDescr.params[i]));
                        this.store((Item)object);
                    }
                    this.code.Emit(OpCodes.Br, labelDescr.label);
                    this.unreachable = true;
                    object = this.msilType(symbol.info().resultType());
                    Item item = object == MSILType.VOID ? this.items.VoidItem() : this.items.StackItem((MSILType)object);
                    return this.coerce(item, mSILType);
                }
                if (!$assertionsDisabled && !symbol.isStatic()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
                }
                Primitive primitive = this.primitives.getPrimitive(symbol);
                if (primitive.$tag == 115) {
                    if (!$assertionsDisabled && treeArray.length != 1) {
                        throw new AssertionError();
                    }
                    MSILType mSILType2 = this.msilType(treeArray[0].type);
                    Item item = this.genLoad(treeArray[0], mSILType2);
                    if (!item.type.isValueType()) {
                        MethodInfo methodInfo = (MethodInfo)this.tc.getMethod(symbol);
                        this.code.Emit(OpCodes.Call, methodInfo);
                        item = this.returnsVoid((MethodBase)methodInfo) ? this.items.VoidItem() : this.items.StackItem(this.msilType(methodInfo.ReturnType));
                        return this.coerce(item, mSILType);
                    }
                    if (symbol == this.primitives.UNBOX_UVALUE) {
                        return this.items.VoidItem();
                    }
                    return item;
                }
                MSILType mSILType3 = this.primitiveConvert(symbol);
                if (mSILType3 != null) {
                    if (!$assertionsDisabled && treeArray.length != 1) {
                        throw new AssertionError();
                    }
                    this.genLoad(treeArray[0], mSILType3);
                    return this.items.StackItem(mSILType3);
                }
                return this.check(this.invokeMethod(symbol, treeArray, mSILType, true));
            }
            case 27: {
                Primitive$.Var var;
                ch.epfl.lamp.compiler.msil.Type type;
                Object object;
                Tree.Select select = (Tree.Select)tree;
                Tree tree2 = select.qualifier;
                if (symbol == this.defs.ANY_EQEQ) {
                    return this.genEq(tree2, treeArray[0]);
                }
                if (symbol == this.defs.ANY_BANGEQ) {
                    return this.negate(this.genEq(tree2, treeArray[0]));
                }
                if (symbol == this.tc.SYM_SUBSTRING_INT_INT) {
                    if (!$assertionsDisabled && treeArray.length != 2) {
                        throw new AssertionError();
                    }
                    this.genLoad(tree2, MSILType.STRING);
                    this.genLoad(treeArray[0], MSILType.I4);
                    this.code.Emit(OpCodes.Dup);
                    this.code.Emit(OpCodes.Neg);
                    this.genLoad(treeArray[1], MSILType.I4);
                    this.code.Emit(OpCodes.Add);
                    this.code.Emit(OpCodes.Call, this.tc.SUBSTRING_INT_INT);
                    return this.coerce(this.items.StackItem(MSILType.STRING), mSILType);
                }
                if (symbol == this.tc.SYM_COMPARE_TO_IGNORE_CASE) {
                    if (!$assertionsDisabled && treeArray.length != 1) {
                        throw new AssertionError();
                    }
                    this.genLoad(tree2, MSILType.STRING);
                    this.genLoad(treeArray[0], MSILType.STRING);
                    this.code.Emit(OpCodes.Ldc_I4_1);
                    this.code.Emit(OpCodes.Call, this.tc.COMPARE_TO_IGNORE_CASE);
                    return this.coerce(this.items.StackItem(MSILType.STRING), mSILType);
                }
                if (this.isPrimitiveArrayOp(symbol)) {
                    object = this.primitives.getPrimitive(symbol);
                    this.loadArgs(treeArray, this.tc.getMethod(symbol).GetParameters());
                    type = this.getArrayElemType((Primitive)object);
                    switch (((Primitive)object).$tag) {
                        case 120: {
                            this.code.Emit(OpCodes.Ldlen);
                            return this.items.StackItem(MSILType.I4);
                        }
                        case 13: {
                            this.code.Emit(OpCodes.Ldlen);
                            return this.items.StackItem(MSILType.I4);
                        }
                        case 109: {
                            this.code.Emit(OpCodes.Ldlen);
                            return this.items.StackItem(MSILType.I4);
                        }
                        case 24: {
                            this.code.Emit(OpCodes.Ldlen);
                            return this.items.StackItem(MSILType.I4);
                        }
                        case 62: {
                            this.code.Emit(OpCodes.Ldlen);
                            return this.items.StackItem(MSILType.I4);
                        }
                        case 74: {
                            this.code.Emit(OpCodes.Ldlen);
                            return this.items.StackItem(MSILType.I4);
                        }
                        case 49: {
                            this.code.Emit(OpCodes.Ldlen);
                            return this.items.StackItem(MSILType.I4);
                        }
                        case 36: {
                            this.code.Emit(OpCodes.Ldlen);
                            return this.items.StackItem(MSILType.I4);
                        }
                        case 97: {
                            this.code.Emit(OpCodes.Ldlen);
                            return this.items.StackItem(MSILType.I4);
                        }
                        case 93: {
                            this.code.Emit(OpCodes.Newarr, type);
                            return this.items.StackItem(MSILType.ARRAY(this.msilType(type)));
                        }
                        case 85: {
                            this.code.Emit(OpCodes.Newarr, type);
                            return this.items.StackItem(MSILType.ARRAY(this.msilType(type)));
                        }
                        case 92: {
                            this.code.Emit(OpCodes.Newarr, type);
                            return this.items.StackItem(MSILType.ARRAY(this.msilType(type)));
                        }
                        case 86: {
                            this.code.Emit(OpCodes.Newarr, type);
                            return this.items.StackItem(MSILType.ARRAY(this.msilType(type)));
                        }
                        case 89: {
                            this.code.Emit(OpCodes.Newarr, type);
                            return this.items.StackItem(MSILType.ARRAY(this.msilType(type)));
                        }
                        case 90: {
                            this.code.Emit(OpCodes.Newarr, type);
                            return this.items.StackItem(MSILType.ARRAY(this.msilType(type)));
                        }
                        case 88: {
                            this.code.Emit(OpCodes.Newarr, type);
                            return this.items.StackItem(MSILType.ARRAY(this.msilType(type)));
                        }
                        case 87: {
                            this.code.Emit(OpCodes.Newarr, type);
                            return this.items.StackItem(MSILType.ARRAY(this.msilType(type)));
                        }
                        case 119: {
                            MSILType mSILType4 = this.MSILArrayElemType(type);
                            this.emitLdelem(mSILType4);
                            return this.items.StackItem(mSILType4);
                        }
                        case 12: {
                            MSILType mSILType5 = this.MSILArrayElemType(type);
                            this.emitLdelem(mSILType5);
                            return this.items.StackItem(mSILType5);
                        }
                        case 108: {
                            MSILType mSILType6 = this.MSILArrayElemType(type);
                            this.emitLdelem(mSILType6);
                            return this.items.StackItem(mSILType6);
                        }
                        case 23: {
                            MSILType mSILType7 = this.MSILArrayElemType(type);
                            this.emitLdelem(mSILType7);
                            return this.items.StackItem(mSILType7);
                        }
                        case 61: {
                            MSILType mSILType8 = this.MSILArrayElemType(type);
                            this.emitLdelem(mSILType8);
                            return this.items.StackItem(mSILType8);
                        }
                        case 73: {
                            MSILType mSILType9 = this.MSILArrayElemType(type);
                            this.emitLdelem(mSILType9);
                            return this.items.StackItem(mSILType9);
                        }
                        case 48: {
                            MSILType mSILType10 = this.MSILArrayElemType(type);
                            this.emitLdelem(mSILType10);
                            return this.items.StackItem(mSILType10);
                        }
                        case 35: {
                            MSILType mSILType11 = this.MSILArrayElemType(type);
                            this.emitLdelem(mSILType11);
                            return this.items.StackItem(mSILType11);
                        }
                        case 96: {
                            MSILType mSILType12 = this.MSILArrayElemType(type);
                            this.emitLdelem(mSILType12);
                            return this.items.StackItem(mSILType12);
                        }
                        case 121: {
                            this.emitStelem(this.MSILArrayElemType(type));
                            return this.items.VoidItem();
                        }
                        case 14: {
                            this.emitStelem(this.MSILArrayElemType(type));
                            return this.items.VoidItem();
                        }
                        case 110: {
                            this.emitStelem(this.MSILArrayElemType(type));
                            return this.items.VoidItem();
                        }
                        case 25: {
                            this.emitStelem(this.MSILArrayElemType(type));
                            return this.items.VoidItem();
                        }
                        case 63: {
                            this.emitStelem(this.MSILArrayElemType(type));
                            return this.items.VoidItem();
                        }
                        case 75: {
                            this.emitStelem(this.MSILArrayElemType(type));
                            return this.items.VoidItem();
                        }
                        case 50: {
                            this.emitStelem(this.MSILArrayElemType(type));
                            return this.items.VoidItem();
                        }
                        case 37: {
                            this.emitStelem(this.MSILArrayElemType(type));
                            return this.items.VoidItem();
                        }
                        case 98: {
                            this.emitStelem(this.MSILArrayElemType(type));
                            return this.items.VoidItem();
                        }
                    }
                }
                if (this.isPrimitiveOp(symbol)) {
                    if (!$assertionsDisabled && treeArray.length > 1) {
                        throw new AssertionError();
                    }
                    object = treeArray.length > 0 ? treeArray[0] : Tree.Empty;
                    return this.primitiveOp(this.primitives.getPrimitive(symbol), tree2, (Tree)object, mSILType);
                }
                object = symbol.owner();
                type = this.tc.getType((Symbol)object);
                if (!$assertionsDisabled && type == null) {
                    throw new AssertionError();
                }
                if (type.IsEnum()) {
                    var = null;
                    if (symbol.name == Names.EQ) {
                        var = Primitive.EQ;
                    } else if (symbol.name == Names.NE) {
                        var = Primitive.NE;
                    } else if (symbol.name == Names.LT) {
                        var = Primitive.LT;
                    } else if (symbol.name == Names.LE) {
                        var = Primitive.LE;
                    } else if (symbol.name == Names.GT) {
                        var = Primitive.GT;
                    } else if (symbol.name == Names.GE) {
                        var = Primitive.GE;
                    } else if (symbol.name == Names.OR) {
                        var = Primitive.OR;
                    } else if (symbol.name == Names.AND) {
                        var = Primitive.AND;
                    } else if (symbol.name == Names.XOR) {
                        var = Primitive.XOR;
                    }
                    if (var != null) {
                        if (!$assertionsDisabled && treeArray.length != 1) {
                            throw new AssertionError();
                        }
                        return this.primitiveOp(var, tree2, treeArray[0], mSILType);
                    }
                }
                switch (tree2.type.$tag) {
                    case 8: {
                        var = this.tc.getMethod(symbol);
                        if (!$assertionsDisabled && var == null) {
                            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
                        }
                        boolean bl = false;
                        if (!var.IsStatic() || this.becomesStatic(symbol)) {
                            if (tree2.$tag == 31) {
                                this.load(this.items.SelfItem(this.tc.getType(this.currentClass)));
                            } else {
                                this.genAddr(tree2, this.msilType(tree2));
                                bl = !this.msilType(tree2).isValueType();
                            }
                        }
                        return this.check(this.invokeMethod(symbol, treeArray, mSILType, bl || var.IsAbstract()));
                    }
                    case 6: {
                        var = this.tc.getMethod(symbol);
                        if (!$assertionsDisabled && var == null) {
                            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
                        }
                        boolean bl = false;
                        if (!var.IsStatic() || this.becomesStatic(symbol)) {
                            if (tree2.$tag == 31) {
                                this.load(this.items.SelfItem(this.tc.getType(this.currentClass)));
                            } else {
                                this.genAddr(tree2, this.msilType(tree2));
                                bl = !this.msilType(tree2).isValueType();
                            }
                        }
                        return this.check(this.invokeMethod(symbol, treeArray, mSILType, bl || var.IsAbstract()));
                    }
                    case 7: {
                        var = this.tc.getMethod(symbol);
                        if (!$assertionsDisabled && var == null) {
                            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
                        }
                        boolean bl = false;
                        if (!var.IsStatic() || this.becomesStatic(symbol)) {
                            if (tree2.$tag == 31) {
                                this.load(this.items.SelfItem(this.tc.getType(this.currentClass)));
                            } else {
                                this.genAddr(tree2, this.msilType(tree2));
                                bl = !this.msilType(tree2).isValueType();
                            }
                        }
                        return this.check(this.invokeMethod(symbol, treeArray, mSILType, bl || var.IsAbstract()));
                    }
                }
                throw Debug.abort(Debug.show(tree));
            }
            case 37: {
                Tree.TypeApply typeApply = (Tree.TypeApply)tree;
                Tree tree3 = typeApply.fun;
                Tree[] treeArray2 = typeApply.args;
                Symbol symbol2 = tree3.symbol();
                if (this.primitives.isPrimitive(symbol2)) {
                    return this.primitiveOp(this.primitives.getPrimitive(symbol2), ((Tree.Select)tree3).qualifier, treeArray2[0], mSILType);
                }
                throw Debug.abort(Debug.show(tree));
            }
        }
        throw Debug.abort(Debug.show(tree));
    }

    private Item genEq(Tree tree, Tree tree2) {
        LocalBuilder localBuilder = (LocalBuilder)this.locals.get(this.defs.ANY_EQEQ);
        if (localBuilder == null) {
            localBuilder = this.code.DeclareLocal(this.tc.OBJECT);
            this.locals.put(this.defs.ANY_EQEQ, localBuilder);
        }
        Label label = this.code.DefineLabel();
        Label label2 = this.code.DefineLabel();
        this.genLoad(tree, MSILType.OBJECT);
        this.genLoad(tree2, MSILType.OBJECT);
        this.emitStloc(localBuilder);
        this.code.Emit(OpCodes.Dup);
        this.code.Emit(OpCodes.Ldnull);
        this.code.Emit(OpCodes.Bne_Un, label);
        this.emitLdloc(localBuilder);
        this.code.Emit(OpCodes.Ceq);
        this.code.Emit(OpCodes.Br, label2);
        this.code.MarkLabel(label);
        this.emitLdloc(localBuilder);
        this.code.Emit(OpCodes.Callvirt, this.tc.OBJECT_EQUALS);
        this.code.MarkLabel(label2);
        return this.items.StackItem(MSILType.BOOL);
    }

    private boolean isPrimitiveOp(Symbol symbol) {
        Primitive primitive = this.primitives.getPrimitive(symbol);
        switch (primitive.$tag) {
            case 100: {
                return true;
            }
            case 84: {
                return true;
            }
            case 94: {
                return true;
            }
            case 0: {
                return true;
            }
            case 111: {
                return true;
            }
            case 82: {
                return true;
            }
            case 38: {
                return true;
            }
            case 81: {
                return true;
            }
            case 99: {
                return true;
            }
            case 117: {
                return true;
            }
            case 1: {
                return true;
            }
            case 78: {
                return true;
            }
            case 79: {
                return true;
            }
            case 4: {
                return true;
            }
            case 64: {
                return true;
            }
            case 39: {
                return true;
            }
            case 83: {
                return true;
            }
            case 80: {
                return true;
            }
            case 76: {
                return true;
            }
            case 52: {
                return true;
            }
            case 51: {
                return true;
            }
            case 122: {
                return true;
            }
            case 123: {
                return true;
            }
            case 118: {
                return true;
            }
            case 65: {
                return true;
            }
            case 3: {
                return true;
            }
            case 27: {
                return true;
            }
            case 113: {
                return true;
            }
            case 112: {
                return true;
            }
        }
        return false;
    }

    private boolean isPrimitiveArrayOp(Symbol symbol) {
        Primitive primitive = this.primitives.getPrimitive(symbol);
        switch (primitive.$tag) {
            case 93: {
                return true;
            }
            case 85: {
                return true;
            }
            case 92: {
                return true;
            }
            case 86: {
                return true;
            }
            case 89: {
                return true;
            }
            case 90: {
                return true;
            }
            case 88: {
                return true;
            }
            case 87: {
                return true;
            }
            case 120: {
                return true;
            }
            case 13: {
                return true;
            }
            case 109: {
                return true;
            }
            case 24: {
                return true;
            }
            case 62: {
                return true;
            }
            case 74: {
                return true;
            }
            case 49: {
                return true;
            }
            case 36: {
                return true;
            }
            case 97: {
                return true;
            }
            case 119: {
                return true;
            }
            case 12: {
                return true;
            }
            case 108: {
                return true;
            }
            case 23: {
                return true;
            }
            case 61: {
                return true;
            }
            case 73: {
                return true;
            }
            case 48: {
                return true;
            }
            case 35: {
                return true;
            }
            case 96: {
                return true;
            }
            case 121: {
                return true;
            }
            case 14: {
                return true;
            }
            case 110: {
                return true;
            }
            case 25: {
                return true;
            }
            case 63: {
                return true;
            }
            case 75: {
                return true;
            }
            case 50: {
                return true;
            }
            case 37: {
                return true;
            }
            case 98: {
                return true;
            }
        }
        return false;
    }

    private MSILType primitiveConvert(Symbol symbol) {
        Primitive primitive = this.primitives.getPrimitive(symbol);
        switch (primitive.$tag) {
            case 5: {
                return MSILType.I1;
            }
            case 101: {
                return MSILType.I1;
            }
            case 16: {
                return MSILType.I1;
            }
            case 54: {
                return MSILType.I1;
            }
            case 66: {
                return MSILType.I1;
            }
            case 41: {
                return MSILType.I1;
            }
            case 28: {
                return MSILType.I1;
            }
            case 11: {
                return MSILType.I2;
            }
            case 107: {
                return MSILType.I2;
            }
            case 22: {
                return MSILType.I2;
            }
            case 60: {
                return MSILType.I2;
            }
            case 72: {
                return MSILType.I2;
            }
            case 47: {
                return MSILType.I2;
            }
            case 34: {
                return MSILType.I2;
            }
            case 6: {
                return MSILType.CHAR;
            }
            case 102: {
                return MSILType.CHAR;
            }
            case 17: {
                return MSILType.CHAR;
            }
            case 55: {
                return MSILType.CHAR;
            }
            case 67: {
                return MSILType.CHAR;
            }
            case 42: {
                return MSILType.CHAR;
            }
            case 29: {
                return MSILType.CHAR;
            }
            case 9: {
                return MSILType.I4;
            }
            case 105: {
                return MSILType.I4;
            }
            case 20: {
                return MSILType.I4;
            }
            case 58: {
                return MSILType.I4;
            }
            case 70: {
                return MSILType.I4;
            }
            case 45: {
                return MSILType.I4;
            }
            case 32: {
                return MSILType.I4;
            }
            case 10: {
                return MSILType.I8;
            }
            case 106: {
                return MSILType.I8;
            }
            case 21: {
                return MSILType.I8;
            }
            case 59: {
                return MSILType.I8;
            }
            case 71: {
                return MSILType.I8;
            }
            case 46: {
                return MSILType.I8;
            }
            case 33: {
                return MSILType.I8;
            }
            case 8: {
                return MSILType.R4;
            }
            case 104: {
                return MSILType.R4;
            }
            case 19: {
                return MSILType.R4;
            }
            case 57: {
                return MSILType.R4;
            }
            case 69: {
                return MSILType.R4;
            }
            case 44: {
                return MSILType.R4;
            }
            case 31: {
                return MSILType.R4;
            }
            case 7: {
                return MSILType.R8;
            }
            case 103: {
                return MSILType.R8;
            }
            case 18: {
                return MSILType.R8;
            }
            case 56: {
                return MSILType.R8;
            }
            case 68: {
                return MSILType.R8;
            }
            case 43: {
                return MSILType.R8;
            }
            case 30: {
                return MSILType.R8;
            }
        }
        return null;
    }

    private Item primitiveOp(Primitive primitive, Tree tree, Tree tree2, MSILType mSILType) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        switch (primitive.$tag) {
            case 27: {
                this.genLoad(tree, MSILType.OBJECT);
                this.genLoad(tree2, MSILType.OBJECT);
                this.code.Emit(OpCodes.Call, this.tc.CONCAT_OBJECT_OBJECT);
                return this.items.StackItem(MSILType.STRING);
            }
            case 0: {
                if (this.tc.getType(tree2.type) != this.tc.STRING) break;
                this.genLoad(tree, MSILType.OBJECT);
                this.genLoad(tree2, MSILType.OBJECT);
                this.code.Emit(OpCodes.Call, this.tc.CONCAT_OBJECT_OBJECT);
                return this.items.StackItem(MSILType.STRING);
            }
            case 65: {
                this.genLoad(tree, MSILType.OBJECT);
                ch.epfl.lamp.compiler.msil.Type type = this.tc.getType(tree2.type);
                this.code.Emit(OpCodes.Isinst, type);
                return this.mkCond(this.items.StackItem(this.msilType(type)));
            }
            case 3: {
                MSILType mSILType2 = this.msilType(tree);
                Item item = this.genLoad(tree, mSILType2);
                ch.epfl.lamp.compiler.msil.Type type = this.tc.getType(tree2.type);
                MSILType mSILType3 = this.msilType(type);
                if (mSILType2.isEnum()) {
                    MSILType mSILType4 = this.unboxValueType(mSILType3);
                    if (mSILType4 != null) {
                        MSILType mSILType5 = this.msilType(mSILType2.getUnderlyingType());
                        this.emitConvert(mSILType5, mSILType4);
                        return this.items.StackItem(mSILType4);
                    }
                } else if (!item.type.equals(mSILType3) && type != this.tc.OBJECT) {
                    if (type.IsValueType()) {
                        this.code.Emit(OpCodes.Unbox, type);
                        if (type.IsEnum()) {
                            this.emitLdind(type.getUnderlyingType());
                        } else {
                            this.code.Emit(OpCodes.Ldobj, type);
                        }
                    } else {
                        this.code.Emit(OpCodes.Castclass, type);
                    }
                }
                return this.items.StackItem(mSILType3);
            }
            case 112: {
                LocalBuilder localBuilder = this.code.DeclareLocal(this.tc.OBJECT);
                this.genLoad(tree, MSILType.OBJECT);
                this.emitStloc(localBuilder);
                this.emitLdloc(localBuilder);
                this.code.Emit(OpCodes.Call, this.tc.MONITOR_ENTER);
                this.genLoad(tree2, MSILType.OBJECT);
                this.emitLdloc(localBuilder);
                this.code.Emit(OpCodes.Call, this.tc.MONITOR_EXIT);
                return this.items.StackItem(MSILType.OBJECT);
            }
        }
        Item item = null;
        MSILType mSILType6 = this.msilType(tree);
        if (tree.$tag == 4) {
            object4 = (Tree.Apply)tree;
            object3 = ((Tree.Apply)object4).fun;
            object2 = ((Tree.Apply)object4).args;
            object = this.primitives.getPrimitive(((Tree)object3).symbol());
            if (((Primitive)object).$tag == 15) {
                if (!$assertionsDisabled && ((Tree[])object2).length != 1) {
                    throw new AssertionError();
                }
                item = this.gen(object2[0], this.msilType(object2[0]));
            } else {
                item = this.gen(tree, mSILType6);
            }
        } else {
            item = this.gen(tree, mSILType6);
        }
        switch (primitive.$tag) {
            case 113: {
                this.load(item);
                this.code.Emit(OpCodes.Throw);
                return this.loadNull();
            }
            case 100: {
                return this.load(this.coerce(item, mSILType));
            }
            case 84: {
                item = this.load(this.coerce(item, mSILType));
                this.code.Emit(OpCodes.Neg);
                return item;
            }
            case 94: {
                item = this.load(this.coerce(item, mSILType));
                this.code.Emit(OpCodes.Not);
                return item;
            }
            case 122: {
                return this.negate(this.mkCond(item));
            }
            case 123: {
                object4 = this.mkCond(item);
                object3 = null;
                object2 = ((Item.CondItem)object4).success;
                object = ((Item.CondItem)object4).failure;
                switch (((Item.CondItem)object4).test.$tag) {
                    case 5: {
                        return object4;
                    }
                    case 4: {
                        return this.mkCond(this.gen(tree2, MSILType.BOOL));
                    }
                    case 0: {
                        object2 = object2 != null ? object2 : new Chain(this.code.DefineLabel(), null);
                        this.branch(this.negate(((Item.CondItem)object4).test), (Chain)object2);
                        this.resolve((Chain)object);
                        object = null;
                        break;
                    }
                    default: {
                        object2 = object2 != null ? object2 : new Chain(this.code.DefineLabel(), null);
                        this.branch(this.negate(((Item.CondItem)object4).test), (Chain)object2);
                    }
                }
                object3 = this.mkCond(this.gen(tree2, MSILType.BOOL));
                object3 = this.items.CondItem(Test.Or(((Item.CondItem)object3).test), GenMSIL.merge((Chain)object2, ((Item.CondItem)object3).success), GenMSIL.merge((Chain)object, ((Item.CondItem)object3).failure));
                return object3;
            }
            case 118: {
                object4 = this.mkCond(item);
                object3 = null;
                object2 = ((Item.CondItem)object4).success;
                object = ((Item.CondItem)object4).failure;
                switch (((Item.CondItem)object4).test.$tag) {
                    case 4: {
                        return object4;
                    }
                    case 5: {
                        return this.mkCond(this.gen(tree2, MSILType.BOOL));
                    }
                    case 3: {
                        object = object != null ? object : new Chain(this.code.DefineLabel(), null);
                        this.branch(((Item.CondItem)object4).test, (Chain)object);
                        this.resolve((Chain)object2);
                        object2 = null;
                        break;
                    }
                    default: {
                        object = object != null ? object : new Chain(this.code.DefineLabel(), null);
                        this.branch(((Item.CondItem)object4).test, (Chain)object);
                    }
                }
                object3 = this.mkCond(this.gen(tree2, MSILType.BOOL));
                object3 = this.items.CondItem(Test.And(((Item.CondItem)object3).test), GenMSIL.merge((Chain)object2, ((Item.CondItem)object3).success), GenMSIL.merge((Chain)object, ((Item.CondItem)object3).failure));
                return object3;
            }
        }
        object4 = MSILType.arithmCoercion(item.type.asPrimitive(), this.primitiveType(tree2.type));
        this.load(this.coerce(item, (MSILType)object4));
        this.genLoad(tree2, (MSILType)object4);
        object3 = null;
        switch (primitive.$tag) {
            case 0: {
                this.code.Emit(OpCodes.Add);
                object3 = this.items.StackItem((MSILType)object4);
                break;
            }
            case 111: {
                this.code.Emit(OpCodes.Sub);
                object3 = this.items.StackItem((MSILType)object4);
                break;
            }
            case 82: {
                this.code.Emit(OpCodes.Mul);
                object3 = this.items.StackItem((MSILType)object4);
                break;
            }
            case 38: {
                this.code.Emit(OpCodes.Div);
                object3 = this.items.StackItem((MSILType)object4);
                break;
            }
            case 81: {
                this.code.Emit(OpCodes.Rem);
                object3 = this.items.StackItem((MSILType)object4);
                break;
            }
            case 99: {
                this.code.Emit(OpCodes.Or);
                object3 = this.items.StackItem((MSILType)object4);
                break;
            }
            case 117: {
                this.code.Emit(OpCodes.Xor);
                object3 = this.items.StackItem((MSILType)object4);
                break;
            }
            case 1: {
                this.code.Emit(OpCodes.And);
                object3 = this.items.StackItem((MSILType)object4);
                break;
            }
            case 78: {
                this.code.Emit(OpCodes.Shl);
                object3 = this.items.StackItem((MSILType)object4);
                break;
            }
            case 79: {
                this.code.Emit(OpCodes.Shr);
                object3 = this.items.StackItem((MSILType)object4);
                break;
            }
            case 4: {
                this.code.Emit(OpCodes.Shr_Un);
                object3 = this.items.StackItem((MSILType)object4);
                break;
            }
            case 64: {
                object3 = this.items.CondItem(Test.Binary(16, (MSILType)object4), null, null);
                break;
            }
            case 39: {
                object3 = this.items.CondItem(Test.Binary(16, (MSILType)object4), null, null);
                break;
            }
            case 83: {
                object3 = this.items.CondItem(Test.Binary(17, (MSILType)object4), null, null);
                break;
            }
            case 80: {
                object3 = this.items.CondItem(Test.Binary(0, (MSILType)object4), null, null);
                break;
            }
            case 76: {
                object3 = this.items.CondItem(Test.Binary(1, (MSILType)object4), null, null);
                break;
            }
            case 52: {
                object3 = this.items.CondItem(Test.Binary(2, (MSILType)object4), null, null);
                break;
            }
            case 51: {
                object3 = this.items.CondItem(Test.Binary(3, (MSILType)object4), null, null);
                break;
            }
            default: {
                throw Debug.abort(Debug.show(primitive));
            }
        }
        return this.coerce((Item)object3, mSILType);
    }

    private void loadArgs(Tree[] treeArray, ParameterInfo[] parameterInfoArray) {
        for (int i = 0; i < treeArray.length; ++i) {
            MSILType mSILType = this.msilType(parameterInfoArray[i].ParameterType);
            this.genLoad(treeArray[i], mSILType);
        }
    }

    private boolean becomesStatic(Symbol symbol) {
        MethodBase methodBase = this.tc.getMethod(symbol);
        return !symbol.isStatic() && methodBase.IsStatic();
    }

    private Item invokeMethod(Symbol symbol, Tree[] treeArray, MSILType mSILType, boolean bl) {
        MethodBase methodBase = this.tc.getMethod(symbol);
        if (!$assertionsDisabled && methodBase == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf("Coudn't resolve method: ".concat(String.valueOf(String.valueOf(Debug.show(symbol)))))));
        }
        Item item = null;
        if (methodBase.IsStatic()) {
            ParameterInfo[] parameterInfoArray = methodBase.GetParameters();
            if (this.becomesStatic(symbol)) {
                if (!$assertionsDisabled && parameterInfoArray.length != treeArray.length + 1) {
                    throw new AssertionError();
                }
                ParameterInfo[] parameterInfoArray2 = new ParameterInfo[parameterInfoArray.length - 1];
                for (int i = 0; i < parameterInfoArray2.length; ++i) {
                    parameterInfoArray2[i] = parameterInfoArray[i + 1];
                }
                parameterInfoArray = parameterInfoArray2;
            }
            this.loadArgs(treeArray, parameterInfoArray);
            this.code.Emit(OpCodes.Call, (MethodInfo)methodBase);
            item = this.returnsVoid(methodBase) ? this.items.VoidItem() : this.items.StackItem(mSILType);
        } else if (methodBase.IsConstructor()) {
            this.loadArgs(treeArray, methodBase.GetParameters());
            this.code.Emit(OpCodes.Call, (ConstructorInfo)methodBase);
            item = this.items.VoidItem();
        } else {
            this.loadArgs(treeArray, methodBase.GetParameters());
            if (this.enableTailCalls && this.lastExpr) {
                this.code.Emit(OpCodes.Tailcall);
            }
            this.code.Emit(bl ? OpCodes.Callvirt : OpCodes.Call, (MethodInfo)methodBase);
            Item item2 = item = this.returnsVoid(methodBase) ? this.items.VoidItem() : this.items.StackItem(mSILType);
        }
        if (this.returnsVoid(symbol) && !this.returnsVoid(methodBase)) {
            item = this.drop(item);
        }
        return item;
    }

    private MSILType msilType(Type type) {
        return type.symbol() == this.defs.ALLREF_CLASS ? MSILType.NULL : this.msilType(this.tc.getType(type));
    }

    MSILType msilType(ch.epfl.lamp.compiler.msil.Type type) {
        return MSILType.fromType(type);
    }

    private MSILType msilType(Tree tree) {
        return this.msilType(tree.type);
    }

    private MSILType primitiveType(Type type) {
        MSILType mSILType = this.msilType(type);
        switch (mSILType.$tag) {
            case 1: {
                MSILType.REF rEF = (MSILType.REF)mSILType;
                ch.epfl.lamp.compiler.msil.Type type2 = rEF.t;
                MSILType mSILType2 = this.unboxValueType(mSILType);
                return mSILType2 != null ? mSILType2 : this.msilType(type2).asPrimitive();
            }
            case 0: {
                throw Debug.abort("cannot convert ".concat(String.valueOf(String.valueOf(mSILType))));
            }
        }
        return mSILType;
    }

    private MSILType unboxValueType(MSILType mSILType) {
        if (mSILType.$tag == 1) {
            MSILType.REF rEF = (MSILType.REF)mSILType;
            ch.epfl.lamp.compiler.msil.Type type = rEF.t;
            if (type == this.tc.SCALA_BYTE) {
                return MSILType.I1;
            }
            if (type == this.tc.SCALA_SHORT) {
                return MSILType.I2;
            }
            if (type == this.tc.SCALA_INT) {
                return MSILType.I4;
            }
            if (type == this.tc.SCALA_LONG) {
                return MSILType.I8;
            }
            if (type == this.tc.SCALA_FLOAT) {
                return MSILType.R4;
            }
            if (type == this.tc.SCALA_DOUBLE) {
                return MSILType.R8;
            }
            if (type == this.tc.SCALA_CHAR) {
                return MSILType.CHAR;
            }
            if (type == this.tc.SCALA_BOOLEAN) {
                return MSILType.BOOL;
            }
        }
        return mSILType;
    }

    private MSILType MSILArrayElemType(ch.epfl.lamp.compiler.msil.Type type) {
        MSILType mSILType = this.msilType(type);
        switch (mSILType.$tag) {
            case 2: {
                return MSILType.I1;
            }
            case 3: {
                return MSILType.I4;
            }
        }
        return mSILType;
    }

    private ch.epfl.lamp.compiler.msil.Type getArrayElemType(Primitive primitive) {
        switch (primitive.$tag) {
            case 93: {
                return this.tc.BOOLEAN;
            }
            case 120: {
                return this.tc.BOOLEAN;
            }
            case 119: {
                return this.tc.BOOLEAN;
            }
            case 121: {
                return this.tc.BOOLEAN;
            }
            case 85: {
                return this.tc.BYTE;
            }
            case 13: {
                return this.tc.BYTE;
            }
            case 12: {
                return this.tc.BYTE;
            }
            case 14: {
                return this.tc.BYTE;
            }
            case 92: {
                return this.tc.SHORT;
            }
            case 109: {
                return this.tc.SHORT;
            }
            case 108: {
                return this.tc.SHORT;
            }
            case 110: {
                return this.tc.SHORT;
            }
            case 86: {
                return this.tc.CHAR;
            }
            case 24: {
                return this.tc.CHAR;
            }
            case 23: {
                return this.tc.CHAR;
            }
            case 25: {
                return this.tc.CHAR;
            }
            case 89: {
                return this.tc.INT;
            }
            case 62: {
                return this.tc.INT;
            }
            case 61: {
                return this.tc.INT;
            }
            case 63: {
                return this.tc.INT;
            }
            case 90: {
                return this.tc.LONG;
            }
            case 74: {
                return this.tc.LONG;
            }
            case 73: {
                return this.tc.LONG;
            }
            case 75: {
                return this.tc.LONG;
            }
            case 88: {
                return this.tc.FLOAT;
            }
            case 49: {
                return this.tc.FLOAT;
            }
            case 48: {
                return this.tc.FLOAT;
            }
            case 50: {
                return this.tc.FLOAT;
            }
            case 87: {
                return this.tc.DOUBLE;
            }
            case 36: {
                return this.tc.DOUBLE;
            }
            case 35: {
                return this.tc.DOUBLE;
            }
            case 37: {
                return this.tc.DOUBLE;
            }
            case 91: {
                return this.tc.OBJECT;
            }
            case 97: {
                return this.tc.OBJECT;
            }
            case 96: {
                return this.tc.OBJECT;
            }
            case 98: {
                return this.tc.OBJECT;
            }
        }
        throw Debug.abort("unknown primitive ".concat(String.valueOf(String.valueOf(Debug.show(primitive)))));
    }

    private Item emitLdelem(MSILType mSILType) {
        switch (mSILType.$tag) {
            case 4: {
                this.code.Emit(OpCodes.Ldelem_I1);
                break;
            }
            case 5: {
                this.code.Emit(OpCodes.Ldelem_I2);
                break;
            }
            case 6: {
                this.code.Emit(OpCodes.Ldelem_I4);
                break;
            }
            case 7: {
                this.code.Emit(OpCodes.Ldelem_I8);
                break;
            }
            case 9: {
                this.code.Emit(OpCodes.Ldelem_R4);
                break;
            }
            case 10: {
                this.code.Emit(OpCodes.Ldelem_R8);
                break;
            }
            case 0: {
                this.code.Emit(OpCodes.Ldelem_Ref);
                break;
            }
            case 1: {
                this.code.Emit(OpCodes.Ldelem_Ref);
            }
        }
        return this.items.StackItem(mSILType);
    }

    private Item emitStelem(MSILType mSILType) {
        switch (mSILType.$tag) {
            case 4: {
                this.code.Emit(OpCodes.Stelem_I1);
                break;
            }
            case 5: {
                this.code.Emit(OpCodes.Stelem_I2);
                break;
            }
            case 6: {
                this.code.Emit(OpCodes.Stelem_I4);
                break;
            }
            case 7: {
                this.code.Emit(OpCodes.Stelem_I8);
                break;
            }
            case 9: {
                this.code.Emit(OpCodes.Stelem_R4);
                break;
            }
            case 10: {
                this.code.Emit(OpCodes.Stelem_R8);
                break;
            }
            case 0: {
                this.code.Emit(OpCodes.Stelem_Ref);
                break;
            }
            case 1: {
                this.code.Emit(OpCodes.Stelem_Ref);
            }
        }
        return this.items.StackItem(mSILType);
    }

    private Item.LiteralItem mkLiteral(MSILType mSILType, Object object) {
        Item.LiteralItem literalItem = null;
        if (object instanceof Integer) {
            literalItem = this.items.LiteralItem(AConstant.INT(((Number)object).intValue()));
        } else if (object instanceof Long) {
            literalItem = this.items.LiteralItem(AConstant.LONG(((Number)object).longValue()));
        } else if (object instanceof Float) {
            literalItem = this.items.LiteralItem(AConstant.FLOAT(((Number)object).floatValue()));
        } else if (object instanceof Double) {
            literalItem = this.items.LiteralItem(AConstant.DOUBLE(((Number)object).doubleValue()));
        } else {
            throw Debug.abort();
        }
        literalItem.type = mSILType;
        return literalItem;
    }

    private void emitLdarg(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        switch (n) {
            case 0: {
                this.code.Emit(OpCodes.Ldarg_0);
                break;
            }
            case 1: {
                this.code.Emit(OpCodes.Ldarg_1);
                break;
            }
            case 2: {
                this.code.Emit(OpCodes.Ldarg_2);
                break;
            }
            case 3: {
                this.code.Emit(OpCodes.Ldarg_3);
                break;
            }
            default: {
                this.code.Emit(n < 256 ? OpCodes.Ldarg_S : OpCodes.Ldarg, n);
            }
        }
    }

    private void emitLdarga(int n) {
        this.code.Emit(n < 256 ? OpCodes.Ldarga_S : OpCodes.Ldarga, n);
    }

    private void emitLdloc(LocalBuilder localBuilder) {
        switch (localBuilder.slot) {
            case 0: {
                this.code.Emit(OpCodes.Ldloc_0);
                break;
            }
            case 1: {
                this.code.Emit(OpCodes.Ldloc_1);
                break;
            }
            case 2: {
                this.code.Emit(OpCodes.Ldloc_2);
                break;
            }
            case 3: {
                this.code.Emit(OpCodes.Ldloc_3);
                break;
            }
            default: {
                this.code.Emit(localBuilder.slot < 256 ? OpCodes.Ldloc_S : OpCodes.Ldloc, localBuilder);
            }
        }
    }

    private void emitLdloca(LocalBuilder localBuilder) {
        this.code.Emit(localBuilder.slot < 256 ? OpCodes.Ldloca_S : OpCodes.Ldloca, localBuilder);
    }

    private void emitStloc(LocalBuilder localBuilder) {
        switch (localBuilder.slot) {
            case 0: {
                this.code.Emit(OpCodes.Stloc_0);
                break;
            }
            case 1: {
                this.code.Emit(OpCodes.Stloc_1);
                break;
            }
            case 2: {
                this.code.Emit(OpCodes.Stloc_2);
                break;
            }
            case 3: {
                this.code.Emit(OpCodes.Stloc_3);
                break;
            }
            default: {
                this.code.Emit(localBuilder.slot < 256 ? OpCodes.Stloc_S : OpCodes.Stloc, localBuilder);
            }
        }
    }

    private Item load(Item item) {
        switch (item.$tag) {
            case 8: {
                return item;
            }
            case 6: {
                return (Item.StackItem)item;
            }
            case 2: {
                Item.LiteralItem literalItem = (Item.LiteralItem)item;
                AConstant aConstant = literalItem.value;
                return this.loadLiteral(aConstant, item.type);
            }
            case 5: {
                this.emitThis();
                return this.items.StackItem(item.type);
            }
            case 0: {
                Item.ArgItem argItem = (Item.ArgItem)item;
                int n = argItem.slot;
                this.emitLdarg(n);
                return this.items.StackItem(item.type);
            }
            case 3: {
                Item.LocalItem localItem = (Item.LocalItem)item;
                LocalBuilder localBuilder = localItem.local;
                this.emitLdloc(localBuilder);
                return this.items.StackItem(item.type);
            }
            case 7: {
                Item.StaticItem staticItem = (Item.StaticItem)item;
                FieldInfo fieldInfo = staticItem.field;
                if (!$assertionsDisabled && fieldInfo.IsLiteral()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(fieldInfo.toString())));
                }
                this.code.Emit(OpCodes.Ldsfld, fieldInfo);
                return this.items.StackItem(item.type);
            }
            case 4: {
                Item.SelectItem selectItem = (Item.SelectItem)item;
                Item item2 = selectItem.qual;
                FieldInfo fieldInfo = selectItem.field;
                this.load(item2);
                this.code.Emit(OpCodes.Ldfld, fieldInfo);
                return this.items.StackItem(item.type);
            }
            case 1: {
                Item.CondItem condItem = (Item.CondItem)item;
                Test test = condItem.test;
                Chain chain = condItem.success;
                Chain chain2 = condItem.failure;
                this.load(test);
                switch (test.$tag) {
                    case 3: {
                        Label label = null;
                        label = this.code.DefineLabel();
                        if (!this.unreachable) {
                            this.code.Emit(OpCodes.Br, label);
                        }
                        if (chain2 != null) {
                            this.resolve(chain2);
                            this.load(FALSE_ITEM);
                            if (chain != null && !this.unreachable) {
                                this.code.Emit(OpCodes.Br, label);
                            }
                        }
                        if (chain != null) {
                            this.resolve(chain);
                            this.load(TRUE_ITEM);
                        }
                        this.resolve(label);
                        break;
                    }
                    case 0: {
                        Label label = null;
                        label = this.code.DefineLabel();
                        if (!this.unreachable) {
                            this.code.Emit(OpCodes.Br, label);
                        }
                        if (chain2 != null) {
                            this.resolve(chain2);
                            this.load(FALSE_ITEM);
                            if (chain != null && !this.unreachable) {
                                this.code.Emit(OpCodes.Br, label);
                            }
                        }
                        if (chain != null) {
                            this.resolve(chain);
                            this.load(TRUE_ITEM);
                        }
                        this.resolve(label);
                    }
                }
                return this.items.StackItem(MSILType.BOOL);
            }
        }
        throw Debug.abort("load item: ".concat(String.valueOf(String.valueOf(item))));
    }

    private void load(Test test) {
        switch (test.$tag) {
            case 4: {
                this.code.Emit(OpCodes.Ldc_I4_0);
                break;
            }
            case 5: {
                this.code.Emit(OpCodes.Ldc_I4_1);
                break;
            }
            case 2: {
                Test.Bool bool = (Test.Bool)test;
                boolean bl = bool.value;
                if (!bl) break;
                this.negate_load();
                break;
            }
            case 1: {
                Test.Binary binary = (Test.Binary)test;
                int n = binary.opcode;
                this.code.Emit(GenMSIL.load(n));
                if (!GenMSIL.negate_load(n)) break;
                this.negate_load();
                break;
            }
            case 0: {
                Test.And and = (Test.And)test;
                Test test2 = and.test;
                this.load(test2);
                break;
            }
            case 3: {
                Test.Or or = (Test.Or)test;
                Test test3 = or.test;
                this.load(test3);
                break;
            }
            default: {
                throw Debug.abort(test.getClass().getName());
            }
        }
    }

    private Item.StackItem loadLiteral(AConstant aConstant) {
        switch (aConstant.$tag) {
            case 10: {
                return this.loadUnit();
            }
            case 0: {
                AConstant.BOOLEAN bOOLEAN = (AConstant.BOOLEAN)aConstant;
                boolean bl = bOOLEAN.value;
                return this.loadBool(bl);
            }
            case 1: {
                AConstant.BYTE bYTE = (AConstant.BYTE)aConstant;
                byte by = bYTE.value;
                return this.loadI4(by);
            }
            case 7: {
                AConstant.SHORT sHORT = (AConstant.SHORT)aConstant;
                short s = sHORT.value;
                return this.loadI4(s);
            }
            case 2: {
                AConstant.CHAR cHAR = (AConstant.CHAR)aConstant;
                char c = cHAR.value;
                this.loadI4(c);
                return this.items.StackItem(MSILType.CHAR);
            }
            case 5: {
                AConstant.INT iNT = (AConstant.INT)aConstant;
                int n = iNT.value;
                return this.loadI4(n);
            }
            case 6: {
                AConstant.LONG lONG = (AConstant.LONG)aConstant;
                long l = lONG.value;
                return this.loadI8(l);
            }
            case 4: {
                AConstant.FLOAT fLOAT = (AConstant.FLOAT)aConstant;
                float f = fLOAT.value;
                return this.loadR4(f);
            }
            case 3: {
                AConstant.DOUBLE dOUBLE = (AConstant.DOUBLE)aConstant;
                double d = dOUBLE.value;
                return this.loadR8(d);
            }
            case 8: {
                AConstant.STRING sTRING = (AConstant.STRING)aConstant;
                String string = sTRING.value;
                return this.loadString(string);
            }
            case 9: {
                return this.loadNull();
            }
        }
        throw Debug.abort("illegal case", aConstant);
    }

    private Item loadLiteral(AConstant aConstant, MSILType mSILType) {
        switch (mSILType.$tag) {
            case 4: {
                this.loadI4(aConstant.intValue());
                return this.items.StackItem(MSILType.I4);
            }
            case 5: {
                this.loadI4(aConstant.intValue());
                return this.items.StackItem(MSILType.I4);
            }
            case 6: {
                this.loadI4(aConstant.intValue());
                return this.items.StackItem(MSILType.I4);
            }
            case 3: {
                this.loadI4(aConstant.intValue());
                return this.items.StackItem(MSILType.CHAR);
            }
            case 7: {
                this.loadI8(aConstant.longValue());
                return this.items.StackItem(mSILType);
            }
            case 9: {
                this.loadR4(aConstant.floatValue());
                return this.items.StackItem(mSILType);
            }
            case 10: {
                this.loadR8(aConstant.doubleValue());
                return this.items.StackItem(mSILType);
            }
            case 1: {
                return this.coerce(this.loadLiteral(aConstant), mSILType);
            }
        }
        return this.coerce(this.loadLiteral(aConstant), mSILType);
    }

    private Item.StackItem loadUnit() {
        this.code.Emit(OpCodes.Call, this.tc.RUNTIME_BOX_UNIT);
        return this.items.StackItem(this.msilType(this.tc.RUNTIME_BOX_UNIT.ReturnType));
    }

    private Item.StackItem loadBool(boolean bl) {
        this.code.Emit(bl ? OpCodes.Ldc_I4_1 : OpCodes.Ldc_I4_0);
        return this.items.StackItem(MSILType.BOOL);
    }

    private Item.StackItem loadI4(int n) {
        switch (n) {
            case -1: {
                this.code.Emit(OpCodes.Ldc_I4_M1);
                break;
            }
            case 0: {
                this.code.Emit(OpCodes.Ldc_I4_0);
                break;
            }
            case 1: {
                this.code.Emit(OpCodes.Ldc_I4_1);
                break;
            }
            case 2: {
                this.code.Emit(OpCodes.Ldc_I4_2);
                break;
            }
            case 3: {
                this.code.Emit(OpCodes.Ldc_I4_3);
                break;
            }
            case 4: {
                this.code.Emit(OpCodes.Ldc_I4_4);
                break;
            }
            case 5: {
                this.code.Emit(OpCodes.Ldc_I4_5);
                break;
            }
            case 6: {
                this.code.Emit(OpCodes.Ldc_I4_6);
                break;
            }
            case 7: {
                this.code.Emit(OpCodes.Ldc_I4_7);
                break;
            }
            case 8: {
                this.code.Emit(OpCodes.Ldc_I4_8);
                break;
            }
            default: {
                if (n >= -128 && n <= 127) {
                    this.code.Emit(OpCodes.Ldc_I4_S, n);
                    break;
                }
                this.code.Emit(OpCodes.Ldc_I4, n);
            }
        }
        return this.items.StackItem(MSILType.I4);
    }

    private Item.StackItem loadI8(long l) {
        this.code.Emit(OpCodes.Ldc_I8, l);
        return this.items.StackItem(MSILType.I8);
    }

    private Item.StackItem loadR4(float f) {
        this.code.Emit(OpCodes.Ldc_R4, f);
        return this.items.StackItem(MSILType.R4);
    }

    private Item.StackItem loadR8(double d) {
        this.code.Emit(OpCodes.Ldc_R8, d);
        return this.items.StackItem(MSILType.R8);
    }

    private Item.StackItem loadString(String string) {
        this.code.Emit(OpCodes.Ldstr, string);
        return this.items.StackItem(MSILType.STRING);
    }

    private Item.StackItem loadNull() {
        this.code.Emit(OpCodes.Ldnull);
        return this.items.StackItem(MSILType.NULL);
    }

    private void emitLdind(ch.epfl.lamp.compiler.msil.Type type) {
        if (type == this.tc.BYTE) {
            this.code.Emit(OpCodes.Ldind_I1);
        } else if (type == this.tc.SHORT) {
            this.code.Emit(OpCodes.Ldind_I2);
        } else if (type == this.tc.INT) {
            this.code.Emit(OpCodes.Ldind_I4);
        } else if (type == this.tc.LONG) {
            this.code.Emit(OpCodes.Ldind_I8);
        } else {
            throw Debug.abort("emitLdind failed", type);
        }
    }

    private Item store(Item item) {
        switch (item.$tag) {
            case 0: {
                Item.ArgItem argItem = (Item.ArgItem)item;
                int n = argItem.slot;
                this.code.Emit(OpCodes.Starg, n);
                break;
            }
            case 3: {
                Item.LocalItem localItem = (Item.LocalItem)item;
                LocalBuilder localBuilder = localItem.local;
                this.emitStloc(localBuilder);
                break;
            }
            case 7: {
                Item.StaticItem staticItem = (Item.StaticItem)item;
                FieldInfo fieldInfo = staticItem.field;
                if (!$assertionsDisabled && fieldInfo.IsLiteral()) {
                    throw new AssertionError();
                }
                this.code.Emit(OpCodes.Stsfld, fieldInfo);
                break;
            }
            case 4: {
                Item.SelectItem selectItem = (Item.SelectItem)item;
                Item item2 = selectItem.qual;
                FieldInfo fieldInfo = selectItem.field;
                this.load(item2);
                this.code.Emit(OpCodes.Stfld, fieldInfo);
                break;
            }
            default: {
                throw Debug.abort("Cannot store item: ".concat(String.valueOf(String.valueOf(item))));
            }
        }
        return this.items.VoidItem();
    }

    private Item drop(Item item) {
        block0 : switch (item.$tag) {
            case 8: {
                break;
            }
            case 5: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                break;
            }
            case 3: {
                break;
            }
            case 7: {
                break;
            }
            case 6: {
                this.code.Emit(OpCodes.Pop);
                break;
            }
            case 4: {
                Item.SelectItem selectItem = (Item.SelectItem)item;
                Item item2 = selectItem.qual;
                this.drop(item2);
                break;
            }
            case 1: {
                Item.CondItem condItem = (Item.CondItem)item;
                Test test = condItem.test;
                switch (test.$tag) {
                    case 4: {
                        break block0;
                    }
                    case 5: {
                        break block0;
                    }
                    case 2: {
                        this.code.Emit(OpCodes.Pop);
                        break block0;
                    }
                    case 0: {
                        this.drop(this.load(item));
                        break block0;
                    }
                    case 3: {
                        this.drop(this.load(item));
                        break block0;
                    }
                    case 1: {
                        this.code.Emit(OpCodes.Pop);
                        this.code.Emit(OpCodes.Pop);
                        break block0;
                    }
                }
                throw Debug.abort(item.getClass().getName());
            }
            default: {
                this.drop(this.load(item));
            }
        }
        return this.items.VoidItem();
    }

    private Item.CondItem mkCond(Item item) {
        if (item.$tag == 1) {
            return (Item.CondItem)item;
        }
        this.load(item);
        return this.items.CondItem(Test.Bool(false), null, null);
    }

    private Item genAddr(Tree tree, MSILType mSILType) {
        Item item = this.gen(tree, mSILType);
        if (!item.type.isValueType()) {
            return this.load(item);
        }
        switch (item.$tag) {
            case 0: {
                Item.ArgItem argItem = (Item.ArgItem)item;
                int n = argItem.slot;
                this.emitLdarga(n);
                break;
            }
            case 3: {
                Item.LocalItem localItem = (Item.LocalItem)item;
                LocalBuilder localBuilder = localItem.local;
                this.emitLdloca(localBuilder);
                break;
            }
            case 7: {
                Item.StaticItem staticItem = (Item.StaticItem)item;
                FieldInfo fieldInfo = staticItem.field;
                if (fieldInfo.IsInitOnly()) {
                    this.load(item);
                    this.genLocalAddr(fieldInfo.FieldType);
                    break;
                }
                this.code.Emit(OpCodes.Ldsflda, fieldInfo);
                break;
            }
            case 4: {
                Item.SelectItem selectItem = (Item.SelectItem)item;
                Item item2 = selectItem.qual;
                FieldInfo fieldInfo = selectItem.field;
                if (fieldInfo.IsInitOnly()) {
                    this.load(item);
                    this.genLocalAddr(fieldInfo.FieldType);
                    break;
                }
                this.load(item2);
                this.code.Emit(OpCodes.Ldflda, fieldInfo);
                break;
            }
            case 6: {
                this.genLocalAddr(item.type.toType());
                break;
            }
            default: {
                throw Debug.abort(item.toString());
            }
        }
        return this.items.StackItem(mSILType);
    }

    private void genLocalAddr(ch.epfl.lamp.compiler.msil.Type type) {
        if (!$assertionsDisabled && !type.IsValueType()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(type.toString())));
        }
        LocalBuilder localBuilder = (LocalBuilder)this.locals.get(type);
        if (localBuilder == null) {
            localBuilder = this.code.DeclareLocal(type);
            this.locals.put(type, localBuilder);
        }
        this.emitStloc(localBuilder);
        this.emitLdloca(localBuilder);
    }

    private Item.CondItem negate(Item item) {
        Item.CondItem condItem = this.mkCond(item);
        return this.items.CondItem(this.negate(condItem.test), condItem.failure, condItem.success);
    }

    private void negate_load() {
        this.code.Emit(OpCodes.Ldc_I4_1);
        this.code.Emit(OpCodes.Xor);
    }

    private Test negate(Test test) {
        switch (test.$tag) {
            case 4: {
                return Test.True;
            }
            case 5: {
                return Test.False;
            }
            case 2: {
                Test.Bool bool = (Test.Bool)test;
                boolean bl = bool.value;
                return Test.Bool(!bl);
            }
            case 0: {
                Test.And and = (Test.And)test;
                Test test2 = and.test;
                return Test.Or(this.negate(test2));
            }
            case 3: {
                Test.Or or = (Test.Or)test;
                Test test3 = or.test;
                return Test.And(this.negate(test3));
            }
            case 1: {
                Test.Binary binary = (Test.Binary)test;
                int n = binary.opcode;
                MSILType mSILType = binary.type;
                return Test.Binary(GenMSIL.negate(n), mSILType);
            }
        }
        throw Debug.abort(test.getClass().getName());
    }

    private Label branch(Test test, Chain chain) {
        if (!$assertionsDisabled && chain == null) {
            throw new AssertionError();
        }
        Label label = chain.label;
        switch (test.$tag) {
            case 4: {
                this.code.Emit(OpCodes.Br, label);
                return label;
            }
            case 5: {
                return null;
            }
            case 2: {
                Test.Bool bool = (Test.Bool)test;
                boolean bl = bool.value;
                this.code.Emit(bl ? OpCodes.Brtrue : OpCodes.Brfalse, label);
                return label;
            }
            case 0: {
                Test.And and = (Test.And)test;
                Test test2 = and.test;
                return this.branch(test2, chain);
            }
            case 3: {
                Test.Or or = (Test.Or)test;
                Test test3 = or.test;
                return this.branch(test3, chain);
            }
            case 1: {
                Test.Binary binary = (Test.Binary)test;
                int n = binary.opcode;
                this.code.Emit(GenMSIL.branch(GenMSIL.negate(n)), label);
                return label;
            }
        }
        throw Debug.abort();
    }

    private static Chain merge(Chain chain, Chain chain2) {
        if (chain == null) {
            return chain2;
        }
        if (chain2 == null) {
            return chain;
        }
        Chain chain3 = chain;
        while (chain3.next != null) {
            chain3 = chain3.next;
        }
        chain3.next = chain2;
        return chain;
    }

    private void resolve(Chain chain) {
        while (chain != null) {
            this.code.MarkLabel(chain.label);
            chain = chain.next;
        }
    }

    private void resolve(Label label) {
        if (label != null) {
            this.code.MarkLabel(label);
        }
    }

    private static boolean negate_load(int n) {
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                return true;
            }
            case 6: {
                return false;
            }
            case 7: {
                return true;
            }
            case 8: {
                return false;
            }
            case 9: {
                return true;
            }
            case 10: {
                return false;
            }
            case 11: {
                return true;
            }
            case 12: {
                return false;
            }
            case 13: {
                return true;
            }
            case 14: {
                return false;
            }
            case 15: {
                return true;
            }
            case 16: {
                return false;
            }
            case 17: {
                return true;
            }
        }
        throw Debug.abort("".concat(String.valueOf(n)));
    }

    private static OpCode load(int n) {
        switch (n) {
            case 0: {
                return OpCodes.Clt;
            }
            case 1: {
                return OpCodes.Cgt;
            }
            case 2: {
                return OpCodes.Cgt;
            }
            case 3: {
                return OpCodes.Clt;
            }
            case 4: {
                return OpCodes.Clt_Un;
            }
            case 5: {
                return OpCodes.Cgt_Un;
            }
            case 6: {
                return OpCodes.Cgt_Un;
            }
            case 7: {
                return OpCodes.Clt_Un;
            }
            case 8: {
                return OpCodes.Clt;
            }
            case 9: {
                return OpCodes.Cgt_Un;
            }
            case 10: {
                return OpCodes.Cgt;
            }
            case 11: {
                return OpCodes.Clt_Un;
            }
            case 12: {
                return OpCodes.Clt_Un;
            }
            case 13: {
                return OpCodes.Cgt;
            }
            case 14: {
                return OpCodes.Cgt_Un;
            }
            case 15: {
                return OpCodes.Clt;
            }
            case 16: {
                return OpCodes.Ceq;
            }
            case 17: {
                return OpCodes.Ceq;
            }
        }
        throw Debug.abort("".concat(String.valueOf(n)));
    }

    private static int negate(int n) {
        switch (n) {
            case 0: {
                return 3;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 7;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 15;
            }
            case 9: {
                return 14;
            }
            case 10: {
                return 13;
            }
            case 11: {
                return 12;
            }
            case 12: {
                return 11;
            }
            case 13: {
                return 10;
            }
            case 14: {
                return 9;
            }
            case 15: {
                return 8;
            }
            case 16: {
                return 17;
            }
            case 17: {
                return 16;
            }
        }
        throw Debug.abort("".concat(String.valueOf(n)));
    }

    private static OpCode branch(int n) {
        switch (n) {
            case 0: 
            case 8: {
                return OpCodes.Blt;
            }
            case 1: 
            case 9: {
                return OpCodes.Ble;
            }
            case 2: 
            case 10: {
                return OpCodes.Bgt;
            }
            case 3: 
            case 11: {
                return OpCodes.Bge;
            }
            case 4: 
            case 12: {
                return OpCodes.Blt_Un;
            }
            case 5: 
            case 13: {
                return OpCodes.Ble_Un;
            }
            case 6: 
            case 14: {
                return OpCodes.Bgt_Un;
            }
            case 7: 
            case 15: {
                return OpCodes.Bge_Un;
            }
            case 16: {
                return OpCodes.Beq;
            }
            case 17: {
                return OpCodes.Bne_Un;
            }
        }
        throw Debug.abort("".concat(String.valueOf(n)));
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.backend.msil.GenMSIL").desiredAssertionStatus();
        TRUE_ITEM = Item.CondItem(Test.True, null, null);
        FALSE_ITEM = Item.CondItem(Test.False, null, null);
    }

    private static class LabelDescr {
        final Label label;
        final Tree.Ident[] params;

        LabelDescr(Label label, Tree.Ident[] identArray) {
            this.label = label;
            this.params = identArray;
        }
    }
}

