/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scalatest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import scala.tools.scalatest.Command;
import scala.tools.scalatest.Console;
import scala.tools.scalatest.FileUtils;
import scala.tools.scalatest.Test;

public class Main {
    private static final String PRODUCT = "scalatest";
    private static final String VERSION = "1.02";
    private static final String COPYRIGHT = "(c) 2002-03 LAMP/EPFL";
    private static final String AUTHORS = "Philippe Altherr & Stephane Micheloud";
    private static String SCALA_HOME;
    private static String SCALA_BINPATH;
    private static String SCALA_TESTPATH;
    private static final String NAME_DTDFILE = "dtd";
    private static final String SUFFIX_OBJDIR = "-obj";
    private static final String SUFFIX_CHECKFILE = ".check";
    private static final String SUFFIX_DTDFILE = ".dtd";
    private static final String SUFFIX_LOGFILE = ".log";
    private static final String SUFFIX_SCALAFILE = ".scala";
    private static final String SUFFIX_XMLFILE = ".xml";
    private static final String HEADER_TESTING = "testing: ";
    private static final String HEADER_VERBOSE = "debug: ";
    private final int NONE = 0;
    private final int SOME = 1;
    private final int MANY = 2;
    private final int AUTO = 0;
    private final int RUN = 1;
    private final int INT = 2;
    private final int JVM = 3;
    private final int XML = 4;
    private final int POS = 5;
    private final int NEG = 6;
    private boolean noRun = false;
    private boolean showLog = false;
    private boolean showDiff = false;
    private boolean failed = false;
    private int verbose = 0;
    private int errors = 0;
    private boolean testAll = true;
    private int testType = 0;
    private List filesRUN = new ArrayList();
    private List filesINT = new ArrayList();
    private List filesJVM = new ArrayList();
    private List filesXML = new ArrayList();
    private List filesPOS = new ArrayList();
    private List filesNEG = new ArrayList();
    private Console console = new Console();
    private StringBuffer blanks = new StringBuffer("    ");
    private String colorOutline;
    private String colorSuccess;
    private String colorFailure;
    private String colorWarning;
    private String colorNormal;
    private String statusSuccess = "  OK  ";
    private String statusFailed = "FAILED";
    private String objDir = Main.getTempDirectory(SCALA_TESTPATH);
    private final String filesDir = "files".concat(String.valueOf(String.valueOf(FileUtils.FILE_SEP)));
    private final String runDir = String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.filesDir)).concat("run"))).concat(String.valueOf(String.valueOf(FileUtils.FILE_SEP)));
    private final String jvmDir = String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.filesDir)).concat("jvm"))).concat(String.valueOf(String.valueOf(FileUtils.FILE_SEP)));
    private final String xmlDir = String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.filesDir)).concat("xml"))).concat(String.valueOf(String.valueOf(FileUtils.FILE_SEP)));
    private final String posDir = "pos".concat(String.valueOf(String.valueOf(FileUtils.FILE_SEP)));
    private final String coursDir = "cours".concat(String.valueOf(String.valueOf(FileUtils.FILE_SEP)));
    private final String negDir = "neg".concat(String.valueOf(String.valueOf(FileUtils.FILE_SEP)));
    private String scala = Main.getExecutable("scala");
    private String scalac = Main.getExecutable("scalac");
    private String scalarun = Main.getExecutable("scalarun");
    private String dtd2scala = Main.getExecutable("dtd2scala");
    private MessageFormat scalaCmdLine;
    private MessageFormat scalacCmdLine;
    private MessageFormat scalarunCmdLine;
    private MessageFormat dtd2scalaCmdLine;
    private String flags = "";
    private int color = 2;
    private static final /* synthetic */ boolean $assertionsDisabled;

    private static String getExecutable(String string) {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(SCALA_BINPATH)).concat(String.valueOf(String.valueOf(FileUtils.FILE_SEP))))).concat(String.valueOf(String.valueOf(string)));
    }

    private static String getTempDirectory(String string) {
        String string2 = string;
        File file = FileUtils.getTempDir();
        if (file != null) {
            file = new File(file, PRODUCT);
            try {
                file.mkdir();
                string2 = String.valueOf(String.valueOf(file.getCanonicalPath())).concat(String.valueOf(String.valueOf(FileUtils.FILE_SEP)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }

    private void abort(String string) {
        this.console.println(string);
        System.exit(1);
    }

    private void printUsage() {
        this.console.println("Usage: scalatest [OPTION]...");
    }

    private void printHelp() {
        this.printUsage();
        this.console.println();
        this.console.println("--auto          use filenames to select the test to run");
        this.console.println("--run           next files test the interpreter and all backends");
        this.console.println("--int           next files test the interpreter");
        this.console.println("--jvm           next files test the jvm backend");
        this.console.println("--xml           next files test the dtd2scala tool");
        this.console.println("--pos           next files test a compilation success");
        this.console.println("--neg           next files test a compilation failure");
        this.console.println("--no-run        run no test, use results of last run");
        this.console.println("--show-log      show output of failed tests");
        this.console.println("--show-diff     show differences between actual and expected output");
        this.console.println("--failed        test only files that failed last time");
        this.console.println("--verbose=LEVEL display debug information (LEVEL=0|1|2)");
        this.console.println("--errors=<int>  specify the number of expected errors");
        this.console.println("--flags=<flags> specify flags to pass on to the executable");
        this.console.println("--color=USAGE   control the color usage (USAGE=none|some|many)");
        this.console.println("--objdir=<dir>  specify where to place generated files");
        this.console.println("--help, -?      display this help and exit");
        this.console.println("--version       output version information and exit");
    }

    private void printVersion() {
        this.console.println("scalatest 1.02, (c) 2002-03 LAMP/EPFL");
        this.console.println("Written by Philippe Altherr & Stephane Micheloud");
    }

    private void printOutline(String string) {
        this.console.print(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.colorOutline)).concat(String.valueOf(String.valueOf(string))))).concat(String.valueOf(String.valueOf(this.colorNormal))));
    }

    private void printSuccess(String string) {
        this.console.print(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.colorSuccess)).concat(String.valueOf(String.valueOf(string))))).concat(String.valueOf(String.valueOf(this.colorNormal))));
    }

    private void printFailure(String string) {
        this.console.print(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.colorFailure)).concat(String.valueOf(String.valueOf(string))))).concat(String.valueOf(String.valueOf(this.colorNormal))));
    }

    private void printStatus(String string, boolean bl) {
        int n = 70 - string.length();
        while (this.blanks.length() < n) {
            this.blanks.append(" ");
        }
        if (n > 0) {
            this.console.print(this.blanks.substring(this.blanks.length() - n));
        }
        this.console.println(bl ? this.statusSuccess : this.statusFailed);
    }

    private void printLog(File file) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                this.console.println(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getDiff(File file, String string) {
        String string2 = "";
        File file2 = new File(SCALA_TESTPATH, String.valueOf(String.valueOf(string)).concat(SUFFIX_CHECKFILE));
        if (file2.isFile()) {
            string2 = FileUtils.compareFiles(file, file2);
        }
        return string2;
    }

    private String makeCmdLine(MessageFormat messageFormat, Object[] objectArray) {
        String string = messageFormat.format(objectArray);
        if (this.verbose > 0) {
            this.console.println(HEADER_VERBOSE.concat(String.valueOf(String.valueOf(string))));
        }
        return string;
    }

    private void testAll() {
        this.console.println("Test configuration");
        this.console.println("scalac   executable: ".concat(String.valueOf(String.valueOf(this.scalac))));
        this.console.println("scala    executable: ".concat(String.valueOf(String.valueOf(this.scala))));
        this.console.println("scalarun executable: ".concat(String.valueOf(String.valueOf(this.scalarun))));
        Test.setConsole(this.console);
        int n = 0;
        n += new InterpretationTest(new List[]{this.filesRUN, this.filesINT}).run();
        n += new CompilationTest(new List[]{this.filesRUN, this.filesJVM}).run();
        n += new XMLTest(this.filesXML).run();
        n += new SuccessTest(this.filesPOS).run();
        this.console.println();
        if ((n += new FailureTest(this.filesNEG).run()) == 0) {
            this.printSuccess("All tests were successful");
        } else if (n == 1) {
            this.printFailure("There was 1 test that failed");
        } else {
            this.printFailure(String.valueOf(String.valueOf("There were ".concat(String.valueOf(n)))).concat(" tests that failed"));
        }
        this.console.println();
    }

    private void addFile(String string) {
        this.testAll = false;
        if (!new File(string).isFile()) {
            this.abort(String.valueOf(String.valueOf("File \"".concat(String.valueOf(String.valueOf(string))))).concat("\" doesn't exist"));
        }
        switch (this.testType) {
            case 0: {
                break;
            }
            case 1: {
                this.filesRUN.add(string);
                break;
            }
            case 2: {
                this.filesINT.add(string);
                break;
            }
            case 3: {
                this.filesJVM.add(string);
                break;
            }
            case 4: {
                this.filesXML.add(string);
                break;
            }
            case 5: {
                this.filesPOS.add(string);
                break;
            }
            case 6: {
                this.filesNEG.add(string);
                break;
            }
            default: {
                this.abort("unknown test type ".concat(String.valueOf(this.testType)));
            }
        }
    }

    private void addFiles(List list, String string) {
        File file = new File(SCALA_TESTPATH, string);
        if (file.isDirectory()) {
            String[] stringArray = file.list(new 0());
            for (int i = 0; i < stringArray.length; ++i) {
                list.add(String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(stringArray[i]))));
            }
        }
    }

    private void addFiles(List list, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addFiles(list, stringArray[i]);
        }
    }

    private String getOptionValue(String string, String string2) {
        int n = string.indexOf(61);
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        if (string4.length() == 0) {
            this.abort("illegal empty value for option --".concat(String.valueOf(String.valueOf(string3))));
        } else if (string2 != null && !string4.matches(string2)) {
            this.abort(String.valueOf(String.valueOf(String.valueOf(String.valueOf("unknown value for option --".concat(String.valueOf(String.valueOf(string3))))).concat(": "))).concat(String.valueOf(String.valueOf(string4))));
        }
        return string4;
    }

    private int getColorOption(String string, String string2) {
        String string3 = this.getOptionValue(string, string2);
        return "nsm".indexOf(string3.charAt(0));
    }

    private String getPathOption(String string, String string2) {
        String string3 = this.getOptionValue(string, string2);
        File file = new File(string3);
        if (!file.isDirectory()) {
            this.abort(String.valueOf(String.valueOf("Could not access directory '".concat(String.valueOf(String.valueOf(string3))))).concat("'"));
        }
        return string3;
    }

    private void initializeColors() {
        switch (this.color) {
            case 2: {
                this.colorOutline = "\u001b[39m";
                this.colorSuccess = "\u001b[32m";
                this.colorFailure = "\u001b[31m";
                this.colorWarning = "\u001b[33m";
                this.colorNormal = "\u001b[0m";
                break;
            }
            case 1: {
                this.colorOutline = "\u001b[1m";
                this.colorSuccess = "\u001b[0m";
                this.colorFailure = "\u001b[1m";
                this.colorWarning = "\u001b[1m";
                this.colorNormal = "\u001b[0m";
                break;
            }
            default: {
                this.colorOutline = "";
                this.colorSuccess = "";
                this.colorFailure = "";
                this.colorWarning = "";
                this.colorNormal = "";
            }
        }
        this.statusSuccess = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[".concat(String.valueOf(String.valueOf(this.colorSuccess))))).concat(String.valueOf(String.valueOf(this.statusSuccess))))).concat(String.valueOf(String.valueOf(this.colorNormal))))).concat("]");
        this.statusFailed = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[".concat(String.valueOf(String.valueOf(this.colorFailure))))).concat(String.valueOf(String.valueOf(this.statusFailed))))).concat(String.valueOf(String.valueOf(this.colorNormal))))).concat("]");
    }

    public Main(String[] stringArray) {
        this.console.setOut(System.out);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = null;
            String string2 = null;
            if (stringArray[i].matches("--[a-z]+(-[a-z]*)?(=.*)?")) {
                string = stringArray[i].substring(2);
            } else if (stringArray[i].equals("-?")) {
                string = "help";
            } else if (!stringArray[i].startsWith("-")) {
                string2 = stringArray[i];
            } else {
                this.abort("illegal argument ".concat(String.valueOf(String.valueOf(stringArray[i]))));
            }
            if (string == null) {
                this.addFile(string2);
                continue;
            }
            if (string.equals("auto")) {
                this.testType = 0;
                continue;
            }
            if (string.equals("run")) {
                this.testType = 1;
                continue;
            }
            if (string.equals("int")) {
                this.testType = 2;
                continue;
            }
            if (string.equals("jvm")) {
                this.testType = 3;
                continue;
            }
            if (string.equals("xml")) {
                this.testType = 4;
                continue;
            }
            if (string.equals("pos")) {
                this.testType = 5;
                continue;
            }
            if (string.equals("neg")) {
                this.testType = 6;
                continue;
            }
            if (string.equals("no-run")) {
                this.noRun = true;
                continue;
            }
            if (string.equals("show-log")) {
                this.showLog = true;
                continue;
            }
            if (string.equals("show-diff")) {
                this.showDiff = true;
                continue;
            }
            if (string.equals("failed")) {
                this.failed = true;
                continue;
            }
            if (string.startsWith("verbose=")) {
                this.verbose = Integer.parseInt(this.getOptionValue(string, "(0|1|2)"));
                continue;
            }
            if (string.startsWith("errors=")) {
                this.errors = Integer.parseInt(this.getOptionValue(string, "[0-9]*"));
                continue;
            }
            if (string.startsWith("flags=")) {
                this.flags = this.getOptionValue(string, null);
                continue;
            }
            if (string.startsWith("color=")) {
                this.color = this.getColorOption(string, "(none|some|many)");
                continue;
            }
            if (string.startsWith("objdir=")) {
                this.objDir = this.getPathOption(string, null);
                continue;
            }
            if (string.equals("help")) {
                this.printHelp();
                System.exit(0);
                continue;
            }
            if (string.equals("version")) {
                this.printVersion();
                System.exit(0);
                continue;
            }
            this.abort("unknown option ".concat(String.valueOf(String.valueOf(string))));
        }
        this.initializeColors();
        this.scalacCmdLine = new MessageFormat(String.valueOf(String.valueOf(this.scalac)).concat(" -Xshortname -d {0} {1} {2} {3}"));
        this.scalarunCmdLine = new MessageFormat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.scalarun)).concat(" {0} "))).concat(String.valueOf(String.valueOf(SCALA_TESTPATH))))).concat(String.valueOf(String.valueOf(FileUtils.FILE_SEP))))).concat("{1} -- Test"));
        this.dtd2scalaCmdLine = new MessageFormat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.dtd2scala)).concat(" -d {0} {1} "))).concat(NAME_DTDFILE));
        this.scalaCmdLine = new MessageFormat(String.valueOf(String.valueOf(this.scala)).concat(" -classpath {0} Test {1}"));
        if (this.testAll) {
            if (this.testType == 1) {
                this.addFiles(this.filesRUN, this.runDir);
            }
            if (this.testType == 0 || this.testType == 2) {
                this.addFiles(this.filesINT, this.runDir);
            }
            if (this.testType == 0 || this.testType == 3) {
                this.addFiles(this.filesJVM, new String[]{this.runDir, this.jvmDir});
            }
            if (this.testType == 0 || this.testType == 4) {
                this.addFiles(this.filesXML, this.xmlDir);
            }
            if (this.testType == 0 || this.testType == 5) {
                this.addFiles(this.filesPOS, new String[]{this.posDir, this.coursDir});
            }
            if (this.testType == 0 || this.testType == 6) {
                this.addFiles(this.filesNEG, this.negDir);
            }
        }
    }

    public static void main(String[] stringArray) {
        new Main(stringArray).testAll();
    }

    final /* synthetic */ String access$19(MessageFormat messageFormat, Object[] objectArray) {
        return this.makeCmdLine(messageFormat, objectArray);
    }

    final /* synthetic */ String access$14(File file, String string) {
        return this.getDiff(file, string);
    }

    final /* synthetic */ void access$17(File file) {
        this.printLog(file);
    }

    final /* synthetic */ void access$15(String string, boolean bl) {
        this.printStatus(string, bl);
    }

    final /* synthetic */ void access$13(String string) {
        this.printOutline(string);
    }

    final /* synthetic */ String access$21() {
        return this.flags;
    }

    final /* synthetic */ MessageFormat access$28() {
        return this.dtd2scalaCmdLine;
    }

    final /* synthetic */ MessageFormat access$20() {
        return this.scalarunCmdLine;
    }

    final /* synthetic */ MessageFormat access$22() {
        return this.scalacCmdLine;
    }

    final /* synthetic */ MessageFormat access$24() {
        return this.scalaCmdLine;
    }

    final /* synthetic */ String access$8() {
        return this.objDir;
    }

    final /* synthetic */ Console access$6() {
        return this.console;
    }

    final /* synthetic */ boolean access$3() {
        return this.testAll;
    }

    final /* synthetic */ int access$5() {
        return this.verbose;
    }

    final /* synthetic */ boolean access$18() {
        return this.showDiff;
    }

    final /* synthetic */ boolean access$16() {
        return this.showLog;
    }

    static {
        $assertionsDisabled = !Class.forName("scala.tools.scalatest.Main").desiredAssertionStatus();
        SCALA_HOME = System.getProperty("scala.home");
        SCALA_BINPATH = String.valueOf(String.valueOf(SCALA_HOME)).concat("/bin");
        SCALA_TESTPATH = String.valueOf(String.valueOf(SCALA_HOME)).concat("/test");
    }

    class 0
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string.endsWith(SUFFIX_SCALAFILE);
        }

        0() {
        }
    }

    private class FailureTest
    extends Test {
        FailureTest(List list) {
            super("Testing compiler (on files whose compilation should fail)", new List[]{list});
        }

        public int run() {
            return this.filesCount - this.run(new FailureCommand(Test.console));
        }
    }

    private class SuccessTest
    extends Test {
        SuccessTest(List list) {
            super("Testing compiler (on files whose compilation should succeed)", new List[]{list});
        }

        public int run() {
            return this.filesCount - this.run(new SuccessCommand(Test.console));
        }
    }

    private class XMLTest
    extends Test {
        XMLTest(List list) {
            super("Testing dtd2scala", new List[]{list});
        }

        public int run() {
            return this.filesCount - this.run(new XMLCommand(Test.console));
        }
    }

    private class CompilationTest
    extends Test {
        CompilationTest(List[] listArray) {
            super("Testing jvm backend", listArray);
        }

        public int run() {
            return this.filesCount - this.run(new CompilationCommand(Test.console));
        }
    }

    private class InterpretationTest
    extends Test {
        InterpretationTest(List[] listArray) {
            super("Testing interpreter", listArray);
        }

        public int run() {
            return this.filesCount - this.run(new InterpretationCommand(Test.console));
        }
    }

    private class FailureCommand
    extends TestCommand {
        FailureCommand(Console console) {
            super(console);
        }

        public boolean run(String string) {
            this.pre(string, true);
            String string2 = String.valueOf(String.valueOf(String.valueOf(String.valueOf(Main.this.access$8())).concat(String.valueOf(String.valueOf(this.name))))).concat(String.valueOf(String.valueOf(SUFFIX_OBJDIR)));
            String string3 = Main.this.access$19(Main.this.access$22(), new Object[]{string2, Main.this.access$21(), "", String.valueOf(String.valueOf(this.name)).concat(String.valueOf(String.valueOf(SUFFIX_SCALAFILE)))});
            this.printMessage();
            try {
                this.success = this.execute(string3, new FileOutputStream(this.logFile)) >= 0;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            this.post();
            return this.success;
        }
    }

    private class SuccessCommand
    extends TestCommand {
        SuccessCommand(Console console) {
            super(console);
        }

        public boolean run(String string) {
            this.pre(string, true);
            String string2 = String.valueOf(String.valueOf(String.valueOf(String.valueOf(Main.this.access$8())).concat(String.valueOf(String.valueOf(this.name))))).concat(String.valueOf(String.valueOf(SUFFIX_OBJDIR)));
            String string3 = Main.this.access$19(Main.this.access$22(), new Object[]{string2, Main.this.access$21(), "", String.valueOf(String.valueOf(this.name)).concat(String.valueOf(String.valueOf(SUFFIX_SCALAFILE)))});
            this.printMessage();
            try {
                this.success = this.execute(string3, new FileOutputStream(this.logFile)) >= 0;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            this.post();
            return this.success;
        }
    }

    private class XMLCommand
    extends TestCommand {
        XMLCommand(Console console) {
            super(console);
        }

        public boolean run(String string) {
            this.pre(string, true);
            String string2 = String.valueOf(String.valueOf(String.valueOf(String.valueOf(Main.this.access$8())).concat(String.valueOf(String.valueOf(this.name))))).concat(String.valueOf(String.valueOf(SUFFIX_OBJDIR)));
            String string3 = String.valueOf(String.valueOf(this.name)).concat(String.valueOf(String.valueOf(SUFFIX_DTDFILE)));
            String string4 = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(FileUtils.FILE_SEP))))).concat(String.valueOf(String.valueOf(NAME_DTDFILE))))).concat(String.valueOf(String.valueOf(SUFFIX_SCALAFILE)));
            String string5 = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(SCALA_TESTPATH)).concat(String.valueOf(String.valueOf(FileUtils.FILE_SEP))))).concat(String.valueOf(String.valueOf(this.name))))).concat(String.valueOf(String.valueOf(SUFFIX_XMLFILE)));
            String string6 = Main.this.access$19(Main.this.access$28(), new Object[]{string2, string3});
            String string7 = Main.this.access$19(Main.this.access$22(), new Object[]{string2, Main.this.access$21(), string4, String.valueOf(String.valueOf(this.name)).concat(String.valueOf(String.valueOf(SUFFIX_SCALAFILE)))});
            String string8 = Main.this.access$19(Main.this.access$24(), new Object[]{string2, string5});
            this.printMessage();
            try {
                this.success = this.execute(string6) >= 0 && this.execute(string7) >= 0 && this.execute(string8, new FileOutputStream(this.logFile)) >= 0;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            this.post();
            return this.success;
        }
    }

    private class CompilationCommand
    extends TestCommand {
        CompilationCommand(Console console) {
            super(console);
        }

        public boolean run(String string) {
            this.pre(string, true);
            String string2 = String.valueOf(String.valueOf(String.valueOf(String.valueOf(Main.this.access$8())).concat(String.valueOf(String.valueOf(this.name))))).concat(String.valueOf(String.valueOf(SUFFIX_OBJDIR)));
            String string3 = Main.this.access$19(Main.this.access$22(), new Object[]{string2, Main.this.access$21(), "", String.valueOf(String.valueOf(this.name)).concat(String.valueOf(String.valueOf(SUFFIX_SCALAFILE)))});
            String string4 = Main.this.access$19(Main.this.access$24(), new Object[]{string2, ""});
            this.printMessage();
            try {
                this.success = this.execute(string3) >= 0 && this.execute(string4, new FileOutputStream(this.logFile)) >= 0;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            this.post();
            return this.success;
        }
    }

    private class InterpretationCommand
    extends TestCommand {
        InterpretationCommand(Console console) {
            super(console);
        }

        public boolean run(String string) {
            this.pre(string, false);
            String string2 = Main.this.access$19(Main.this.access$20(), new Object[]{Main.this.access$21(), string});
            this.printMessage();
            try {
                this.success = this.execute(string2, new FileOutputStream(this.logFile)) >= 0;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            this.post();
            return this.success;
        }
    }

    private abstract class TestCommand
    extends Command {
        private String message;
        protected boolean success;
        protected String name;
        protected File logFile;
        protected File outDir;
        private static final /* synthetic */ boolean $assertionsDisabled;

        TestCommand(Console console) {
            super(console);
        }

        protected void pre(String string, boolean bl) {
            int n = string.lastIndexOf(46);
            String string2 = this.name = n < 0 ? string : string.substring(0, n);
            if (Main.this.access$3()) {
                this.name = String.valueOf(String.valueOf(String.valueOf(String.valueOf(SCALA_TESTPATH)).concat(String.valueOf(String.valueOf(FileUtils.FILE_SEP))))).concat(String.valueOf(String.valueOf(this.name)));
            }
            if (Main.this.access$5() > 1) {
                Main.this.access$6().println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(HEADER_VERBOSE)).concat("diff "))).concat(String.valueOf(String.valueOf(Main.this.access$8()))))).concat(String.valueOf(String.valueOf(this.name))))).concat(String.valueOf(String.valueOf(SUFFIX_LOGFILE))))).concat(" "))).concat(String.valueOf(String.valueOf(this.name))))).concat(String.valueOf(String.valueOf(SUFFIX_CHECKFILE))));
            }
            this.message = String.valueOf(String.valueOf(HEADER_TESTING)).concat(String.valueOf(String.valueOf(string)));
            this.outDir = new File(Main.this.access$8(), String.valueOf(String.valueOf(this.name)).concat(String.valueOf(String.valueOf(SUFFIX_OBJDIR))));
            FileUtils.createDir(this.outDir);
            this.logFile = new File(Main.this.access$8(), String.valueOf(String.valueOf(this.name)).concat(String.valueOf(String.valueOf(SUFFIX_LOGFILE))));
            this.success = false;
        }

        protected void printMessage() {
            if (!$assertionsDisabled && this.message == null) {
                throw new AssertionError();
            }
            Main.this.access$13(this.message);
        }

        protected void post() {
            if (!$assertionsDisabled && this.message == null) {
                throw new AssertionError();
            }
            String string = "";
            if (this.success) {
                string = Main.this.access$14(this.logFile, this.name);
                this.success = string.length() == 0;
            }
            Main.this.access$15(this.message, this.success);
            if (!this.success) {
                if (Main.this.access$16()) {
                    Main.this.access$17(this.logFile);
                }
                if (Main.this.access$18()) {
                    Main.this.access$6().println(string);
                }
            }
            if (this.outDir != null) {
                FileUtils.deleteDir(this.outDir);
            }
        }

        static {
            $assertionsDisabled = !Class.forName("scala.tools.scalatest.Main").desiredAssertionStatus();
        }
    }
}

