/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import [Ljava.lang.String;;
import ch.epfl.lamp.compiler.msil.ConstructorInfo;
import ch.epfl.lamp.compiler.msil.PEFile;
import ch.epfl.lamp.compiler.msil.ParameterInfo;
import ch.epfl.lamp.compiler.msil.Type;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class Attribute {
    private final ConstructorInfo constr;
    private final byte[] value;
    private static final Map type2id;
    private static final Map id2type;
    private Object[] constrArgs;
    private Map namedArgs;
    private ByteBuffer buf;
    static final /* synthetic */ boolean $assertionsDisabled;

    Attribute(ConstructorInfo constructorInfo, byte[] byArray) {
        if (!$assertionsDisabled && constructorInfo == null) {
            throw new AssertionError();
        }
        this.constr = constructorInfo;
        if (!$assertionsDisabled && byArray == null) {
            throw new AssertionError((Object)constructorInfo.toString());
        }
        this.value = byArray;
    }

    public Type GetType() {
        return this.constr.DeclaringType;
    }

    public ConstructorInfo getConstructor() {
        return this.constr;
    }

    public byte[] getValue() {
        byte[] byArray = new byte[this.value.length];
        System.arraycopy(this.value, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public Object[] getConstructorArguments() {
        this.parseBlob();
        Object[] objectArray = new Object[this.constrArgs.length];
        System.arraycopy(this.constrArgs, 0, objectArray, 0, objectArray.length);
        return objectArray;
    }

    public NamedArgument getNamedArgument(String string) {
        return (NamedArgument)this.namedArgs.get(string);
    }

    public NamedArgument[] getNamedArguments() {
        NamedArgument[] namedArgumentArray = this.namedArgs.values().toArray(NamedArgument.EMPTY);
        return namedArgumentArray;
    }

    public String toString() {
        this.parseBlob();
        ParameterInfo[] parameterInfoArray = this.constr.GetParameters();
        if (!$assertionsDisabled && parameterInfoArray.length != this.constrArgs.length) {
            throw new AssertionError(this.constr);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        stringBuffer.append(this.constr.DeclaringType.Name);
        stringBuffer.append('(');
        for (int i = 0; i < this.constrArgs.length; ++i) {
            Type type;
            if (i > 0) {
                stringBuffer.append(", ");
            }
            if ((type = parameterInfoArray[i].ParameterType).IsEnum()) {
                stringBuffer.append('(');
                stringBuffer.append(type.FullName);
                stringBuffer.append(')');
            }
            Attribute.formatValue(stringBuffer, this.constrArgs[i]);
        }
        NamedArgument[] namedArgumentArray = this.getNamedArguments();
        for (int i = 0; i < namedArgumentArray.length; ++i) {
            stringBuffer.append(", ").append(namedArgumentArray[i]);
        }
        stringBuffer.append(")]");
        return stringBuffer.toString();
    }

    private static void map(String string, int n) {
        Type type = Type.GetType("System." + string);
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError((Object)(string + " -> " + n));
        }
        Integer n2 = new Integer(n);
        type2id.put(type, n2);
        id2type.put(n2, type);
    }

    private static int getTypeId(Type type) {
        Integer n = (Integer)type2id.get(type);
        if (!$assertionsDisabled && n == null) {
            throw new AssertionError(type);
        }
        return n;
    }

    private void parseBlob() {
        try {
            this.parseBlob0();
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException(PEFile.bytes2hex(this.value), runtimeException);
        }
    }

    private void parseBlob0() {
        int n;
        if (this.buf != null) {
            return;
        }
        this.buf = ByteBuffer.wrap(this.value);
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
        short s = this.buf.getShort();
        if (!$assertionsDisabled && s != 1) {
            throw new AssertionError((Object)PEFile.bytes2hex(this.value));
        }
        ParameterInfo[] parameterInfoArray = this.constr.GetParameters();
        this.constrArgs = new Object[parameterInfoArray.length];
        for (n = 0; n < parameterInfoArray.length; ++n) {
            this.constrArgs[n] = this.parseElement(parameterInfoArray[n].ParameterType);
        }
        n = this.buf.getShort();
        this.namedArgs = new LinkedHashMap();
        for (int i = 0; i < n; ++i) {
            byte by = this.buf.get();
            if (!$assertionsDisabled && by != 83 && by != 84) {
                throw new AssertionError((Object)("0x" + PEFile.byte2hex(by)));
            }
            Type type = this.parseType();
            String string = this.parseString();
            Object object = this.parseElement(type);
            NamedArgument namedArgument = new NamedArgument(by, string, type, object);
            this.namedArgs.put(string, namedArgument);
        }
    }

    private Object parseElement(Type type) {
        if (type.IsArray()) {
            return this.parseArray(type.GetElementType());
        }
        if (type.IsEnum()) {
            return this.parseElement(type.getUnderlyingType());
        }
        return this.parseElement(Attribute.getTypeId(type));
    }

    private Object parseElement(int n) {
        switch (n) {
            case 2: {
                return new Boolean(this.buf.get() != 0);
            }
            case 3: {
                return new Character(this.buf.getChar());
            }
            case 4: 
            case 5: {
                return new Byte(this.buf.get());
            }
            case 6: 
            case 7: {
                return new Short(this.buf.getShort());
            }
            case 8: 
            case 9: {
                return new Integer(this.buf.getInt());
            }
            case 10: 
            case 11: {
                return new Long(this.buf.getLong());
            }
            case 12: {
                return new Float(this.buf.getFloat());
            }
            case 13: {
                return new Double(this.buf.getDouble());
            }
            case 14: {
                return this.parseString();
            }
            case 80: {
                return Type.GetType(this.parseString());
            }
        }
        throw new RuntimeException("Unknown type id: " + n);
    }

    private Object parseArray(Type type) {
        if (type.IsEnum()) {
            return this.parseArray(type.getUnderlyingType());
        }
        return this.parseArray(Attribute.getTypeId(type));
    }

    private Object parseArray(int n) {
        switch (n) {
            case 2: {
                return this.parseBooleanArray();
            }
            case 3: {
                return this.parseCharArray();
            }
            case 4: 
            case 5: {
                return this.parseByteArray();
            }
            case 6: 
            case 7: {
                return this.parseShortArray();
            }
            case 8: 
            case 9: {
                return this.parseIntArray();
            }
            case 10: 
            case 11: {
                return this.parseLongArray();
            }
            case 12: {
                return this.parseFloatArray();
            }
            case 13: {
                return this.parseDoubleArray();
            }
            case 14: {
                return this.parseStringArray();
            }
            case 85: {
                Type type = this.parseEnumType();
                return this.parseArray(type.getUnderlyingType());
            }
        }
        throw new RuntimeException("Unknown type id: " + n);
    }

    private Type parseEnumType() {
        String string = this.parseString();
        Type type = Type.GetType(string);
        if (!($assertionsDisabled || type != null && type.IsEnum())) {
            throw new AssertionError((Object)string);
        }
        return type;
    }

    private Type parseType() {
        byte by = this.buf.get();
        switch (by) {
            case 29: {
                return Type.mkArray(this.parseType(), 1);
            }
            case 85: {
                String string = this.parseString();
                Type type = Type.GetType(string);
                if (!($assertionsDisabled || type != null && type.IsEnum())) {
                    throw new AssertionError((Object)string);
                }
                return type;
            }
        }
        Type type = (Type)id2type.get(new Integer(by));
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError((Object)PEFile.byte2hex(by));
        }
        return type;
    }

    private boolean[] parseBooleanArray() {
        boolean[] blArray = new boolean[this.buf.getInt()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.buf.get() != 0;
        }
        return blArray;
    }

    private char[] parseCharArray() {
        char[] cArray = new char[this.buf.getInt()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = this.buf.getChar();
        }
        return cArray;
    }

    private byte[] parseByteArray() {
        byte[] byArray = new byte[this.buf.getInt()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.buf.get();
        }
        return byArray;
    }

    private short[] parseShortArray() {
        short[] sArray = new short[this.buf.getInt()];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = this.buf.getShort();
        }
        return sArray;
    }

    private int[] parseIntArray() {
        int[] nArray = new int[this.buf.getInt()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.buf.getInt();
        }
        return nArray;
    }

    private long[] parseLongArray() {
        long[] lArray = new long[this.buf.getInt()];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = this.buf.getLong();
        }
        return lArray;
    }

    private float[] parseFloatArray() {
        float[] fArray = new float[this.buf.getInt()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.buf.getFloat();
        }
        return fArray;
    }

    private double[] parseDoubleArray() {
        double[] dArray = new double[this.buf.getInt()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.buf.getDouble();
        }
        return dArray;
    }

    private String[] parseStringArray() {
        String[] stringArray = new String[this.buf.getInt()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.parseString();
        }
        return stringArray;
    }

    private String parseString() {
        String string = null;
        int n = this.parseLength();
        try {
            string = new String(this.value, this.buf.position(), n, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error(unsupportedEncodingException);
        }
        this.buf.position(this.buf.position() + n);
        return string;
    }

    private int getByte() {
        return this.buf.get() + 256 & 0xFF;
    }

    public int parseLength() {
        int n = this.getByte();
        if ((n & 0x80) != 0 && ((n = (n & 0x7F) << 8 | this.getByte()) & 0x4000) != 0) {
            n = (n & 0x3FFF) << 16 | this.getByte() << 8 | this.getByte();
        }
        return n;
    }

    private static void formatValue(StringBuffer stringBuffer, Object object) {
        Class<?> clazz = object.getClass();
        if (clazz == String.class) {
            stringBuffer.append('\"');
            stringBuffer.append(object);
            stringBuffer.append('\"');
        } else if (clazz == Character.class) {
            stringBuffer.append('\'');
            stringBuffer.append(object);
            stringBuffer.append('\'');
        } else if (clazz == [Z.class) {
            stringBuffer.append("new boolean[] {");
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < blArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(blArray[i]);
            }
            stringBuffer.append('}');
        } else if (clazz == [C.class) {
            stringBuffer.append("new short[] {");
            short[] sArray = (short[])object;
            for (int i = 0; i < sArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(sArray[i]);
            }
            stringBuffer.append('}');
        } else if (clazz == [B.class) {
            stringBuffer.append("new byte[] {");
            byte[] byArray = (byte[])object;
            for (int i = 0; i < byArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(byArray[i]);
            }
            stringBuffer.append('}');
        } else if (clazz == [S.class) {
            stringBuffer.append("new short[] {");
            short[] sArray = (short[])object;
            for (int i = 0; i < sArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(sArray[i]);
            }
            stringBuffer.append('}');
        } else if (clazz == [I.class) {
            stringBuffer.append("new int[] {");
            int[] nArray = (int[])object;
            for (int i = 0; i < nArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(nArray[i]);
            }
            stringBuffer.append('}');
        } else if (clazz == [J.class) {
            stringBuffer.append("new long[] {");
            long[] lArray = (long[])object;
            for (int i = 0; i < lArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(lArray[i]);
            }
            stringBuffer.append('}');
        } else if (clazz == [F.class) {
            stringBuffer.append("new float[] {");
            float[] fArray = (float[])object;
            for (int i = 0; i < fArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(fArray[i]);
            }
            stringBuffer.append('}');
        } else if (clazz == [D.class) {
            stringBuffer.append("new double[] {");
            double[] dArray = (double[])object;
            for (int i = 0; i < dArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(dArray[i]);
            }
            stringBuffer.append('}');
        } else if (clazz == String;.class) {
            stringBuffer.append("new String[] {");
            String[] stringArray = (String[])object;
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                Attribute.formatValue(stringBuffer, stringArray[i]);
            }
            stringBuffer.append('}');
        } else if (object instanceof Type) {
            stringBuffer.append("typeof(");
            stringBuffer.append(object);
            stringBuffer.append(")");
        } else {
            stringBuffer.append(object);
        }
    }

    static {
        $assertionsDisabled = !Attribute.class.desiredAssertionStatus();
        type2id = new HashMap();
        id2type = new HashMap();
        Attribute.map("Boolean", 2);
        Attribute.map("Char", 3);
        Attribute.map("SByte", 4);
        Attribute.map("Byte", 5);
        Attribute.map("Int16", 6);
        Attribute.map("UInt16", 7);
        Attribute.map("Int32", 8);
        Attribute.map("UInt32", 9);
        Attribute.map("Int64", 10);
        Attribute.map("UInt64", 11);
        Attribute.map("Single", 12);
        Attribute.map("Double", 13);
        Attribute.map("String", 14);
        Attribute.map("Type", 80);
    }

    public static class NamedArgument {
        public final int designator;
        public final String name;
        public final Type type;
        public final Object value;
        public static final NamedArgument[] EMPTY = new NamedArgument[0];

        public NamedArgument(int n, String string, Type type, Object object) {
            this.designator = n;
            this.name = string;
            this.type = type;
            this.value = object;
        }

        public boolean isField() {
            return this.designator == 83;
        }

        public boolean isProperty() {
            return this.designator == 84;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.name);
            stringBuffer.append(" = ");
            if (this.type.IsEnum()) {
                stringBuffer.append('(').append(this.type.FullName).append(')');
            }
            Attribute.formatValue(stringBuffer, this.value);
            return stringBuffer.toString();
        }
    }
}

