/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.dialogs;

import com.zerog.ia.download.utility.AppletResourceBundle;
import com.zerog.ia.download.utility.Gestalt;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;

public class ProgressBar
extends Canvas {
    int percentDone = 0;
    int fontHeight;
    long timerStarted = 0L;
    Image offscreenImage;
    Graphics offscreenGraphics;
    public static final String PERCENT_DONE = ".PercentDone";
    public static final String ABOUT_PREPEND = ".About.Prepend";
    public static final String ABOUT_POSTPEND = ".About.Postpend";
    public static final String ABOUT_A_MINUTE = ".AboutAMinute";
    public static final String LESS_A_MINUTE = ".AboutLessMinute";
    static /* synthetic */ Class class$com$zerog$ia$download$dialogs$ProgressBar;

    public ProgressBar() {
        this(300, 50);
    }

    public ProgressBar(int n, int n2) {
        this.resize(n, n2);
    }

    public void addNotify() {
        super.addNotify();
        this.fontHeight = this.getFontMetrics(this.getFont()).getHeight();
        this.offscreenImage = this.createImage(this.size().width, this.size().height);
        this.offscreenGraphics = this.offscreenImage.getGraphics();
        if (Gestalt.getVMVendor().equals(Gestalt.APPLE_VM)) {
            this.offscreenGraphics.setFont(new Font("SanSerif", 0, 10));
        } else {
            this.offscreenGraphics.setFont(new Font("Dialog", 0, 12));
        }
        this.offscreenGraphics.translate(2, 2);
        this.repaint();
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.offscreenImage, 0, 0, this);
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.size();
        Dimension dimension2 = this.size();
        dimension2.height = (dimension.height >> 1) - 4;
        dimension2.width = dimension.width - 4;
        String string = "" + this.percentDone + "% " + AppletResourceBundle.getLocalizedString(this, PERCENT_DONE);
        if (this.percentDone >= 10) {
            long l = System.currentTimeMillis() - this.timerStarted;
            long l2 = (100L * l / (long)this.percentDone - l) / 1000L;
            string = l2 > 90L ? string + " (" + AppletResourceBundle.getLocalizedString(this, ABOUT_PREPEND) + " " + (l2 + 30L) / 60L + " " + AppletResourceBundle.getLocalizedString(this, ABOUT_POSTPEND) + ")" : (l2 > 30L ? string + " (" + AppletResourceBundle.getLocalizedString(this, ABOUT_A_MINUTE) + ")" : string + " (" + AppletResourceBundle.getLocalizedString(this, LESS_A_MINUTE) + ")");
        }
        int n = this.percentDone * dimension2.width / 100;
        this.offscreenGraphics.setColor(this.getBackground());
        this.offscreenGraphics.fillRect(-2, -2, dimension.width, dimension.height);
        this.offscreenGraphics.setColor(Color.black);
        this.offscreenGraphics.drawRect(0, 0, dimension.width - 5, dimension2.height - 1);
        int n2 = 0;
        int n3 = 0;
        while (n3 <= n2) {
            Color color = new Color(0, 0, 150);
            int n4 = n3;
            while (n4 < n2) {
                color = color.darker();
                ++n4;
            }
            this.offscreenGraphics.setColor(color);
            this.offscreenGraphics.fillRect(n3, n3, n - n3, dimension2.height - 1 - n3);
            float f = (float)n3 / (float)n2;
            this.offscreenGraphics.setColor(new Color(f, f, f));
            ++n3;
        }
        this.offscreenGraphics.setColor(Color.black);
        this.offscreenGraphics.drawString(string, 0, dimension2.height + (this.fontHeight >> 1) + 5);
        this.paint(graphics);
    }

    public void setPercentDone(int n) {
        if (n == this.percentDone && n != 0) {
            return;
        }
        this.percentDone = n;
        if (this.percentDone < 0) {
            this.percentDone = 0;
        } else if (this.percentDone > 100) {
            this.percentDone = 100;
        }
        if (this.timerStarted == 0L && n > 0) {
            this.timerStarted = System.currentTimeMillis();
        }
        this.repaint();
    }

    public int getPercentDone() {
        return this.percentDone;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressBar == null ? (class$com$zerog$ia$download$dialogs$ProgressBar = ProgressBar.class$("com.zerog.ia.download.dialogs.ProgressBar")) : class$com$zerog$ia$download$dialogs$ProgressBar, PERCENT_DONE, "done");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressBar == null ? (class$com$zerog$ia$download$dialogs$ProgressBar = ProgressBar.class$("com.zerog.ia.download.dialogs.ProgressBar")) : class$com$zerog$ia$download$dialogs$ProgressBar, ABOUT_PREPEND, "About");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressBar == null ? (class$com$zerog$ia$download$dialogs$ProgressBar = ProgressBar.class$("com.zerog.ia.download.dialogs.ProgressBar")) : class$com$zerog$ia$download$dialogs$ProgressBar, ABOUT_POSTPEND, "minutes remaining");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressBar == null ? (class$com$zerog$ia$download$dialogs$ProgressBar = ProgressBar.class$("com.zerog.ia.download.dialogs.ProgressBar")) : class$com$zerog$ia$download$dialogs$ProgressBar, ABOUT_A_MINUTE, "About a minute remaining");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressBar == null ? (class$com$zerog$ia$download$dialogs$ProgressBar = ProgressBar.class$("com.zerog.ia.download.dialogs.ProgressBar")) : class$com$zerog$ia$download$dialogs$ProgressBar, LESS_A_MINUTE, "Less than a minute remaining");
    }
}

