/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download;

import com.apple.mrj.MRJFileUtils;
import com.apple.mrj.MRJOSType;
import com.zerog.ia.download.dialogs.ProgressDialog;
import com.zerog.ia.download.downloaders.BrowserDownloader;
import com.zerog.ia.download.downloaders.FileDownloader;
import com.zerog.ia.download.outputListeners.ContextListener;
import com.zerog.ia.download.outputListeners.GUIContextListener;
import com.zerog.ia.download.outputListeners.StdErrContextListener;
import com.zerog.ia.download.shared.DownloadContext;
import com.zerog.ia.download.shared.Platform;
import com.zerog.ia.download.shared.PlatformList;
import com.zerog.ia.download.utility.AppletResourceBundle;
import com.zerog.ia.download.utility.DiskSpaceCheckForDownload;
import com.zerog.ia.download.utility.Gestalt;
import com.zerog.ia.download.utility.GridBagUtilImpl;
import com.zerog.ia.download.utility.Util;
import com.zerog.ia.download.utility.nativelib.unix.Environment;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class WebInstallerApplet
extends Applet
implements DownloadContext {
    public static AppletResourceBundle resourceBundle;
    public PlatformList platforms;
    private boolean wantingToDownloadInstallerWithVM;
    private boolean allowingEmailToBeSent;
    private String productName;
    private Frame parentFrame;
    private Vector contextListenerList = new Vector(3, 1);
    private FileDownloader downloadProcess;
    private Button btnAction;
    private Checkbox chkIncludeVM;
    private Image creditImage;
    private Panel pnlNormalGui;
    private Panel pnlExceptionGui;
    private Panel pnlNoInstallerGui;
    private String troubleEmailAddress;
    private Vector filesToBeDeleted = new Vector(1, 1);
    private boolean immediateInstall = false;
    private boolean optionToDownloadEitherInstaller = true;
    private int timeoutLength = 30000;
    private Label lblRecommended = null;
    private Font currentFont = null;
    private Font boldFont = null;
    private String buttonTextDownload = null;
    private String buttonTextInstall = null;
    private String vmCheckboxText = null;
    public static final String DOWNLOAD_BUTTON = ".Button.Download";
    public static final String INSTALL_BUTTON = ".Button.Install";
    public static final String OK_BUTTON = ".Button.OK";
    public static final String CANCEL_BUTTON = ".Button.Cancel";
    public static final String VM_CHECKBOX = ".CheckBox.VM";
    public static final String RECOMMENDED_INSTALLER = ".RecommendedInstaller";
    public static final String NONE_AVAILABLE = ".NoInstallerAvailable.Label";
    public static final String SELECT_FROM_LIST = ".SelectFromList.Label";
    public static final String INSTRUCTIONS = ".Instructions.Label";
    public static final String ERROR_DETAIL_TITLE = ".Error.Detail.Title";
    public static final String OG_EXCEPTION_INSTRUCTIONS = ".Exception.InstructionsLabel";
    public static final String FAILURE_UNKNOWN = ".Failure.Unknown";
    private final String otherPlatforms = "Other Platforms";
    static /* synthetic */ Class class$com$zerog$ia$download$WebInstallerApplet;
    static /* synthetic */ Class class$com$zerog$ia$download$dialogs$EmailProgressDialog;
    static /* synthetic */ Class class$com$zerog$ia$download$dialogs$ErrorDetailDialog;
    static /* synthetic */ Class class$com$zerog$ia$download$dialogs$ErrorDialog;
    static /* synthetic */ Class class$com$zerog$ia$download$dialogs$ProgressDialog;
    static /* synthetic */ Class class$com$zerog$ia$download$dialogs$ProgressBar;

    public void init() {
        try {
            super.init();
            System.err.println("Platform :  " + Gestalt.getPlatform());
            System.err.println("VM Vendor:  " + Gestalt.getVMVendor());
            System.err.println("VM Version: " + Gestalt.getVMVersion());
            System.err.println("IsSupportedVM:  " + Gestalt.isSupportedVM());
            System.err.println("-----------------------");
            this.addContextListener(new GUIContextListener(this));
            this.addContextListener(new StdErrContextListener(this));
            this.notifySetFriendlyErrorMessage(AppletResourceBundle.getLocalizedString(this, FAILURE_UNKNOWN));
            this.notifyOutputDiagnosticMessage("Java Vendor:  " + System.getProperty("java.vendor"));
            this.notifyOutputDiagnosticMessage("URL:  " + System.getProperty("java.vendor.url"));
            this.notifyOutputDiagnosticMessage("Java Version:  " + System.getProperty("java.version"));
            this.notifyOutputDiagnosticMessage("Java Class Version:  " + System.getProperty("java.class.version"));
            this.notifyOutputDiagnosticMessage("OS Name:  " + System.getProperty("os.name"));
            this.notifyOutputDiagnosticMessage("OS Architecture:  " + System.getProperty("os.arch"));
            this.notifyOutputDiagnosticMessage("OS Version:  " + System.getProperty("os.version"));
            this.notifyOutputDiagnosticMessage("---------------------------------");
            if (!Gestalt.isSupportedVM()) {
                this.createAppletGui();
                this.handleError();
                this.repaint();
                return;
            }
            this.loadPlatformData();
            this.platforms.computeRunningOnPlatform();
            if (this.platforms.getRunningOnPlatform() == null) {
                this.createAppletGui();
                this.handleNoInstallerError();
                this.repaint();
                return;
            }
            this.optionToDownloadEitherInstaller = true;
            this.setWantingToDownloadInstallerWithVM(true);
            if (this.platforms.getRunningOnPlatform().installerNameVM == null) {
                this.setWantingToDownloadInstallerWithVM(false);
                this.optionToDownloadEitherInstaller = false;
            } else if (this.platforms.getRunningOnPlatform().installerNameNoVM == null) {
                this.setWantingToDownloadInstallerWithVM(true);
                this.optionToDownloadEitherInstaller = false;
            }
            if (this.troubleEmailAddress != null) {
                if (this.troubleEmailAddress.indexOf(64) >= 0) {
                    this.setAllowingEmailToBeSent(true);
                } else {
                    this.setAllowingEmailToBeSent(false);
                }
            } else {
                this.setAllowingEmailToBeSent(false);
            }
            if (this.immediateInstall) {
                this.notifyOutputDiagnosticMessage("init:  startDownloadProcess called from init");
                this.startDownloadProcess();
            } else {
                this.loadCustomLocale();
                this.createAppletGui();
                this.addNormalAppletGui();
            }
        }
        catch (Throwable e) {
            this.notifyErrorOccured(e);
            try {
                this.createAppletGui();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.handleError();
            this.repaint();
        }
    }

    void createAppletGui() throws Exception {
        this.setBackground(Color.white);
        this.pnlExceptionGui = new Panel();
        this.pnlExceptionGui.setLayout(new FlowLayout());
        String temp = AppletResourceBundle.getLocalizedString(this, SELECT_FROM_LIST);
        this.pnlExceptionGui.add(new Label(temp, 1));
        this.pnlNormalGui = new Panel();
        this.pnlNoInstallerGui = new Panel();
        this.pnlNoInstallerGui.setLayout(new GridLayout(2, 1));
        temp = AppletResourceBundle.getLocalizedString(this, NONE_AVAILABLE);
        this.pnlNoInstallerGui.add(new Label(temp, 1));
        temp = AppletResourceBundle.getLocalizedString(this, INSTRUCTIONS);
        this.pnlNoInstallerGui.add(new Label(temp, 1));
        GridBagLayout gbl = new GridBagLayout();
        this.pnlNormalGui.setLayout(gbl);
        GridBagUtilImpl.setLayoutManager(gbl);
        temp = AppletResourceBundle.getLocalizedString(this, RECOMMENDED_INSTALLER);
        this.lblRecommended = new Label(temp, 1);
        this.currentFont = this.getFont();
        this.boldFont = new Font(this.currentFont.getName(), 1, this.currentFont.getSize() + 2);
        if (!Gestalt.getVMVendor().equals(Gestalt.APPLE_VM)) {
            this.lblRecommended.setFont(this.boldFont);
        }
        GridBagUtilImpl.add(this.pnlNormalGui, this.lblRecommended, 0, 0, 3, 1, 2, 10, 1.0, 0.0);
        this.btnAction = new Button();
        GridBagUtilImpl.add(this.pnlNormalGui, this.btnAction, 0, 1, 2, 1, 2, 11, 2.0, 1.0);
        temp = AppletResourceBundle.getLocalizedString(this, VM_CHECKBOX);
        this.chkIncludeVM = new Checkbox(temp);
        if (this.optionToDownloadEitherInstaller) {
            if (Gestalt.isThisPlatformUnix()) {
                GridBagUtilImpl.add(this.pnlNormalGui, this.chkIncludeVM, 2, 1, 1, 1, 2, new Insets(0, 2, 0, 0), 11, 1.0, 1.0);
            } else {
                GridBagUtilImpl.add(this.pnlNormalGui, this.chkIncludeVM, 2, 1, 1, 1, 2, new Insets(0, 5, 0, 0), 11, 1.0, 1.0);
            }
        }
    }

    public void addNormalAppletGui() {
        this.add(this.pnlNormalGui);
        this.chkIncludeVM.setState(this.isWantingToDownloadInstallerWithVM());
        Font standardFont = new Font("Dialog", 0, 12);
        this.btnAction.setFont(standardFont);
        if (Gestalt.isThisPlatformUnix()) {
            this.lblRecommended.setFont(new Font(this.currentFont.getName(), 1, this.currentFont.getSize()));
            this.chkIncludeVM.setFont(new Font("Dialog", 0, 9));
            this.btnAction.setFont(new Font("Dialog", 0, 9));
        }
        try {
            this.creditImage = this.getImage(new URL(this.getCodeBase() + "/images/credit.gif"));
        }
        catch (Throwable e) {
            this.notifyOutputDiagnosticMessage("init: Credits gif couldn't be loaded.");
            this.creditImage = null;
        }
        this.updateActionButtonText();
        this.repaint();
    }

    void handleError() {
        try {
            this.remove(this.pnlNormalGui);
        }
        catch (Throwable e) {
            System.err.println("WebInstallerApplet:  Unable to remove pnlNormalGui.");
        }
        try {
            this.add(this.pnlExceptionGui);
        }
        catch (Throwable e) {
            System.err.println("WebInstallerApplet:  Unable to add pnlExceptionGui.");
            e.printStackTrace();
        }
        this.repaint();
    }

    void handleNoInstallerError() {
        try {
            this.remove(this.pnlNormalGui);
        }
        catch (Throwable e) {
            System.err.println("WebInstallerApplet:  Unable to remove pnlNormalGui.");
        }
        try {
            this.add(this.pnlNoInstallerGui);
        }
        catch (Throwable e) {
            System.err.println("WebInstallerApplet:  Unable to add pnlNoInstallerGui.");
            e.printStackTrace();
        }
        this.repaint();
    }

    public void start() {
        try {
            super.start();
        }
        catch (Throwable e) {
            this.notifyErrorOccured(e);
        }
    }

    public void addNotify() {
        try {
            super.addNotify();
            Container c = this;
            while (c != null) {
                System.err.println(c);
                if (c instanceof Frame) {
                    this.parentFrame = (Frame)c;
                }
                c = c.getParent();
            }
        }
        catch (Throwable e) {
            this.notifyErrorOccured(e);
        }
    }

    public synchronized boolean isWantingToDownloadInstallerWithVM() {
        return this.wantingToDownloadInstallerWithVM;
    }

    public synchronized void setWantingToDownloadInstallerWithVM(boolean _wantingToDownloadInstallerWithVM) {
        this.wantingToDownloadInstallerWithVM = _wantingToDownloadInstallerWithVM;
        this.updateActionButtonText();
    }

    public String getTroubleEmailAddress() {
        return this.troubleEmailAddress;
    }

    public PlatformList getPlatforms() {
        return this.platforms;
    }

    public void loadPlatformData() throws Exception {
        this.productName = this.getParameter("ProductName");
        String immediateInstallParam = this.getParameter("ImmediateInstall");
        String timeoutParam = this.getParameter("Timeout");
        if (timeoutParam == null || timeoutParam.equals("")) {
            this.timeoutLength = 30000;
            this.notifyOutputDiagnosticMessage("Timeout set to :" + this.timeoutLength);
        } else {
            this.timeoutLength = new Integer(this.getParameter("Timeout"));
            this.notifyOutputDiagnosticMessage("Timeout set to :" + this.timeoutLength);
        }
        try {
            this.immediateInstall = immediateInstallParam.trim().equalsIgnoreCase("yes") || immediateInstallParam.trim().equalsIgnoreCase("true");
        }
        catch (Exception e) {
            this.immediateInstall = false;
        }
        this.notifyOutputDiagnosticMessage("immediateInstall:  " + this.immediateInstall);
        this.troubleEmailAddress = this.getParameter("SendTroubleEmailTo");
        this.notifyOutputDiagnosticMessage("Trouble e-mail address:  " + this.troubleEmailAddress);
        this.platforms = new PlatformList();
        int maxNumberOfSupportedPlatforms = 20;
        int i = 1;
        while (i <= maxNumberOfSupportedPlatforms) {
            try {
                Platform platformToAdd = new Platform(this, i);
                this.platforms.add(platformToAdd);
                this.notifyOutputDiagnosticMessage("Reading applet parameters: Reading in data for platform #" + i + "; platform name = " + platformToAdd.platformName);
            }
            catch (Throwable e) {
                this.notifyOutputDiagnosticMessage("Reading applet parameters: Platform #" + i + " not found.");
            }
            ++i;
        }
        Platform runningOnPlatform = this.platforms.getRunningOnPlatform();
        if (runningOnPlatform == null) {
            // empty if block
        }
    }

    public boolean handleEvent(Event event) {
        try {
            if (event.target == this.btnAction && event.id == 1001) {
                this.pnlNormalGui.disable();
                this.notifyOutputDiagnosticMessage("handleEvent:  startDownloadProcess called from handleEvent");
                this.startDownloadProcess();
            } else if (event.target == this.chkIncludeVM && event.id == 1001) {
                this.setWantingToDownloadInstallerWithVM(this.chkIncludeVM.getState());
            } else {
                if (event.id == 505) {
                    this.getAppletContext().showStatus("");
                    return super.handleEvent(event);
                }
                if (this.creditImage != null) {
                    if (event.id == 501 && event.y >= this.size().height - this.creditImage.getHeight(this)) {
                        try {
                            this.getAppletContext().showDocument(new URL("http://www.ZeroG.com"));
                        }
                        catch (Throwable e) {
                            this.notifyOutputDiagnosticMessage("HandleEvent: User clicked on credit GIF; applet couldn't open www.ZeroG.com.");
                        }
                    } else if (event.y >= this.size().height - this.creditImage.getHeight(this)) {
                        this.getAppletContext().showStatus("http://www.ZeroG.com");
                        return super.handleEvent(event);
                    }
                } else {
                    this.getAppletContext().showStatus("");
                    return super.handleEvent(event);
                }
            }
            return true;
        }
        catch (Throwable e) {
            this.notifyErrorOccured(e);
            return false;
        }
    }

    void updateActionButtonText() {
        if (this.btnAction == null) {
            return;
        }
        String currentPlatform = this.platforms.getRunningOnPlatform().platformName;
        boolean installerIsRunnable = true;
        if (this.isWantingToDownloadInstallerWithVM()) {
            installerIsRunnable = !this.platforms.getRunningOnPlatform().isNotRunnableVM;
        } else {
            boolean bl = installerIsRunnable = !this.platforms.getRunningOnPlatform().isNotRunnableNoVM;
            if (Gestalt.isThisPlatformUnix() && !Gestalt.checkPathForVM()) {
                installerIsRunnable = false;
            }
        }
        if (currentPlatform.equals("Other Platforms")) {
            this.wantingToDownloadInstallerWithVM = false;
            installerIsRunnable = false;
        }
        this.notifyOutputDiagnosticMessage("");
        this.notifyOutputDiagnosticMessage("Does Installer with VM exist: " + (this.platforms.getRunningOnPlatform().installerNameVM != null));
        this.notifyOutputDiagnosticMessage("Does Installer no VM exist:   " + (this.platforms.getRunningOnPlatform().installerNameNoVM != null));
        this.notifyOutputDiagnosticMessage("Is this Platform Unix:        " + Gestalt.isThisPlatformUnix());
        if (Gestalt.isThisPlatformUnix()) {
            this.notifyOutputDiagnosticMessage("Is Java on the PATH:          " + Gestalt.checkPathForVM());
            try {
                this.notifyOutputDiagnosticMessage("** PATH = " + Environment.getInstance().getValue("PATH"));
            }
            catch (Exception e) {
                this.notifyOutputDiagnosticMessage("IE: I'm being checked to see if I am unix ");
                e.printStackTrace();
            }
        }
        this.notifyOutputDiagnosticMessage("");
        if (Gestalt.isAbleToExecuteFiles() && installerIsRunnable) {
            this.notifyOutputDiagnosticMessage("able to execute and runnable " + installerIsRunnable);
            String temp = AppletResourceBundle.getLocalizedString(this, INSTALL_BUTTON) + " " + currentPlatform;
            this.btnAction.setLabel(temp + "...     ");
        } else {
            if (!installerIsRunnable) {
                this.notifyOutputDiagnosticMessage("Installer is not runnable by default, due to platform");
            }
            if (!Gestalt.isAbleToExecuteFiles()) {
                this.notifyOutputDiagnosticMessage("Is unable to execute files because of permissions");
            }
            String temp = AppletResourceBundle.getLocalizedString(this, DOWNLOAD_BUTTON) + " " + currentPlatform;
            this.btnAction.setLabel(temp + "...     ");
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        try {
            if (this.creditImage != null) {
                Dimension sizeOfMe = this.size();
                g.drawImage(this.creditImage, sizeOfMe.width - this.creditImage.getWidth(this) >> 1, sizeOfMe.height - 1 - this.creditImage.getHeight(this), this);
            }
        }
        catch (Throwable e) {
            this.notifyErrorOccured(e);
        }
    }

    public void startDownloadProcess() throws Exception {
        boolean installerIsRunnable;
        URL sourceFile = null;
        String sourceFileName = this.isWantingToDownloadInstallerWithVM() ? this.getCodeBase().toString() + this.platforms.getRunningOnPlatform().installerNameVM : this.getCodeBase().toString() + this.platforms.getRunningOnPlatform().installerNameNoVM;
        if (this.isWantingToDownloadInstallerWithVM()) {
            installerIsRunnable = !this.platforms.getRunningOnPlatform().isNotRunnableVM;
        } else {
            boolean bl = installerIsRunnable = !this.platforms.getRunningOnPlatform().isNotRunnableNoVM;
            if (Gestalt.isThisPlatformUnix() && !Gestalt.checkPathForVM()) {
                installerIsRunnable = false;
            }
        }
        String currentPlatform = this.platforms.getRunningOnPlatform().platformName;
        if (currentPlatform.equals("Other Platforms")) {
            this.wantingToDownloadInstallerWithVM = false;
            installerIsRunnable = false;
            String codeBase = this.getCodeBase().toString().substring(0, this.getCodeBase().toString().indexOf("InstData"));
            sourceFileName = codeBase + this.platforms.getRunningOnPlatform().installerNameVM;
        }
        try {
            sourceFile = new URL(sourceFileName);
        }
        catch (MalformedURLException e) {
            this.notifySetFriendlyErrorMessage("Installer '" + sourceFileName + "' not found.");
            throw e;
        }
        this.notifyOutputDiagnosticMessage("Handle Event: File to copy is '" + sourceFileName + "'.");
        if (!installerIsRunnable) {
            this.doBrowserDownload(sourceFile);
        } else if (installerIsRunnable && Gestalt.isAbleToExecuteFiles()) {
            this.doZGDownload(sourceFile);
        } else {
            this.doBrowserDownload(sourceFile);
        }
    }

    public void doZGDownload(URL sourceFile) {
        String installerName;
        if (Gestalt.isNetscapeSecurityModelAvailable()) {
            PrivilegeManager.enablePrivilege((String)Gestalt.NETSCAPE_PROPERTY_READ);
        }
        String logDir = this.getIALogFileDirectory();
        System.err.println("logDir" + logDir);
        if (this.isWantingToDownloadInstallerWithVM()) {
            installerName = this.platforms.getRunningOnPlatform().installerNameVM;
            System.err.println("platforms.getRunningOnPlatform()" + this.platforms.getRunningOnPlatform());
        } else {
            installerName = this.platforms.getRunningOnPlatform().installerNameNoVM;
            System.err.println("platforms.getRunningOnPlatform()" + this.platforms.getRunningOnPlatform());
        }
        installerName = installerName.substring(installerName.lastIndexOf(47) + 1);
        System.err.println("WIA.doZGDownload(): initial installer name: '" + installerName + "'");
        if (Gestalt.getPlatform() == Gestalt.MAC_OS_PLATFORM) {
            int index = Math.min(installerName.length(), 26);
            String installerNameLower = installerName.toLowerCase();
            if (installerNameLower.endsWith(".bin")) {
                index = installerNameLower.lastIndexOf(".bin");
            }
            installerName = installerName.substring(0, Math.min(26, index)).trim();
            installerName = installerName + ".bin";
        }
        installerName = installerName.trim();
        installerName = installerName.replace(' ', '_');
        this.notifyOutputDiagnosticMessage("handleEvent: installer name is" + installerName);
        String productNameDir = this.getProductName().substring(0, Math.min(30, this.getProductName().length())).trim();
        productNameDir = productNameDir.replace(' ', '_');
        File checkDiskSpaceFile = new File(Util.prepFileName(logDir + productNameDir + "/" + installerName));
        System.err.println("WIA.doZGDownload(): logDir = '" + logDir + "'");
        System.err.println("WIA.doZGDownload(): productNameDir (final) = '" + productNameDir + "'");
        System.err.println("WIA.doZGDownload(): installerName  (final) = '" + installerName + "'");
        this.notifyOutputDiagnosticMessage("The temp file has been created: " + checkDiskSpaceFile.toString());
        this.notifyOutputDiagnosticMessage("Creating the ProgressDialog for the disk space check");
        ProgressDialog progressDialog = new ProgressDialog(this);
        progressDialog.setProgressDialogText(2, null, checkDiskSpaceFile.toString());
        this.notifyOutputDiagnosticMessage("Creating the class to check for disk space");
        this.notifyOutputDiagnosticMessage("Source location: " + sourceFile);
        DiskSpaceCheckForDownload diskSpaceCheck = new DiskSpaceCheckForDownload(sourceFile, checkDiskSpaceFile, progressDialog, this);
        progressDialog.addObserver(diskSpaceCheck);
        Thread progressDialogThread = new Thread(progressDialog);
        progressDialogThread.setPriority(10);
        progressDialogThread.start();
        Thread diskSpaceThread = new Thread(diskSpaceCheck);
        diskSpaceThread.start();
        this.notifyOutputDiagnosticMessage("Disk space checking has started");
    }

    public void doBrowserDownload(URL sourceFile) {
        this.notifyOutputDiagnosticMessage("Preparing browser download object.");
        this.downloadProcess = new BrowserDownloader(this);
        this.downloadProcess.setFileToDownload(sourceFile);
        this.notifyOutputDiagnosticMessage("Starting the download process from doBrowserDownload");
        this.downloadProcess.start();
    }

    public Frame getParentFrame() {
        return this.parentFrame;
    }

    public String getProductName() {
        return this.productName;
    }

    public URL getCodeBase() {
        String codeBase = super.getCodeBase().toString();
        if (codeBase.substring(codeBase.length() - 2).equals("/.")) {
            codeBase = codeBase.substring(0, codeBase.length() - 1);
        }
        try {
            return new URL(codeBase);
        }
        catch (MalformedURLException e) {
            this.notifyOutputDiagnosticMessage("getCodeBase: Unable to retrieve code base (currently showing up as '" + codeBase + "'.");
            return null;
        }
    }

    public void loadCustomLocale() {
        Locale thisLocale = this.getLocale();
        this.notifyOutputDiagnosticMessage("Locale from System. Language: " + thisLocale.getDisplayLanguage());
        this.notifyOutputDiagnosticMessage("Locale from System.  Country: " + thisLocale.getDisplayCountry());
        this.loadLocalizedStringResource("CustomOKButtonLabel", class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, OK_BUTTON);
        this.loadLocalizedStringResource("CustomCancelButtonLabel", class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, CANCEL_BUTTON);
        this.loadLocalizedStringResource("CustomRecommendedText", class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, RECOMMENDED_INSTALLER);
        this.loadLocalizedStringResource("CustomDownloadButtonText", class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, DOWNLOAD_BUTTON);
        this.loadLocalizedStringResource("CustomInstallButtonText", class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, INSTALL_BUTTON);
        this.loadLocalizedStringResource("CustomVMCheckboxText", class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, VM_CHECKBOX);
        this.loadLocalizedStringResource("CustomNoInstallersAvailableText", class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, NONE_AVAILABLE);
        this.loadLocalizedStringResource("CustomSelectInstallerFromListText", class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, SELECT_FROM_LIST);
        this.loadLocalizedStringResource("CustomSelectInstructionsText", class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, INSTRUCTIONS);
        this.loadLocalizedStringResource("CustomUnknownFailureText", class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, FAILURE_UNKNOWN);
        this.loadLocalizedStringResource("CustomEmailDialogTitle", class$com$zerog$ia$download$dialogs$EmailProgressDialog == null ? (class$com$zerog$ia$download$dialogs$EmailProgressDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.EmailProgressDialog")) : class$com$zerog$ia$download$dialogs$EmailProgressDialog, ".Title");
        this.loadLocalizedStringResource("CustomErrorDetailDialogTitle", class$com$zerog$ia$download$dialogs$ErrorDetailDialog == null ? (class$com$zerog$ia$download$dialogs$ErrorDetailDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ErrorDetailDialog")) : class$com$zerog$ia$download$dialogs$ErrorDetailDialog, ".Title");
        this.loadLocalizedStringResource("CustomErrorDetailDialogHeading", class$com$zerog$ia$download$dialogs$ErrorDetailDialog == null ? (class$com$zerog$ia$download$dialogs$ErrorDetailDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ErrorDetailDialog")) : class$com$zerog$ia$download$dialogs$ErrorDetailDialog, ".Heading");
        this.loadLocalizedStringResource("CustomErrorDialogTitle", class$com$zerog$ia$download$dialogs$ErrorDialog == null ? (class$com$zerog$ia$download$dialogs$ErrorDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ErrorDialog")) : class$com$zerog$ia$download$dialogs$ErrorDialog, ".Title");
        this.loadLocalizedStringResource("CustomErrorDialogHeading", class$com$zerog$ia$download$dialogs$ErrorDialog == null ? (class$com$zerog$ia$download$dialogs$ErrorDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ErrorDialog")) : class$com$zerog$ia$download$dialogs$ErrorDialog, ".Heading");
        this.loadLocalizedStringResource("CustomErrorDialogShowDetail", class$com$zerog$ia$download$dialogs$ErrorDialog == null ? (class$com$zerog$ia$download$dialogs$ErrorDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ErrorDialog")) : class$com$zerog$ia$download$dialogs$ErrorDialog, ".Show.Detail");
        this.loadLocalizedStringResource("CustomErrorDialogSendTo", class$com$zerog$ia$download$dialogs$ErrorDialog == null ? (class$com$zerog$ia$download$dialogs$ErrorDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ErrorDialog")) : class$com$zerog$ia$download$dialogs$ErrorDialog, ".Send.To");
        this.loadLocalizedStringResource("CustomErrorDialogSendToAbout", class$com$zerog$ia$download$dialogs$ErrorDialog == null ? (class$com$zerog$ia$download$dialogs$ErrorDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ErrorDialog")) : class$com$zerog$ia$download$dialogs$ErrorDialog, ".Send.To.About");
        this.loadLocalizedStringResource("CustomErrorDialogEnterEmail", class$com$zerog$ia$download$dialogs$ErrorDialog == null ? (class$com$zerog$ia$download$dialogs$ErrorDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ErrorDialog")) : class$com$zerog$ia$download$dialogs$ErrorDialog, ".Enter.Email");
        this.loadLocalizedStringResource("CustomErrorDialogInvalidEmail", class$com$zerog$ia$download$dialogs$ErrorDialog == null ? (class$com$zerog$ia$download$dialogs$ErrorDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ErrorDialog")) : class$com$zerog$ia$download$dialogs$ErrorDialog, ".Invalid.Email");
        this.loadLocalizedStringResource("CustomProgressDialogCheckDiskSpaceTitle", class$com$zerog$ia$download$dialogs$ProgressDialog == null ? (class$com$zerog$ia$download$dialogs$ProgressDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ProgressDialog")) : class$com$zerog$ia$download$dialogs$ProgressDialog, ".CheckDiskSpace.Title");
        this.loadLocalizedStringResource("CustomProgressDialogDownloadTitle", class$com$zerog$ia$download$dialogs$ProgressDialog == null ? (class$com$zerog$ia$download$dialogs$ProgressDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ProgressDialog")) : class$com$zerog$ia$download$dialogs$ProgressDialog, ".Download.Title");
        this.loadLocalizedStringResource("CustomProgressDialogStartInstallerTitle", class$com$zerog$ia$download$dialogs$ProgressDialog == null ? (class$com$zerog$ia$download$dialogs$ProgressDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ProgressDialog")) : class$com$zerog$ia$download$dialogs$ProgressDialog, ".StartInstaller.Title");
        this.loadLocalizedStringResource("CustomProgressDialogCheckDiskSpaceHeading", class$com$zerog$ia$download$dialogs$ProgressDialog == null ? (class$com$zerog$ia$download$dialogs$ProgressDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ProgressDialog")) : class$com$zerog$ia$download$dialogs$ProgressDialog, ".CheckDiskSpace.Heading");
        this.loadLocalizedStringResource("CustomProgressDialogDownloadHeading", class$com$zerog$ia$download$dialogs$ProgressDialog == null ? (class$com$zerog$ia$download$dialogs$ProgressDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ProgressDialog")) : class$com$zerog$ia$download$dialogs$ProgressDialog, ".Download.Heading");
        this.loadLocalizedStringResource("CustomProgressDialogStartInstallerHeading", class$com$zerog$ia$download$dialogs$ProgressDialog == null ? (class$com$zerog$ia$download$dialogs$ProgressDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ProgressDialog")) : class$com$zerog$ia$download$dialogs$ProgressDialog, ".StartInstaller.Heading");
        this.loadLocalizedStringResource("CustomProgressDialogCheckDiskSpaceLabel", class$com$zerog$ia$download$dialogs$ProgressDialog == null ? (class$com$zerog$ia$download$dialogs$ProgressDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ProgressDialog")) : class$com$zerog$ia$download$dialogs$ProgressDialog, ".CheckDiskSpace.Label");
        this.loadLocalizedStringResource("CustomProgressDialogDownloadLabel", class$com$zerog$ia$download$dialogs$ProgressDialog == null ? (class$com$zerog$ia$download$dialogs$ProgressDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ProgressDialog")) : class$com$zerog$ia$download$dialogs$ProgressDialog, ".Download.Label");
        this.loadLocalizedStringResource("CustomProgressDialogStartInstallerLabel", class$com$zerog$ia$download$dialogs$ProgressDialog == null ? (class$com$zerog$ia$download$dialogs$ProgressDialog = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ProgressDialog")) : class$com$zerog$ia$download$dialogs$ProgressDialog, ".StartInstaller.Label");
        this.loadLocalizedStringResource("CustomProgressBarPercentDoneText", class$com$zerog$ia$download$dialogs$ProgressBar == null ? (class$com$zerog$ia$download$dialogs$ProgressBar = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ProgressBar")) : class$com$zerog$ia$download$dialogs$ProgressBar, ".PercentDone");
        this.loadLocalizedStringResource("CustomProgressBarAboutPrependText", class$com$zerog$ia$download$dialogs$ProgressBar == null ? (class$com$zerog$ia$download$dialogs$ProgressBar = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ProgressBar")) : class$com$zerog$ia$download$dialogs$ProgressBar, ".About.Prepend");
        this.loadLocalizedStringResource("CustomProgressBarAboutPostpendText", class$com$zerog$ia$download$dialogs$ProgressBar == null ? (class$com$zerog$ia$download$dialogs$ProgressBar = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ProgressBar")) : class$com$zerog$ia$download$dialogs$ProgressBar, ".About.Postpend");
        this.loadLocalizedStringResource("CustomProgressBarAboutAMinuteRemainingText", class$com$zerog$ia$download$dialogs$ProgressBar == null ? (class$com$zerog$ia$download$dialogs$ProgressBar = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ProgressBar")) : class$com$zerog$ia$download$dialogs$ProgressBar, ".AboutAMinute");
        this.loadLocalizedStringResource("CustomProgressBarLessThanAMinuteRemainingText", class$com$zerog$ia$download$dialogs$ProgressBar == null ? (class$com$zerog$ia$download$dialogs$ProgressBar = WebInstallerApplet.class$("com.zerog.ia.download.dialogs.ProgressBar")) : class$com$zerog$ia$download$dialogs$ProgressBar, ".AboutLessMinute");
    }

    public void loadLocalizedStringResource(String resourceName, Class theClass, String key) {
        Locale thisLocale = this.getLocale();
        String temp = this.getParameter(resourceName + "_" + thisLocale.getLanguage());
        if (temp == null) {
            this.notifyOutputDiagnosticMessage(resourceName + "_" + thisLocale.getLanguage() + " not found");
        } else {
            AppletResourceBundle.setLocalizedString(theClass, key, temp);
        }
    }

    public void addContextListener(ContextListener _cl) {
        this.contextListenerList.addElement(_cl);
    }

    public void removeContextListener(ContextListener _cl) {
        this.contextListenerList.removeElement(_cl);
    }

    public void notifyErrorOccured(Throwable _exception) {
        Enumeration e = this.contextListenerList.elements();
        while (e.hasMoreElements()) {
            ((ContextListener)e.nextElement()).errorOccured(_exception);
        }
        this.notifySetFriendlyErrorMessage(AppletResourceBundle.getLocalizedString(this, FAILURE_UNKNOWN));
    }

    public void notifyOutputDiagnosticMessage(String _msg) {
        Enumeration e = this.contextListenerList.elements();
        while (e.hasMoreElements()) {
            ((ContextListener)e.nextElement()).outputDiagnosticMessage(_msg);
        }
    }

    public void notifySetFriendlyErrorMessage(String _msg) {
        Enumeration e = this.contextListenerList.elements();
        while (e.hasMoreElements()) {
            ((ContextListener)e.nextElement()).setFriendlyErrorMessage(_msg);
        }
    }

    public FileDownloader getDownloadProcess() {
        return this.downloadProcess;
    }

    public boolean isAllowingEmailToBeSent() {
        return this.allowingEmailToBeSent;
    }

    public void setAllowingEmailToBeSent(boolean _allowingEmailToBeSent) {
        this.allowingEmailToBeSent = _allowingEmailToBeSent;
    }

    public Vector getContextListenerList() {
        return this.contextListenerList;
    }

    public void downloadStopped() {
        if (this.pnlNormalGui != null) {
            this.pnlNormalGui.enable();
        }
    }

    public String getIALogFileDirectory() {
        String rootDir2;
        if (Gestalt.getPlatform().equals(Gestalt.WINDOWS_PLATFORM)) {
            String userHome = Util.prepFileName(System.getProperty("user.home"));
            rootDir2 = userHome.substring(0, userHome.indexOf(47));
        } else {
            if (Gestalt.getPlatform().equals(Gestalt.MAC_OS_PLATFORM)) {
                File path = null;
                String tempHome = null;
                try {
                    this.notifyOutputDiagnosticMessage("Finding download location for Mac");
                    path = MRJFileUtils.findFolder((MRJOSType)new MRJOSType("desk"));
                    tempHome = Util.prepFileName(path.getPath());
                }
                catch (FileNotFoundException e) {
                    this.notifyOutputDiagnosticMessage("Error: Unable to find temporary items folder.  Defaulting to /Mac_OS_9/");
                    tempHome = System.getProperty("user.home");
                    e.printStackTrace();
                }
                catch (Throwable e) {
                    this.notifyOutputDiagnosticMessage("Exception found");
                    e.printStackTrace();
                }
                String rootDir2 = new String(tempHome);
                this.notifyOutputDiagnosticMessage("handleEvent: rootDir = '" + rootDir2 + "'.");
                return rootDir2;
            }
            rootDir2 = System.getProperty("user.home");
            int hiddenNetscapeFolder = rootDir2.toLowerCase().lastIndexOf(".netscape");
            if (hiddenNetscapeFolder >= 0) {
                rootDir2 = rootDir2.substring(0, hiddenNetscapeFolder - 1);
            }
        }
        this.notifyOutputDiagnosticMessage("handleEvent: rootDir = '" + rootDir2 + "'.");
        return rootDir2 + "/IA_Installers/";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, OK_BUTTON, "OK");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, CANCEL_BUTTON, "Cancel");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, DOWNLOAD_BUTTON, "Download Installer for");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, INSTALL_BUTTON, "     Start Installer for");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, VM_CHECKBOX, "Include VM in download");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, RECOMMENDED_INSTALLER, "Recommended Installation for Your Platform:");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, NONE_AVAILABLE, "There is no installer available for your platform.");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, SELECT_FROM_LIST, "Please select an installer to download from the list below.");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, INSTRUCTIONS, "You can download an installer for another platform from the list below.");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = WebInstallerApplet.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, FAILURE_UNKNOWN, "The applet has failed for an unknown reason, possibly because of an incompatibility between this applet and your browser.");
    }
}

