/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003-2004, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
** $Id: Comment.scala,v 1.5 2004/06/22 21:21:45 buraq Exp $
\*                                                                      */

package scala.xml;

import scala.collection.immutable ;

/** an XML node for comments.
 *
 * @author Burak Emir
 * @param text text contained in this node, may not contain "--"
**/

case class Comment( text:String ) extends SpecialNode {  

  final override def typeTag$:Int = -3;

  if( text.indexOf("--" ) != -1 ) 
    throw new IllegalArgumentException("text containts \"--\"");

  final override def equals(x:Any) = x match {
    case Comment( s ) => text.equals( s );
    case _ => false;
  }

  /** the constant "#REM" */
  def label    = "#REM";

  /** hashcode for this Comment */
  override def hashCode() = text.hashCode();

  /** returns "<!--"+text+"-->" */
  final override def toString() = "<!--"+text+"-->";
    
}
