/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.JArrayType;
import ch.epfl.lamp.fjbg.JObjectType;
import ch.epfl.lamp.fjbg.JType;

public class JOpcode {
    public final String name;
    public final int code;
    protected final int size;
    protected final JType[] producedDataTypes;
    protected final JType[] consumedDataTypes;
    protected final int jumpKind;
    protected final int successorCount;
    protected static final int UNKNOWN = Integer.MIN_VALUE;
    protected static final int JMP_NONE = 0;
    protected static final int JMP_NEXT = 1;
    protected static final int JMP_ALWAYS_S2_OFFSET = 2;
    protected static final int JMP_ALWAYS_S4_OFFSET = 3;
    protected static final int JMP_MAYBE_S2_OFFSET = 4;
    protected static final int JMP_TABLE = 5;
    protected static final int JMP_LOOKUP = 6;
    protected static final JType[] NO_DATA = new JType[0];
    protected static final JType[] INT_TYPE = new JType[]{JType.INT};
    protected static final JType[] FLOAT_TYPE = new JType[]{JType.FLOAT};
    protected static final JType[] LONG_TYPE = new JType[]{JType.LONG};
    protected static final JType[] DOUBLE_TYPE = new JType[]{JType.DOUBLE};
    protected static final JType[] OBJECT_REF_TYPE = new JType[]{JObjectType.JAVA_LANG_OBJECT};
    protected static final JType[] ARRAY_REF_TYPE = new JType[]{new JArrayType(JType.VOID)};
    protected static final JType[] REFERENCE_TYPE = new JType[]{JType.REFERENCE};
    protected static final JType[] ADDRESS_TYPE = new JType[]{JType.ADDRESS};
    protected static final JType[] UNKNOWN_TYPE = new JType[]{JType.UNKNOWN};
    public static final int cNOP = 0;
    public static final int cACONST_NULL = 1;
    public static final int cICONST_M1 = 2;
    public static final int cICONST_0 = 3;
    public static final int cICONST_1 = 4;
    public static final int cICONST_2 = 5;
    public static final int cICONST_3 = 6;
    public static final int cICONST_4 = 7;
    public static final int cICONST_5 = 8;
    public static final int cLCONST_0 = 9;
    public static final int cLCONST_1 = 10;
    public static final int cFCONST_0 = 11;
    public static final int cFCONST_1 = 12;
    public static final int cFCONST_2 = 13;
    public static final int cDCONST_0 = 14;
    public static final int cDCONST_1 = 15;
    public static final int cBIPUSH = 16;
    public static final int cSIPUSH = 17;
    public static final int cLDC = 18;
    public static final int cLDC_W = 19;
    public static final int cLDC2_W = 20;
    public static final int cILOAD = 21;
    public static final int cLLOAD = 22;
    public static final int cFLOAD = 23;
    public static final int cDLOAD = 24;
    public static final int cALOAD = 25;
    public static final int cILOAD_0 = 26;
    public static final int cILOAD_1 = 27;
    public static final int cILOAD_2 = 28;
    public static final int cILOAD_3 = 29;
    public static final int cLLOAD_0 = 30;
    public static final int cLLOAD_1 = 31;
    public static final int cLLOAD_2 = 32;
    public static final int cLLOAD_3 = 33;
    public static final int cFLOAD_0 = 34;
    public static final int cFLOAD_1 = 35;
    public static final int cFLOAD_2 = 36;
    public static final int cFLOAD_3 = 37;
    public static final int cDLOAD_0 = 38;
    public static final int cDLOAD_1 = 39;
    public static final int cDLOAD_2 = 40;
    public static final int cDLOAD_3 = 41;
    public static final int cALOAD_0 = 42;
    public static final int cALOAD_1 = 43;
    public static final int cALOAD_2 = 44;
    public static final int cALOAD_3 = 45;
    public static final int cIALOAD = 46;
    public static final int cLALOAD = 47;
    public static final int cFALOAD = 48;
    public static final int cDALOAD = 49;
    public static final int cAALOAD = 50;
    public static final int cBALOAD = 51;
    public static final int cCALOAD = 52;
    public static final int cSALOAD = 53;
    public static final int cISTORE = 54;
    public static final int cLSTORE = 55;
    public static final int cFSTORE = 56;
    public static final int cDSTORE = 57;
    public static final int cASTORE = 58;
    public static final int cISTORE_0 = 59;
    public static final int cISTORE_1 = 60;
    public static final int cISTORE_2 = 61;
    public static final int cISTORE_3 = 62;
    public static final int cLSTORE_0 = 63;
    public static final int cLSTORE_1 = 64;
    public static final int cLSTORE_2 = 65;
    public static final int cLSTORE_3 = 66;
    public static final int cFSTORE_0 = 67;
    public static final int cFSTORE_1 = 68;
    public static final int cFSTORE_2 = 69;
    public static final int cFSTORE_3 = 70;
    public static final int cDSTORE_0 = 71;
    public static final int cDSTORE_1 = 72;
    public static final int cDSTORE_2 = 73;
    public static final int cDSTORE_3 = 74;
    public static final int cASTORE_0 = 75;
    public static final int cASTORE_1 = 76;
    public static final int cASTORE_2 = 77;
    public static final int cASTORE_3 = 78;
    public static final int cIASTORE = 79;
    public static final int cLASTORE = 80;
    public static final int cFASTORE = 81;
    public static final int cDASTORE = 82;
    public static final int cAASTORE = 83;
    public static final int cBASTORE = 84;
    public static final int cCASTORE = 85;
    public static final int cSASTORE = 86;
    public static final int cPOP = 87;
    public static final int cPOP2 = 88;
    public static final int cDUP = 89;
    public static final int cDUP_X1 = 90;
    public static final int cDUP_X2 = 91;
    public static final int cDUP2 = 92;
    public static final int cDUP2_X1 = 93;
    public static final int cDUP2_X2 = 94;
    public static final int cSWAP = 95;
    public static final int cIADD = 96;
    public static final int cLADD = 97;
    public static final int cFADD = 98;
    public static final int cDADD = 99;
    public static final int cISUB = 100;
    public static final int cLSUB = 101;
    public static final int cFSUB = 102;
    public static final int cDSUB = 103;
    public static final int cIMUL = 104;
    public static final int cLMUL = 105;
    public static final int cFMUL = 106;
    public static final int cDMUL = 107;
    public static final int cIDIV = 108;
    public static final int cLDIV = 109;
    public static final int cFDIV = 110;
    public static final int cDDIV = 111;
    public static final int cIREM = 112;
    public static final int cLREM = 113;
    public static final int cFREM = 114;
    public static final int cDREM = 115;
    public static final int cINEG = 116;
    public static final int cLNEG = 117;
    public static final int cFNEG = 118;
    public static final int cDNEG = 119;
    public static final int cISHL = 120;
    public static final int cLSHL = 121;
    public static final int cISHR = 122;
    public static final int cLSHR = 123;
    public static final int cIUSHR = 124;
    public static final int cLUSHR = 125;
    public static final int cIAND = 126;
    public static final int cLAND = 127;
    public static final int cIOR = 128;
    public static final int cLOR = 129;
    public static final int cIXOR = 130;
    public static final int cLXOR = 131;
    public static final int cIINC = 132;
    public static final int cI2L = 133;
    public static final int cI2F = 134;
    public static final int cI2D = 135;
    public static final int cL2I = 136;
    public static final int cL2F = 137;
    public static final int cL2D = 138;
    public static final int cF2I = 139;
    public static final int cF2L = 140;
    public static final int cF2D = 141;
    public static final int cD2I = 142;
    public static final int cD2L = 143;
    public static final int cD2F = 144;
    public static final int cI2B = 145;
    public static final int cI2C = 146;
    public static final int cI2S = 147;
    public static final int cLCMP = 148;
    public static final int cFCMPL = 149;
    public static final int cFCMPG = 150;
    public static final int cDCMPL = 151;
    public static final int cDCMPG = 152;
    public static final int cIFEQ = 153;
    public static final int cIFNE = 154;
    public static final int cIFLT = 155;
    public static final int cIFGE = 156;
    public static final int cIFGT = 157;
    public static final int cIFLE = 158;
    public static final int cIF_ICMPEQ = 159;
    public static final int cIF_ICMPNE = 160;
    public static final int cIF_ICMPLT = 161;
    public static final int cIF_ICMPGE = 162;
    public static final int cIF_ICMPGT = 163;
    public static final int cIF_ICMPLE = 164;
    public static final int cIF_ACMPEQ = 165;
    public static final int cIF_ACMPNE = 166;
    public static final int cGOTO = 167;
    public static final int cJSR = 168;
    public static final int cRET = 169;
    public static final int cTABLESWITCH = 170;
    public static final int cLOOKUPSWITCH = 171;
    public static final int cIRETURN = 172;
    public static final int cLRETURN = 173;
    public static final int cFRETURN = 174;
    public static final int cDRETURN = 175;
    public static final int cARETURN = 176;
    public static final int cRETURN = 177;
    public static final int cGETSTATIC = 178;
    public static final int cPUTSTATIC = 179;
    public static final int cGETFIELD = 180;
    public static final int cPUTFIELD = 181;
    public static final int cINVOKEVIRTUAL = 182;
    public static final int cINVOKESPECIAL = 183;
    public static final int cINVOKESTATIC = 184;
    public static final int cINVOKEINTERFACE = 185;
    public static final int cNEW = 187;
    public static final int cNEWARRAY = 188;
    public static final int cANEWARRAY = 189;
    public static final int cARRAYLENGTH = 190;
    public static final int cATHROW = 191;
    public static final int cCHECKCAST = 192;
    public static final int cINSTANCEOF = 193;
    public static final int cMONITORENTER = 194;
    public static final int cMONITOREXIT = 195;
    public static final int cWIDE = 196;
    public static final int cMULTIANEWARRAY = 197;
    public static final int cIFNULL = 198;
    public static final int cIFNONNULL = 199;
    public static final int cGOTO_W = 200;
    public static final int cJSR_W = 201;
    public static final JOpcode NOP = new JOpcode("NOP", 0, 1, NO_DATA, NO_DATA, 1);
    public static final JOpcode ACONST_NULL = new JOpcode("ACONST_NULL", 1, 1, REFERENCE_TYPE, NO_DATA, 1);
    public static final JOpcode ICONST_M1 = new JOpcode("ICONST_M1", 2, 1, INT_TYPE, NO_DATA, 1);
    public static final JOpcode ICONST_0 = new JOpcode("ICONST_0", 3, 1, INT_TYPE, NO_DATA, 1);
    public static final JOpcode ICONST_1 = new JOpcode("ICONST_1", 4, 1, INT_TYPE, NO_DATA, 1);
    public static final JOpcode ICONST_2 = new JOpcode("ICONST_2", 5, 1, INT_TYPE, NO_DATA, 1);
    public static final JOpcode ICONST_3 = new JOpcode("ICONST_3", 6, 1, INT_TYPE, NO_DATA, 1);
    public static final JOpcode ICONST_4 = new JOpcode("ICONST_4", 7, 1, INT_TYPE, NO_DATA, 1);
    public static final JOpcode ICONST_5 = new JOpcode("ICONST_5", 8, 1, INT_TYPE, NO_DATA, 1);
    public static final JOpcode LCONST_0 = new JOpcode("LCONST_0", 9, 1, LONG_TYPE, NO_DATA, 1);
    public static final JOpcode LCONST_1 = new JOpcode("LCONST_1", 10, 1, LONG_TYPE, NO_DATA, 1);
    public static final JOpcode FCONST_0 = new JOpcode("FCONST_0", 11, 1, FLOAT_TYPE, NO_DATA, 1);
    public static final JOpcode FCONST_1 = new JOpcode("FCONST_1", 12, 1, FLOAT_TYPE, NO_DATA, 1);
    public static final JOpcode FCONST_2 = new JOpcode("FCONST_2", 13, 1, FLOAT_TYPE, NO_DATA, 1);
    public static final JOpcode DCONST_0 = new JOpcode("DCONST_0", 14, 1, DOUBLE_TYPE, NO_DATA, 1);
    public static final JOpcode DCONST_1 = new JOpcode("DCONST_1", 15, 1, DOUBLE_TYPE, NO_DATA, 1);
    public static final JOpcode BIPUSH = new JOpcode("BIPUSH", 16, 2, INT_TYPE, NO_DATA, 1);
    public static final JOpcode SIPUSH = new JOpcode("SIPUSH", 17, 3, INT_TYPE, NO_DATA, 1);
    public static final JOpcode LDC = new JOpcode("LDC", 18, 2, UNKNOWN_TYPE, NO_DATA, 1);
    public static final JOpcode LDC_W = new JOpcode("LDC_W", 19, 3, UNKNOWN_TYPE, NO_DATA, 1);
    public static final JOpcode LDC2_W = new JOpcode("LDC2_W", 20, 3, UNKNOWN_TYPE, NO_DATA, 1);
    public static final JOpcode ILOAD = new JOpcode("ILOAD", 21, 2, INT_TYPE, NO_DATA, 1);
    public static final JOpcode LLOAD = new JOpcode("LLOAD", 22, 2, LONG_TYPE, NO_DATA, 1);
    public static final JOpcode FLOAD = new JOpcode("FLOAD", 23, 2, FLOAT_TYPE, NO_DATA, 1);
    public static final JOpcode DLOAD = new JOpcode("DLOAD", 24, 2, DOUBLE_TYPE, NO_DATA, 1);
    public static final JOpcode ALOAD = new JOpcode("ALOAD", 25, 2, REFERENCE_TYPE, NO_DATA, 1);
    public static final JOpcode ILOAD_0 = new JOpcode("ILOAD_0", 26, 1, INT_TYPE, NO_DATA, 1);
    public static final JOpcode ILOAD_1 = new JOpcode("ILOAD_1", 27, 1, INT_TYPE, NO_DATA, 1);
    public static final JOpcode ILOAD_2 = new JOpcode("ILOAD_2", 28, 1, INT_TYPE, NO_DATA, 1);
    public static final JOpcode ILOAD_3 = new JOpcode("ILOAD_3", 29, 1, INT_TYPE, NO_DATA, 1);
    public static final JOpcode LLOAD_0 = new JOpcode("LLOAD_0", 30, 1, LONG_TYPE, NO_DATA, 1);
    public static final JOpcode LLOAD_1 = new JOpcode("LLOAD_1", 31, 1, LONG_TYPE, NO_DATA, 1);
    public static final JOpcode LLOAD_2 = new JOpcode("LLOAD_2", 32, 1, LONG_TYPE, NO_DATA, 1);
    public static final JOpcode LLOAD_3 = new JOpcode("LLOAD_3", 33, 1, LONG_TYPE, NO_DATA, 1);
    public static final JOpcode FLOAD_0 = new JOpcode("FLOAD_0", 34, 1, FLOAT_TYPE, NO_DATA, 1);
    public static final JOpcode FLOAD_1 = new JOpcode("FLOAD_1", 35, 1, FLOAT_TYPE, NO_DATA, 1);
    public static final JOpcode FLOAD_2 = new JOpcode("FLOAD_2", 36, 1, FLOAT_TYPE, NO_DATA, 1);
    public static final JOpcode FLOAD_3 = new JOpcode("FLOAD_3", 37, 1, FLOAT_TYPE, NO_DATA, 1);
    public static final JOpcode DLOAD_0 = new JOpcode("DLOAD_0", 38, 1, DOUBLE_TYPE, NO_DATA, 1);
    public static final JOpcode DLOAD_1 = new JOpcode("DLOAD_1", 39, 1, DOUBLE_TYPE, NO_DATA, 1);
    public static final JOpcode DLOAD_2 = new JOpcode("DLOAD_2", 40, 1, DOUBLE_TYPE, NO_DATA, 1);
    public static final JOpcode DLOAD_3 = new JOpcode("DLOAD_3", 41, 1, DOUBLE_TYPE, NO_DATA, 1);
    public static final JOpcode ALOAD_0 = new JOpcode("ALOAD_0", 42, 1, REFERENCE_TYPE, NO_DATA, 1);
    public static final JOpcode ALOAD_1 = new JOpcode("ALOAD_1", 43, 1, REFERENCE_TYPE, NO_DATA, 1);
    public static final JOpcode ALOAD_2 = new JOpcode("ALOAD_2", 44, 1, REFERENCE_TYPE, NO_DATA, 1);
    public static final JOpcode ALOAD_3 = new JOpcode("ALOAD_3", 45, 1, REFERENCE_TYPE, NO_DATA, 1);
    public static final JOpcode IALOAD = new JOpcode("IALOAD", 46, 1, INT_TYPE, new JType[]{JType.INT, JArrayType.INT}, 1);
    public static final JOpcode LALOAD = new JOpcode("LALOAD", 47, 1, LONG_TYPE, new JType[]{JType.INT, JArrayType.LONG}, 1);
    public static final JOpcode FALOAD = new JOpcode("FALOAD", 48, 1, FLOAT_TYPE, new JType[]{JType.INT, JArrayType.FLOAT}, 1);
    public static final JOpcode DALOAD = new JOpcode("DALOAD", 49, 1, DOUBLE_TYPE, new JType[]{JType.INT, JArrayType.DOUBLE}, 1);
    public static final JOpcode AALOAD = new JOpcode("AALOAD", 50, 1, REFERENCE_TYPE, new JType[]{JType.INT, JArrayType.REFERENCE}, 1);
    public static final JOpcode BALOAD = new JOpcode("BALOAD", 51, 1, INT_TYPE, new JType[]{JType.INT, new JArrayType(JType.UNKNOWN)}, 1);
    public static final JOpcode CALOAD = new JOpcode("CALOAD", 52, 1, INT_TYPE, new JType[]{JType.INT, JArrayType.CHAR}, 1);
    public static final JOpcode SALOAD = new JOpcode("SALOAD", 53, 1, INT_TYPE, new JType[]{JType.INT, JArrayType.SHORT}, 1);
    public static final JOpcode ISTORE = new JOpcode("ISTORE", 54, 2, NO_DATA, INT_TYPE, 1);
    public static final JOpcode LSTORE = new JOpcode("LSTORE", 55, 2, NO_DATA, LONG_TYPE, 1);
    public static final JOpcode FSTORE = new JOpcode("FSTORE", 56, 2, NO_DATA, FLOAT_TYPE, 1);
    public static final JOpcode DSTORE = new JOpcode("DSTORE", 57, 2, NO_DATA, DOUBLE_TYPE, 1);
    public static final JOpcode ASTORE = new JOpcode("ASTORE", 58, 2, NO_DATA, REFERENCE_TYPE, 1);
    public static final JOpcode ISTORE_0 = new JOpcode("ISTORE_0", 59, 1, NO_DATA, INT_TYPE, 1);
    public static final JOpcode ISTORE_1 = new JOpcode("ISTORE_1", 60, 1, NO_DATA, INT_TYPE, 1);
    public static final JOpcode ISTORE_2 = new JOpcode("ISTORE_2", 61, 1, NO_DATA, INT_TYPE, 1);
    public static final JOpcode ISTORE_3 = new JOpcode("ISTORE_3", 62, 1, NO_DATA, INT_TYPE, 1);
    public static final JOpcode LSTORE_0 = new JOpcode("LSTORE_0", 63, 1, NO_DATA, LONG_TYPE, 1);
    public static final JOpcode LSTORE_1 = new JOpcode("LSTORE_1", 64, 1, NO_DATA, LONG_TYPE, 1);
    public static final JOpcode LSTORE_2 = new JOpcode("LSTORE_2", 65, 1, NO_DATA, LONG_TYPE, 1);
    public static final JOpcode LSTORE_3 = new JOpcode("LSTORE_3", 66, 1, NO_DATA, LONG_TYPE, 1);
    public static final JOpcode FSTORE_0 = new JOpcode("FSTORE_0", 67, 1, NO_DATA, FLOAT_TYPE, 1);
    public static final JOpcode FSTORE_1 = new JOpcode("FSTORE_1", 68, 1, NO_DATA, FLOAT_TYPE, 1);
    public static final JOpcode FSTORE_2 = new JOpcode("FSTORE_2", 69, 1, NO_DATA, FLOAT_TYPE, 1);
    public static final JOpcode FSTORE_3 = new JOpcode("FSTORE_3", 70, 1, NO_DATA, FLOAT_TYPE, 1);
    public static final JOpcode DSTORE_0 = new JOpcode("DSTORE_0", 71, 1, NO_DATA, DOUBLE_TYPE, 1);
    public static final JOpcode DSTORE_1 = new JOpcode("DSTORE_1", 72, 1, NO_DATA, DOUBLE_TYPE, 1);
    public static final JOpcode DSTORE_2 = new JOpcode("DSTORE_2", 73, 1, NO_DATA, DOUBLE_TYPE, 1);
    public static final JOpcode DSTORE_3 = new JOpcode("DSTORE_3", 74, 1, NO_DATA, DOUBLE_TYPE, 1);
    public static final JOpcode ASTORE_0 = new JOpcode("ASTORE_0", 75, 1, NO_DATA, REFERENCE_TYPE, 1);
    public static final JOpcode ASTORE_1 = new JOpcode("ASTORE_1", 76, 1, NO_DATA, REFERENCE_TYPE, 1);
    public static final JOpcode ASTORE_2 = new JOpcode("ASTORE_2", 77, 1, NO_DATA, REFERENCE_TYPE, 1);
    public static final JOpcode ASTORE_3 = new JOpcode("ASTORE_3", 78, 1, NO_DATA, REFERENCE_TYPE, 1);
    public static final JOpcode IASTORE = new JOpcode("IASTORE", 79, 1, NO_DATA, new JType[]{JType.INT, JType.INT, JArrayType.INT}, 1);
    public static final JOpcode LASTORE = new JOpcode("LASTORE", 80, 1, NO_DATA, new JType[]{JType.LONG, JType.INT, JArrayType.LONG}, 1);
    public static final JOpcode FASTORE = new JOpcode("FASTORE", 81, 1, NO_DATA, new JType[]{JType.FLOAT, JType.INT, JArrayType.FLOAT}, 1);
    public static final JOpcode DASTORE = new JOpcode("DASTORE", 82, 1, NO_DATA, new JType[]{JType.DOUBLE, JType.INT, JArrayType.DOUBLE}, 1);
    public static final JOpcode AASTORE = new JOpcode("AASTORE", 83, 1, NO_DATA, new JType[]{JType.REFERENCE, JType.INT, JArrayType.REFERENCE}, 1);
    public static final JOpcode BASTORE = new JOpcode("BASTORE", 84, 1, NO_DATA, new JType[]{JType.INT, JType.INT, new JArrayType(JType.UNKNOWN)}, 1);
    public static final JOpcode CASTORE = new JOpcode("CASTORE", 85, 1, NO_DATA, new JType[]{JType.INT, JType.INT, JArrayType.CHAR}, 1);
    public static final JOpcode SASTORE = new JOpcode("SASTORE", 86, 1, NO_DATA, new JType[]{JType.INT, JType.INT, JArrayType.SHORT}, 1);
    public static final JOpcode POP = new JOpcode("POP", 87, 1, NO_DATA, UNKNOWN_TYPE, 1);
    public static final JOpcode POP2 = new JOpcode("POP2", 88, 1, NO_DATA, UNKNOWN_TYPE, 1);
    public static final JOpcode DUP = new JOpcode("DUP", 89, 1, UNKNOWN_TYPE, UNKNOWN_TYPE, 1);
    public static final JOpcode DUP_X1 = new JOpcode("DUP_X1", 90, 1, UNKNOWN_TYPE, UNKNOWN_TYPE, 1);
    public static final JOpcode DUP_X2 = new JOpcode("DUP_X2", 91, 1, UNKNOWN_TYPE, UNKNOWN_TYPE, 1);
    public static final JOpcode DUP2 = new JOpcode("DUP2", 92, 1, UNKNOWN_TYPE, UNKNOWN_TYPE, 1);
    public static final JOpcode DUP2_X1 = new JOpcode("DUP2_X1", 93, 1, UNKNOWN_TYPE, UNKNOWN_TYPE, 1);
    public static final JOpcode DUP2_X2 = new JOpcode("DUP2_X2", 94, 1, UNKNOWN_TYPE, UNKNOWN_TYPE, 1);
    public static final JOpcode SWAP = new JOpcode("SWAP", 95, 1, UNKNOWN_TYPE, UNKNOWN_TYPE, 1);
    public static final JOpcode IADD = new JOpcode("IADD", 96, 1, INT_TYPE, new JType[]{JType.INT, JType.INT}, 1);
    public static final JOpcode LADD = new JOpcode("LADD", 97, 1, LONG_TYPE, new JType[]{JType.LONG, JType.LONG}, 1);
    public static final JOpcode FADD = new JOpcode("FADD", 98, 1, FLOAT_TYPE, new JType[]{JType.FLOAT, JType.FLOAT}, 1);
    public static final JOpcode DADD = new JOpcode("DADD", 99, 1, DOUBLE_TYPE, new JType[]{JType.DOUBLE, JType.DOUBLE}, 1);
    public static final JOpcode ISUB = new JOpcode("ISUB", 100, 1, INT_TYPE, new JType[]{JType.INT, JType.INT}, 1);
    public static final JOpcode LSUB = new JOpcode("LSUB", 101, 1, LONG_TYPE, new JType[]{JType.LONG, JType.LONG}, 1);
    public static final JOpcode FSUB = new JOpcode("FSUB", 102, 1, FLOAT_TYPE, new JType[]{JType.FLOAT, JType.FLOAT}, 1);
    public static final JOpcode DSUB = new JOpcode("DSUB", 103, 1, DOUBLE_TYPE, new JType[]{JType.DOUBLE, JType.DOUBLE}, 1);
    public static final JOpcode IMUL = new JOpcode("IMUL", 104, 1, INT_TYPE, new JType[]{JType.INT, JType.INT}, 1);
    public static final JOpcode LMUL = new JOpcode("LMUL", 105, 1, LONG_TYPE, new JType[]{JType.LONG, JType.LONG}, 1);
    public static final JOpcode FMUL = new JOpcode("FMUL", 106, 1, FLOAT_TYPE, new JType[]{JType.FLOAT, JType.FLOAT}, 1);
    public static final JOpcode DMUL = new JOpcode("DMUL", 107, 1, DOUBLE_TYPE, new JType[]{JType.DOUBLE, JType.DOUBLE}, 1);
    public static final JOpcode IDIV = new JOpcode("IDIV", 108, 1, INT_TYPE, new JType[]{JType.INT, JType.INT}, 1);
    public static final JOpcode LDIV = new JOpcode("LDIV", 109, 1, LONG_TYPE, new JType[]{JType.LONG, JType.LONG}, 1);
    public static final JOpcode FDIV = new JOpcode("FDIV", 110, 1, FLOAT_TYPE, new JType[]{JType.FLOAT, JType.FLOAT}, 1);
    public static final JOpcode DDIV = new JOpcode("DDIV", 111, 1, DOUBLE_TYPE, new JType[]{JType.DOUBLE, JType.DOUBLE}, 1);
    public static final JOpcode IREM = new JOpcode("IREM", 112, 1, INT_TYPE, new JType[]{JType.INT, JType.INT}, 1);
    public static final JOpcode LREM = new JOpcode("LREM", 113, 1, LONG_TYPE, new JType[]{JType.LONG, JType.LONG}, 1);
    public static final JOpcode FREM = new JOpcode("FREM", 114, 1, FLOAT_TYPE, new JType[]{JType.FLOAT, JType.FLOAT}, 1);
    public static final JOpcode DREM = new JOpcode("DREM", 115, 1, DOUBLE_TYPE, new JType[]{JType.DOUBLE, JType.DOUBLE}, 1);
    public static final JOpcode INEG = new JOpcode("INEG", 116, 1, INT_TYPE, INT_TYPE, 1);
    public static final JOpcode LNEG = new JOpcode("LNEG", 117, 1, LONG_TYPE, LONG_TYPE, 1);
    public static final JOpcode FNEG = new JOpcode("FNEG", 118, 1, FLOAT_TYPE, FLOAT_TYPE, 1);
    public static final JOpcode DNEG = new JOpcode("DNEG", 119, 1, DOUBLE_TYPE, DOUBLE_TYPE, 1);
    public static final JOpcode ISHL = new JOpcode("ISHL", 120, 1, INT_TYPE, new JType[]{JType.INT, JType.INT}, 1);
    public static final JOpcode LSHL = new JOpcode("LSHL", 121, 1, LONG_TYPE, new JType[]{JType.INT, JType.LONG}, 1);
    public static final JOpcode ISHR = new JOpcode("ISHR", 122, 1, INT_TYPE, new JType[]{JType.INT, JType.INT}, 1);
    public static final JOpcode LSHR = new JOpcode("LSHR", 123, 1, LONG_TYPE, new JType[]{JType.INT, JType.LONG}, 1);
    public static final JOpcode IUSHR = new JOpcode("IUSHR", 124, 1, INT_TYPE, new JType[]{JType.INT, JType.INT}, 1);
    public static final JOpcode LUSHR = new JOpcode("LUSHR", 125, 1, LONG_TYPE, new JType[]{JType.INT, JType.LONG}, 1);
    public static final JOpcode IAND = new JOpcode("IAND", 126, 1, INT_TYPE, new JType[]{JType.INT, JType.INT}, 1);
    public static final JOpcode LAND = new JOpcode("LAND", 127, 1, LONG_TYPE, new JType[]{JType.LONG, JType.LONG}, 1);
    public static final JOpcode IOR = new JOpcode("IOR", 128, 1, INT_TYPE, new JType[]{JType.INT, JType.INT}, 1);
    public static final JOpcode LOR = new JOpcode("LOR", 129, 1, LONG_TYPE, new JType[]{JType.LONG, JType.LONG}, 1);
    public static final JOpcode IXOR = new JOpcode("IXOR", 130, 1, INT_TYPE, new JType[]{JType.INT, JType.INT}, 1);
    public static final JOpcode LXOR = new JOpcode("LXOR", 131, 1, LONG_TYPE, new JType[]{JType.LONG, JType.LONG}, 1);
    public static final JOpcode IINC = new JOpcode("IINC", 132, 3, NO_DATA, NO_DATA, 1);
    public static final JOpcode I2L = new JOpcode("I2L", 133, 1, LONG_TYPE, INT_TYPE, 1);
    public static final JOpcode I2F = new JOpcode("I2F", 134, 1, FLOAT_TYPE, INT_TYPE, 1);
    public static final JOpcode I2D = new JOpcode("I2D", 135, 1, DOUBLE_TYPE, INT_TYPE, 1);
    public static final JOpcode L2I = new JOpcode("L2I", 136, 1, INT_TYPE, LONG_TYPE, 1);
    public static final JOpcode L2F = new JOpcode("L2F", 137, 1, FLOAT_TYPE, LONG_TYPE, 1);
    public static final JOpcode L2D = new JOpcode("L2D", 138, 1, DOUBLE_TYPE, LONG_TYPE, 1);
    public static final JOpcode F2I = new JOpcode("F2I", 139, 1, INT_TYPE, FLOAT_TYPE, 1);
    public static final JOpcode F2L = new JOpcode("F2L", 140, 1, LONG_TYPE, FLOAT_TYPE, 1);
    public static final JOpcode F2D = new JOpcode("F2D", 141, 1, DOUBLE_TYPE, FLOAT_TYPE, 1);
    public static final JOpcode D2I = new JOpcode("D2I", 142, 1, INT_TYPE, DOUBLE_TYPE, 1);
    public static final JOpcode D2L = new JOpcode("D2L", 143, 1, LONG_TYPE, DOUBLE_TYPE, 1);
    public static final JOpcode D2F = new JOpcode("D2F", 144, 1, FLOAT_TYPE, DOUBLE_TYPE, 1);
    public static final JOpcode I2B = new JOpcode("I2B", 145, 1, INT_TYPE, INT_TYPE, 1);
    public static final JOpcode I2C = new JOpcode("I2C", 146, 1, INT_TYPE, INT_TYPE, 1);
    public static final JOpcode I2S = new JOpcode("I2S", 147, 1, INT_TYPE, INT_TYPE, 1);
    public static final JOpcode LCMP = new JOpcode("LCMP", 148, 1, INT_TYPE, new JType[]{JType.LONG, JType.LONG}, 1);
    public static final JOpcode FCMPL = new JOpcode("FCMPL", 149, 1, INT_TYPE, new JType[]{JType.FLOAT, JType.FLOAT}, 1);
    public static final JOpcode FCMPG = new JOpcode("FCMPG", 150, 1, INT_TYPE, new JType[]{JType.FLOAT, JType.FLOAT}, 1);
    public static final JOpcode DCMPL = new JOpcode("DCMPL", 151, 1, INT_TYPE, new JType[]{JType.LONG, JType.LONG}, 1);
    public static final JOpcode DCMPG = new JOpcode("DCMPG", 152, 1, INT_TYPE, new JType[]{JType.DOUBLE, JType.DOUBLE}, 1);
    public static final JOpcode IFEQ = new JOpcode("IFEQ", 153, 3, NO_DATA, INT_TYPE, 4);
    public static final JOpcode IFNE = new JOpcode("IFNE", 154, 3, NO_DATA, INT_TYPE, 4);
    public static final JOpcode IFLT = new JOpcode("IFLT", 155, 3, NO_DATA, INT_TYPE, 4);
    public static final JOpcode IFGE = new JOpcode("IFGE", 156, 3, NO_DATA, INT_TYPE, 4);
    public static final JOpcode IFGT = new JOpcode("IFGT", 157, 3, NO_DATA, INT_TYPE, 4);
    public static final JOpcode IFLE = new JOpcode("IFLE", 158, 3, NO_DATA, INT_TYPE, 4);
    public static final JOpcode IF_ICMPEQ = new JOpcode("IF_ICMPEQ", 159, 3, NO_DATA, new JType[]{JType.INT, JType.INT}, 4);
    public static final JOpcode IF_ICMPNE = new JOpcode("IF_ICMPNE", 160, 3, NO_DATA, new JType[]{JType.INT, JType.INT}, 4);
    public static final JOpcode IF_ICMPLT = new JOpcode("IF_ICMPLT", 161, 3, NO_DATA, new JType[]{JType.INT, JType.INT}, 4);
    public static final JOpcode IF_ICMPGE = new JOpcode("IF_ICMPGE", 162, 3, NO_DATA, new JType[]{JType.INT, JType.INT}, 4);
    public static final JOpcode IF_ICMPGT = new JOpcode("IF_ICMPGT", 163, 3, NO_DATA, new JType[]{JType.INT, JType.INT}, 4);
    public static final JOpcode IF_ICMPLE = new JOpcode("IF_ICMPLE", 164, 3, NO_DATA, new JType[]{JType.INT, JType.INT}, 4);
    public static final JOpcode IF_ACMPEQ = new JOpcode("IF_ACMPEQ", 165, 3, NO_DATA, new JType[]{JType.REFERENCE, JType.REFERENCE}, 4);
    public static final JOpcode IF_ACMPNE = new JOpcode("IF_ACMPNE", 166, 3, NO_DATA, new JType[]{JType.REFERENCE, JType.REFERENCE}, 4);
    public static final JOpcode GOTO = new JOpcode("GOTO", 167, 3, NO_DATA, NO_DATA, 2);
    public static final JOpcode JSR = new JOpcode("JSR", 168, 3, ADDRESS_TYPE, NO_DATA, Integer.MIN_VALUE);
    public static final JOpcode RET = new JOpcode("RET", 169, 2, NO_DATA, NO_DATA, Integer.MIN_VALUE);
    public static final JOpcode TABLESWITCH = new JOpcode("TABLESWITCH", 170, Integer.MIN_VALUE, NO_DATA, INT_TYPE, 5);
    public static final JOpcode LOOKUPSWITCH = new JOpcode("LOOKUPSWITCH", 171, Integer.MIN_VALUE, NO_DATA, INT_TYPE, 6);
    public static final JOpcode IRETURN = new JOpcode("IRETURN", 172, 1, NO_DATA, INT_TYPE, 0);
    public static final JOpcode LRETURN = new JOpcode("LRETURN", 173, 1, NO_DATA, LONG_TYPE, 0);
    public static final JOpcode FRETURN = new JOpcode("FRETURN", 174, 1, NO_DATA, FLOAT_TYPE, 0);
    public static final JOpcode DRETURN = new JOpcode("DRETURN", 175, 1, NO_DATA, DOUBLE_TYPE, 0);
    public static final JOpcode ARETURN = new JOpcode("ARETURN", 176, 1, NO_DATA, OBJECT_REF_TYPE, 0);
    public static final JOpcode RETURN = new JOpcode("RETURN", 177, 1, NO_DATA, NO_DATA, 0);
    public static final JOpcode GETSTATIC = new JOpcode("GETSTATIC", 178, 3, UNKNOWN_TYPE, NO_DATA, 1);
    public static final JOpcode PUTSTATIC = new JOpcode("PUTSTATIC", 179, 3, NO_DATA, UNKNOWN_TYPE, 1);
    public static final JOpcode GETFIELD = new JOpcode("GETFIELD", 180, 3, UNKNOWN_TYPE, OBJECT_REF_TYPE, 1);
    public static final JOpcode PUTFIELD = new JOpcode("PUTFIELD", 181, 3, NO_DATA, UNKNOWN_TYPE, 1);
    public static final JOpcode INVOKEVIRTUAL = new JOpcode("INVOKEVIRTUAL", 182, 3, NO_DATA, UNKNOWN_TYPE, 1);
    public static final JOpcode INVOKESPECIAL = new JOpcode("INVOKESPECIAL", 183, 3, NO_DATA, UNKNOWN_TYPE, 1);
    public static final JOpcode INVOKESTATIC = new JOpcode("INVOKESTATIC", 184, 3, NO_DATA, UNKNOWN_TYPE, 1);
    public static final JOpcode INVOKEINTERFACE = new JOpcode("INVOKEINTERFACE", 185, 5, NO_DATA, UNKNOWN_TYPE, 1);
    public static final JOpcode NEW = new JOpcode("NEW", 187, 3, OBJECT_REF_TYPE, NO_DATA, 1);
    public static final JOpcode NEWARRAY = new JOpcode("NEWARRAY", 188, 2, ARRAY_REF_TYPE, INT_TYPE, 1);
    public static final JOpcode ANEWARRAY = new JOpcode("ANEWARRAY", 189, 3, ARRAY_REF_TYPE, INT_TYPE, 1);
    public static final JOpcode ARRAYLENGTH = new JOpcode("ARRAYLENGTH", 190, 1, INT_TYPE, ARRAY_REF_TYPE, 1);
    public static final JOpcode ATHROW = new JOpcode("ATHROW", 191, 1, OBJECT_REF_TYPE, OBJECT_REF_TYPE, 0);
    public static final JOpcode CHECKCAST = new JOpcode("CHECKCAST", 192, 3, OBJECT_REF_TYPE, OBJECT_REF_TYPE, 1);
    public static final JOpcode INSTANCEOF = new JOpcode("INSTANCEOF", 193, 3, INT_TYPE, OBJECT_REF_TYPE, 1);
    public static final JOpcode MONITORENTER = new JOpcode("MONITORENTER", 194, 1, NO_DATA, OBJECT_REF_TYPE, 1);
    public static final JOpcode MONITOREXIT = new JOpcode("MONITOREXIT", 195, 1, NO_DATA, OBJECT_REF_TYPE, 1);
    public static final JOpcode WIDE = new JOpcode("WIDE", 196, Integer.MIN_VALUE, UNKNOWN_TYPE, UNKNOWN_TYPE, 1);
    public static final JOpcode MULTIANEWARRAY = new JOpcode("MULTIANEWARRAY", 197, 4, ARRAY_REF_TYPE, UNKNOWN_TYPE, 1);
    public static final JOpcode IFNULL = new JOpcode("IFNULL", 198, 3, NO_DATA, REFERENCE_TYPE, 4);
    public static final JOpcode IFNONNULL = new JOpcode("IFNONNULL", 199, 3, NO_DATA, REFERENCE_TYPE, 4);
    public static final JOpcode GOTO_W = new JOpcode("GOTO_W", 200, 5, NO_DATA, NO_DATA, 3);
    public static final JOpcode JSR_W = new JOpcode("JSR_W", 201, 5, ADDRESS_TYPE, NO_DATA, 1);
    public static final JOpcode[] OPCODES = new JOpcode[]{NOP, ACONST_NULL, ICONST_M1, ICONST_0, ICONST_1, ICONST_2, ICONST_3, ICONST_4, ICONST_5, LCONST_0, LCONST_1, FCONST_0, FCONST_1, FCONST_2, DCONST_0, DCONST_1, BIPUSH, SIPUSH, LDC, LDC_W, LDC2_W, ILOAD, LLOAD, FLOAD, DLOAD, ALOAD, ILOAD_0, ILOAD_1, ILOAD_2, ILOAD_3, LLOAD_0, LLOAD_1, LLOAD_2, LLOAD_3, FLOAD_0, FLOAD_1, FLOAD_2, FLOAD_3, DLOAD_0, DLOAD_1, DLOAD_2, DLOAD_3, ALOAD_0, ALOAD_1, ALOAD_2, ALOAD_3, IALOAD, LALOAD, FALOAD, DALOAD, AALOAD, BALOAD, CALOAD, SALOAD, ISTORE, LSTORE, FSTORE, DSTORE, ASTORE, ISTORE_0, ISTORE_1, ISTORE_2, ISTORE_3, LSTORE_0, LSTORE_1, LSTORE_2, LSTORE_3, FSTORE_0, FSTORE_1, FSTORE_2, FSTORE_3, DSTORE_0, DSTORE_1, DSTORE_2, DSTORE_3, ASTORE_0, ASTORE_1, ASTORE_2, ASTORE_3, IASTORE, LASTORE, FASTORE, DASTORE, AASTORE, BASTORE, CASTORE, SASTORE, POP, POP2, DUP, DUP_X1, DUP_X2, DUP2, DUP2_X1, DUP2_X2, SWAP, IADD, LADD, FADD, DADD, ISUB, LSUB, FSUB, DSUB, IMUL, LMUL, FMUL, DMUL, IDIV, LDIV, FDIV, DDIV, IREM, LREM, FREM, DREM, INEG, LNEG, FNEG, DNEG, ISHL, LSHL, ISHR, LSHR, IUSHR, LUSHR, IAND, LAND, IOR, LOR, IXOR, LXOR, IINC, I2L, I2F, I2D, L2I, L2F, L2D, F2I, F2L, F2D, D2I, D2L, D2F, I2B, I2C, I2S, LCMP, FCMPL, FCMPG, DCMPL, DCMPG, IFEQ, IFNE, IFLT, IFGE, IFGT, IFLE, IF_ICMPEQ, IF_ICMPNE, IF_ICMPLT, IF_ICMPGE, IF_ICMPGT, IF_ICMPLE, IF_ACMPEQ, IF_ACMPNE, GOTO, JSR, RET, TABLESWITCH, LOOKUPSWITCH, IRETURN, LRETURN, FRETURN, DRETURN, ARETURN, RETURN, GETSTATIC, PUTSTATIC, GETFIELD, PUTFIELD, INVOKEVIRTUAL, INVOKESPECIAL, INVOKESTATIC, INVOKEINTERFACE, null, NEW, NEWARRAY, ANEWARRAY, ARRAYLENGTH, ATHROW, CHECKCAST, INSTANCEOF, MONITORENTER, MONITOREXIT, WIDE, MULTIANEWARRAY, IFNULL, IFNONNULL, GOTO_W, JSR_W};

    protected JOpcode(String name, int code, int size, JType[] producedDataTypes, JType[] consumedDataTypes, int jumpKind) {
        this.name = name;
        this.code = code;
        this.size = size;
        this.producedDataTypes = producedDataTypes;
        this.consumedDataTypes = consumedDataTypes;
        this.jumpKind = jumpKind;
        switch (jumpKind) {
            case 0: {
                this.successorCount = 0;
                break;
            }
            case 1: {
                this.successorCount = 1;
                break;
            }
            case 2: {
                this.successorCount = 1;
                break;
            }
            case 3: {
                this.successorCount = 1;
                break;
            }
            case 4: {
                this.successorCount = 2;
                break;
            }
            case 5: {
                this.successorCount = Integer.MIN_VALUE;
                break;
            }
            case 6: {
                this.successorCount = Integer.MIN_VALUE;
                break;
            }
            default: {
                this.successorCount = Integer.MIN_VALUE;
            }
        }
    }

    public String toString() {
        return this.name;
    }

    protected int getSize() {
        return this.size;
    }

    protected JType[] getProducedDataTypes() {
        return this.producedDataTypes;
    }

    protected JType[] getConsumedDataTypes() {
        return this.consumedDataTypes;
    }

    protected int getProducedDataSize() {
        if (this.producedDataTypes != UNKNOWN_TYPE) {
            return JType.getTotalSize(this.producedDataTypes);
        }
        switch (this.code) {
            case 18: 
            case 19: 
            case 51: {
                return 1;
            }
            case 20: 
            case 89: 
            case 95: {
                return 2;
            }
            case 90: {
                return 3;
            }
            case 91: 
            case 92: {
                return 4;
            }
            case 93: {
                return 5;
            }
            case 94: {
                return 6;
            }
        }
        throw new Error(this.toString());
    }

    protected int getConsumedDataSize() {
        if (this.consumedDataTypes != UNKNOWN_TYPE) {
            return JType.getTotalSize(this.consumedDataTypes);
        }
        switch (this.code) {
            case 87: 
            case 89: {
                return 1;
            }
            case 88: 
            case 90: 
            case 92: 
            case 95: {
                return 2;
            }
            case 91: 
            case 93: {
                return 3;
            }
            case 94: {
                return 4;
            }
        }
        throw new Error(this.toString());
    }

    protected int getProducedDataTypesNumber() {
        if (this.producedDataTypes != UNKNOWN_TYPE) {
            return this.producedDataTypes.length;
        }
        switch (this.code) {
            case 18: 
            case 19: 
            case 20: 
            case 51: 
            case 178: 
            case 180: {
                return 1;
            }
            case 89: 
            case 95: {
                return 2;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                return 2;
            }
            case 90: {
                return 3;
            }
        }
        throw new Error(this.toString());
    }

    protected int getConsumedDataTypesNumber() {
        if (this.consumedDataTypes != UNKNOWN_TYPE) {
            return this.consumedDataTypes.length;
        }
        switch (this.code) {
            case 87: 
            case 89: 
            case 179: {
                return 1;
            }
            case 88: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 181: {
                return 2;
            }
        }
        throw new Error(this.toString());
    }
}

