/*
 * Decompiled with CFR 0.152.
 */
package scalac.transformer.matching;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import scalac.ApplicationError;
import scalac.transformer.matching.Label;

public class NondetWordAutom {
    protected int nstates;
    protected HashSet labels;
    protected TreeMap finals;
    public HashMap[] deltaq;
    public Vector[] defaultq;
    TreeSet initials;
    boolean leftTrans;
    boolean rightTrans;
    public Vector[] qbinders;
    int[] offset;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public int nstates() {
        return this.nstates;
    }

    public HashSet labels() {
        return this.labels;
    }

    public HashMap deltaq(int n) {
        return this.deltaq[n];
    }

    public HashMap deltaq(Integer n) {
        return this.deltaq[n];
    }

    public Vector defaultq(int n) {
        return this.defaultq[n];
    }

    public Vector defaultq(Integer n) {
        return this.defaultq[n];
    }

    public boolean isFinal(int n) {
        return this.finals != null && this.finals.get(new Integer(n)) != null;
    }

    public boolean isFinal(Integer n) {
        return this.finals != null && this.finals.containsKey(n);
    }

    public Integer finalTag(Integer n) {
        return (Integer)this.finals.get(n);
    }

    public Integer finalTag(int n) {
        return (Integer)this.finals.get(new Integer(n));
    }

    boolean containsFinal(TreeSet treeSet) {
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            if (!this.isFinal((Integer)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.finals.isEmpty();
    }

    public boolean producesRun() {
        return this.leftTrans;
    }

    public boolean consumesRun() {
        return this.rightTrans;
    }

    public boolean initial(Integer n) {
        return this.initials.contains(n);
    }

    TreeSet getSide(TreeSet treeSet, Object object) {
        TreeSet treeSet2 = new TreeSet();
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            Vector vector = (Vector)this.deltaq[n].get(object);
            if (vector != null) {
                treeSet2.addAll(vector);
            }
            treeSet2.addAll(this.defaultq(n));
        }
        return treeSet2;
    }

    public Object defaultq(Set set) {
        TreeSet treeSet = new TreeSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            treeSet.addAll(this.defaultq(n));
        }
        return treeSet;
    }

    Integer finalTag(Set set) {
        int n = Integer.MAX_VALUE;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            Integer n3 = (Integer)this.finals.get(n2);
            if (n3 == null || n3 >= n) continue;
            n = n3;
        }
        if (n == Integer.MAX_VALUE) {
            throw new ApplicationError("there should be a final state ");
        }
        return new Integer(n);
    }

    protected Map mapmap(Map map, int n, Map map2, boolean bl, boolean bl2) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Object object2 = map.get(object);
            if (bl) {
                object = new Integer((Integer)object + n);
            }
            if (bl2) {
                object2 = NondetWordAutom.vmap(n, (Vector)object2);
            }
            map2.put(object, object2);
        }
        return map2;
    }

    protected static Vector vmap(int n, Vector vector) {
        if (vector == null) {
            return null;
        }
        Vector<Integer> vector2 = new Vector<Integer>(vector.size());
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            vector2.add(new Integer(n2 + n));
        }
        return vector2;
    }

    protected void relocate(int n, TreeMap treeMap, HashMap[] hashMapArray, Vector[] vectorArray, Vector[] vectorArray2) {
        this.mapmap(this.finals, n, treeMap, true, false);
        for (int i = 0; i < this.nstates; ++i) {
            hashMapArray[i + n] = (HashMap)this.mapmap(this.deltaq[i], n, new HashMap(), false, true);
            vectorArray[i + n] = NondetWordAutom.vmap(n, this.defaultq[i]);
        }
        if (vectorArray2 != null && this.qbinders != null) {
            for (int i = 0; i < this.nstates; ++i) {
                if (!$assertionsDisabled && vectorArray2 == null) {
                    throw new AssertionError();
                }
                vectorArray2[i + n] = this.qbinders[i];
            }
        }
    }

    protected void normalize(TreeSet treeSet, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        HashMap hashMap = new HashMap();
        TreeSet treeSet2 = new TreeSet();
        Integer n = new Integer(0);
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            serializable = (Integer)this.finals.get(n2);
            if (serializable != null && this.finals.get(n) == null) {
                this.finals.put(n, serializable);
            }
            object3 = this.deltaq(n2);
            if (bl) {
                object3 = (HashMap)this.mapmap((Map)object3, 1, new HashMap(), false, true);
            }
            object2 = ((HashMap)object3).keySet().iterator();
            while (object2.hasNext()) {
                object = (Label)object2.next();
                Vector vector = (Vector)hashMap.get(object);
                if (vector == null) {
                    vector = new Vector();
                    hashMap.put((Vector[])object, vector);
                }
                Vector vector2 = (Vector)((HashMap)object3).get(object);
                vector.addAll(vector2);
            }
            if (this.defaultq(n2) == null) continue;
            treeSet2.addAll(this.defaultq(n2));
        }
        if (bl) {
            int n3 = 1 + this.nstates;
            serializable = new TreeMap();
            object3 = new HashMap[n3];
            object2 = new Vector[n3];
            object = null;
            if (this.qbinders != null) {
                object = new Vector[n3];
            }
            this.relocate(1, (TreeMap)serializable, (HashMap[])object3, (Vector[])object2, (Vector[])object);
            this.nstates = n3;
            this.finals = serializable;
            this.deltaq = object3;
            this.defaultq = object2;
            this.qbinders = object;
        }
        this.deltaq[0] = hashMap;
        this.defaultq[0] = new Vector(treeSet2);
        this.initials = new TreeSet();
        this.initials.add(n);
    }

    NondetWordAutom() {
    }

    public NondetWordAutom(int n, HashSet hashSet, TreeSet treeSet, TreeMap treeMap, HashMap[] hashMapArray, Vector[] vectorArray, Object object) {
        this.nstates = n;
        this.labels = hashSet;
        this.initials = treeSet;
        this.finals = treeMap;
        this.deltaq = hashMapArray;
        this.defaultq = vectorArray;
        this.qbinders = (Vector[])object;
    }

    protected void collectLabels(NondetWordAutom[] nondetWordAutomArray) {
        this.labels = new HashSet();
        for (int i = 0; i < nondetWordAutomArray.length; ++i) {
            this.labels.addAll(nondetWordAutomArray[i].labels);
        }
    }

    protected void collectOffsets(NondetWordAutom[] nondetWordAutomArray) {
        this.offset = new int[nondetWordAutomArray.length + 1];
        this.offset[0] = 1;
        for (int i = 0; i < nondetWordAutomArray.length; ++i) {
            this.offset[i + 1] = nondetWordAutomArray[i].nstates + this.offset[i];
        }
    }

    static Set collectVariables(NondetWordAutom nondetWordAutom) {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < nondetWordAutom.nstates; ++i) {
            if (nondetWordAutom.qbinders[i] == null) continue;
            hashSet.addAll(nondetWordAutom.qbinders[i]);
        }
        return hashSet;
    }

    public NondetWordAutom(NondetWordAutom[] nondetWordAutomArray) {
        int n = nondetWordAutomArray.length;
        this.collectLabels(nondetWordAutomArray);
        this.collectOffsets(nondetWordAutomArray);
        this.nstates = this.offset[nondetWordAutomArray.length];
        this.finals = new TreeMap();
        this.qbinders = new Vector[this.nstates];
        this.deltaq = new HashMap[this.nstates];
        this.defaultq = new Vector[this.nstates];
        this.deltaq[0] = new HashMap();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = 0; i < n; ++i) {
            NondetWordAutom nondetWordAutom = nondetWordAutomArray[i];
            int n2 = this.offset[i];
            treeSet.add(new Integer(n2));
            nondetWordAutom.relocate(n2, this.finals, this.deltaq, this.defaultq, this.qbinders);
        }
        this.normalize(treeSet, false);
    }

    public void print() {
        int n;
        System.out.print("NFA on labels ".concat(String.valueOf(String.valueOf(this.labels))));
        if (this.offset != null) {
            System.out.print("offset");
            for (n = 0; n < this.offset.length; ++n) {
                if (n > 0) {
                    System.out.print(", ");
                }
                System.out.print(this.offset[n]);
            }
        }
        System.out.println();
        System.out.print("max state number :".concat(String.valueOf(this.nstates - 1)));
        System.out.println("initials".concat(String.valueOf(String.valueOf(this.initials))));
        System.out.println("finals".concat(String.valueOf(String.valueOf(this.finals))));
        for (n = 0; n < this.nstates; ++n) {
            System.out.print("state: ".concat(String.valueOf(n)));
            if (this.finals.containsKey(new Integer(n))) {
                System.out.print("*");
            }
            System.out.print("  transitions: {");
            HashMap hashMap = this.deltaq[n];
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Vector vector = (Vector)hashMap.get(k);
                Iterator iterator2 = ((AbstractList)vector).iterator();
                while (iterator2.hasNext()) {
                    Integer n2 = (Integer)iterator2.next();
                    System.out.print(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("(".concat(String.valueOf(String.valueOf(k))))).concat(","))).concat(String.valueOf(String.valueOf(n2))))).concat(")"));
                }
            }
            System.out.print("} ");
            System.out.print(" default transitions: ".concat(String.valueOf(String.valueOf(this.defaultq(n)))));
            if (this.qbinders != null) {
                System.out.println(" binders ".concat(String.valueOf(String.valueOf(this.qbinders[n]))));
            }
            System.out.println();
        }
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.transformer.matching.NondetWordAutom").desiredAssertionStatus();
    }
}

