/*
 * Decompiled with CFR 0.152.
 */
package scalac.transformer.matching;

import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import scalac.ApplicationError;
import scalac.CompilationUnit;
import scalac.ast.Tree;
import scalac.ast.TreeInfo;
import scalac.transformer.matching.Label;
import scalac.transformer.matching.Label$;
import scalac.transformer.matching.NondetWordAutom;
import scalac.util.Name;

class BerrySethi {
    CompilationUnit unit;
    HashSet labels;
    int pos;
    HashMap posMap;
    HashMap labelAt;
    TreeSet globalFirst;
    HashMap follow;
    HashMap recVars;
    Vector activeBinders;
    TreeMap finals;
    HashMap[] deltaq;
    Vector[] defaultq;
    TreeSet initials;
    Integer finalTag;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public BerrySethi(CompilationUnit compilationUnit) {
        this.unit = compilationUnit;
    }

    boolean isStar(Name name) {
        boolean bl = TreeInfo.isNameOfStarPattern(name);
        return bl;
    }

    boolean nullable(Tree tree) {
        switch (tree.$tag) {
            case 4: {
                return false;
            }
            case 29: {
                Tree.Sequence sequence = (Tree.Sequence)tree;
                Tree[] treeArray = sequence.trees;
                return treeArray.length == 0 || this.nullable(treeArray);
            }
            case 7: {
                Tree.Bind bind = (Tree.Bind)tree;
                Tree tree2 = bind.rhs;
                return this.nullable(tree2);
            }
            case 2: {
                Tree.Alternative alternative = (Tree.Alternative)tree;
                Tree[] treeArray = alternative.trees;
                boolean bl = false;
                for (int i = 0; i < treeArray.length && !bl; ++i) {
                    bl = bl || this.nullable(treeArray[i]);
                }
                return bl;
            }
        }
        return false;
    }

    boolean nullableSequence(Tree tree) {
        if (tree.$tag == 29) {
            Tree.Sequence sequence = (Tree.Sequence)tree;
            Tree[] treeArray = sequence.trees;
            return this.nullable(treeArray);
        }
        return false;
    }

    boolean nullable(Tree[] treeArray) {
        boolean bl = true;
        for (int i = 0; i < treeArray.length && bl; ++i) {
            bl = bl && this.nullable(treeArray[i]);
        }
        return bl;
    }

    TreeSet compFirst(Tree tree) {
        switch (tree.$tag) {
            case 29: {
                Tree.Sequence sequence = (Tree.Sequence)tree;
                Tree[] treeArray = sequence.trees;
                return this.compFirst(treeArray);
            }
            case 39: {
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                treeSet.add((Integer)this.posMap.get(tree));
                return treeSet;
            }
            case 27: {
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                treeSet.add((Integer)this.posMap.get(tree));
                return treeSet;
            }
            case 4: {
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                treeSet.add((Integer)this.posMap.get(tree));
                return treeSet;
            }
            case 21: {
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                treeSet.add((Integer)this.posMap.get(tree));
                return treeSet;
            }
            case 2: {
                Tree.Alternative alternative = (Tree.Alternative)tree;
                Tree[] treeArray = alternative.trees;
                TreeSet treeSet = new TreeSet();
                for (int i = 0; i < treeArray.length; ++i) {
                    treeSet.addAll(this.compFirst(treeArray[i]));
                }
                return treeSet;
            }
            case 7: {
                Tree.Bind bind = (Tree.Bind)tree;
                Tree tree2 = bind.rhs;
                return this.compFirst(tree2);
            }
            case 17: {
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                treeSet.add((Integer)this.posMap.get(tree));
                return treeSet;
            }
        }
        throw new ApplicationError("unexpected pattern");
    }

    TreeSet compLast(Tree tree) {
        switch (tree.$tag) {
            case 29: {
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                treeSet.add((Integer)this.posMap.get(tree));
                return treeSet;
            }
            case 4: {
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                treeSet.add((Integer)this.posMap.get(tree));
                return treeSet;
            }
            case 21: {
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                treeSet.add((Integer)this.posMap.get(tree));
                return treeSet;
            }
            case 2: {
                Tree.Alternative alternative = (Tree.Alternative)tree;
                Tree[] treeArray = alternative.trees;
                TreeSet treeSet = new TreeSet();
                for (int i = 0; i < treeArray.length; ++i) {
                    treeSet.addAll(this.compLast(treeArray));
                }
                return treeSet;
            }
            case 7: {
                Tree.Bind bind = (Tree.Bind)tree;
                Tree tree2 = bind.rhs;
                return this.compLast(tree2);
            }
        }
        throw new ApplicationError("unexpected pattern");
    }

    TreeSet compFirst(Tree[] treeArray) {
        if (treeArray.length == 0) {
            return new TreeSet();
        }
        int n = 0;
        Tree tree = treeArray[n];
        TreeSet treeSet = this.compFirst(tree);
        ++n;
        while (this.nullable(tree) && n < treeArray.length) {
            tree = treeArray[n];
            treeSet.addAll(this.compFirst(tree));
            ++n;
        }
        return treeSet;
    }

    TreeSet compLast(Tree[] treeArray) {
        if (treeArray.length == 0) {
            return new TreeSet();
        }
        int n = treeArray.length - 1;
        Tree tree = treeArray[n];
        TreeSet treeSet = this.compLast(tree);
        --n;
        while (this.nullable(tree) && n >= 0) {
            tree = treeArray[n];
            treeSet.addAll(this.compLast(tree));
            ++n;
        }
        return treeSet;
    }

    TreeSet compFollow(Tree[] treeArray) {
        TreeSet treeSet = null;
        this.recVars = new HashMap();
        TreeSet treeSet2 = new TreeSet();
        if (treeArray.length > 0) {
            int n = treeArray.length;
            treeSet2.add(new Integer(this.pos));
            do {
                treeSet = this.compFollow1(treeSet2, treeArray[--n]);
                if (this.nullable(treeArray[n])) {
                    treeSet2.addAll(treeSet);
                    continue;
                }
                treeSet2 = treeSet;
            } while (n > 0);
        }
        treeSet = treeSet == null ? new TreeSet() : treeSet2;
        this.follow.put(new Integer(0), treeSet);
        return treeSet;
    }

    TreeSet compFollow1(TreeSet treeSet, Tree tree) {
        switch (tree.$tag) {
            case 29: {
                Tree.Sequence sequence = (Tree.Sequence)tree;
                Tree[] treeArray = sequence.trees;
                TreeSet treeSet2 = null;
                int n = treeArray.length;
                if (n > 0) {
                    do {
                        treeSet2 = this.compFollow1(treeSet, treeArray[--n]);
                        if (this.nullable(treeArray[n])) {
                            treeSet.addAll(treeSet2);
                            continue;
                        }
                        treeSet = treeSet2;
                    } while (n > 0);
                }
                if (treeSet2 == null) {
                    treeSet2 = new TreeSet();
                }
                return treeSet2;
            }
            case 2: {
                Tree.Alternative alternative = (Tree.Alternative)tree;
                Tree[] treeArray = alternative.trees;
                TreeSet treeSet3 = new TreeSet();
                for (int i = treeArray.length - 1; i >= 0; --i) {
                    treeSet3.addAll(this.compFollow1(treeSet, treeArray[i]));
                }
                return treeSet3;
            }
            case 7: {
                Tree.Bind bind = (Tree.Bind)tree;
                Name name = bind.name;
                Tree tree2 = bind.rhs;
                TreeSet treeSet4 = this.compFirst(tree2);
                this.recVars.put(tree.symbol(), treeSet4);
                if (this.isStar(name)) {
                    treeSet.addAll(treeSet4);
                }
                return this.compFollow1(treeSet, tree2);
            }
            case 17: {
                if (tree.symbol() != null && tree.symbol().isPrimaryConstructor()) {
                    Integer n = (Integer)this.posMap.get(tree);
                    TreeSet treeSet5 = (TreeSet)treeSet.clone();
                    this.follow.put(n, treeSet5);
                    TreeSet<Integer> treeSet6 = new TreeSet<Integer>();
                    treeSet6.add(n);
                    return treeSet6;
                }
                if (this.recVars.keySet().contains(tree.symbol())) {
                    TreeSet treeSet7 = (TreeSet)this.recVars.get(tree.symbol());
                    TreeSet treeSet8 = (TreeSet)treeSet.clone();
                    treeSet7.addAll(treeSet8);
                    return treeSet7;
                }
                Integer n = (Integer)this.posMap.get(tree);
                TreeSet treeSet9 = (TreeSet)treeSet.clone();
                this.follow.put(n, treeSet9);
                TreeSet<Integer> treeSet10 = new TreeSet<Integer>();
                treeSet10.add(n);
                return treeSet10;
            }
            case 4: {
                Integer n = (Integer)this.posMap.get(tree);
                TreeSet treeSet11 = (TreeSet)treeSet.clone();
                this.follow.put(n, treeSet11);
                TreeSet<Integer> treeSet12 = new TreeSet<Integer>();
                treeSet12.add(n);
                return treeSet12;
            }
            case 21: {
                Integer n = (Integer)this.posMap.get(tree);
                TreeSet treeSet13 = (TreeSet)treeSet.clone();
                this.follow.put(n, treeSet13);
                TreeSet<Integer> treeSet14 = new TreeSet<Integer>();
                treeSet14.add(n);
                return treeSet14;
            }
            case 39: {
                Integer n = (Integer)this.posMap.get(tree);
                TreeSet treeSet15 = (TreeSet)treeSet.clone();
                this.follow.put(n, treeSet15);
                TreeSet<Integer> treeSet16 = new TreeSet<Integer>();
                treeSet16.add(n);
                return treeSet16;
            }
            case 27: {
                Integer n = (Integer)this.posMap.get(tree);
                TreeSet treeSet17 = (TreeSet)treeSet.clone();
                this.follow.put(n, treeSet17);
                TreeSet<Integer> treeSet18 = new TreeSet<Integer>();
                treeSet18.add(n);
                return treeSet18;
            }
        }
        throw new ApplicationError("unexpected pattern: ".concat(String.valueOf(String.valueOf(tree.getClass()))));
    }

    void seenLabel(Tree tree, Integer n, Label label) {
        this.posMap.put(tree, n);
        this.labelAt.put(n, label);
        if (label != Label.DefaultLabel) {
            this.labels.add(label);
        }
    }

    void seenLabel(Tree tree, Label label) {
        this.seenLabel(tree, new Integer(++this.pos), label);
    }

    void traverse(Tree tree) {
        switch (tree.$tag) {
            case 4: {
                Label.TreeLabel treeLabel = new Label.TreeLabel(tree);
                this.seenLabel(tree, treeLabel);
                return;
            }
            case 39: {
                Label.TreeLabel treeLabel = new Label.TreeLabel(tree);
                this.seenLabel(tree, treeLabel);
                return;
            }
            case 27: {
                Label.TreeLabel treeLabel = new Label.TreeLabel(tree);
                this.seenLabel(tree, treeLabel);
                return;
            }
            case 21: {
                Label.SimpleLabel simpleLabel = new Label.SimpleLabel((Tree.Literal)tree);
                this.seenLabel(tree, simpleLabel);
                return;
            }
            case 29: {
                Tree.Sequence sequence = (Tree.Sequence)tree;
                Tree[] treeArray = sequence.trees;
                for (int i = 0; i < treeArray.length; ++i) {
                    this.traverse(treeArray[i]);
                }
                return;
            }
            case 2: {
                Tree.Alternative alternative = (Tree.Alternative)tree;
                Tree[] treeArray = alternative.trees;
                for (int i = 0; i < treeArray.length; ++i) {
                    this.traverse(treeArray[i]);
                }
                return;
            }
            case 7: {
                Tree.Bind bind = (Tree.Bind)tree;
                Name name = bind.name;
                Tree tree2 = bind.rhs;
                this.recVars.put(tree.symbol(), Boolean.TRUE);
                if (!this.isStar(name)) {
                    this.activeBinders.add(tree.symbol());
                    this.traverse(tree2);
                    this.activeBinders.remove(tree.symbol());
                } else {
                    this.traverse(tree2);
                }
                return;
            }
            case 17: {
                if (tree.symbol() != null && tree.symbol().isPrimaryConstructor()) {
                    Label.TreeLabel treeLabel = new Label.TreeLabel(tree);
                    this.seenLabel(tree, treeLabel);
                    return;
                }
                if (this.recVars.get(tree.symbol()) != null) {
                    return;
                }
                Label$.Var var = Label.DefaultLabel;
                this.seenLabel(tree, var);
                return;
            }
        }
        throw new ApplicationError("this is not a pattern");
    }

    protected void makeTransition(Integer n, Integer n2, Label label) {
        Vector vector;
        int n3 = n;
        n2.intValue();
        if (label.$tag == 4) {
            vector = this.defaultq[n3];
        } else {
            vector = (Vector)this.deltaq[n3].get(label);
            if (vector == null) {
                vector = new Vector();
                this.deltaq[n3].put(label, vector);
            }
        }
        vector.add(n2);
    }

    protected void initialize(Tree[] treeArray) {
        this.posMap = new HashMap();
        this.labelAt = new HashMap();
        this.follow = new HashMap();
        this.labels = new HashSet();
        this.recVars = new HashMap();
        this.pos = 0;
        this.activeBinders = new Vector();
        for (int i = 0; i < treeArray.length; ++i) {
            this.traverse(treeArray[i]);
            if (!$assertionsDisabled && !this.activeBinders.isEmpty()) {
                throw new AssertionError();
            }
        }
        this.initials = new TreeSet();
        this.initials.add(new Integer(0));
    }

    protected void initializeAutom() {
        this.finals = new TreeMap();
        this.deltaq = new HashMap[this.pos];
        this.defaultq = new Vector[this.pos];
        for (int i = 0; i < this.pos; ++i) {
            this.deltaq[i] = new HashMap();
            this.defaultq[i] = new Vector();
        }
    }

    void collectTransitions() {
        for (int i = 0; i < this.pos; ++i) {
            Integer n = new Integer(i);
            TreeSet treeSet = (TreeSet)this.follow.get(n);
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                Integer n2 = (Integer)iterator.next();
                if (n2 == this.pos) {
                    this.finals.put(n, this.finalTag);
                    continue;
                }
                this.makeTransition(new Integer(i), n2, (Label)this.labelAt.get(n2));
            }
        }
    }

    public NondetWordAutom automatonFrom(Tree tree, Integer n) {
        this.finalTag = n;
        if (tree.$tag == 29) {
            Tree.Sequence sequence = (Tree.Sequence)tree;
            Tree[] treeArray = sequence.trees;
            this.initialize(treeArray);
            ++this.pos;
            this.globalFirst = this.compFollow(treeArray);
            this.initializeAutom();
            this.collectTransitions();
            if (this.nullable(treeArray)) {
                this.finals.put(new Integer(0), n);
            }
            NondetWordAutom nondetWordAutom = new NondetWordAutom(this.pos, this.labels, this.initials, this.finals, this.deltaq, this.defaultq, null);
            return nondetWordAutom;
        }
        throw new ApplicationError("expected a sequence pattern");
    }

    void print1() {
        Object object;
        System.out.println("after sethi-style processing");
        System.out.println("#positions:".concat(String.valueOf(this.pos)));
        System.out.println("posMap:");
        Iterator iterator = this.posMap.keySet().iterator();
        while (iterator.hasNext()) {
            Tree tree = (Tree)iterator.next();
            if (tree.$tag != 21) continue;
            System.out.print(String.valueOf(String.valueOf("(".concat(String.valueOf(String.valueOf(tree.toString()))))).concat(" -> "));
            object = ((Integer)this.posMap.get(tree)).toString();
            System.out.print(String.valueOf(String.valueOf(object)).concat(") "));
        }
        System.out.println("\nfollow: ");
        for (int i = 1; i < this.pos; ++i) {
            object = (TreeSet)this.follow.get(new Integer(i));
            System.out.print(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("(".concat(String.valueOf(i)))).concat(" -> "))).concat(String.valueOf(String.valueOf(((AbstractCollection)object).toString()))))).concat(") "));
            System.out.println();
        }
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.transformer.matching.BerrySethi").desiredAssertionStatus();
    }
}

