/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab.classfile;

import ch.epfl.lamp.compiler.msil.Attribute;
import ch.epfl.lamp.compiler.msil.ConstructorInfo;
import ch.epfl.lamp.compiler.msil.FieldInfo;
import ch.epfl.lamp.compiler.msil.ICustomAttributeProvider;
import ch.epfl.lamp.compiler.msil.MemberInfo;
import ch.epfl.lamp.compiler.msil.MethodBase;
import ch.epfl.lamp.compiler.msil.MethodInfo;
import ch.epfl.lamp.compiler.msil.ParameterInfo;
import ch.epfl.lamp.compiler.msil.PropertyInfo;
import java.util.Arrays;
import java.util.HashSet;
import scalac.Global;
import scalac.atree.AConstant;
import scalac.symtab.Modifiers;
import scalac.symtab.ModuleSymbol;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.SymbolLoader;
import scalac.symtab.Type;
import scalac.symtab.classfile.CLRTypes;
import scalac.symtab.classfile.JavaTypeCreator;
import scalac.symtab.classfile.JavaTypeFactory;
import scalac.symtab.classfile.MetaParser;
import scalac.util.Debug;
import scalac.util.Name;
import scalac.util.Names;

public class CLRClassParser
extends SymbolLoader {
    private static Name[] ENUM_CMP_NAMES;
    private static Name[] ENUM_BIT_LOG_NAMES;
    private static JavaTypeFactory make;
    private static final CLRTypes clrTypes;
    private final ch.epfl.lamp.compiler.msil.Type type;
    private Symbol clazz;
    private Scope members;
    private Symbol staticsClass;
    private Scope statics;
    Type clazzType;
    private final Scope tvars = new Scope();
    private static final /* synthetic */ boolean $assertionsDisabled;

    public CLRClassParser(Global global, ch.epfl.lamp.compiler.msil.Type type) {
        super(global);
        this.type = type;
    }

    protected String doComplete(Symbol symbol) {
        Modifiers modifiers;
        Modifiers modifiers2;
        Object object;
        Object object2;
        Type[] typeArray;
        Object object3;
        Object object4;
        Object object5;
        int n;
        FieldInfo[] fieldInfoArray;
        this.clazz = symbol;
        this.clazz.owner().initialize();
        if (make == null) {
            make = new JavaTypeCreator(this.global.definitions);
        }
        this.clazz.flags = CLRClassParser.translateAttributes(this.type);
        ch.epfl.lamp.compiler.msil.Type[] typeArray2 = this.type.getInterfaces();
        Type[] typeArray3 = new Type[typeArray2.length + 1];
        typeArray3[0] = this.type.BaseType() != null ? this.getCLRType(this.type.BaseType()) : (this.type.IsInterface() ? make.objectType() : make.anyType());
        for (int i = 0; i < typeArray2.length; ++i) {
            typeArray3[i + 1] = this.getCLRType(typeArray2[i]);
        }
        this.members = new Scope();
        this.statics = new Scope();
        Type.CompoundType compoundType = Type.compoundType(typeArray3, this.members, this.clazz);
        this.clazz.setInfo(compoundType);
        ModuleSymbol moduleSymbol = this.clazz.linkedModule();
        this.staticsClass = ((Symbol)moduleSymbol).moduleClass();
        if (!$assertionsDisabled && !this.staticsClass.isModuleClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(this.staticsClass))));
        }
        Type.CompoundType compoundType2 = Type.compoundType(Type.EMPTY_ARRAY, this.statics, this.staticsClass);
        this.staticsClass.setInfo(compoundType2);
        moduleSymbol.setInfo(make.classType(this.staticsClass));
        this.clazzType = make.classType(this.clazz);
        ch.epfl.lamp.compiler.msil.Type[] typeArray4 = this.type.getNestedTypes();
        for (int i = 0; i < typeArray4.length; ++i) {
            fieldInfoArray = typeArray4[i];
            if (fieldInfoArray.IsNestedPrivate() || fieldInfoArray.IsNestedAssembly() || fieldInfoArray.IsNestedFamANDAssem()) continue;
            n = fieldInfoArray.FullName.lastIndexOf(46);
            String string = (n < 0 ? fieldInfoArray.FullName : fieldInfoArray.FullName.substring(n + 1)).replace('+', '#');
            object5 = Name.fromString(string).toTypeName();
            object4 = Name.fromString(fieldInfoArray.Name).toTypeName();
            object3 = new CLRClassParser(this.global, (ch.epfl.lamp.compiler.msil.Type)fieldInfoArray);
            typeArray = this.clazz.owner().newLoadedClass(4096, (Name)object5, (SymbolLoader)object3, null);
            clrTypes.map((Symbol)typeArray, (MemberInfo)fieldInfoArray);
            object2 = this.staticsClass.newTypeAlias(0, CLRClassParser.translateAttributes((ch.epfl.lamp.compiler.msil.Type)fieldInfoArray), (Name)object4, make.classType((Symbol)typeArray));
            this.statics.enterNoHide((Symbol)object2);
        }
        fieldInfoArray = this.type.getFields();
        for (n = 0; n < fieldInfoArray.length; ++n) {
            if (fieldInfoArray[n].IsPrivate() || fieldInfoArray[n].IsAssembly() || fieldInfoArray[n].IsFamilyAndAssembly()) continue;
            int n2 = CLRClassParser.translateAttributes(fieldInfoArray[n]);
            object5 = Name.fromString(fieldInfoArray[n].Name);
            object4 = this.getCLRType(fieldInfoArray[n].FieldType);
            if (fieldInfoArray[n].IsLiteral() && !fieldInfoArray[n].FieldType.IsEnum()) {
                object4 = make.constantType(this.getConstant(((Type)object4).symbol(), fieldInfoArray[n].getValue()));
            }
            object3 = fieldInfoArray[n].IsStatic() ? this.staticsClass : this.clazz;
            typeArray = ((Symbol)object3).newField(0, n2, (Name)object5);
            this.parseMeta((Symbol)typeArray, (ICustomAttributeProvider)fieldInfoArray[n], (Type)object4);
            (fieldInfoArray[n].IsStatic() ? this.statics : this.members).enterOrOverload((Symbol)typeArray);
            clrTypes.map((Symbol)typeArray, (MemberInfo)fieldInfoArray[n]);
        }
        HashSet<MethodInfo> hashSet = new HashSet<MethodInfo>(Arrays.asList(this.type.getMethods()));
        object5 = this.type.getProperties();
        for (int i = 0; i < ((PropertyInfo[])object5).length; ++i) {
            Name name;
            object3 = this.getCLSType(object5[i].PropertyType);
            if (object3 == null) continue;
            typeArray = object5[i].GetGetMethod(true);
            object2 = object5[i].GetSetMethod(true);
            if (typeArray == null || typeArray.IsPrivate() || typeArray.IsAssembly() || typeArray.IsFamilyAndAssembly()) continue;
            if (!$assertionsDisabled && object5[i].PropertyType != typeArray.ReturnType) {
                throw new AssertionError();
            }
            object = typeArray.GetParameters();
            if (((ParameterInfo[])object).length == 0) {
                name = Name.fromString(object5[i].Name);
                modifiers2 = Type.PolyType(Symbol.EMPTY_ARRAY, (Type)object3);
            } else {
                name = Names.apply;
                modifiers2 = this.methodType((MethodBase)typeArray, typeArray.ReturnType);
            }
            Symbol symbol2 = typeArray.IsStatic() ? this.staticsClass : this.clazz;
            int n3 = CLRClassParser.translateAttributes((MethodBase)typeArray);
            modifiers = symbol2.newMethod(0, n3, name);
            this.setParamOwners((Type)modifiers2, (Symbol)modifiers);
            ((Symbol)modifiers).setInfo((Type)modifiers2);
            (typeArray.IsStatic() ? this.statics : this.members).enterOrOverload((Symbol)modifiers);
            clrTypes.map((Symbol)modifiers, (MemberInfo)typeArray);
            if (!$assertionsDisabled && !hashSet.contains(typeArray)) {
                throw new AssertionError((Object)String.valueOf(String.valueOf("".concat(String.valueOf(String.valueOf(typeArray))))));
            }
            hashSet.remove(typeArray);
            if (object2 == null || object2.IsPrivate() || object2.IsAssembly() || object2.IsFamilyAndAssembly()) continue;
            ParameterInfo[] parameterInfoArray = object2.GetParameters();
            if (!$assertionsDisabled && typeArray.IsStatic() != object2.IsStatic()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && object2.ReturnType != CLRClassParser.clrTypes.VOID) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && parameterInfoArray.length != ((Object)object).length + 1) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("".concat(String.valueOf(String.valueOf(typeArray))))).concat("; "))).concat(String.valueOf(String.valueOf(object2))))));
            }
            name = ((Object)object).length == 0 ? Name.fromString(String.valueOf(String.valueOf(name.toString())).concat(String.valueOf(String.valueOf(Names._EQ)))) : Names.update;
            n3 = CLRClassParser.translateAttributes((MethodBase)object2);
            modifiers = symbol2.newMethod(0, n3, name);
            modifiers2 = this.methodType((MethodBase)object2, this.global.definitions.UNIT_TYPE());
            this.setParamOwners((Type)modifiers2, (Symbol)modifiers);
            ((Symbol)modifiers).setInfo((Type)modifiers2);
            (object2.IsStatic() ? this.statics : this.members).enterOrOverload((Symbol)modifiers);
            clrTypes.map((Symbol)modifiers, (MemberInfo)object2);
            if (!$assertionsDisabled && !hashSet.contains(object2)) {
                throw new AssertionError((Object)String.valueOf(String.valueOf("".concat(String.valueOf(String.valueOf(object2))))));
            }
            hashSet.remove(object2);
        }
        object3 = hashSet.iterator();
        while (object3.hasNext()) {
            typeArray = (Type[])object3.next();
            if (clrTypes.getSymbol((MemberInfo)typeArray) != null || typeArray.IsPrivate() || typeArray.IsAssembly() || typeArray.IsFamilyAndAssembly()) continue;
            this.createMethod((MethodInfo)typeArray);
        }
        if (this.type.IsEnum()) {
            typeArray = new Type[]{this.clazzType};
            int n4 = 4098;
            for (int i = 0; i < ENUM_CMP_NAMES.length; ++i) {
                modifiers = make.methodType(typeArray, this.global.definitions.boolean_TYPE(), Type.EMPTY_ARRAY);
                modifiers2 = this.clazz.newMethod(0, n4, ENUM_CMP_NAMES[i]);
                this.setParamOwners((Type)modifiers, (Symbol)modifiers2);
                ((Symbol)modifiers2).setInfo((Type)modifiers);
                this.members.enterOrOverload((Symbol)modifiers2);
            }
            for (int i = 0; i < ENUM_BIT_LOG_NAMES.length; ++i) {
                modifiers2 = make.methodType(typeArray, this.clazzType, Type.EMPTY_ARRAY);
                object = this.clazz.newMethod(0, n4, ENUM_BIT_LOG_NAMES[i]);
                this.setParamOwners((Type)modifiers2, (Symbol)object);
                ((Symbol)object).setInfo((Type)modifiers2);
                this.members.enterOrOverload((Symbol)object);
            }
        }
        typeArray = this.type.getConstructors();
        for (int i = 0; i < typeArray.length; ++i) {
            if (typeArray[i].IsStatic() || typeArray[i].IsPrivate() || typeArray[i].IsAssembly() || typeArray[i].IsFamilyAndAssembly()) continue;
            this.createConstructor((ConstructorInfo)typeArray[i]);
        }
        Symbol symbol3 = this.clazz.primaryConstructor();
        if (!symbol3.isInitialized()) {
            symbol3.setInfo(Type.MethodType(Symbol.EMPTY_ARRAY, this.clazzType));
            if ((this.clazz.flags & 0x10000000) == 0) {
                symbol3.flags |= 4;
            }
        }
        this.parseMeta(this.clazz, (ICustomAttributeProvider)this.type, compoundType);
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.type)).concat(" from assembly "))).concat(String.valueOf(String.valueOf(this.type.Assembly())));
    }

    private Type parseMeta(Symbol symbol, ICustomAttributeProvider iCustomAttributeProvider, Type type) {
        Type type2 = null;
        if (!iCustomAttributeProvider.IsDefined(CLRClassParser.clrTypes.PICO_META_ATTR, false)) {
            type2 = type;
        } else {
            Object[] objectArray = iCustomAttributeProvider.GetCustomAttributes(CLRClassParser.clrTypes.PICO_META_ATTR, false);
            if (!$assertionsDisabled && objectArray.length != 1) {
                throw new AssertionError((Object)String.valueOf(String.valueOf("attrs.length = ".concat(String.valueOf(objectArray.length)))));
            }
            String string = (String)((Attribute)objectArray[0]).getConstructorArguments()[0];
            type2 = new MetaParser(string, this.tvars, symbol, type, this.clazz, this.clazzType, make).parse();
        }
        symbol.setInfo(type2);
        return type2;
    }

    private void createConstructor(ConstructorInfo constructorInfo) {
        Type type = this.methodType((MethodBase)constructorInfo, this.clazzType);
        if (type == null) {
            return;
        }
        Symbol symbol = this.clazz.primaryConstructor();
        int n = CLRClassParser.translateAttributes((MethodBase)constructorInfo);
        if (symbol.isInitialized()) {
            symbol = this.clazz.newConstructor(0, n);
            this.clazz.addConstructor(symbol);
        } else {
            symbol.flags = n;
        }
        this.setParamOwners(type, symbol);
        this.parseMeta(symbol, (ICustomAttributeProvider)constructorInfo, type);
        clrTypes.map(symbol, (MemberInfo)constructorInfo);
    }

    private void createMethod(MethodInfo methodInfo) {
        Type type = this.methodType((MethodBase)methodInfo, methodInfo.ReturnType);
        if (type == null) {
            return;
        }
        int n = CLRClassParser.translateAttributes((MethodBase)methodInfo);
        Symbol symbol = methodInfo.IsStatic() ? this.staticsClass : this.clazz;
        Symbol symbol2 = symbol.newMethod(0, n, this.getName(methodInfo));
        this.setParamOwners(type, symbol2);
        this.parseMeta(symbol2, (ICustomAttributeProvider)methodInfo, type);
        (methodInfo.IsStatic() ? this.statics : this.members).enterOrOverload(symbol2);
        clrTypes.map(symbol2, (MemberInfo)methodInfo);
    }

    private Name getName(MethodInfo methodInfo) {
        String string = methodInfo.Name;
        if (methodInfo.IsStatic()) {
            return Name.fromString(string);
        }
        ParameterInfo[] parameterInfoArray = methodInfo.GetParameters();
        if (string.equals("GetHashCode") && parameterInfoArray.length == 0) {
            return Names.hashCode;
        }
        if (string.equals("ToString") && parameterInfoArray.length == 0) {
            return Names.toString;
        }
        if (string.equals("Finalize") && parameterInfoArray.length == 0) {
            return Names.finalize;
        }
        if (string.equals("Equals") && parameterInfoArray.length == 1 && parameterInfoArray[0].ParameterType == CLRClassParser.clrTypes.OBJECT) {
            return Names.equals;
        }
        return Name.fromString(string);
    }

    private ch.epfl.lamp.compiler.msil.Type[] getParamTypes(MethodBase methodBase) {
        ParameterInfo[] parameterInfoArray = methodBase.GetParameters();
        ch.epfl.lamp.compiler.msil.Type[] typeArray = new ch.epfl.lamp.compiler.msil.Type[parameterInfoArray.length];
        for (int i = 0; i < parameterInfoArray.length; ++i) {
            typeArray[i] = parameterInfoArray[i].ParameterType;
        }
        return typeArray;
    }

    private Type methodType(MethodBase methodBase, ch.epfl.lamp.compiler.msil.Type type) {
        Type type2 = this.getCLSType(type);
        return type2 == null ? null : this.methodType(methodBase, type2);
    }

    private Type methodType(MethodBase methodBase, Type type) {
        return this.methodType(this.getParamTypes(methodBase), type);
    }

    private Type methodType(ch.epfl.lamp.compiler.msil.Type[] typeArray, Type type) {
        Type[] typeArray2 = new Type[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray2[i] = this.getCLSType(typeArray[i]);
            if (typeArray2[i] != null) continue;
            return null;
        }
        return make.methodType(typeArray2, type, Type.EMPTY_ARRAY);
    }

    private void setParamOwners(Type type, Symbol symbol) {
        switch (type.$tag) {
            case 5: {
                Type.PolyType polyType = (Type.PolyType)type;
                Symbol[] symbolArray = polyType.tparams;
                Type type2 = polyType.result;
                for (int i = 0; i < symbolArray.length; ++i) {
                    symbolArray[i].setOwner(symbol);
                }
                this.setParamOwners(type2, symbol);
                return;
            }
            case 3: {
                Type.MethodType methodType = (Type.MethodType)type;
                Symbol[] symbolArray = methodType.vparams;
                Type type3 = methodType.result;
                for (int i = 0; i < symbolArray.length; ++i) {
                    symbolArray[i].setOwner(symbol);
                }
                this.setParamOwners(type3, symbol);
                return;
            }
        }
    }

    private Type getClassType(ch.epfl.lamp.compiler.msil.Type type) {
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        Type type2 = make.classType(type.FullName.replace('+', '.'));
        if (type2.isError()) {
            this.global.error("unknown class reference ".concat(String.valueOf(String.valueOf(type.FullName))));
        }
        return type2;
    }

    private Type getCLSType(ch.epfl.lamp.compiler.msil.Type type) {
        if (type == CLRClassParser.clrTypes.USHORT || type == CLRClassParser.clrTypes.UINT || type == CLRClassParser.clrTypes.ULONG || type.IsNotPublic() || type.IsNestedPrivate() || type.IsNestedAssembly() || type.IsNestedFamANDAssem() || type.IsPointer() || type.IsArray() && this.getCLSType(type.GetElementType()) == null) {
            return null;
        }
        return this.getCLRType(type);
    }

    private Type getCLRType(ch.epfl.lamp.compiler.msil.Type type) {
        if (type == CLRClassParser.clrTypes.OBJECT) {
            return make.objectType();
        }
        if (type == CLRClassParser.clrTypes.STRING) {
            return make.stringType();
        }
        if (type == CLRClassParser.clrTypes.VOID) {
            return make.voidType();
        }
        if (type == CLRClassParser.clrTypes.BOOLEAN) {
            return make.booleanType();
        }
        if (type == CLRClassParser.clrTypes.CHAR) {
            return make.charType();
        }
        if (type == CLRClassParser.clrTypes.BYTE || type == CLRClassParser.clrTypes.UBYTE) {
            return make.byteType();
        }
        if (type == CLRClassParser.clrTypes.SHORT || type == CLRClassParser.clrTypes.USHORT) {
            return make.shortType();
        }
        if (type == CLRClassParser.clrTypes.INT || type == CLRClassParser.clrTypes.UINT) {
            return make.intType();
        }
        if (type == CLRClassParser.clrTypes.LONG || type == CLRClassParser.clrTypes.ULONG) {
            return make.longType();
        }
        if (type == CLRClassParser.clrTypes.FLOAT) {
            return make.floatType();
        }
        if (type == CLRClassParser.clrTypes.DOUBLE) {
            return make.doubleType();
        }
        if (type.IsArray()) {
            return make.arrayType(this.getCLRType(type.GetElementType()));
        }
        Symbol symbol = clrTypes.getSymbol((MemberInfo)type);
        return symbol != null ? make.classType(symbol) : this.getClassType(type);
    }

    public AConstant getConstant(Symbol symbol, Object object) {
        if (symbol == this.global.definitions.BOOLEAN_CLASS) {
            return AConstant.BOOLEAN(((Number)object).intValue() != 0);
        }
        if (symbol == this.global.definitions.BYTE_CLASS) {
            return AConstant.BYTE(((Number)object).byteValue());
        }
        if (symbol == this.global.definitions.SHORT_CLASS) {
            return AConstant.SHORT(((Number)object).shortValue());
        }
        if (symbol == this.global.definitions.CHAR_CLASS) {
            return AConstant.CHAR(((Character)object).charValue());
        }
        if (symbol == this.global.definitions.INT_CLASS) {
            return AConstant.INT(((Number)object).intValue());
        }
        if (symbol == this.global.definitions.LONG_CLASS) {
            return AConstant.LONG(((Number)object).longValue());
        }
        if (symbol == this.global.definitions.FLOAT_CLASS) {
            return AConstant.FLOAT(((Number)object).floatValue());
        }
        if (symbol == this.global.definitions.DOUBLE_CLASS) {
            return AConstant.DOUBLE(((Number)object).doubleValue());
        }
        if (symbol == this.global.definitions.STRING_CLASS) {
            return AConstant.STRING((String)object);
        }
        throw Debug.abort("illegal value", Debug.show(object, symbol));
    }

    private static int translateAttributes(ch.epfl.lamp.compiler.msil.Type type) {
        int n = 4096;
        if (type.IsNotPublic() || type.IsNestedPrivate() || type.IsNestedAssembly() || type.IsNestedFamANDAssem()) {
            n |= 4;
        } else if (type.IsNestedFamily() || type.IsNestedFamORAssem()) {
            n |= 8;
        }
        if (type.IsAbstract()) {
            n |= 0x80;
        }
        if (type.IsSealed()) {
            n |= 2;
        }
        if (type.IsInterface()) {
            n |= 0x30000080;
        }
        return n;
    }

    private static int translateAttributes(FieldInfo fieldInfo) {
        int n = 4096;
        if (fieldInfo.IsPrivate() || fieldInfo.IsAssembly() || fieldInfo.IsFamilyAndAssembly()) {
            n |= 4;
        } else if (fieldInfo.IsFamily() || fieldInfo.IsFamilyOrAssembly()) {
            n |= 8;
        }
        n = fieldInfo.IsInitOnly() ? (n |= 2) : (n |= 0x4000);
        return n;
    }

    private static int translateAttributes(MethodBase methodBase) {
        int n = 4096;
        if (methodBase.IsPrivate() || methodBase.IsAssembly() || methodBase.IsFamilyAndAssembly()) {
            n |= 4;
        } else if (methodBase.IsFamily() || methodBase.IsFamilyOrAssembly()) {
            n |= 8;
        }
        if (methodBase.IsAbstract()) {
            n |= 1;
        }
        return n;
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.symtab.classfile.CLRClassParser").desiredAssertionStatus();
        ENUM_CMP_NAMES = new Name[]{Names.EQ, Names.NE, Names.LT, Names.LE, Names.GT, Names.GE};
        ENUM_BIT_LOG_NAMES = new Name[]{Names.OR, Names.AND, Names.XOR};
        clrTypes = CLRTypes.instance();
    }
}

