/*
 * Decompiled with CFR 0.152.
 */
package scalac.ast;

import scalac.CompilationUnit;
import scalac.Global;
import scalac.ast.Tree;
import scalac.ast.TreeGen;
import scalac.atree.AConstant;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Debug;
import scalac.util.Name;

public class GenTransformer {
    public final Global global;
    public final Type.Map map;
    public final TreeGen gen;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public GenTransformer(Global global) {
        this(global, Type.IdMap);
    }

    public GenTransformer(Global global, Type.Map map) {
        this.global = global;
        this.gen = global.treeGen;
        this.map = map;
    }

    public void apply(CompilationUnit[] compilationUnitArray) {
        for (int i = 0; i < compilationUnitArray.length; ++i) {
            this.apply(compilationUnitArray[i]);
        }
    }

    public void apply(CompilationUnit compilationUnit) {
        compilationUnit.global.log("transforming ".concat(String.valueOf(String.valueOf(compilationUnit))));
        compilationUnit.body = this.transform(compilationUnit.body);
    }

    public Symbol getSymbolFor(Tree tree) {
        return tree.symbol();
    }

    public Type[] transform(Type[] typeArray) {
        for (int i = 0; i < typeArray.length; ++i) {
            Type type = this.transform(typeArray[i]);
            if (type == typeArray[i]) continue;
            Type[] typeArray2 = new Type[typeArray.length];
            for (int j = 0; j < i; ++j) {
                typeArray2[j] = typeArray[j];
            }
            typeArray2[i] = type;
            while (i < typeArray.length) {
                typeArray2[i] = this.transform(typeArray[i]);
                ++i;
            }
            return typeArray2;
        }
        return typeArray;
    }

    public Type transform(Type type) {
        return this.map.apply(type);
    }

    public Tree transform(Tree tree) {
        switch (tree.$tag) {
            case 42: {
                return tree;
            }
            case 10: {
                Tree.ClassDef classDef = (Tree.ClassDef)tree;
                Tree.Template template = classDef.impl;
                Symbol symbol = this.getSymbolFor(tree);
                if (this.global.currentPhase.id < this.global.PHASE.ADDCONSTRUCTORS.id()) {
                    Symbol symbol2 = this.getSymbolFor(template);
                    Tree[] treeArray = this.transform(template.parents);
                    Tree[] treeArray2 = this.transform(template.body);
                    return this.gen.ClassDef(symbol, treeArray, symbol2, treeArray2);
                }
                Tree[] treeArray = this.transform(template.body);
                return this.gen.ClassDef(symbol, treeArray);
            }
            case 24: {
                Tree.PackageDef packageDef = (Tree.PackageDef)tree;
                if (packageDef.impl.$tag != 33) break;
                Tree.Template template = packageDef.impl;
                Tree tree2 = packageDef.packaged;
                Tree[] treeArray = template.parents;
                Tree[] treeArray3 = template.body;
                Symbol symbol = this.getSymbolFor(tree2);
                if (!$assertionsDisabled && treeArray.length != 0) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
                }
                return this.gen.PackageDef(symbol, this.transform(treeArray3));
            }
            case 40: {
                Tree.ValDef valDef = (Tree.ValDef)tree;
                Tree tree3 = valDef.rhs;
                Symbol symbol = this.getSymbolFor(tree);
                return this.gen.ValDef(symbol, this.transform(tree3));
            }
            case 13: {
                Tree.DefDef defDef = (Tree.DefDef)tree;
                Tree tree4 = defDef.rhs;
                Symbol symbol = this.getSymbolFor(tree);
                return this.gen.DefDef(symbol, this.transform(tree4));
            }
            case 0: {
                Symbol symbol = this.getSymbolFor(tree);
                return this.gen.AbsTypeDef(symbol);
            }
            case 1: {
                Symbol symbol = this.getSymbolFor(tree);
                return this.gen.AliasTypeDef(symbol);
            }
            case 19: {
                Tree.Import import_ = (Tree.Import)tree;
                Tree tree5 = import_.expr;
                Name[] nameArray = import_.selectors;
                return this.gen.Import(tree.pos, this.transform(tree5), nameArray);
            }
            case 9: {
                Tree.CaseDef caseDef = (Tree.CaseDef)tree;
                Tree tree6 = caseDef.pat;
                Tree tree7 = caseDef.guard;
                Tree tree8 = caseDef.body;
                tree6 = this.transform(tree6);
                tree7 = this.transform(tree7);
                tree8 = this.transform(tree8);
                return this.gen.CaseDef(tree6, tree7, tree8);
            }
            case 20: {
                Tree.LabelDef labelDef = (Tree.LabelDef)tree;
                Tree.Ident[] identArray = labelDef.params;
                Tree tree9 = labelDef.rhs;
                Symbol symbol = this.getSymbolFor(tree);
                return this.gen.LabelDef(symbol, this.transform(identArray), this.transform(tree9));
            }
            case 8: {
                Tree.Block block = (Tree.Block)tree;
                Tree[] treeArray = block.stats;
                Tree tree10 = block.expr;
                return this.gen.Block(tree.pos, this.transform(treeArray), this.transform(tree10));
            }
            case 5: {
                Tree.Assign assign = (Tree.Assign)tree;
                Tree tree11 = assign.lhs;
                Tree tree12 = assign.rhs;
                return this.gen.Assign(tree.pos, this.transform(tree11), this.transform(tree12));
            }
            case 18: {
                Tree.If if_ = (Tree.If)tree;
                Tree tree13 = if_.cond;
                Tree tree14 = if_.thenp;
                Tree tree15 = if_.elsep;
                tree13 = this.transform(tree13);
                tree14 = this.transform(tree14);
                tree15 = this.transform(tree15);
                if (tree.type().isSameAs(this.global.definitions.ANY_TYPE())) {
                    this.global.nextPhase();
                    Type type = this.global.definitions.ANY_TYPE();
                    this.global.prevPhase();
                    return this.gen.If(tree.pos, tree13, tree14, tree15, type);
                }
                return this.gen.If(tree.pos, tree13, tree14, tree15);
            }
            case 32: {
                Tree.Switch switch_ = (Tree.Switch)tree;
                Tree tree16 = switch_.test;
                int[] nArray = switch_.tags;
                Tree[] treeArray = switch_.bodies;
                Tree tree17 = switch_.otherwise;
                tree16 = this.transform(tree16);
                treeArray = this.transform(treeArray);
                tree17 = this.transform(tree17);
                if (tree.type().isSameAs(this.global.definitions.ANY_TYPE())) {
                    this.global.nextPhase();
                    Type type = this.global.definitions.ANY_TYPE();
                    this.global.prevPhase();
                    return this.gen.Switch(tree.pos, tree16, nArray, treeArray, tree17, type);
                }
                return this.gen.Switch(tree.pos, tree16, nArray, treeArray, tree17);
            }
            case 26: {
                Tree.Return return_ = (Tree.Return)tree;
                Tree tree18 = return_.expr;
                Symbol symbol = this.getSymbolFor(tree);
                return this.gen.Return(tree.pos, symbol, this.transform(tree18));
            }
            case 23: {
                Tree.New new_ = (Tree.New)tree;
                Tree tree19 = new_.init;
                return this.gen.New(tree.pos, this.transform(tree19));
            }
            case 12: {
                Tree.Create create = (Tree.Create)tree;
                Tree tree20 = create.qualifier;
                Tree[] treeArray = create.targs;
                Symbol symbol = this.getSymbolFor(tree);
                tree20 = this.transform(tree20);
                treeArray = this.transform(treeArray);
                return this.gen.Create(tree.pos, tree20, symbol, treeArray);
            }
            case 39: {
                Tree.Typed typed = (Tree.Typed)tree;
                Tree tree21 = typed.expr;
                Tree tree22 = typed.tpe;
                return this.gen.Typed(tree.pos, this.transform(tree21), this.transform(tree22));
            }
            case 37: {
                Tree.TypeApply typeApply = (Tree.TypeApply)tree;
                Tree tree23 = typeApply.fun;
                Tree[] treeArray = typeApply.args;
                return this.gen.TypeApply(this.transform(tree23), this.transform(treeArray));
            }
            case 4: {
                Tree.Apply apply = (Tree.Apply)tree;
                Tree tree24 = apply.fun;
                Tree[] treeArray = apply.args;
                return this.gen.Apply(this.transform(tree24), this.transform(treeArray));
            }
            case 31: {
                Symbol symbol = this.getSymbolFor(tree);
                return this.gen.Super(tree.pos, symbol);
            }
            case 34: {
                Symbol symbol = this.getSymbolFor(tree);
                return this.gen.This(tree.pos, symbol);
            }
            case 27: {
                Tree.Select select = (Tree.Select)tree;
                Tree tree25 = select.qualifier;
                Symbol symbol = this.getSymbolFor(tree);
                return this.gen.Select(tree.pos, this.transform(tree25), symbol);
            }
            case 17: {
                Symbol symbol = this.getSymbolFor(tree);
                return this.gen.Ident(tree.pos, symbol);
            }
            case 21: {
                Tree.Literal literal = (Tree.Literal)tree;
                AConstant aConstant = literal.value;
                return this.gen.Literal(tree.pos, aConstant);
            }
            case 38: {
                return this.gen.mkType(tree.pos, this.transform(tree.type()));
            }
        }
        throw Debug.abort("illegal case", tree);
    }

    public Tree[] transform(Tree[] treeArray) {
        for (int i = 0; i < treeArray.length; ++i) {
            Tree tree = this.transform(treeArray[i]);
            if (tree == treeArray[i]) continue;
            Tree[] treeArray2 = new Tree[treeArray.length];
            System.arraycopy(treeArray, 0, treeArray2, 0, i);
            treeArray2[i++] = tree;
            while (i < treeArray.length) {
                treeArray2[i] = this.transform(treeArray[i]);
                ++i;
            }
            return treeArray2;
        }
        return treeArray;
    }

    public Tree.ValDef[] transform(Tree.ValDef[] valDefArray) {
        for (int i = 0; i < valDefArray.length; ++i) {
            Tree tree = this.transform(valDefArray[i]);
            if (tree == valDefArray[i]) continue;
            Tree.ValDef[] valDefArray2 = new Tree.ValDef[valDefArray.length];
            System.arraycopy(valDefArray, 0, valDefArray2, 0, i);
            valDefArray2[i++] = (Tree.ValDef)tree;
            while (i < valDefArray.length) {
                valDefArray2[i] = (Tree.ValDef)this.transform(valDefArray[i]);
                ++i;
            }
            return valDefArray2;
        }
        return valDefArray;
    }

    public Tree.ValDef[][] transform(Tree.ValDef[][] valDefArray) {
        for (int i = 0; i < valDefArray.length; ++i) {
            Tree.ValDef[] valDefArray2 = this.transform(valDefArray[i]);
            if (valDefArray2 == valDefArray[i]) continue;
            Tree.ValDef[][] valDefArray3 = new Tree.ValDef[valDefArray.length][];
            System.arraycopy(valDefArray, 0, valDefArray3, 0, i);
            valDefArray3[i++] = valDefArray2;
            while (i < valDefArray.length) {
                valDefArray3[i] = this.transform(valDefArray[i]);
                ++i;
            }
            return valDefArray3;
        }
        return valDefArray;
    }

    public Tree.AbsTypeDef[] transform(Tree.AbsTypeDef[] absTypeDefArray) {
        for (int i = 0; i < absTypeDefArray.length; ++i) {
            Tree tree = this.transform(absTypeDefArray[i]);
            if (tree == absTypeDefArray[i]) continue;
            Tree.AbsTypeDef[] absTypeDefArray2 = new Tree.AbsTypeDef[absTypeDefArray.length];
            System.arraycopy(absTypeDefArray, 0, absTypeDefArray2, 0, i);
            absTypeDefArray2[i++] = (Tree.AbsTypeDef)tree;
            while (i < absTypeDefArray.length) {
                absTypeDefArray2[i] = (Tree.AbsTypeDef)this.transform(absTypeDefArray[i]);
                ++i;
            }
            return absTypeDefArray2;
        }
        return absTypeDefArray;
    }

    public Tree.CaseDef[] transform(Tree.CaseDef[] caseDefArray) {
        for (int i = 0; i < caseDefArray.length; ++i) {
            Tree tree = this.transform(caseDefArray[i]);
            if (tree == caseDefArray[i]) continue;
            Tree.CaseDef[] caseDefArray2 = new Tree.CaseDef[caseDefArray.length];
            System.arraycopy(caseDefArray, 0, caseDefArray2, 0, i);
            caseDefArray2[i++] = (Tree.CaseDef)tree;
            while (i < caseDefArray.length) {
                caseDefArray2[i] = (Tree.CaseDef)this.transform(caseDefArray[i]);
                ++i;
            }
            return caseDefArray2;
        }
        return caseDefArray;
    }

    public Tree.Ident[] transform(Tree.Ident[] identArray) {
        for (int i = 0; i < identArray.length; ++i) {
            Tree tree = this.transform(identArray[i]);
            if (tree == identArray[i]) continue;
            Tree.Ident[] identArray2 = new Tree.Ident[identArray.length];
            System.arraycopy(identArray, 0, identArray2, 0, i);
            identArray2[i++] = (Tree.Ident)tree;
            while (i < identArray.length) {
                identArray2[i] = (Tree.Ident)this.transform(identArray[i]);
                ++i;
            }
            return identArray2;
        }
        return identArray;
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.ast.GenTransformer").desiredAssertionStatus();
    }
}

