/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scalai;

import java.util.HashMap;
import scala.runtime.InterpreterSupport;
import scala.tools.scalai.Compiler;
import scala.tools.scalai.Evaluator;
import scala.tools.scalai.EvaluatorException;
import scala.tools.scalai.EvaluatorResult;
import scala.tools.scalai.Function;
import scala.tools.scalai.Variable;
import scalac.Global;
import scalac.Phase;
import scalac.symtab.Definitions;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Name;
import scalac.util.TermName;

public class Interpreter {
    public static final Name MAIN_N = Name.fromString("main");
    public static final Name ARGS_N = Name.fromString("args");
    private final Global global;
    private final Compiler compiler;
    private final Evaluator evaluator;

    public Interpreter(Global global) {
        this.global = global;
        HashMap hashMap = new HashMap();
        this.evaluator = new Evaluator(hashMap);
        this.compiler = new Compiler(global, hashMap, this.evaluator);
    }

    public EvaluatorResult invoke(String string, String[] stringArray) {
        Symbol symbol = this.getMainModule(string);
        if (symbol == null) {
            return EvaluatorResult.Void;
        }
        Symbol symbol2 = this.getMainMethod(string, symbol);
        if (symbol2 == null) {
            return EvaluatorResult.Void;
        }
        Variable variable = this.compiler.getModule(symbol);
        Function function = this.compiler.getMethod(symbol2);
        try {
            this.evaluator.evaluate(variable, function, new Object[]{stringArray});
            return EvaluatorResult.Void;
        }
        catch (EvaluatorException evaluatorException) {
            return EvaluatorResult.Error(evaluatorException);
        }
    }

    public EvaluatorResult interpret(String string, boolean bl) {
        if (string.trim().length() == 0) {
            return EvaluatorResult.Void;
        }
        this.global.compile("<console>", String.valueOf(String.valueOf(string)).concat(";"), bl);
        return this.interpret(bl);
    }

    public EvaluatorResult interpret(String[] stringArray, boolean bl) {
        if (stringArray.length == 0) {
            return EvaluatorResult.Void;
        }
        this.global.compile(stringArray, bl);
        return this.interpret(bl);
    }

    public EvaluatorResult toString(Object object, String string) {
        try {
            return EvaluatorResult.Value(this.evaluator.toString(object), string);
        }
        catch (EvaluatorException evaluatorException) {
            return EvaluatorResult.Error(evaluatorException);
        }
    }

    private EvaluatorResult interpret(boolean bl) {
        try {
            Object object;
            if (this.global.reporter.errors() != 0) {
                return EvaluatorResult.Void;
            }
            this.compiler.compile(this.global.units);
            if (bl) {
                object = this.compiler.getModule(this.global.console);
                this.evaluator.evaluate((Variable)object);
            }
            if ((object = InterpreterSupport.getAndResetEvaluationResult()) == null) {
                return EvaluatorResult.Void;
            }
            return EvaluatorResult.Value(object.value, object.type);
        }
        catch (EvaluatorException evaluatorException) {
            return EvaluatorResult.Error(evaluatorException);
        }
    }

    private Symbol getMainModule(String string) {
        int n;
        String string2 = String.valueOf(String.valueOf(string.replace('/', '.'))).concat(String.valueOf(String.valueOf(string.length() > 0 ? "." : "")));
        if (string2.length() > 0 && string2.charAt(0) == '.') {
            this.error(String.valueOf(String.valueOf("illegal module name '".concat(String.valueOf(String.valueOf(string))))).concat("'"));
            return null;
        }
        Symbol symbol = this.global.definitions.ROOT_CLASS;
        int n2 = 0;
        while ((n = string2.indexOf(46, n2)) >= 0) {
            TermName termName = Name.fromString(string2.substring(n2, n));
            Symbol symbol2 = symbol.lookup(termName);
            if (symbol2.isNone()) {
                this.error(String.valueOf(String.valueOf("could not find module '".concat(String.valueOf(String.valueOf(string.substring(0, n)))))).concat("'"));
                return null;
            }
            if (!symbol2.isModule()) {
                Type type = symbol2.type();
                if (type.$tag == 4) {
                    Type.OverloadedType overloadedType = (Type.OverloadedType)type;
                    Symbol[] symbolArray = overloadedType.alts;
                    for (int i = 0; i < symbolArray.length; ++i) {
                        if (!symbolArray[i].isModule()) continue;
                        symbol = symbolArray[i];
                    }
                }
                this.error(String.valueOf(String.valueOf("term '".concat(String.valueOf(String.valueOf(string.substring(0, n)))))).concat("' is not a module"));
                return null;
            }
            symbol = symbol2;
            n2 = n + 1;
        }
        return symbol;
    }

    private Type getMainMethodType(boolean bl) {
        Phase phase = this.global.currentPhase;
        if (!bl) {
            this.global.currentPhase = this.global.PHASE.ANALYZER.phase();
        }
        Definitions definitions = this.global.definitions;
        Type type = definitions.array_TYPE(definitions.STRING_TYPE());
        Type type2 = definitions.void_TYPE();
        Symbol symbol = Symbol.NONE.newTerm(0, 32768, ARGS_N);
        symbol.setInfo(type);
        this.global.currentPhase = phase;
        return Type.MethodType(new Symbol[]{symbol}, type2);
    }

    private Symbol getMainMethod(String string, Symbol symbol) {
        Symbol symbol2 = symbol.moduleClass().lookup(MAIN_N);
        if (symbol2.isNone()) {
            this.error(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("module '".concat(String.valueOf(String.valueOf(string))))).concat("' has no method '"))).concat(String.valueOf(String.valueOf(MAIN_N))))).concat("'"));
            return null;
        }
        Type type = this.getMainMethodType(true);
        if (symbol2.type().equals(type)) {
            return symbol2;
        }
        Type type2 = symbol2.type();
        if (type2.$tag == 4) {
            Type.OverloadedType overloadedType = (Type.OverloadedType)type2;
            Symbol[] symbolArray = overloadedType.alts;
            for (int i = 0; i < symbolArray.length; ++i) {
                if (!symbolArray[i].type().equals(type)) continue;
                return symbolArray[i];
            }
        }
        this.error(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("module '".concat(String.valueOf(String.valueOf(string))))).concat("' has no method '"))).concat(String.valueOf(String.valueOf(MAIN_N))))).concat("' with type '"))).concat(String.valueOf(String.valueOf(this.getMainMethodType(false)))))).concat("'"));
        return null;
    }

    private void error(String string) {
        this.global.reporter.error(null, string);
    }
}

