/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scalai;

import java.util.HashMap;
import java.util.Map;
import scala.tools.scalai.Environment;
import scala.tools.scalai.Function;
import scala.tools.scalai.Template;
import scala.tools.scalai.Variable;
import scala.tools.util.SourceFile;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Debug;

public class ExpressionContext {
    private final Environment environment;
    private final Map functions;
    private final Map variables;
    private final SourceFile source;
    private final Symbol owner;
    private int current;
    private int maximum;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public ExpressionContext(Environment environment, SourceFile sourceFile, Symbol symbol) {
        this.environment = environment;
        this.functions = new HashMap();
        this.variables = new HashMap();
        this.source = sourceFile;
        this.owner = symbol;
        this.current = 0;
        this.maximum = 0;
    }

    public Class getClass(Symbol symbol) {
        return this.environment.getClass(symbol);
    }

    public Class getClass(Type type) {
        return this.environment.getClass(type);
    }

    public Function insertLabel(Symbol symbol) {
        Function.Label label = Function.Label(symbol);
        if (!$assertionsDisabled && !Debug.log("insert label   : ", symbol)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.functions.containsKey(symbol)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        this.functions.put(symbol, label);
        return label;
    }

    public Variable insertVariable(Symbol symbol, Variable variable) {
        if (!$assertionsDisabled && !Debug.log("insert variable: ", symbol)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.variables.containsKey(symbol)) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(symbol))));
        }
        this.variables.put(symbol, variable);
        return variable;
    }

    public Template lookupTemplate(Symbol symbol) {
        return this.environment.lookupTemplate(symbol);
    }

    public Function lookupFunction(Symbol symbol) {
        Object v = this.functions.get(symbol);
        if (v != null) {
            return (Function)v;
        }
        return this.environment.lookupFunction(symbol);
    }

    public Variable lookupVariable(Symbol symbol) {
        Object v = this.variables.get(symbol);
        if (v != null) {
            return (Variable)v;
        }
        return this.environment.lookupVariable(symbol);
    }

    public SourceFile source() {
        return this.source;
    }

    public Symbol owner() {
        return this.owner;
    }

    public void stacksize(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError((Object)String.valueOf(n));
        }
        this.maximum = Math.max(this.current, this.maximum);
        this.current = n;
    }

    public int stacksize() {
        return this.current;
    }

    public int stackmax() {
        this.maximum = Math.max(this.current, this.maximum);
        return this.maximum;
    }

    public int push() {
        return this.current++;
    }

    public int pop() {
        this.maximum = Math.max(this.current, this.maximum);
        return --this.current;
    }

    static {
        $assertionsDisabled = !Class.forName("scala.tools.scalai.ExpressionContext").desiredAssertionStatus();
    }
}

