/*
 * Decompiled with CFR 0.152.
 */
package scala.runtime.types;

import scala.ScalaObject;
import scala.Type;
import scala.runtime.FNV_Hash;
import scala.runtime.PearsonHash;
import scala.runtime.types.ClassType;
import scala.runtime.types.Refinement;
import scala.runtime.types.TypeConstructor;

public class ScalaClassType
extends ClassType {
    private static ScalaClassType[] EMPTY_DISPLAY_ROW;
    private static ScalaClassType[][] EMPTY_DISPLAY;
    protected Refinement[] refinements;
    private final TypeConstructor constr;
    private final Type[] inst;
    private final ScalaClassType[] parents;
    private final int hashCode;
    private ScalaClassType[][] display = EMPTY_DISPLAY;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public ScalaClassType(TypeConstructor typeConstructor, Type[] typeArray, ScalaClassType[] scalaClassTypeArray, Refinement[] refinementArray) {
        super(typeConstructor.clazz, typeConstructor.isTrivial);
        this.constr = typeConstructor;
        this.inst = typeArray;
        this.parents = scalaClassTypeArray;
        this.refinements = refinementArray;
        int n = FNV_Hash.hashStep(-2128831035, PearsonHash.hash8(typeConstructor.hashCode()));
        for (int i = 0; i < typeArray.length; ++i) {
            n = FNV_Hash.hashStep(n, PearsonHash.hash8(typeArray[i].hashCode()));
        }
        this.hashCode = n;
        this.computeDisplay();
        this.computeRefinement();
    }

    public boolean isInstance(Object object) {
        return super.isInstance(object) && ((ScalaObject)object).getType().weakIsSubScalaClassType(this);
    }

    protected boolean isSubClassType(ClassType classType) {
        return super.isSubClassType(classType) && (classType.isTrivial || this.weakIsSubScalaClassType((ScalaClassType)classType));
    }

    protected boolean hasSubRefinements(Refinement[] refinementArray) {
        return Refinement.isFiner(this.refinements, refinementArray);
    }

    private boolean weakIsSubScalaClassType(ScalaClassType scalaClassType) {
        ScalaClassType scalaClassType2 = this.myInstantiationFor(scalaClassType);
        return scalaClassType2 != null && (scalaClassType2 == scalaClassType || scalaClassType2.hasSubInstantiation(scalaClassType));
    }

    private boolean hasSubInstantiation(ScalaClassType scalaClassType) {
        int n;
        if (!$assertionsDisabled && this.constr != scalaClassType.constr) {
            throw new AssertionError();
        }
        Type[] typeArray = this.inst;
        Type[] typeArray2 = scalaClassType.inst;
        int n2 = this.constr.zCount;
        for (n = 0; n < n2; ++n) {
            if (typeArray[n].isSameAs(typeArray2[n])) continue;
            return false;
        }
        int n3 = n2 + this.constr.mCount;
        while (n < n3) {
            if (!typeArray2[n].isSubType(typeArray[n])) {
                return false;
            }
            ++n;
        }
        int n4 = n3 + this.constr.pCount;
        while (n < n4) {
            if (!typeArray[n].isSubType(typeArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isSameAs(Type type) {
        if (super.isSameAs(type)) {
            ScalaClassType scalaClassType = (ScalaClassType)type;
            ScalaClassType scalaClassType2 = this.myInstantiationFor(scalaClassType);
            return scalaClassType2 != null && scalaClassType2.hasSameInstantiation(scalaClassType);
        }
        return false;
    }

    private boolean hasSameInstantiation(ScalaClassType scalaClassType) {
        Type[] typeArray = this.inst;
        Type[] typeArray2 = scalaClassType.inst;
        for (int i = 0; i < typeArray.length; ++i) {
            if (typeArray[i].isSameAs(typeArray2[i])) continue;
            return false;
        }
        return true;
    }

    private ScalaClassType myInstantiationFor(ScalaClassType scalaClassType) {
        ScalaClassType[] scalaClassTypeArray = this.display[scalaClassType.constr.level];
        for (int i = 0; i < scalaClassTypeArray.length; ++i) {
            if (scalaClassTypeArray[i].constr != scalaClassType.constr) continue;
            return scalaClassTypeArray[i];
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.constr.outer != null) {
            stringBuffer.append(this.constr.outer).append(".");
        }
        int n = this.constr.zCount;
        int n2 = n + this.constr.pCount;
        stringBuffer.append(this.constr).append("[");
        for (int i = 0; i < this.inst.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            if (i >= n2) {
                stringBuffer.append('+');
            } else if (i >= n) {
                stringBuffer.append('-');
            }
            stringBuffer.append(this.inst[i]);
        }
        return stringBuffer.append("]").toString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    private void computeDisplay() {
        int n = this.constr.level;
        int[] nArray = this.constr.displayCode;
        this.display = new ScalaClassType[n + 1][];
        ScalaClassType[][] scalaClassTypeArray = this.parents.length > 0 ? this.parents[0].display : EMPTY_DISPLAY;
        int n2 = 0;
        for (int i = 0; i <= n; ++i) {
            int n3 = nArray[n2++];
            ScalaClassType[] scalaClassTypeArray2 = i < scalaClassTypeArray.length ? scalaClassTypeArray[i] : (i == n ? new ScalaClassType[]{this} : EMPTY_DISPLAY_ROW);
            if (n3 == 0) {
                this.display[i] = scalaClassTypeArray2;
                continue;
            }
            int n4 = scalaClassTypeArray2.length;
            ScalaClassType[] scalaClassTypeArray3 = new ScalaClassType[n4 + n3];
            System.arraycopy(scalaClassTypeArray2, 0, scalaClassTypeArray3, 0, n4);
            for (int j = 0; j < n3; ++j) {
                int n5 = nArray[n2++];
                int n6 = nArray[n2++];
                scalaClassTypeArray3[n4 + j] = this.parents[n5].display[i][n6];
            }
            this.display[i] = scalaClassTypeArray3;
        }
    }

    private void computeRefinement() {
        this.refinements = Refinement.make(this.parents, this.refinements, this.constr.refinementCode);
    }

    static {
        $assertionsDisabled = !Class.forName("scala.runtime.types.ScalaClassType").desiredAssertionStatus();
        EMPTY_DISPLAY_ROW = new ScalaClassType[0];
        EMPTY_DISPLAY = new ScalaClassType[0][];
    }
}

