/*
 * Decompiled with CFR 0.152.
 */
package scalac.util;

import scalac.symtab.ClassSymbol;
import scalac.symtab.Symbol;
import scalac.symtab.SymbolNameWriter;
import scalac.util.Debug;
import scalac.util.Name;
import scalac.util.NameTransformer;

public class Names {
    private static final SymbolNameWriter writer;
    private static final String ALIAS_PREFIX = "alias$";
    private static final String LOCAL_PREFIX = "local$";
    private static final String MIXIN_PREFIX = "mixin$";
    private static final String OUTER_PREFIX = "outer$";
    private static final String SUPER_PREFIX = "super$";
    private static final String ACCESS_PREFIX = "access$";
    private static final String TUPLE_FIELD_PREFIX = "_";
    private static final String TYPE_PREFIX = "type$";
    public static final Name ERROR;
    public static final Name NOSYMBOL;
    public static final Name EMPTY;
    public static final Name IMPORT_WILDCARD;
    public static final Name PATTERN_WILDCARD;
    public static final Name COMPOUND_NAME;
    public static final Name ANON_CLASS_NAME;
    public static final Name ZERO;
    public static final Name STAR;
    public static final Name ROOT;
    public static final Name CONSTRUCTOR;
    public static final Name INITIALIZER;
    public static final Name INLINED_INITIALIZER;
    public static final Name _EQ;
    public static final Name MINUS;
    public static final Name PLUS;
    public static final Name TILDE;
    public static final Name EQEQ;
    public static final Name BANG;
    public static final Name BANGEQ;
    public static final Name BARBAR;
    public static final Name AMPAMP;
    public static final Name COLONCOLON;
    public static final Name PERCENT;
    public static final Name All;
    public static final Name AllRef;
    public static final Name Any;
    public static final Name AnyVal;
    public static final Name AnyRef;
    public static final Name Array;
    public static final Name Byte;
    public static final Name CaseClass;
    public static final Name Catch;
    public static final Name Char;
    public static final Name Boolean;
    public static final Name Do;
    public static final Name Double;
    public static final Name Element;
    public static final Name Finally;
    public static final Name Float;
    public static final Name Function;
    public static final Name GetType;
    public static final Name Int;
    public static final Name Labelled;
    public static final Name List;
    public static final Name Long;
    public static final Name Nil;
    public static final Name Object;
    public static final Name PartialFunction;
    public static final Name Predef;
    public static final Name ScalaObject;
    public static final Name ScalaRunTime;
    public static final Name Seq;
    public static final Name Short;
    public static final Name String;
    public static final Name Symbol;
    public static final Name Text;
    public static final Name Throwable;
    public static final Name Try;
    public static final Name Tuple;
    public static final Name Type;
    public static final Name Tuple2;
    public static final Name Unit;
    public static final Name While;
    public static final Name apply;
    public static final Name array;
    public static final Name asInstanceOf;
    public static final Name box;
    public static final Name caseArity;
    public static final Name caseElement;
    public static final Name checkCastability;
    public static final Name coerce;
    public static final Name defaultValue;
    public static final Name elem;
    public static final Name elements;
    public static final Name eq;
    public static final Name equals;
    public static final Name fail;
    public static final Name false_;
    public static final Name filter;
    public static final Name finalize;
    public static final Name flatmap;
    public static final Name foreach;
    public static final Name getClass;
    public static final Name hasAsInstance;
    public static final Name hashCode;
    public static final Name hasNext;
    public static final Name head;
    public static final Name isInstanceOf;
    public static final Name isDefinedAt;
    public static final Name isEmpty;
    public static final Name java;
    public static final Name lang;
    public static final Name length;
    public static final Name _match;
    public static final Name map;
    public static final Name n;
    public static final Name nobinding;
    public static final Name next;
    public static final Name newArray;
    public static final Name notify;
    public static final Name notifyAll;
    public static final Name null_;
    public static final Name predef;
    public static final Name print;
    public static final Name readResolve;
    public static final Name report;
    public static final Name runtime;
    public static final Name scala;
    public static final Name synchronized_;
    public static final Name tag;
    public static final Name tail;
    public static final Name toString;
    public static final Name that;
    public static final Name that1;
    public static final Name this_;
    public static final Name throw_;
    public static final Name true_;
    public static final Name update;
    public static final Name view;
    public static final Name wait;
    public static final Name xml;
    public static final Name ZNOT;
    public static final Name ZAND;
    public static final Name ZOR;
    public static final Name NOT;
    public static final Name ADD;
    public static final Name SUB;
    public static final Name MUL;
    public static final Name DIV;
    public static final Name MOD;
    public static final Name EQ;
    public static final Name NE;
    public static final Name LT;
    public static final Name LE;
    public static final Name GT;
    public static final Name GE;
    public static final Name OR;
    public static final Name XOR;
    public static final Name AND;
    public static final Name LSL;
    public static final Name LSR;
    public static final Name ASR;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public static Name ALIAS(ClassSymbol classSymbol) {
        return Name.fromString(ALIAS_PREFIX.concat(java.lang.String.valueOf(java.lang.String.valueOf(classSymbol.name)))).toTypeName();
    }

    public static Name LOCAL(Symbol symbol) {
        return Name.fromString(LOCAL_PREFIX.concat(java.lang.String.valueOf(java.lang.String.valueOf(symbol.name))));
    }

    public static Name MIXIN(Symbol symbol) {
        Name name = Name.fromString(java.lang.String.valueOf(java.lang.String.valueOf(MIXIN_PREFIX.concat(java.lang.String.valueOf(java.lang.String.valueOf(symbol.owner().name))))).concat(java.lang.String.valueOf(java.lang.String.valueOf(symbol.isInitializer() ? INLINED_INITIALIZER : symbol.name))));
        if (symbol.name.isTypeName()) {
            name = name.toTypeName();
        }
        return name;
    }

    public static Name OUTER(Symbol symbol) {
        if (symbol.isClass()) {
            return Name.fromString(OUTER_PREFIX.concat(java.lang.String.valueOf(java.lang.String.valueOf(symbol.owner().name))));
        }
        if (!$assertionsDisabled && !symbol.isConstructor()) {
            throw new AssertionError((Object)java.lang.String.valueOf(java.lang.String.valueOf(Debug.show(symbol))));
        }
        Symbol symbol2 = symbol.constructorClass();
        Symbol[] symbolArray = symbol2.allConstructors().alternativeSymbols();
        int n = 0;
        while (symbolArray[n] != symbol) {
            ++n;
        }
        String string = java.lang.String.valueOf(java.lang.String.valueOf(java.lang.String.valueOf(java.lang.String.valueOf(OUTER_PREFIX.concat(java.lang.String.valueOf(n)))).concat("$"))).concat(java.lang.String.valueOf(java.lang.String.valueOf(symbol2.owner().name)));
        return Name.fromString(string);
    }

    public static Name OUTER(Symbol symbol, Symbol symbol2) {
        Name name = Name.fromString(java.lang.String.valueOf(java.lang.String.valueOf(java.lang.String.valueOf(java.lang.String.valueOf(Names.OUTER(symbol))).concat("$"))).concat(java.lang.String.valueOf(java.lang.String.valueOf(symbol2.name))));
        if (symbol2.name.isTypeName()) {
            name = name.toTypeName();
        }
        return name;
    }

    public static Name ACCESS(Symbol symbol, boolean bl) {
        if (!($assertionsDisabled || symbol.isTerm() && symbol.owner().isClass())) {
            throw new AssertionError((Object)java.lang.String.valueOf(java.lang.String.valueOf(Debug.show(symbol))));
        }
        String string = bl ? "access$super$" : ACCESS_PREFIX;
        return Name.fromString(writer.toString(string, symbol));
    }

    public static Name TUPLE_FIELD(int n) {
        return Name.fromString(TUPLE_FIELD_PREFIX.concat(java.lang.String.valueOf(n)));
    }

    public static Name TYPE(Symbol symbol) {
        return Name.fromString(TYPE_PREFIX.concat(java.lang.String.valueOf(java.lang.String.valueOf(symbol.name))));
    }

    private static Name encode(String string) {
        return NameTransformer.encode(Name.fromString(string));
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.util.Names").desiredAssertionStatus();
        writer = new SymbolNameWriter().setAllSeparators('$').setRootSeparator('\u0000');
        ERROR = Name.fromString("<error>");
        NOSYMBOL = Name.fromString("<none>");
        EMPTY = Name.fromString("");
        IMPORT_WILDCARD = Name.fromString(TUPLE_FIELD_PREFIX);
        PATTERN_WILDCARD = Name.fromString(TUPLE_FIELD_PREFIX);
        COMPOUND_NAME = Name.fromString("<ct>");
        ANON_CLASS_NAME = Name.fromString("$anon");
        ZERO = Name.fromString("<zero>");
        STAR = Name.fromString("*");
        ROOT = Name.fromString("<root>");
        CONSTRUCTOR = Name.fromString("<init>");
        INITIALIZER = Name.fromString("<init>");
        INLINED_INITIALIZER = Name.fromString("$init$");
        _EQ = Names.encode("_=");
        MINUS = Names.encode("-");
        PLUS = Names.encode("+");
        TILDE = Names.encode("~");
        EQEQ = Names.encode("==");
        BANG = Names.encode("!");
        BANGEQ = Names.encode("!=");
        BARBAR = Names.encode("||");
        AMPAMP = Names.encode("&&");
        COLONCOLON = Names.encode("::");
        PERCENT = Names.encode("%");
        All = Name.fromString("All");
        AllRef = Name.fromString("AllRef");
        Any = Name.fromString("Any");
        AnyVal = Name.fromString("AnyVal");
        AnyRef = Name.fromString("AnyRef");
        Array = Name.fromString("Array");
        Byte = Name.fromString("Byte");
        CaseClass = Name.fromString("CaseClass");
        Catch = Name.fromString("Catch");
        Char = Name.fromString("Char");
        Boolean = Name.fromString("Boolean");
        Do = Name.fromString("Do");
        Double = Name.fromString("Double");
        Element = Name.fromString("Element");
        Finally = Name.fromString("Finally");
        Float = Name.fromString("Float");
        Function = Name.fromString("Function");
        GetType = Name.fromString("GetType");
        Int = Name.fromString("Int");
        Labelled = Name.fromString("Labelled");
        List = Name.fromString("List");
        Long = Name.fromString("Long");
        Nil = Name.fromString("Nil");
        Object = Name.fromString("Object");
        PartialFunction = Name.fromString("PartialFunction");
        Predef = Name.fromString("Predef");
        ScalaObject = Name.fromString("ScalaObject");
        ScalaRunTime = Name.fromString("ScalaRunTime");
        Seq = Name.fromString("Seq");
        Short = Name.fromString("Short");
        String = Name.fromString("String");
        Symbol = Name.fromString("Symbol");
        Text = Name.fromString("Text");
        Throwable = Name.fromString("Throwable");
        Try = Name.fromString("Try");
        Tuple = Name.fromString("Tuple");
        Type = Name.fromString("Type");
        Tuple2 = Name.fromString("Tuple2");
        Unit = Name.fromString("Unit");
        While = Name.fromString("While");
        apply = Name.fromString("apply");
        array = Name.fromString("array");
        asInstanceOf = Name.fromString("asInstanceOf");
        box = Name.fromString("box");
        caseArity = Name.fromString("caseArity");
        caseElement = Name.fromString("caseElement");
        checkCastability = Name.fromString("checkCastability");
        coerce = Name.fromString("coerce");
        defaultValue = Name.fromString("defaultValue");
        elem = Name.fromString("elem");
        elements = Name.fromString("elements");
        eq = Name.fromString("eq");
        equals = Name.fromString("equals");
        fail = Name.fromString("fail");
        false_ = Name.fromString("false");
        filter = Name.fromString("filter");
        finalize = Name.fromString("finalize");
        flatmap = Name.fromString("flatMap");
        foreach = Name.fromString("foreach");
        getClass = Name.fromString("getClass");
        hasAsInstance = Name.fromString("hasAsInstance");
        hashCode = Name.fromString("hashCode");
        hasNext = Name.fromString("hasNext");
        head = Name.fromString("head");
        isInstanceOf = Name.fromString("isInstanceOf");
        isDefinedAt = Name.fromString("isDefinedAt");
        isEmpty = Name.fromString("isEmpty");
        java = Name.fromString("java");
        lang = Name.fromString("lang");
        length = Name.fromString("length");
        _match = Name.fromString("match");
        map = Name.fromString("map");
        n = Name.fromString("n");
        nobinding = Name.fromString("nobinding");
        next = Name.fromString("next");
        newArray = Name.fromString("newArray");
        notify = Name.fromString("notify");
        notifyAll = Name.fromString("notifyAll");
        null_ = Name.fromString("null");
        predef = Name.fromString("predef");
        print = Name.fromString("print");
        readResolve = Name.fromString("readResolve");
        report = Name.fromString("report");
        runtime = Name.fromString("runtime");
        scala = Name.fromString("scala");
        synchronized_ = Name.fromString("synchronized");
        tag = Name.fromString("$tag");
        tail = Name.fromString("tail");
        toString = Name.fromString("toString");
        that = Name.fromString("that");
        that1 = Name.fromString("that1");
        this_ = Name.fromString("this");
        throw_ = Name.fromString("throw");
        true_ = Name.fromString("true");
        update = Name.fromString("update");
        view = Name.fromString("view");
        wait = Name.fromString("wait");
        xml = Name.fromString("xml");
        ZNOT = Names.encode("!");
        ZAND = Names.encode("&&");
        ZOR = Names.encode("||");
        NOT = Names.encode("~");
        ADD = Names.encode("+");
        SUB = Names.encode("-");
        MUL = Names.encode("*");
        DIV = Names.encode("/");
        MOD = Names.encode("%");
        EQ = Names.encode("==");
        NE = Names.encode("!=");
        LT = Names.encode("<");
        LE = Names.encode("<=");
        GT = Names.encode(">");
        GE = Names.encode(">=");
        OR = Names.encode("|");
        XOR = Names.encode("^");
        AND = Names.encode("&");
        LSL = Names.encode("<<");
        LSR = Names.encode(">>>");
        ASR = Names.encode(">>");
    }
}

