/*
 * Decompiled with CFR 0.152.
 */
package scalac.transformer;

import java.util.HashMap;
import scalac.ApplicationError;
import scalac.CompilationUnit;
import scalac.Global;
import scalac.ast.Tree;
import scalac.ast.TreeInfo;
import scalac.ast.TreeList;
import scalac.symtab.Definitions;
import scalac.symtab.Kinds;
import scalac.symtab.Modifiers;
import scalac.symtab.SymSet;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.transformer.LambdaLiftPhase;
import scalac.transformer.OwnerTransformer;
import scalac.util.Debug;

public class LambdaLift
extends OwnerTransformer
implements Modifiers,
Kinds {
    final Global global;
    final Definitions definitions;
    final FreeVars free;
    final LambdaLiftPhase descr;
    private CompilationUnit unit;
    private TreeList liftedDefs;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public LambdaLift(Global global, LambdaLiftPhase lambdaLiftPhase) {
        super(global);
        this.global = global;
        this.definitions = global.definitions;
        this.free = new FreeVars(global);
        this.descr = lambdaLiftPhase;
    }

    public void apply(CompilationUnit compilationUnit) {
        this.unit = compilationUnit;
        this.global.log(compilationUnit.source.toString());
        this.free.initialize(compilationUnit);
        this.currentOwner = this.global.definitions.ROOT_CLASS;
        compilationUnit.body = this.transformTemplateStats(compilationUnit.body, this.currentOwner);
    }

    static Symbol asFunction(Symbol symbol) {
        return symbol.kind == 3 ? symbol.primaryConstructor() : symbol;
    }

    static boolean isLocal(Symbol symbol, Symbol symbol2) {
        if ((symbol.flags & 0x8000) != 0 && symbol.owner().isPrimaryConstructor() && symbol.owner().constructorClass().kind == 3 && ((symbol2.flags & 0x8000) == 0 || symbol2.owner() != symbol)) {
            Symbol symbol3 = symbol.owner().owner();
            Symbol symbol4 = symbol.owner().constructorClass();
            while (symbol2 != symbol3 && symbol2.kind != 1 && symbol2 != symbol4) {
                symbol2 = symbol2.owner();
            }
            return symbol2 != symbol4;
        }
        return symbol.isLocal();
    }

    static Symbol enclFun(Symbol symbol) {
        Symbol symbol2 = symbol;
        while (!LambdaLift.asFunction(symbol2).isMethod()) {
            symbol2 = symbol2.owner();
        }
        return LambdaLift.asFunction(symbol2);
    }

    private static SymSet get(HashMap hashMap, Symbol symbol) {
        SymSet symSet = (SymSet)hashMap.get(symbol);
        return symSet == null ? SymSet.EMPTY : symSet;
    }

    public Tree[] transformTemplateStats(Tree[] treeArray, Symbol symbol) {
        TreeList treeList = this.liftedDefs;
        this.liftedDefs = new TreeList();
        TreeList treeList2 = new TreeList(super.transformTemplateStats(treeArray, symbol));
        treeList2.append(this.liftedDefs);
        this.liftedDefs = treeList;
        return treeList2.toArray();
    }

    public Tree transform(Tree tree) {
        tree.type = this.descr.transform(tree.type, this.currentOwner);
        switch (tree.$tag) {
            case 8: {
                Tree.Block block = (Tree.Block)tree;
                Tree[] treeArray = block.stats;
                Tree tree2 = block.expr;
                for (int i = 0; i < treeArray.length; ++i) {
                    this.liftSymbol(treeArray[i]);
                }
                return this.copy.Block(tree, this.transform(treeArray), this.transform(tree2));
            }
            case 10: {
                Tree.ClassDef classDef = (Tree.ClassDef)tree;
                int n = classDef.mods;
                Tree.AbsTypeDef[] absTypeDefArray = classDef.tparams;
                Tree.ValDef[][] valDefArray = classDef.vparams;
                Tree tree3 = classDef.tpe;
                Tree.Template template = classDef.impl;
                Symbol symbol = tree.symbol();
                if ((n & 0x8000000) != 0) {
                    ((Tree.ClassDef)tree).mods &= 0xF7FFFFFF;
                    Tree.ClassDef classDef2 = this.copy.ClassDef(tree, symbol, this.addTypeParams(this.transform(absTypeDefArray, symbol), this.newtparams(symbol.primaryConstructor())), new Tree.ValDef[][]{this.addParams(this.transform(valDefArray, symbol)[0], this.newparams(symbol.primaryConstructor()))}, this.transform(tree3, symbol), this.transform(template, symbol));
                    this.liftedDefs.append(classDef2);
                    return Tree.Empty;
                }
                if (!$assertionsDisabled && symbol.isLocal()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(symbol)));
                }
                return this.copy.ClassDef(tree, symbol, this.transform(absTypeDefArray, symbol), this.transform(valDefArray, symbol), this.transform(tree3, symbol), this.transform(template, symbol));
            }
            case 13: {
                Tree.DefDef defDef = (Tree.DefDef)tree;
                int n = defDef.mods;
                Tree.AbsTypeDef[] absTypeDefArray = defDef.tparams;
                Tree.ValDef[][] valDefArray = defDef.vparams;
                Tree tree4 = defDef.tpe;
                Tree tree5 = defDef.rhs;
                Symbol symbol = tree.symbol();
                if ((n & 0x8000000) != 0) {
                    ((Tree.DefDef)tree).mods &= 0xF7FFFFFF;
                    Tree.DefDef defDef2 = this.copy.DefDef(tree, symbol, this.addTypeParams(this.transform(absTypeDefArray, symbol), this.newtparams(symbol)), new Tree.ValDef[][]{this.addParams(this.transform(valDefArray, symbol)[0], this.newparams(symbol))}, this.transform(tree4, symbol), this.transform(tree5, symbol));
                    this.liftedDefs.append(defDef2);
                    return Tree.Empty;
                }
                if (!$assertionsDisabled && symbol.isLocal()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(symbol)));
                }
                return this.copy.DefDef(tree, symbol, this.transform(absTypeDefArray, symbol), this.transform(valDefArray, symbol), this.transform(tree4, symbol), this.transform(tree5, symbol));
            }
            case 0: {
                Tree.AbsTypeDef absTypeDef = (Tree.AbsTypeDef)tree;
                Tree tree6 = absTypeDef.rhs;
                Tree tree7 = absTypeDef.lobound;
                return this.copy.AbsTypeDef(tree, tree.symbol(), this.transform(tree6, this.currentOwner), this.transform(tree7, this.currentOwner));
            }
            case 1: {
                Tree.AliasTypeDef aliasTypeDef = (Tree.AliasTypeDef)tree;
                Tree.AbsTypeDef[] absTypeDefArray = aliasTypeDef.tparams;
                Tree tree8 = aliasTypeDef.rhs;
                return this.copy.AliasTypeDef(tree, tree.symbol(), this.transform(absTypeDefArray, this.currentOwner), this.transform(tree8, this.currentOwner));
            }
            case 40: {
                Tree.ValDef valDef = (Tree.ValDef)tree;
                Tree tree9 = valDef.rhs;
                Symbol symbol = tree.symbol();
                tree9 = this.transform(tree9, symbol);
                if ((symbol.flags & 0x1000000) != 0) {
                    if (!$assertionsDisabled && !symbol.isLocal()) {
                        throw new AssertionError();
                    }
                    Type type = symbol.nextType();
                    if (type.$tag == 8) {
                        Type.TypeRef typeRef = (Type.TypeRef)type;
                        Symbol symbol2 = typeRef.sym;
                        Type[] typeArray = typeRef.args;
                        Tree tree10 = this.gen.mkPrimaryConstructorGlobalRef(tree9.pos, symbol2);
                        tree9 = this.gen.New(this.gen.mkApplyTV(tree10, typeArray, new Tree[]{tree9}));
                    } else {
                        throw Debug.abort("illegal case", symbol.nextType());
                    }
                }
                return this.gen.ValDef(symbol, tree9);
            }
            case 29: {
                throw new ApplicationError("this should not happen");
            }
            case 26: {
                if (tree.symbol() != this.currentOwner.enclMethod()) {
                    this.unit.error(tree.pos, "non-local return not yet implemented");
                }
                return super.transform(tree);
            }
            case 4: {
                Tree[] treeArray;
                Tree.Apply apply = (Tree.Apply)tree;
                Tree tree11 = apply.fun;
                Tree[] treeArray2 = apply.args;
                Symbol symbol = TreeInfo.methSymbol(tree11);
                Tree tree12 = this.transform(tree11);
                if (tree12.$tag == 37) {
                    treeArray = (Tree[])tree12;
                    Tree tree13 = treeArray.fun;
                    Tree[] treeArray3 = treeArray.args;
                    if (treeArray2.length == 1 && tree13.symbol() == this.definitions.PREDEF_ARRAY()) {
                        throw new ApplicationError("this should not happen");
                    }
                    tree12 = this.copy.TypeApply(tree12, tree13, this.addFreeArgs(tree.pos, LambdaLift.get(this.free.access$30(), symbol), treeArray3, true));
                } else {
                    treeArray = this.addFreeArgs(tree.pos, LambdaLift.get(this.free.access$30(), symbol), Tree.EMPTY_ARRAY, true);
                    if (treeArray.length > 0) {
                        tree12 = this.gen.TypeApply(tree12, treeArray);
                    }
                }
                treeArray = this.transform(treeArray2);
                return this.copy.Apply(tree, tree12, this.addFreeArgs(tree.pos, LambdaLift.get(this.free.access$31(), symbol), treeArray, false));
            }
            case 17: {
                Symbol symbol = tree.symbol();
                if (LambdaLift.isLocal(symbol, this.currentOwner) && (symbol.kind == 4 || symbol.kind == 5 && !symbol.isMethod())) {
                    symbol = this.descr.proxy(symbol, this.currentOwner);
                }
                Tree tree14 = this.gen.mkLocalRef(tree.pos, symbol);
                if ((symbol.flags & 0x1000000) != 0) {
                    return this.gen.Select(tree14, this.definitions.REF_ELEM());
                }
                return tree14;
            }
        }
        return super.transform(tree);
    }

    Symbol[] ftvsParams(Symbol symbol) {
        Symbol[] symbolArray = LambdaLift.get(this.free.access$30(), symbol).toArray();
        Symbol[] symbolArray2 = new Symbol[symbolArray.length];
        for (int i = 0; i < symbolArray2.length; ++i) {
            symbolArray2[i] = symbolArray[i].cloneSymbol(symbol);
            symbolArray2[i].pos = symbol.pos;
            symbolArray2[i].flags = 33792;
        }
        for (int i = 0; i < symbolArray2.length; ++i) {
            symbolArray2[i].setInfo(symbolArray[i].info().subst(symbolArray, symbolArray2));
        }
        return symbolArray2;
    }

    Symbol[] fvsParams(Symbol symbol) {
        Symbol[] symbolArray = LambdaLift.get(this.free.access$31(), symbol).toArray();
        Symbol[] symbolArray2 = new Symbol[symbolArray.length];
        for (int i = 0; i < symbolArray2.length; ++i) {
            symbolArray2[i] = symbolArray[i].cloneSymbol(symbol);
            symbolArray2[i].pos = symbol.pos;
            symbolArray2[i].flags &= 0x1000000;
            symbolArray2[i].flags |= 0x8400;
            symbolArray2[i].setInfo(symbolArray[i].type());
        }
        return symbolArray2;
    }

    Symbol[] newtparams(Symbol symbol) {
        Symbol[] symbolArray = symbol.nextType().typeParams();
        int n = LambdaLift.get(this.free.access$30(), symbol).size();
        if (!$assertionsDisabled && n != symbolArray.length - symbol.type().typeParams().length) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(symbol)).concat(" "))).concat(String.valueOf(n)))).concat(" "))).concat(String.valueOf(symbolArray.length)))).concat(" "))).concat(String.valueOf(symbol.type().firstParams().length)))));
        }
        Symbol[] symbolArray2 = new Symbol[n];
        System.arraycopy(symbolArray, symbolArray.length - n, symbolArray2, 0, n);
        return symbolArray2;
    }

    Symbol[] newparams(Symbol symbol) {
        Symbol[] symbolArray = symbol.nextType().firstParams();
        int n = LambdaLift.get(this.free.access$31(), symbol).size();
        if (!$assertionsDisabled && n != symbolArray.length - symbol.type().firstParams().length) {
            throw new AssertionError();
        }
        Symbol[] symbolArray2 = new Symbol[n];
        System.arraycopy(symbolArray, symbolArray.length - n, symbolArray2, 0, n);
        return symbolArray2;
    }

    void liftSymbol(Tree tree) {
        switch (tree.$tag) {
            case 10: {
                ((Tree.ClassDef)tree).mods |= 0x8000000;
                Symbol symbol = tree.symbol();
                symbol.flags |= 0x8000000;
                if (!$assertionsDisabled && !symbol.isLocal()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(symbol)));
                }
                Symbol symbol2 = symbol.primaryConstructor();
                this.liftSymbol(symbol, LambdaLift.get(this.free.access$30(), symbol2).toArray(), this.ftvsParams(symbol2), this.fvsParams(symbol2));
                break;
            }
            case 13: {
                ((Tree.DefDef)tree).mods |= 0x8000000;
                Symbol symbol = tree.symbol();
                symbol.flags |= 0x8000004;
                if (!$assertionsDisabled && !symbol.isLocal()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(symbol)));
                }
                this.liftSymbol(symbol, LambdaLift.get(this.free.access$30(), symbol).toArray(), this.ftvsParams(symbol), this.fvsParams(symbol));
                break;
            }
            case 40: {
                Symbol symbol = tree.symbol();
                if (!$assertionsDisabled && !symbol.isLocal()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(symbol)));
                }
                if (this.isClassMember(symbol.owner())) break;
                if (!$assertionsDisabled && !this.isClassMember(symbol.owner().owner())) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(tree, symbol))));
                }
                symbol.setOwner(symbol.owner().owner());
                break;
            }
            case 20: {
                Symbol symbol = tree.symbol();
                if (!$assertionsDisabled && !symbol.isLocal()) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(symbol)));
                }
                if (this.isClassMember(symbol.owner())) break;
                if (!$assertionsDisabled && !this.isClassMember(symbol.owner().owner())) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(tree, symbol))));
                }
                symbol.setOwner(symbol.owner().owner());
            }
        }
    }

    private boolean isClassMember(Symbol symbol) {
        return symbol.isConstructor() || symbol.owner().isClass();
    }

    void liftSymbol(Symbol symbol, Symbol[] symbolArray, Symbol[] symbolArray2, Symbol[] symbolArray3) {
        Symbol symbol2 = symbol.owner();
        while (!symbol2.isClassType()) {
            symbol2 = symbol2.isConstructor() && !symbol2.isPrimaryConstructor() ? symbol2.constructorClass() : symbol2.owner();
        }
        if (!symbol.isConstructor()) {
            symbol.setOwner(symbol2);
        }
        if (!symbol.isConstructor()) {
            symbol2.members().enter(symbol);
        }
        if (symbol.isMethod()) {
            if (symbolArray2.length != 0 || symbolArray3.length != 0) {
                symbol.updateInfo(this.addParams(this.addTypeParams(symbol.nextInfo(), symbolArray, symbolArray2), symbolArray3));
                if (this.global.debug) {
                    this.global.log(String.valueOf(String.valueOf(String.valueOf(String.valueOf(symbol)).concat(" has now type "))).concat(String.valueOf(String.valueOf(symbol.nextType()))));
                }
            }
        } else if (symbol.kind == 3) {
            Symbol symbol3 = symbol.primaryConstructor();
            this.liftSymbol(symbol3, symbolArray, symbolArray2, symbolArray3);
            symbol3.updateInfo(this.descr.transform(symbol3.nextInfo(), symbol3));
        } else {
            throw new ApplicationError();
        }
    }

    Type addTypeParams(Type type, Symbol[] symbolArray, Symbol[] symbolArray2) {
        if (symbolArray2.length == 0) {
            return type;
        }
        switch (type.$tag) {
            case 3: {
                return Type.PolyType(symbolArray2, Type.getSubst(symbolArray, symbolArray2, true).apply(type));
            }
            case 5: {
                Type.PolyType polyType = (Type.PolyType)type;
                Symbol[] symbolArray3 = polyType.tparams;
                Type type2 = polyType.result;
                Symbol[] symbolArray4 = new Symbol[symbolArray3.length + symbolArray2.length];
                System.arraycopy(symbolArray3, 0, symbolArray4, 0, symbolArray3.length);
                System.arraycopy(symbolArray2, 0, symbolArray4, symbolArray3.length, symbolArray2.length);
                return Type.PolyType(symbolArray4, Type.getSubst(symbolArray, symbolArray2, true).apply(type2));
            }
        }
        throw new ApplicationError("illegal type: ".concat(String.valueOf(String.valueOf(type))));
    }

    Type addParams(Type type, Symbol[] symbolArray) {
        if (symbolArray.length == 0) {
            return type;
        }
        switch (type.$tag) {
            case 3: {
                Type.MethodType methodType = (Type.MethodType)type;
                Symbol[] symbolArray2 = methodType.vparams;
                Type type2 = methodType.result;
                Symbol[] symbolArray3 = new Symbol[symbolArray2.length + symbolArray.length];
                System.arraycopy(symbolArray2, 0, symbolArray3, 0, symbolArray2.length);
                System.arraycopy(symbolArray, 0, symbolArray3, symbolArray2.length, symbolArray.length);
                return Type.MethodType(symbolArray3, type2);
            }
            case 5: {
                Type.PolyType polyType = (Type.PolyType)type;
                Symbol[] symbolArray4 = polyType.tparams;
                Type type3 = polyType.result;
                return Type.PolyType(symbolArray4, this.addParams(type3, symbolArray));
            }
        }
        throw new ApplicationError("illegal type: ".concat(String.valueOf(String.valueOf(type))));
    }

    Tree.AbsTypeDef[] addTypeParams(Tree.AbsTypeDef[] absTypeDefArray, Symbol[] symbolArray) {
        if (symbolArray.length == 0) {
            return absTypeDefArray;
        }
        Tree.AbsTypeDef[] absTypeDefArray2 = new Tree.AbsTypeDef[absTypeDefArray.length + symbolArray.length];
        System.arraycopy(absTypeDefArray, 0, absTypeDefArray2, 0, absTypeDefArray.length);
        for (int i = 0; i < symbolArray.length; ++i) {
            absTypeDefArray2[absTypeDefArray.length + i] = this.gen.mkTypeParam(symbolArray[i]);
        }
        return absTypeDefArray2;
    }

    Tree.ValDef[] addParams(Tree.ValDef[] valDefArray, Symbol[] symbolArray) {
        if (symbolArray.length == 0) {
            return valDefArray;
        }
        Tree.ValDef[] valDefArray2 = new Tree.ValDef[valDefArray.length + symbolArray.length];
        System.arraycopy(valDefArray, 0, valDefArray2, 0, valDefArray.length);
        for (int i = 0; i < symbolArray.length; ++i) {
            valDefArray2[valDefArray.length + i] = this.gen.mkParam(symbolArray[i]);
        }
        return valDefArray2;
    }

    Tree[] addFreeArgs(int n, SymSet symSet, Tree[] treeArray, boolean bl) {
        if (symSet != SymSet.EMPTY) {
            Symbol[] symbolArray = symSet.toArray();
            Tree[] treeArray2 = new Tree[treeArray.length + symbolArray.length];
            System.arraycopy(treeArray, 0, treeArray2, 0, treeArray.length);
            for (int i = 0; i < symbolArray.length; ++i) {
                Symbol symbol = this.descr.proxy(symbolArray[i], this.currentOwner);
                treeArray2[treeArray.length + i] = bl ? this.gen.mkTypeRef(n, symbol) : this.gen.Ident(n, symbol);
            }
            return treeArray2;
        }
        return treeArray;
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.transformer.LambdaLift").desiredAssertionStatus();
    }

    static class FreeVars
    extends OwnerTransformer {
        private CompilationUnit unit;
        private HashMap fvs;
        private HashMap ftvs;
        private HashMap called;
        private SymSet renamable;
        private SymSet excluded;
        private boolean changedFreeVars;
        private boolean propagatePhase;
        private Type.Map traverseTypeMap = new 14();
        private static final /* synthetic */ boolean $assertionsDisabled;

        public FreeVars(Global global) {
            super(global);
        }

        private void putFree(Symbol symbol, Symbol symbol2) {
            if (!$assertionsDisabled && !symbol.isLocal()) {
                throw new AssertionError();
            }
            HashMap hashMap = symbol2.isType() ? this.ftvs : this.fvs;
            SymSet symSet = LambdaLift.get(hashMap, symbol);
            if (!symSet.contains(symbol2)) {
                hashMap.put(symbol, symSet.incl(symbol2));
                this.changedFreeVars = true;
                if (this.global.debug) {
                    this.global.log(String.valueOf(String.valueOf(String.valueOf(String.valueOf(symbol2)).concat(" is free in "))).concat(String.valueOf(String.valueOf(symbol))));
                }
            }
        }

        private void putCall(Symbol symbol, Symbol symbol2) {
            SymSet symSet = LambdaLift.get(this.called, symbol);
            if (!symSet.contains(symbol2)) {
                this.called.put(symbol, symSet.incl(symbol2));
            }
        }

        private boolean markFree(Symbol symbol, Symbol symbol2) {
            if (this.global.debug) {
                this.global.log(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("mark ".concat(String.valueOf(String.valueOf(symbol))))).concat(" of "))).concat(String.valueOf(String.valueOf(symbol.owner()))))).concat(" free in "))).concat(String.valueOf(String.valueOf(symbol2))));
            }
            if (symbol2.kind == 1) {
                if (!$assertionsDisabled && !this.propagatePhase) {
                    throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(symbol)).concat(" in "))).concat(String.valueOf(String.valueOf(symbol.owner()))))));
                }
                return false;
            }
            if (symbol.owner() == symbol2) {
                return true;
            }
            if (this.markFree(symbol, symbol2.owner())) {
                Symbol symbol3 = LambdaLift.asFunction(symbol2);
                if (symbol3.isMethod()) {
                    this.putFree(symbol3, symbol);
                    this.renamable = this.renamable.incl(symbol);
                    if (symbol.isVariable()) {
                        symbol.flags |= 0x1000000;
                    }
                }
                return symbol2.kind != 3;
            }
            return false;
        }

        private void makeUnique(Symbol symbol) {
            symbol.name = this.unit.fresh.newName(symbol.name);
        }

        public Tree transform(Tree tree) {
            if (this.global.debug) {
                this.global.log("free ".concat(String.valueOf(String.valueOf(tree))));
            }
            if (!$assertionsDisabled && tree.type == null) {
                throw new AssertionError((Object)String.valueOf(String.valueOf(tree)));
            }
            this.traverseTypeMap.apply(tree.type.widen());
            Symbol symbol = tree.symbol();
            switch (tree.$tag) {
                case 10: {
                    if (symbol.isLocal()) {
                        this.renamable = this.renamable.incl(symbol);
                    }
                    return super.transform(tree);
                }
                case 13: {
                    if (symbol.isLocal()) {
                        this.renamable = this.renamable.incl(symbol);
                    }
                    return super.transform(tree);
                }
                case 0: {
                    Tree.AbsTypeDef absTypeDef = (Tree.AbsTypeDef)tree;
                    Tree tree2 = absTypeDef.rhs;
                    Tree tree3 = absTypeDef.lobound;
                    return this.copy.AbsTypeDef(tree, symbol, this.transform(tree2, this.currentOwner), this.transform(tree3, this.currentOwner));
                }
                case 1: {
                    Tree.AliasTypeDef aliasTypeDef = (Tree.AliasTypeDef)tree;
                    Tree.AbsTypeDef[] absTypeDefArray = aliasTypeDef.tparams;
                    Tree tree4 = aliasTypeDef.rhs;
                    return this.copy.AliasTypeDef(tree, symbol, this.transform(absTypeDefArray, this.currentOwner), this.transform(tree4, this.currentOwner));
                }
                case 17: {
                    if (LambdaLift.isLocal(symbol, this.currentOwner)) {
                        if (symbol.isMethod()) {
                            Symbol symbol2 = LambdaLift.enclFun(this.currentOwner);
                            if (symbol2.name.length() > 0) {
                                this.putCall(symbol2, symbol);
                            }
                        } else if (symbol.kind == 5 || symbol.kind == 4) {
                            this.markFree(symbol, this.currentOwner);
                        }
                    }
                    return tree;
                }
            }
            return super.transform(tree);
        }

        void propagateFvs(HashMap hashMap) {
            Object[] objectArray = this.called.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Symbol symbol = (Symbol)objectArray[i];
                Symbol[] symbolArray = LambdaLift.get(this.called, symbol).toArray();
                for (int j = 0; j < symbolArray.length; ++j) {
                    Symbol[] symbolArray2 = LambdaLift.get(hashMap, symbolArray[j]).toArray();
                    for (int k = 0; k < symbolArray2.length; ++k) {
                        this.markFree(symbolArray2[k], symbol);
                    }
                }
            }
        }

        void restoreFvs(HashMap hashMap) {
            Object[] objectArray = hashMap.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Symbol symbol = (Symbol)objectArray[i];
                Symbol[] symbolArray = LambdaLift.get(hashMap, symbol).toArray();
                SymSet symSet = SymSet.EMPTY;
                for (int j = 0; j < symbolArray.length; ++j) {
                    symSet = symSet.incl(symbolArray[j]);
                }
                hashMap.put(symbol, symSet);
            }
        }

        public void initialize(CompilationUnit compilationUnit) {
            this.unit = compilationUnit;
            this.fvs = new HashMap();
            this.ftvs = new HashMap();
            this.called = new HashMap();
            this.renamable = SymSet.EMPTY;
            this.excluded = SymSet.EMPTY;
            this.apply(compilationUnit);
            this.propagatePhase = true;
            do {
                this.changedFreeVars = false;
                this.propagateFvs(this.fvs);
                this.propagateFvs(this.ftvs);
            } while (this.changedFreeVars);
            Symbol[] symbolArray = this.renamable.toArray();
            for (int i = 0; i < symbolArray.length; ++i) {
                this.makeUnique(symbolArray[i]);
            }
            this.restoreFvs(this.fvs);
            this.restoreFvs(this.ftvs);
        }

        final /* synthetic */ boolean access$28(Symbol symbol, Symbol symbol2) {
            return this.markFree(symbol, symbol2);
        }

        final /* synthetic */ SymSet access$27() {
            return this.excluded;
        }

        final /* synthetic */ SymSet access$29(SymSet symSet) {
            this.excluded = symSet;
            return this.excluded;
        }

        final /* synthetic */ HashMap access$30() {
            return this.ftvs;
        }

        final /* synthetic */ HashMap access$31() {
            return this.fvs;
        }

        static {
            $assertionsDisabled = !Class.forName("scalac.transformer.LambdaLift").desiredAssertionStatus();
        }

        class 14
        extends Type.Map {
            public Type apply(Type type) {
                if (FreeVars.this.global.debug) {
                    FreeVars.this.global.log("traverse ".concat(String.valueOf(String.valueOf(type))));
                }
                switch (type.$tag) {
                    case 8: {
                        Symbol symbol;
                        Type.TypeRef typeRef = (Type.TypeRef)type;
                        if (typeRef.pre.$tag != 14 || !LambdaLift.isLocal(symbol = typeRef.sym, FreeVars.this.currentOwner) || symbol.kind != 4 || FreeVars.this.access$27().contains(symbol)) break;
                        FreeVars.this.access$28(symbol, FreeVars.this.currentOwner);
                        break;
                    }
                    case 5: {
                        Type.PolyType polyType = (Type.PolyType)type;
                        Symbol[] symbolArray = polyType.tparams;
                        for (int i = 0; i < symbolArray.length; ++i) {
                            FreeVars.this.access$29(FreeVars.this.access$27().incl(symbolArray[i]));
                        }
                        Type type2 = super.map(type);
                        for (int i = 0; i < symbolArray.length; ++i) {
                            FreeVars.this.access$29(FreeVars.this.access$27().excl(symbolArray[i]));
                        }
                        return type2;
                    }
                }
                return this.map(type);
            }

            14() {
            }
        }
    }
}

