/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab.classfile;

import java.util.HashMap;
import scalac.ApplicationError;
import scalac.Global;
import scalac.atree.AConstant;
import scalac.symtab.EntryTags;
import scalac.symtab.Kinds;
import scalac.symtab.Modifiers;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.util.Debug;
import scalac.util.Name;

public class Pickle
implements Kinds,
Modifiers,
EntryTags {
    static final boolean debug = false;
    public byte[] bytes;
    private int bp;
    private Name rootname;
    private Symbol rootowner;
    private HashMap index = new HashMap();
    private Object[] entries = new Object[256];
    private int ep = 0;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public void add(Symbol symbol) {
        if (!symbol.isExternal()) {
            if (Global.instance.debug) {
                System.out.println("pickling ".concat(String.valueOf(String.valueOf(symbol))));
            }
            if (this.index.get(symbol) == null) {
                this.rootname = symbol.name.toTermName();
                this.rootowner = symbol.owner();
                this.putSymbol(symbol);
            }
        }
    }

    public void pickle() {
        this.bytes = new byte[4096];
        this.bp = 0;
        this.writeAttr();
        this.index = null;
        this.entries = null;
    }

    public int size() {
        return this.bp;
    }

    private boolean isLocal(Symbol symbol) {
        return symbol.name.toTermName() == this.rootname && symbol.owner() == this.rootowner || symbol.isConstructor() && this.isLocal(symbol.constructorClass()) || symbol.kind != 1 && this.isLocal(symbol.owner());
    }

    private boolean putEntry(Object object) {
        Integer n = (Integer)this.index.get(object);
        if (n == null) {
            if (this.ep == this.entries.length) {
                Object[] objectArray = new Object[this.ep * 2];
                System.arraycopy(this.entries, 0, objectArray, 0, this.ep);
                this.entries = objectArray;
            }
            this.entries[this.ep] = object;
            this.index.put(object, new Integer(this.ep));
            ++this.ep;
            return true;
        }
        return false;
    }

    private void putSymbol(Symbol symbol) {
        block14: {
            block15: {
                if (!this.putEntry(symbol)) break block14;
                if (!this.isLocal(symbol)) break block15;
                this.putEntry(symbol.name);
                this.putSymbol(symbol.isConstructor() ? symbol.constructorClass() : symbol.owner());
                switch (symbol.kind) {
                    case 4: {
                        if (symbol.isViewBounded()) {
                            this.putType(symbol.vuBound());
                        } else {
                            this.putType(symbol.info());
                        }
                        this.putType(symbol.loBound());
                        break;
                    }
                    case 2: {
                        this.putType(symbol.info());
                        this.putSymbol(symbol.allConstructors());
                        break;
                    }
                    case 3: {
                        this.putType(symbol.info());
                        if (symbol.isModuleClass()) {
                            this.putSymbol(symbol.sourceModule());
                        }
                        this.putType(symbol.typeOfThis());
                        this.putSymbol(symbol.allConstructors());
                        Symbol[] symbolArray = symbol.members().elements();
                        for (int i = 0; i < symbolArray.length; ++i) {
                            this.putSymbol(symbolArray[i]);
                        }
                        break block14;
                    }
                    case 5: {
                        this.putType(symbol.removeInheritedOverloaded(symbol.info()));
                        if (symbol.isConstructor() && symbol == symbol.constructorClass().allConstructors()) {
                            this.putSymbol(symbol.constructorClass());
                            break;
                        }
                        if (symbol.isModule()) {
                            this.putSymbol(symbol.moduleClass());
                            break;
                        }
                        break block14;
                    }
                    default: {
                        throw new ApplicationError();
                    }
                }
                break block14;
            }
            if (symbol.kind != 1) {
                this.putEntry(symbol.isModuleClass() || symbol.isRoot() ? symbol.name.toTermName() : symbol.name);
                if (!symbol.owner().isRoot()) {
                    this.putSymbol(symbol.owner());
                }
            }
        }
    }

    private void putSymbols(Symbol[] symbolArray) {
        for (int i = 0; i < symbolArray.length; ++i) {
            this.putSymbol(symbolArray[i]);
        }
    }

    private void putType(Type type) {
        if (this.putEntry(type)) {
            switch (type.$tag) {
                case 15: {
                    break;
                }
                case 14: {
                    this.putSymbol(Symbol.NONE);
                    break;
                }
                case 7: {
                    Type.ThisType thisType = (Type.ThisType)type;
                    Symbol symbol = thisType.sym;
                    this.putSymbol(symbol);
                    break;
                }
                case 6: {
                    Type.SingleType singleType = (Type.SingleType)type;
                    Type type2 = singleType.pre;
                    Symbol symbol = singleType.sym;
                    this.putType(type2);
                    this.putSymbol(symbol);
                    break;
                }
                case 1: {
                    Type.ConstantType constantType = (Type.ConstantType)type;
                    Type type3 = constantType.base;
                    AConstant aConstant = constantType.value;
                    this.putType(type3);
                    this.putConstant(aConstant);
                    break;
                }
                case 8: {
                    Type.TypeRef typeRef = (Type.TypeRef)type;
                    Type type4 = typeRef.pre;
                    Symbol symbol = typeRef.sym;
                    Type[] typeArray = typeRef.args;
                    this.putType(type4);
                    this.putSymbol(symbol);
                    this.putTypes(typeArray);
                    break;
                }
                case 0: {
                    Type.CompoundType compoundType = (Type.CompoundType)type;
                    Type[] typeArray = compoundType.parts;
                    Symbol symbol = type.symbol();
                    if (symbol.isCompoundSym()) {
                        this.putSymbol(symbol.owner());
                    }
                    this.putSymbol(symbol);
                    this.putTypes(typeArray);
                    break;
                }
                case 3: {
                    Type.MethodType methodType = (Type.MethodType)type;
                    Symbol[] symbolArray = methodType.vparams;
                    Type type5 = methodType.result;
                    this.putType(type5);
                    for (int i = 0; i < symbolArray.length; ++i) {
                        Type type6 = symbolArray[i].type();
                        this.putType(type6);
                        int n = symbolArray[i].flags;
                        if ((n & 0x300) == 0) continue;
                        this.putEntry(new FlagsAndType(Pickle.encodeFlags(n), type6));
                    }
                    break;
                }
                case 5: {
                    Type.PolyType polyType = (Type.PolyType)type;
                    Symbol[] symbolArray = polyType.tparams;
                    Type type7 = polyType.result;
                    this.putType(type7);
                    this.putSymbols(symbolArray);
                    break;
                }
                case 4: {
                    Type.OverloadedType overloadedType = (Type.OverloadedType)type;
                    Symbol[] symbolArray = overloadedType.alts;
                    Type[] typeArray = overloadedType.alttypes;
                    for (int i = 0; i < symbolArray.length; ++i) {
                        symbolArray[i].flags |= 0x8000000;
                    }
                    this.putSymbols(symbolArray);
                    this.putTypes(typeArray);
                    break;
                }
                default: {
                    throw new ApplicationError();
                }
            }
        }
    }

    private void putTypes(Type[] typeArray) {
        for (int i = 0; i < typeArray.length; ++i) {
            this.putType(typeArray[i]);
        }
    }

    private void putConstant(AConstant aConstant) {
        if (this.putEntry(aConstant) && aConstant.$tag == 8) {
            AConstant.STRING sTRING = (AConstant.STRING)aConstant;
            String string = sTRING.value;
            this.putEntry(Name.fromString(string));
            return;
        }
    }

    private void resizeTo(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.bytes, 0, byArray, 0, this.bp);
        this.bytes = byArray;
    }

    private void writeByte(int n) {
        if (this.bp == this.bytes.length) {
            this.resizeTo(this.bytes.length * 2);
        }
        this.bytes[this.bp++] = (byte)n;
    }

    private void writeNat(int n) {
        int n2 = n >>> 7;
        if (n2 != 0) {
            this.writeNatPrefix(n2);
        }
        this.writeByte(n & 0x7F);
    }

    private void writeNatPrefix(int n) {
        int n2 = n >>> 7;
        if (n2 != 0) {
            this.writeNatPrefix(n2);
        }
        this.writeByte(n & 0x7F | 0x80);
    }

    private void patchNat(int n, int n2) {
        this.bytes[n] = (byte)(n2 & 0x7F);
        int n3 = n2 >>> 7;
        if (n3 != 0) {
            this.patchNatPrefix(n, n3);
        }
    }

    private void patchNatPrefix(int n, int n2) {
        this.writeByte(0);
        System.arraycopy(this.bytes, n, this.bytes, n + 1, this.bp - (n + 1));
        this.bytes[n] = (byte)(n2 & 0x7F | 0x80);
        int n3 = n2 >>> 7;
        if (n3 != 0) {
            this.patchNatPrefix(n, n3);
        }
    }

    private void writeLong(long l) {
        long l2 = l >> 8;
        long l3 = l & 0xFFL;
        if (-l2 != l3 >> 7) {
            this.writeLong(l2);
        }
        this.writeByte((int)l3);
    }

    private void writeRef(Object object) {
        Integer n = (Integer)this.index.get(object);
        if (!$assertionsDisabled && n == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(object)).concat(" "))).concat(String.valueOf(String.valueOf(object.getClass()))))));
        }
        this.writeNat(n);
    }

    private void writeRefs(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.writeRef(objectArray[i]);
        }
    }

    private void writeName(Name name) {
        this.writeByte(name.isTermName() ? 1 : 2);
        this.writeByte(0);
        byte[] byArray = name.toAsciiUnsafe();
        while (this.bp + byArray.length > this.bytes.length) {
            this.resizeTo(this.bytes.length * 2);
        }
        System.arraycopy(byArray, 0, this.bytes, this.bp, byArray.length);
        this.bp += byArray.length;
    }

    private void writeSymbol(Symbol symbol) {
        block24: {
            block23: {
                if (!this.isLocal(symbol)) break block23;
                switch (symbol.kind) {
                    case 4: {
                        this.writeByte(5);
                        break;
                    }
                    case 2: {
                        this.writeByte(6);
                        break;
                    }
                    case 3: {
                        this.writeByte(7);
                        break;
                    }
                    case 5: {
                        this.writeByte(8);
                        break;
                    }
                    default: {
                        throw new ApplicationError();
                    }
                }
                this.writeByte(0);
                this.writeRef(symbol.name);
                this.writeRef(symbol.isConstructor() ? symbol.constructorClass() : symbol.owner());
                this.writeNat(symbol.flags);
                switch (symbol.kind) {
                    case 4: {
                        if (symbol.isViewBounded()) {
                            this.writeRef(symbol.vuBound());
                        } else {
                            this.writeRef(symbol.info());
                        }
                        this.writeRef(symbol.loBound());
                        break;
                    }
                    case 2: {
                        this.writeRef(symbol.info());
                        this.writeRef(symbol.allConstructors());
                        break;
                    }
                    case 3: {
                        this.writeRef(symbol.info());
                        if (symbol.isModuleClass()) {
                            this.writeRef(symbol.sourceModule());
                        }
                        this.writeRef(symbol.typeOfThis());
                        this.writeRef(symbol.allConstructors());
                        break;
                    }
                    case 5: {
                        this.writeRef(symbol.removeInheritedOverloaded(symbol.info()));
                        if (symbol.isConstructor() && symbol == symbol.constructorClass().allConstructors()) {
                            this.writeRef(symbol.constructorClass());
                            break;
                        }
                        if (symbol.isModule()) {
                            this.writeRef(symbol.moduleClass());
                            break;
                        }
                        break block24;
                    }
                    default: {
                        throw new ApplicationError();
                    }
                }
                break block24;
            }
            if (symbol.kind == 1) {
                this.writeByte(4);
                this.writeByte(0);
            } else {
                if (symbol.isModuleClass() || symbol.isRoot()) {
                    this.writeByte(10);
                    this.writeByte(0);
                    this.writeRef(symbol.name.toTermName());
                } else {
                    this.writeByte(9);
                    this.writeByte(0);
                    if (!$assertionsDisabled && symbol.isConstructor()) {
                        throw new AssertionError((Object)String.valueOf(String.valueOf(symbol)));
                    }
                    this.writeRef(symbol.name);
                }
                if (!symbol.owner().isRoot()) {
                    this.writeRef(symbol.owner());
                }
            }
        }
        symbol.flags &= 0xF7FFFFFF;
    }

    private void writeType(Type type) {
        switch (type.$tag) {
            case 15: {
                this.writeByte(11);
                this.writeByte(0);
                break;
            }
            case 14: {
                this.writeByte(12);
                this.writeByte(0);
                this.writeRef(Symbol.NONE);
                break;
            }
            case 7: {
                Type.ThisType thisType = (Type.ThisType)type;
                Symbol symbol = thisType.sym;
                this.writeByte(12);
                this.writeByte(0);
                this.writeRef(symbol);
                break;
            }
            case 6: {
                Type.SingleType singleType = (Type.SingleType)type;
                Type type2 = singleType.pre;
                Symbol symbol = singleType.sym;
                this.writeByte(13);
                this.writeByte(0);
                this.writeRef(type2);
                this.writeRef(symbol);
                break;
            }
            case 1: {
                Type.ConstantType constantType = (Type.ConstantType)type;
                Type type3 = constantType.base;
                AConstant aConstant = constantType.value;
                this.writeByte(14);
                this.writeByte(0);
                this.writeRef(type3);
                this.writeRef(aConstant);
                break;
            }
            case 8: {
                Type.TypeRef typeRef = (Type.TypeRef)type;
                Type type4 = typeRef.pre;
                Symbol symbol = typeRef.sym;
                Object[] objectArray = typeRef.args;
                this.writeByte(15);
                this.writeByte(0);
                this.writeRef(type4);
                this.writeRef(symbol);
                this.writeRefs(objectArray);
                break;
            }
            case 0: {
                Type.CompoundType compoundType = (Type.CompoundType)type;
                Object[] objectArray = compoundType.parts;
                this.writeByte(16);
                this.writeByte(0);
                Symbol symbol = type.symbol();
                this.writeByte(symbol.isCompoundSym() ? 1 : 0);
                if (symbol.isCompoundSym()) {
                    this.writeRef(symbol.owner());
                }
                this.writeRef(symbol);
                this.writeRefs(objectArray);
                break;
            }
            case 3: {
                Type.MethodType methodType = (Type.MethodType)type;
                Symbol[] symbolArray = methodType.vparams;
                Type type5 = methodType.result;
                this.writeByte(17);
                this.writeByte(0);
                this.writeRef(type5);
                for (int i = 0; i < symbolArray.length; ++i) {
                    Type type6 = symbolArray[i].type();
                    int n = symbolArray[i].flags;
                    if ((n & 0x300) != 0) {
                        this.writeRef(new FlagsAndType(Pickle.encodeFlags(n), type6));
                        continue;
                    }
                    this.writeRef(type6);
                }
                break;
            }
            case 5: {
                Type.PolyType polyType = (Type.PolyType)type;
                Object[] objectArray = polyType.tparams;
                Type type7 = polyType.result;
                this.writeByte(18);
                this.writeByte(0);
                this.writeRef(type7);
                this.writeRefs(objectArray);
                break;
            }
            case 4: {
                Type.OverloadedType overloadedType = (Type.OverloadedType)type;
                Object[] objectArray = overloadedType.alts;
                Object[] objectArray2 = overloadedType.alttypes;
                this.writeByte(19);
                this.writeByte(0);
                this.writeRefs(objectArray);
                this.writeRefs(objectArray2);
                break;
            }
            default: {
                throw new ApplicationError();
            }
        }
    }

    private void writeFlagsAndType(FlagsAndType flagsAndType) {
        this.writeByte(22);
        this.writeByte(0);
        this.writeNat(flagsAndType.flags);
        this.writeRef(flagsAndType.type);
    }

    private void writeConstant(AConstant aConstant) {
        switch (aConstant.$tag) {
            case 10: {
                this.writeByte(24);
                this.writeByte(0);
                return;
            }
            case 0: {
                AConstant.BOOLEAN bOOLEAN = (AConstant.BOOLEAN)aConstant;
                boolean bl = bOOLEAN.value;
                this.writeByte(25);
                this.writeByte(0);
                this.writeByte(bl ? 1 : 0);
                return;
            }
            case 1: {
                AConstant.BYTE bYTE = (AConstant.BYTE)aConstant;
                byte by = bYTE.value;
                this.writeByte(26);
                this.writeByte(0);
                this.writeLong(by);
                return;
            }
            case 7: {
                AConstant.SHORT sHORT = (AConstant.SHORT)aConstant;
                short s = sHORT.value;
                this.writeByte(27);
                this.writeByte(0);
                this.writeLong(s);
                return;
            }
            case 2: {
                AConstant.CHAR cHAR = (AConstant.CHAR)aConstant;
                char c = cHAR.value;
                this.writeByte(28);
                this.writeByte(0);
                this.writeLong(c);
                return;
            }
            case 5: {
                AConstant.INT iNT = (AConstant.INT)aConstant;
                int n = iNT.value;
                this.writeByte(29);
                this.writeByte(0);
                this.writeLong(n);
                return;
            }
            case 6: {
                AConstant.LONG lONG = (AConstant.LONG)aConstant;
                long l = lONG.value;
                this.writeByte(30);
                this.writeByte(0);
                this.writeLong(l);
                return;
            }
            case 4: {
                AConstant.FLOAT fLOAT = (AConstant.FLOAT)aConstant;
                float f = fLOAT.value;
                this.writeByte(31);
                this.writeByte(0);
                this.writeLong(Float.floatToIntBits(f));
                return;
            }
            case 3: {
                AConstant.DOUBLE dOUBLE = (AConstant.DOUBLE)aConstant;
                double d = dOUBLE.value;
                this.writeByte(32);
                this.writeByte(0);
                this.writeLong(Double.doubleToLongBits(d));
                return;
            }
            case 8: {
                AConstant.STRING sTRING = (AConstant.STRING)aConstant;
                String string = sTRING.value;
                this.writeByte(33);
                this.writeByte(0);
                this.writeRef(Name.fromString(string));
                return;
            }
            case 9: {
                this.writeByte(34);
                this.writeByte(0);
                return;
            }
            case 11: {
                this.writeByte(35);
                this.writeByte(0);
                return;
            }
        }
        throw Debug.abort("unknown case", aConstant);
    }

    private void writeEntry(Object object) {
        int n = this.bp;
        if (object instanceof Symbol) {
            this.writeSymbol((Symbol)object);
        } else if (object instanceof Type) {
            this.writeType((Type)object);
        } else if (object instanceof Name) {
            this.writeName((Name)object);
        } else if (object instanceof FlagsAndType) {
            this.writeFlagsAndType((FlagsAndType)object);
        } else if (object instanceof AConstant) {
            this.writeConstant((AConstant)object);
        } else {
            throw new ApplicationError(object);
        }
        this.patchNat(n + 1, this.bp - (n + 2));
    }

    private void writeAttr() {
        this.writeNat(this.ep);
        for (int i = 0; i < this.ep; ++i) {
            this.writeEntry(this.entries[i]);
        }
    }

    private static int encodeFlags(int n) {
        int n2 = 0;
        if ((n & 0x200) != 0) {
            n2 |= 4;
        }
        if ((n & 0x100) != 0) {
            n2 |= 8;
        }
        return n2;
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.symtab.classfile.Pickle").desiredAssertionStatus();
    }

    static class FlagsAndType {
        int flags;
        Type type;

        FlagsAndType(int n, Type type) {
            this.flags = n;
            this.type = type;
        }

        public boolean equals(Object object) {
            if (object instanceof FlagsAndType) {
                FlagsAndType flagsAndType = (FlagsAndType)object;
                return this.type.equals(flagsAndType.type) && this.flags == flagsAndType.flags;
            }
            return false;
        }

        public int hashCode() {
            return 37 + (this.flags * 41 ^ this.type.hashCode());
        }
    }
}

