/*
 * Decompiled with CFR 0.152.
 */
package scalac.symtab.classfile;

import java.io.IOException;
import scala.tools.util.AbstractFile;
import scalac.Global;
import scalac.symtab.ModuleClassSymbol;
import scalac.symtab.Scope;
import scalac.symtab.Symbol;
import scalac.symtab.Type;
import scalac.symtab.classfile.AttributeParser;
import scalac.symtab.classfile.ClassfileConstants;
import scalac.symtab.classfile.ConstantPool;
import scalac.symtab.classfile.JavaTypeCreator;
import scalac.symtab.classfile.JavaTypeFactory;
import scalac.symtab.classfile.Signatures;
import scalac.util.AbstractFileReader;
import scalac.util.Debug;
import scalac.util.Name;

public class ClassfileParser
implements ClassfileConstants {
    static final int CLASS_ATTR = 1540103;
    static final int METH_ATTR = 1638430;
    static final int FIELD_ATTR = 1114150;
    protected final Global global;
    protected final AbstractFileReader in;
    protected final Symbol c;
    protected final Symbol m;
    protected final Type ctype;
    protected final JavaTypeFactory make;
    protected final ConstantPool pool;
    protected final AttributeParser attrib;
    protected final Scope locals;
    protected final Scope statics;
    private static final /* synthetic */ boolean $assertionsDisabled;

    private ClassfileParser(Global global, AbstractFileReader abstractFileReader, Symbol symbol, JavaTypeFactory javaTypeFactory, ConstantPool constantPool) {
        this.global = global;
        this.in = abstractFileReader;
        this.c = symbol;
        this.m = symbol.linkedModule();
        this.ctype = javaTypeFactory.classType(symbol);
        this.make = javaTypeFactory;
        this.pool = constantPool;
        this.attrib = new AttributeParser(abstractFileReader, constantPool, this);
        this.locals = new Scope();
        this.statics = new Scope();
    }

    public static void parse(Global global, AbstractFile abstractFile, Symbol symbol) throws IOException {
        AbstractFileReader abstractFileReader = new AbstractFileReader(abstractFile);
        try {
            int n = abstractFileReader.nextInt();
            if (n != -889275714) {
                throw new IOException(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("class file '".concat(String.valueOf(String.valueOf(abstractFileReader.path))))).concat("' "))).concat("has wrong magic number 0x"))).concat(String.valueOf(String.valueOf(Integer.toHexString(n)))))).concat(", should be 0x"))).concat(String.valueOf(String.valueOf(Integer.toHexString(-889275714)))));
            }
            char c = abstractFileReader.nextChar();
            char c2 = abstractFileReader.nextChar();
            if (c2 < '-' || c2 == '-' && c < '\u0003') {
                throw new IOException(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("class file '".concat(String.valueOf(String.valueOf(abstractFileReader.path))))).concat("' "))).concat("has unknown version "))).concat(String.valueOf((int)c2)))).concat("."))).concat(String.valueOf((int)c)))).concat(", should be less than "))).concat(String.valueOf(45)))).concat("."))).concat(String.valueOf(3)));
            }
            JavaTypeCreator javaTypeCreator = new JavaTypeCreator(global.definitions);
            Signatures signatures = new Signatures(global, javaTypeCreator, abstractFileReader);
            ConstantPool constantPool = new ConstantPool(abstractFileReader, signatures);
            char c3 = abstractFileReader.nextChar();
            Symbol symbol2 = constantPool.getClass(abstractFileReader.nextChar());
            if (symbol != symbol2) {
                throw new IOException(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("class file '".concat(String.valueOf(String.valueOf(abstractFileReader.path))))).concat("' "))).concat("contains wrong class "))).concat(String.valueOf(String.valueOf(symbol2.staticType()))));
            }
            new ClassfileParser(global, abstractFileReader, symbol, javaTypeCreator, constantPool).parse(c3);
        }
        catch (RuntimeException runtimeException) {
            if (global.debug) {
                runtimeException.printStackTrace();
            }
            throw new IOException(String.valueOf(String.valueOf("class file '".concat(String.valueOf(String.valueOf(abstractFileReader.path))))).concat("' is broken"));
        }
    }

    protected void parse(int n) {
        this.c.flags = this.transFlags(n);
        if ((this.c.flags & 1) != 0) {
            this.c.flags = this.c.flags & 0xFFFFFFFE | 0x80;
        }
        Type type = this.readClassType(this.in.nextChar());
        Type[] typeArray = new Type[this.in.nextChar() + '\u0001'];
        Type.CompoundType compoundType = Type.compoundType(typeArray, this.locals, this.c);
        this.c.setInfo(compoundType);
        ModuleClassSymbol moduleClassSymbol = this.m.moduleClass();
        if (!$assertionsDisabled && !moduleClassSymbol.isModuleClass()) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(Debug.show(moduleClassSymbol))));
        }
        Type.CompoundType compoundType2 = Type.compoundType(Type.EMPTY_ARRAY, this.statics, moduleClassSymbol);
        moduleClassSymbol.setInfo(compoundType2);
        this.m.setInfo(this.make.classType(moduleClassSymbol));
        typeArray[0] = type;
        for (int i = 1; i < typeArray.length; ++i) {
            typeArray[i] = this.readClassType(this.in.nextChar());
        }
        int n2 = this.in.nextChar();
        for (int i = 0; i < n2; ++i) {
            this.parseField();
        }
        int n3 = this.in.nextChar();
        for (int i = 0; i < n3; ++i) {
            this.parseMethod();
        }
        Symbol symbol = this.c.primaryConstructor();
        if (!symbol.isInitialized()) {
            symbol.setInfo(Type.MethodType(Symbol.EMPTY_ARRAY, this.ctype));
            if ((this.c.flags & 0x10000000) == 0) {
                symbol.flags |= 4;
            }
        }
        this.attrib.readAttributes(this.c, compoundType, 1540103);
        int n4 = this.c.flags;
        this.c.flags |= 0x10000;
        if (this.global.currentPhase.id <= this.global.PHASE.REFCHECK.id() && !this.c.name.toString().endsWith("$class")) {
            this.addInheritedOverloaded();
        }
        this.c.flags = n4;
        Symbol symbol2 = type.symbol();
        if (this.m.isJava() && symbol2.isJava()) {
            ModuleClassSymbol moduleClassSymbol2 = this.m.moduleClass();
            Scope.SymbolIterator symbolIterator = symbol2.linkedModule().moduleClass().members().iterator();
            block3: while (symbolIterator.hasNext()) {
                Symbol symbol3 = symbolIterator.next();
                Symbol symbol4 = this.statics.lookup(symbol3.name);
                if (!symbol4.isNone()) {
                    if (!symbol3.isTerm()) continue;
                    Type type2 = symbol3.info();
                    Symbol[] symbolArray = symbol4.alternativeSymbols();
                    for (int i = 0; i < symbolArray.length; ++i) {
                        if (symbolArray[i].owner() == moduleClassSymbol2 && symbolArray[i].info().isSubType(type2)) continue block3;
                    }
                }
                this.statics.enterOrOverload(symbol3);
            }
        }
    }

    private void addInheritedOverloaded() {
        Symbol[] symbolArray = this.c.members().elements();
        for (int i = 0; i < symbolArray.length; ++i) {
            this.addInheritedOverloaded(symbolArray[i]);
        }
    }

    private void addInheritedOverloaded(Symbol symbol) {
        if (symbol.isMethod() && !symbol.isConstructor()) {
            symbol.addInheritedOverloaded(symbol.type());
        }
    }

    public int transFlags(int n) {
        int n2 = 0;
        if ((n & 2) != 0) {
            n2 |= 4;
        } else if ((n & 4) != 0) {
            n2 |= 8;
        } else if ((n & 1) == 0) {
            n2 |= 4;
        }
        if ((n & 0x400) != 0) {
            n2 |= 1;
        }
        if ((n & 0x10) != 0) {
            n2 |= 2;
        }
        if ((n & 0x200) != 0) {
            n2 |= 0x30000080;
        }
        if ((n & 0x1000) != 0) {
            n2 |= 0x400;
        }
        return n2 | 0x1000;
    }

    protected Type readClassType(int n) {
        return n == 0 ? this.make.anyType() : this.make.classType(this.pool.getClass(n));
    }

    protected void parseField() {
        char c = this.in.nextChar();
        int n = this.transFlags(c);
        if ((c & 0x10) == 0) {
            n |= 0x4000;
        }
        if ((n & 4) != 0) {
            this.in.skip(4);
            this.attrib.skipAttributes();
        } else {
            Name name = this.pool.getName(this.in.nextChar());
            Symbol symbol = this.getOwner(c);
            Symbol symbol2 = symbol.newTerm(0, n, name);
            Type type = this.pool.getFieldType(this.in.nextChar());
            symbol2.setInfo(type);
            this.attrib.readAttributes(symbol2, type, 1114150);
            this.getScope(c).enterOrOverload(symbol2);
        }
    }

    protected void parseMethod() {
        char c = this.in.nextChar();
        int n = this.transFlags(c);
        if ((c & 0x40) != 0) {
            n |= 4;
        }
        if ((n & 4) != 0) {
            this.in.skip(4);
            this.attrib.skipAttributes();
        } else {
            Symbol symbol;
            Name name = this.pool.getName(this.in.nextChar());
            Type type = this.pool.getMethodType(this.in.nextChar());
            Symbol symbol2 = this.getOwner(c);
            boolean bl = false;
            if (name == ClassfileConstants.CONSTR_N) {
                if (type.$tag != 3) {
                    throw Debug.abort("illegal case", type);
                }
                Type.MethodType methodType = (Type.MethodType)type;
                Symbol[] symbolArray = methodType.vparams;
                type = Type.MethodType(symbolArray, this.ctype);
                symbol = symbol2.primaryConstructor();
                if (symbol.isInitialized()) {
                    symbol = symbol2.newConstructor(0, n);
                    bl = true;
                } else {
                    symbol.flags = n;
                }
            } else {
                symbol = symbol2.newTerm(0, n, name);
            }
            this.setParamOwners(type, symbol);
            symbol.setInfo(type);
            this.attrib.readAttributes(symbol, type, 1638430);
            if (name != ClassfileConstants.CONSTR_N) {
                if ((symbol.flags & 0x8000000) == 0) {
                    this.getScope(c).enterOrOverload(symbol);
                }
            } else if (bl) {
                symbol2.addConstructor(symbol);
            }
        }
    }

    private Symbol getOwner(int n) {
        return (n & 8) != 0 ? this.m.moduleClass() : this.c;
    }

    private Scope getScope(int n) {
        return (n & 8) != 0 ? this.statics : this.locals;
    }

    private void setParamOwners(Type type, Symbol symbol) {
        switch (type.$tag) {
            case 5: {
                Type.PolyType polyType = (Type.PolyType)type;
                Symbol[] symbolArray = polyType.tparams;
                Type type2 = polyType.result;
                for (int i = 0; i < symbolArray.length; ++i) {
                    symbolArray[i].setOwner(symbol);
                }
                this.setParamOwners(type2, symbol);
                break;
            }
            case 3: {
                Type.MethodType methodType = (Type.MethodType)type;
                Symbol[] symbolArray = methodType.vparams;
                Type type3 = methodType.result;
                for (int i = 0; i < symbolArray.length; ++i) {
                    symbolArray[i].setOwner(symbol);
                }
                this.setParamOwners(type3, symbol);
            }
        }
    }

    static {
        $assertionsDisabled = !Class.forName("scalac.symtab.classfile.ClassfileParser").desiredAssertionStatus();
    }
}

